/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.LANModeAMIPanel_jEnableCheckBox_changeAdapter;
import IPMIView20.LANModeAMIPanel_jUpdateButton_actionAdapter;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class LANModeAMIPanel
extends JPanel {
    private String ip;
    private String id;
    private String password;
    private byte privilege;
    boolean isLoaded;
    TitledBorder titledBorder1 = new TitledBorder("");
    JCheckBox jEnableCheckBox = new JCheckBox();
    JRadioButton jDedicatedLANRadioButton = new JRadioButton();
    JRadioButton jOnBoardRadioButton = new JRadioButton();
    JButton jUpdateButton = new JButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel2 = new JPanel();

    public LANModeAMIPanel(String ip, String id, String password, byte privilege) {
        try {
            this.ip = ip;
            this.id = id;
            this.password = password;
            this.privilege = privilege;
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.buttonGroup1.add(this.jDedicatedLANRadioButton);
        this.buttonGroup1.add(this.jOnBoardRadioButton);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("LAN Interface");
        this.setLayout(this.gridLayout1);
        this.jEnableCheckBox.setActionCommand("Enable LAN Interface Selection");
        this.jEnableCheckBox.setText("Enable");
        this.jEnableCheckBox.setBounds(new Rectangle(10, 19, 188, 23));
        this.jEnableCheckBox.addChangeListener(new LANModeAMIPanel_jEnableCheckBox_changeAdapter(this));
        this.jDedicatedLANRadioButton.setText("Dedicated LAN");
        this.jDedicatedLANRadioButton.setBounds(new Rectangle(43, 41, 115, 26));
        this.jOnBoardRadioButton.setText("On-Board LAN");
        this.jOnBoardRadioButton.setBounds(new Rectangle(218, 41, 126, 23));
        this.jUpdateButton.setBounds(new Rectangle(460, 41, 63, 23));
        this.jUpdateButton.setMargin(new Insets(2, 6, 2, 6));
        this.jUpdateButton.setText("Update");
        this.jUpdateButton.addActionListener(new LANModeAMIPanel_jUpdateButton_actionAdapter(this));
        this.jPanel1.setLayout(null);
        this.gridLayout1.setRows(2);
        this.setBorder(null);
        this.jPanel1.setBorder(this.titledBorder1);
        this.add(this.jPanel1);
        this.add(this.jPanel2);
        this.jPanel1.add(this.jEnableCheckBox);
        this.jPanel1.add(this.jDedicatedLANRadioButton);
        this.jPanel1.add(this.jOnBoardRadioButton);
        this.jPanel1.add(this.jUpdateButton);
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean getIsLoaded() {
        return this.isLoaded;
    }

    public String getPassword() {
        return this.password;
    }

    public byte getPrivilege() {
        return this.privilege;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setIsLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrivilege(byte privilege) {
        this.privilege = privilege;
    }

    public void load() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        this.isLoaded = false;
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        byte[] lanMode = ipmiAMIOEMCommand.getAMILANMode();
        if (lanMode[0] == 1) {
            this.jEnableCheckBox.setSelected(true);
        } else {
            this.jEnableCheckBox.setSelected(false);
            this.jOnBoardRadioButton.setEnabled(false);
            this.jDedicatedLANRadioButton.setEnabled(false);
        }
        if (lanMode[1] == 0) {
            this.jDedicatedLANRadioButton.setSelected(true);
        } else if (lanMode[1] == 1) {
            this.jOnBoardRadioButton.setSelected(true);
        } else {
            this.jDedicatedLANRadioButton.setSelected(false);
            this.jOnBoardRadioButton.setSelected(false);
        }
        this.isLoaded = true;
        sessionController.closeSession();
    }

    public void update() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.password);
        config.setPrivilege(this.privilege);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Cannot connect to host");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        byte isEnable = 0;
        byte type = 0;
        byte[] orgLANMode = ipmiAMIOEMCommand.getAMILANMode();
        isEnable = this.jEnableCheckBox.isSelected() ? (byte)1 : 0;
        if (this.jDedicatedLANRadioButton.isSelected()) {
            type = 0;
        } else if (this.jOnBoardRadioButton.isSelected()) {
            type = 1;
        }
        if (orgLANMode[0] != isEnable || orgLANMode[1] != type) {
            ipmiAMIOEMCommand.setAMILANMode(isEnable, type);
        }
        sessionController.closeSession();
    }

    public void jEnableCheckBox_stateChanged(ChangeEvent e2) {
        if (this.jEnableCheckBox.isSelected()) {
            this.jDedicatedLANRadioButton.setEnabled(true);
            this.jOnBoardRadioButton.setEnabled(true);
        } else {
            this.jDedicatedLANRadioButton.setEnabled(false);
            this.jOnBoardRadioButton.setEnabled(false);
        }
    }

    public void jUpdateButton_actionPerformed(ActionEvent e2) {
        if (0 != JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("Please make sure the LAN cable is connected correctly as the setting after press the Yes button") + "\n This session will be terminated.", "", 0)) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    LANModeAMIPanel.this.setCursor(new Cursor(3));
                    LANModeAMIPanel.this.update();
                    LANModeAMIPanel.this.setCursor(new Cursor(0));
                    IPMIView20.getInstance().closeActivatelySession();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), ex.toString());
                }
            }
        };
        thread.start();
    }
}

