/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.NetworkSettingInterface;
import IPMIView20.NetworkSettingProfile;
import IPMIView20.NetworkSettingProperties;
import IPMIView20.NetworkSettingPropertiesController;
import com.supermicro.ipmi.IPMIInterfaceConfig;

public class NetworkSettingControl {
    private NetworkSettingProfile profile;
    private NetworkSettingProperties[] properties = new NetworkSettingProperties[1];
    private NetworkSettingPropertiesController controller;
    private IPMIInterfaceConfig interfaceConfig = null;

    public NetworkSettingControl(NetworkSettingInterface settingInterface) {
        this.profile = new NetworkSettingProfile();
        this.properties[0] = new NetworkSettingProperties();
        this.controller = new NetworkSettingPropertiesController(settingInterface);
        this.interfaceConfig = new IPMIInterfaceConfig();
    }

    public void load(boolean isFirstLoad) {
        this.controller.load(this.properties, isFirstLoad);
    }

    public void save() {
        this.controller.save(this.profile.retrieve(), this.properties[0]);
    }

    public void update() {
        this.profile.update(this.properties[0]);
    }

    public void setControlSession(CSession session) {
        this.interfaceConfig.setIp(session.SIP);
        this.interfaceConfig.setUserName(session.userID);
        this.interfaceConfig.setPassword(new String(session.UserPassword));
        this.interfaceConfig.setPrivilege(session.MaxLevel[0]);
        this.interfaceConfig.setSmcRAKP(session.isSMCRAKP);
    }

    public void setControllerConfig() {
        this.controller.setIPMIInterfaceConfig(this.interfaceConfig);
    }

    public NetworkSettingProperties getProperties() {
        return this.properties[0];
    }

    public NetworkSettingProfile getProfile() {
        return this.profile;
    }

    public boolean isPrivilegeSufficient() {
        return this.interfaceConfig != null ? this.interfaceConfig.getPrivilege() == 4 : false;
    }
}

