/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.NetworkSettingUtility;
import java.util.ArrayList;
import java.util.List;

public class NetworkSettingProperties {
    public static final int IPV4_STATIC_IP = 1;
    public static final int IPV4_DHCP = 2;
    public static final int IPV6_DHCP_STATELESS = 0;
    public static final int IPV6_DHCP_STATEFUL = 1;
    public static final int IPV6_DHCP_DISABLED = 2;
    public static final int LAN_INTERFACE_DEDICATED = 0;
    public static final int LAN_INTERFACE_SHARE = 1;
    public static final int LAN_INTERFACE_FAILOVER = 2;
    public static final int LINK_AUTO_NEGOTIATION = 0;
    public static final int LINK_10M_HALF_DUPLEX = 1;
    public static final int LINK_10M_FULL_DUPLEX = 2;
    public static final int LINK_100M_HALF_DUPLEX = 3;
    public static final int LINK_100M_FULL_DUPLEX = 4;
    public static final int IPV6_ADDRESS_COUNT_LIMIT = 5;
    private int ipv4DhcpMode;
    private int ipv6DhcpMode;
    private int generalLanInterfaceMode;
    private int generalLanInterfaceSupportMask;
    private boolean ipv4Enable;
    private boolean ipv6Enable;
    private boolean ipv6EnableAutoConfig;
    private boolean ipv6EnableStaticRoute;
    private boolean ipv6ProtocolSupport;
    private boolean generalEnableVLAN;
    private String ipv4Address;
    private String ipv4SubMask;
    private String ipv4Gateway;
    private String ipv4PrimaryDNSServer;
    private String ipv4SecondaryDNSServer;
    private String ipv6AddressPendingAdd;
    private String ipv6AddressPendingDel;
    private String ipv6DNSServer;
    private String ipv6DUID;
    private String generalHostname;
    private String generalMACAddress;
    private String generalVLANID;
    private String generalRMCPPort;
    private String generalActivedInterface;
    private String generalDedicatedLinkeMode;
    private String generalDedicatedStatus;
    private String generalDedicatedSpeed;
    private String generalDedicatedDuplex;
    private String generalShareStatus;
    private String generalShareSpeed;
    private String generalShareDuplex;
    private ArrayList<String> ipv6AddressList = new ArrayList();
    private ArrayList<String> ipv6PrefixRouteList = new ArrayList();
    private ArrayList<String> ipv6RouterAddressList = new ArrayList();

    public void copy(NetworkSettingProperties properties) {
        this.ipv4DhcpMode = properties.getIpv4DhcpMode();
        this.ipv4Enable = properties.isIPv4Enable();
        this.ipv4Address = properties.getIPv4Address();
        this.ipv4SubMask = properties.getIPv4SubMask();
        this.ipv4Gateway = properties.getIPv4Gateway();
        this.ipv4PrimaryDNSServer = properties.getIPv4PrimaryDNSServer();
        this.ipv4SecondaryDNSServer = properties.getIPv4SecondaryDNSServer();
        this.ipv6DhcpMode = properties.getIpv6DhcpMode();
        this.ipv6Enable = properties.isIPv6Enable();
        this.ipv6ProtocolSupport = properties.isIPv6ProtocolSupport();
        this.ipv6EnableAutoConfig = properties.isIPv6AutoConfigEnable();
        this.ipv6EnableStaticRoute = properties.isIPv6StaticRouteEnable();
        this.ipv6DNSServer = properties.getIPv6DNSServer();
        this.ipv6DUID = properties.getIPv6DUID();
        this.generalHostname = properties.getGeneralHostname();
        this.generalMACAddress = properties.getGeneralMACAddress();
        this.generalEnableVLAN = properties.isGeneralVLANEnable();
        this.generalVLANID = properties.getGeneralVLANID();
        this.generalRMCPPort = properties.getGeneralRMCPPort();
        this.generalLanInterfaceMode = properties.getGeneralLanInterfaceMode();
        this.generalLanInterfaceSupportMask = properties.getGeneralLanInterfaceSupportMask();
        this.generalActivedInterface = properties.getGeneralActivedInterface();
        this.generalDedicatedLinkeMode = properties.getGeneralDedicatedLinkeMode();
        this.generalDedicatedStatus = properties.getGeneralDedicatedStatus();
        this.generalDedicatedSpeed = properties.getGeneralDedicatedSpeed();
        this.generalDedicatedDuplex = properties.getGeneralDedicatedDuplex();
        this.generalShareStatus = properties.getGeneralShareStatus();
        this.generalShareSpeed = properties.getGeneralShareSpeed();
        this.generalShareDuplex = properties.getGeneralShareDuplex();
        this.ipv6AddressList.clear();
        this.ipv6AddressList.addAll(properties.getIPv6AddressList());
        this.ipv6RouterAddressList.clear();
        this.ipv6RouterAddressList.addAll(properties.getIPv6RouterAddressList());
        this.ipv6PrefixRouteList.clear();
        this.ipv6PrefixRouteList.addAll(properties.getIPv6PrefixRouteList());
    }

    public boolean isLanProtocolValid() {
        return this.ipv4Enable || this.ipv6Enable;
    }

    public boolean isIPv4StaticMode() {
        return this.ipv4DhcpMode == 1;
    }

    public boolean isIPv4DhcpModeChanged(NetworkSettingProperties property) {
        return property.ipv4DhcpMode != this.ipv4DhcpMode;
    }

    public boolean isIPv6DhcpModeChanged(NetworkSettingProperties property) {
        return property.ipv6DhcpMode != this.ipv6DhcpMode;
    }

    public boolean isGeneralLanInterfaceModeChanged(NetworkSettingProperties property) {
        return property.generalLanInterfaceMode != this.generalLanInterfaceMode;
    }

    public boolean isIPv4EnableChanged(NetworkSettingProperties property) {
        return property.ipv4Enable != this.ipv4Enable;
    }

    public boolean isIPv6EnableChanged(NetworkSettingProperties property) {
        return property.ipv6Enable != this.ipv6Enable;
    }

    public boolean isIPv6EnableAutoConfigChanged(NetworkSettingProperties property) {
        return property.ipv6EnableAutoConfig != this.ipv6EnableAutoConfig;
    }

    public boolean isIPv6EnableStaticRouteChanged(NetworkSettingProperties property) {
        return property.ipv6EnableStaticRoute != this.ipv6EnableStaticRoute;
    }

    public boolean isGeneralEnableVLANChanged(NetworkSettingProperties property) {
        return property.generalEnableVLAN != this.generalEnableVLAN;
    }

    public boolean isIPv4AddressChanged(NetworkSettingProperties property) {
        return !property.ipv4Address.equalsIgnoreCase(this.ipv4Address);
    }

    public boolean isIPv4SubMaskChanged(NetworkSettingProperties property) {
        return !property.ipv4SubMask.equalsIgnoreCase(this.ipv4SubMask);
    }

    public boolean isIPv4GatewayChanged(NetworkSettingProperties property) {
        return !property.ipv4Gateway.equalsIgnoreCase(this.ipv4Gateway);
    }

    public boolean isIPv4PrimaryDNSServerChanged(NetworkSettingProperties property) {
        return !property.ipv4PrimaryDNSServer.equalsIgnoreCase(this.ipv4PrimaryDNSServer);
    }

    public boolean isIPv4SecondaryDNSServerChanged(NetworkSettingProperties property) {
        return !property.ipv4SecondaryDNSServer.equalsIgnoreCase(this.ipv4SecondaryDNSServer);
    }

    public boolean isIPv6DNSServerChanged(NetworkSettingProperties property) {
        return !property.ipv6DNSServer.equalsIgnoreCase(this.ipv6DNSServer);
    }

    public boolean isIPv6AddressPendingAddChanged() {
        return this.ipv6AddressPendingAdd != null && !this.ipv6AddressPendingAdd.isEmpty();
    }

    public boolean isIPv6AddressPendingDelChanged() {
        return this.ipv6AddressPendingDel != null && !this.ipv6AddressPendingDel.isEmpty();
    }

    public boolean isIPv6PrefixRouteListChanged(NetworkSettingProperties property) {
        return null != property.ipv6PrefixRouteList && !property.ipv6PrefixRouteList.equals(this.ipv6PrefixRouteList);
    }

    public boolean isIPv6RouterAddressListChanged(NetworkSettingProperties property) {
        return null != property.ipv6RouterAddressList && !property.ipv6RouterAddressList.equals(this.ipv6RouterAddressList);
    }

    public boolean isGeneralHostnameChanged(NetworkSettingProperties property) {
        return !property.generalHostname.equalsIgnoreCase(this.generalHostname);
    }

    public boolean isGeneralVLANIDChanged(NetworkSettingProperties property) {
        return !property.generalVLANID.equalsIgnoreCase(this.generalVLANID);
    }

    public int getIpv4DhcpMode() {
        return this.ipv4DhcpMode;
    }

    public int getIpv6DhcpMode() {
        return this.ipv6DhcpMode;
    }

    public int getGeneralLanInterfaceMode() {
        return this.generalLanInterfaceMode;
    }

    public int getGeneralLanInterfaceSupportMask() {
        return this.generalLanInterfaceSupportMask;
    }

    public boolean isGeneralLanInterfaceDedicatedSupport() {
        return this.generalLanInterfaceSupportMask == 0 || (this.generalLanInterfaceSupportMask & 1) != 0;
    }

    public boolean isGeneralLanInterfaceShareSupport() {
        return this.generalLanInterfaceSupportMask == 0 || (this.generalLanInterfaceSupportMask & 2) != 0;
    }

    public boolean isGeneralLanInterfaceFailoverSupport() {
        return this.generalLanInterfaceSupportMask == 0 || (this.generalLanInterfaceSupportMask & 4) != 0;
    }

    public boolean isIPv4Enable() {
        return this.ipv4Enable;
    }

    public boolean isIPv6Enable() {
        return this.ipv6Enable;
    }

    public boolean isIPv6ProtocolSupport() {
        return this.ipv6ProtocolSupport;
    }

    public boolean isIPv6AutoConfigEnable() {
        return this.ipv6EnableAutoConfig;
    }

    public boolean isIPv6StaticRouteEnable() {
        return this.ipv6EnableStaticRoute;
    }

    public boolean isGeneralVLANEnable() {
        return this.generalEnableVLAN;
    }

    public String getIPv4Address() {
        return this.ipv4Address;
    }

    public String getIPv4Gateway() {
        return this.ipv4Gateway;
    }

    public String getIPv4SubMask() {
        return this.ipv4SubMask;
    }

    public String getIPv4PrimaryDNSServer() {
        return this.ipv4PrimaryDNSServer;
    }

    public String getIPv4SecondaryDNSServer() {
        return this.ipv4SecondaryDNSServer;
    }

    public String getIPv6DNSServer() {
        return this.ipv6DNSServer;
    }

    public String getIPv6DUID() {
        return this.ipv6DUID;
    }

    public String getGeneralVLANID() {
        return this.generalVLANID;
    }

    public String getGeneralHostname() {
        return this.generalHostname;
    }

    public String getGeneralDedicatedLinkeMode() {
        return this.generalDedicatedLinkeMode;
    }

    public String getGeneralMACAddress() {
        return this.generalMACAddress;
    }

    public String getGeneralRMCPPort() {
        return this.generalRMCPPort;
    }

    public String getGeneralActivedInterface() {
        return this.generalActivedInterface;
    }

    public String getGeneralDedicatedStatus() {
        return this.generalDedicatedStatus;
    }

    public String getGeneralDedicatedSpeed() {
        return this.generalDedicatedSpeed;
    }

    public String getGeneralDedicatedDuplex() {
        return this.generalDedicatedDuplex;
    }

    public String getGeneralShareStatus() {
        return this.generalShareStatus;
    }

    public String getGeneralShareSpeed() {
        return this.generalShareSpeed;
    }

    public String getGeneralShareDuplex() {
        return this.generalShareDuplex;
    }

    public String getIPv6AddressPendingAdd() {
        return this.ipv6AddressPendingAdd;
    }

    public String getIPv6AddressPendingDel() {
        return this.ipv6AddressPendingDel;
    }

    public List<String> getIPv6AddressList() {
        return this.ipv6AddressList;
    }

    public List<String> getIPv6RouterAddressList() {
        return this.ipv6RouterAddressList;
    }

    public List<String> getIPv6PrefixRouteList() {
        return this.ipv6PrefixRouteList;
    }

    public boolean setIPv4DhcpMode(int mode) {
        if (1 <= mode && mode <= 2) {
            this.ipv4DhcpMode = mode;
            return true;
        }
        return false;
    }

    public boolean setIPv6DhcpMode(int mode) {
        if (0 <= mode && mode <= 2) {
            this.ipv6DhcpMode = mode;
            return true;
        }
        return false;
    }

    public boolean setGeneralLanInterfaceMode(int mode) {
        if (0 <= mode && mode <= 2) {
            this.generalLanInterfaceMode = mode;
            return true;
        }
        return false;
    }

    public void setGeneralLanInterfaceSupportMask(int mask) {
        this.generalLanInterfaceSupportMask = mask;
    }

    public void setIPv4Enable(boolean enable) {
        this.ipv4Enable = enable;
    }

    public void setIPv6Enable(boolean enable) {
        this.ipv6Enable = enable;
    }

    public void setIPv6ProtocolSupport(boolean support) {
        this.ipv6ProtocolSupport = support;
    }

    public void setIPv6EnableAutoConfig(boolean enable) {
        this.ipv6EnableAutoConfig = enable;
    }

    public void setIPv6EnableStaticRoute(boolean enable) {
        this.ipv6EnableStaticRoute = enable;
    }

    public void setGeneralEnableVLAN(boolean enable) {
        this.generalEnableVLAN = enable;
    }

    public boolean setIPv4Address(String address) {
        if (NetworkSettingUtility.isValidIPv4(address)) {
            this.ipv4Address = address;
            return true;
        }
        return false;
    }

    public boolean setIPv4SubMask(String address) {
        if (NetworkSettingUtility.isValidIPv4(address)) {
            this.ipv4SubMask = address;
            return true;
        }
        return false;
    }

    public boolean setIPv4Gateway(String address) {
        if (NetworkSettingUtility.isValidIPv4(address)) {
            this.ipv4Gateway = address;
            return true;
        }
        return false;
    }

    public boolean setIPv4PrimaryDNSServer(String address, boolean checkFormat) {
        if (!(address.isEmpty() || !checkFormat || checkFormat && NetworkSettingUtility.isValidIPv4(address))) {
            return false;
        }
        this.ipv4PrimaryDNSServer = address;
        return true;
    }

    public boolean setIPv4SecondaryDNSServer(String address, boolean checkFormat) {
        if (!(address.isEmpty() || !checkFormat || checkFormat && NetworkSettingUtility.isValidIPv4(address))) {
            return false;
        }
        this.ipv4SecondaryDNSServer = address;
        return true;
    }

    public boolean setIPv6AddressPendingAdd(String address) {
        if (NetworkSettingUtility.isValidIPv6(address, true)) {
            this.ipv6AddressPendingAdd = NetworkSettingUtility.standardizeAddress(address, true);
            return true;
        }
        return false;
    }

    public boolean setIPv6AddressPendingDel(String address) {
        if (NetworkSettingUtility.isValidIPv6(address, true)) {
            this.ipv6AddressPendingDel = NetworkSettingUtility.standardizeAddress(address, true);
            return true;
        }
        return false;
    }

    public void clearIPv6AddressPendingAdd() {
        this.ipv6AddressPendingAdd = "";
    }

    public void clearIPv6AddressPendingDel() {
        this.ipv6AddressPendingDel = "";
    }

    public boolean setIPv6DNSServer(String address) {
        if (address.isEmpty() || NetworkSettingUtility.isValidIPv6(address, false)) {
            this.ipv6DNSServer = address;
            return true;
        }
        return false;
    }

    public void setIPv6DUID(String duid) {
        this.ipv6DUID = duid;
    }

    public void setGeneralHostname(String hostname) {
        this.generalHostname = hostname;
    }

    public void setGeneralMACAddress(String address) {
        this.generalMACAddress = address;
    }

    public boolean setGeneralVLANID(String vlanID) {
        if (NetworkSettingUtility.isValidVLANID(vlanID)) {
            this.generalVLANID = vlanID;
            return true;
        }
        if (vlanID.equals("")) {
            this.generalVLANID = "0";
            return true;
        }
        return false;
    }

    public void setGeneralRMCPPort(String port) {
        this.generalRMCPPort = port;
    }

    public void setGeneralActivedInterface(String intf) {
        this.generalActivedInterface = intf;
    }

    public void setGeneralDedicatedLinkeMode(String mode) {
        this.generalDedicatedLinkeMode = mode;
    }

    public void setGeneralDedicatedStatus(String status) {
        this.generalDedicatedStatus = status;
    }

    public void setGeneralDedicatedSpeed(String speed) {
        this.generalDedicatedSpeed = speed;
    }

    public void setGeneralDedicatedDuplex(String duplex) {
        this.generalDedicatedDuplex = duplex;
    }

    public void setGeneralShareStatus(String status) {
        this.generalShareStatus = status;
    }

    public void setGeneralShareSpeed(String speed) {
        this.generalShareSpeed = speed;
    }

    public void setGeneralShareDuplex(String duplex) {
        this.generalShareDuplex = duplex;
    }

    public boolean setIPv6AddressList(String address, boolean addAddr) {
        if (null != address) {
            if (addAddr) {
                if (this.ipv6AddressList.size() <= 5) {
                    this.ipv6AddressList.add(address);
                    return true;
                }
                return false;
            }
            this.ipv6AddressList.remove(address);
            return true;
        }
        return false;
    }

    public void setIPv6AddressList(List<String> strList) {
        this.ipv6AddressList.clear();
        this.ipv6AddressList.addAll(strList);
    }

    public void setIPv6RouterAddressList(List<String> strList) {
        this.ipv6RouterAddressList.clear();
        this.ipv6RouterAddressList.addAll(strList);
    }

    public void setIPv6PrefixRouteList(List<String> strList) {
        this.ipv6PrefixRouteList.clear();
        this.ipv6PrefixRouteList.addAll(strList);
    }

    public boolean setIPv6RouterAddressList(String addr, int index) {
        if (NetworkSettingUtility.isValidIPv6(addr, false)) {
            this.ipv6RouterAddressList.set(index, NetworkSettingUtility.standardizeAddress(addr, false));
            return true;
        }
        return false;
    }

    public boolean setIPv6PrefixRouteList(String prefix, int index) {
        if (NetworkSettingUtility.isValidIPv6(prefix, true) && NetworkSettingUtility.isValidIPv6Prefix(prefix)) {
            this.ipv6PrefixRouteList.set(index, NetworkSettingUtility.standardizeAddress(prefix, true));
            return true;
        }
        return false;
    }

    public void clearIPv6RouteAddressList(int index) {
        this.ipv6RouterAddressList.set(index, "0000:0000:0000:0000:0000:0000:0000:0000");
    }

    public void clearIPv6PrefixRouteList(int index) {
        this.ipv6PrefixRouteList.set(index, "0000:0000:0000:0000:0000:0000:0000:0000/64");
    }
}

