/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.NetworkSettingInterface;
import IPMIView20.NetworkSettingProperties;
import IPMIView20.NetworkSettingUtility;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMHostNameCommand;
import com.supermicro.ipmi.IPMIOEMIpv6Command;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;

public class NetworkSettingPropertiesController {
    private IPMIInterfaceConfig interfaceConfig = null;
    private NetworkSettingInterface networkSettingInterface = null;

    public NetworkSettingPropertiesController(NetworkSettingInterface settingInterface) {
        this.networkSettingInterface = settingInterface;
    }

    public void setIPMIInterfaceConfig(IPMIInterfaceConfig config) {
        this.interfaceConfig = config;
    }

    public void load(NetworkSettingProperties[] properties, boolean isFirstLoad) {
        this.networkSettingInterface.updateStatus(2, isFirstLoad);
        new Thread(() -> {
            block3: {
                this.getIPMIAMIOEMCommand(properties);
                this.getIPMILanCommand(properties);
                this.getIPMIOEMIPv6Command(properties);
                if (this.interfaceConfig.getPrivilege() == 4) {
                    this.getIPMIMiscCommand(properties);
                }
                try {
                    SwingUtilities.invokeAndWait(() -> this.networkSettingInterface.updateStatus(0, isFirstLoad));
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }).start();
    }

    public void save(NetworkSettingProperties backupProp, NetworkSettingProperties currentProp) {
        this.networkSettingInterface.updateStatus(3, false);
        new Thread(() -> {
            block2: {
                boolean resetSession = false;
                resetSession |= this.setIPMIAMIOEMCommand(backupProp, currentProp);
                resetSession |= this.setIPMIOEMIpv6Command(backupProp, currentProp);
                resetSession |= this.setIPMIMiscCommand(backupProp, currentProp);
                resetSession |= this.setIPMILanCommand(backupProp, currentProp);
                try {
                    boolean parameter = resetSession;
                    SwingUtilities.invokeAndWait(() -> this.networkSettingInterface.updateStatus(1, parameter));
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    if (!IPMIView20.showException) break block2;
                    e2.printStackTrace();
                }
            }
        }).start();
    }

    private void getIPMIAMIOEMCommand(NetworkSettingProperties[] properties) {
        IPMIAMIOEMCommand command = new IPMIAMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command, 30);
        if (null != sessionController) {
            this.getLANInterfaceMode(properties, command);
            this.getLANInterfaceSupportMask(properties, command);
            this.getActivedInterface(properties, command);
            this.getDedicatedLinkMode(properties, command);
            this.getDedicatedStatus(properties, command);
            this.getDedicatedSpeed(properties, command);
            this.getDedicatedDuplexMode(properties, command);
            this.getShareStatus(properties, command);
            this.getShareSpeed(properties, command);
            this.getShareDuplexMode(properties, command);
            sessionController.closeSession();
        }
    }

    private void getIPMILanCommand(NetworkSettingProperties[] properties) {
        IPMILanCommand command = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command, 30);
        if (null != sessionController) {
            this.getLANProtocol(properties, command);
            this.getIPv4DHCPMode(properties, command);
            this.getIPv4Address(properties, command);
            this.getIPv4SubnetMask(properties, command);
            this.getIPv4Gateway(properties, command);
            this.getIPv6StaticRouteMode(properties, command);
            this.getIPv6StaticRouteAddressList(properties, command);
            this.getMACAddress(properties, command);
            this.getVLANMode(properties, command);
            this.getVLANID(properties, command);
            sessionController.closeSession();
        }
    }

    private void getIPMIOEMIPv6Command(NetworkSettingProperties[] properties) {
        IPMIOEMIpv6Command command = new IPMIOEMIpv6Command(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command, 30);
        if (null != sessionController) {
            this.getIPv4DNSServer(properties, command);
            this.getIPv6DHCPMode(properties, command);
            this.getIPv6AddressList(properties, command);
            this.getIPv6AutoConfigMode(properties, command);
            this.getIPv6DNSServer(properties, command);
            this.getIPv6DUID(properties, command);
            sessionController.closeSession();
        }
    }

    private void getIPMIMiscCommand(NetworkSettingProperties[] properties) {
        IPMIOEMHostNameCommand command = new IPMIOEMHostNameCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command, 30);
        if (null != sessionController) {
            this.getHostname(properties, command);
            sessionController.closeSession();
        }
        this.getRMCPPort(properties);
    }

    private boolean setIPMIAMIOEMCommand(NetworkSettingProperties backupProp, NetworkSettingProperties currentProp) {
        boolean resetSession = false;
        IPMIAMIOEMCommand command = new IPMIAMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command);
        if (null != sessionController) {
            if (backupProp.isGeneralLanInterfaceModeChanged(currentProp)) {
                this.setLANInterfaceMode(currentProp, command);
            }
            sessionController.closeSession();
        }
        return resetSession;
    }

    private boolean setIPMILanCommand(NetworkSettingProperties backupProp, NetworkSettingProperties currentProp) {
        boolean resetSession = false;
        IPMILanCommand command = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command);
        if (null != sessionController) {
            if (backupProp.isIPv4EnableChanged(currentProp) || backupProp.isIPv6EnableChanged(currentProp)) {
                this.setLANProtocol(currentProp, command);
            }
            if (backupProp.isIPv4DhcpModeChanged(currentProp)) {
                this.setIPv4DHCPMode(currentProp, command);
            }
            if (currentProp.isIPv4StaticMode() && backupProp.isIPv4SubMaskChanged(currentProp)) {
                this.setIPv4SubnetMask(currentProp, command);
            }
            if (currentProp.isIPv4StaticMode() && backupProp.isIPv4GatewayChanged(currentProp)) {
                this.setIPv4Gateway(currentProp, command);
            }
            if (backupProp.isIPv6EnableStaticRouteChanged(currentProp)) {
                this.setIPv6StaticRouteMode(currentProp, command);
            }
            if (backupProp.isIPv6PrefixRouteListChanged(currentProp)) {
                this.setIPv6RoutePrefixAddressList(currentProp, command);
            }
            if (backupProp.isIPv6RouterAddressListChanged(currentProp)) {
                this.setIPv6StaticRouteAddressList(currentProp, command);
            }
            if (backupProp.isGeneralEnableVLANChanged(currentProp)) {
                this.setVLANMode(currentProp, command);
            }
            if (backupProp.isGeneralVLANIDChanged(currentProp)) {
                this.setVLANID(currentProp, command);
            }
            if (currentProp.isIPv4StaticMode() && backupProp.isIPv4AddressChanged(currentProp)) {
                this.setIPv4Address(currentProp, command);
                resetSession = true;
            }
            sessionController.closeSession();
        }
        return resetSession;
    }

    private boolean setIPMIOEMIpv6Command(NetworkSettingProperties backupProp, NetworkSettingProperties currentProp) {
        boolean resetSession = false;
        IPMIOEMIpv6Command command = new IPMIOEMIpv6Command(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command);
        if (null != sessionController) {
            if (currentProp.isIPv4StaticMode() && (backupProp.isIPv4PrimaryDNSServerChanged(currentProp) || backupProp.isIPv4SecondaryDNSServerChanged(currentProp))) {
                this.setIPv4DNSServer(currentProp, command);
            }
            if (backupProp.isIPv6DhcpModeChanged(currentProp)) {
                this.setIPv6DHCPMode(currentProp, command);
            }
            if (currentProp.isIPv6AddressPendingAddChanged()) {
                currentProp.setIPv6AddressList(currentProp.getIPv6AddressPendingAdd(), true);
            }
            if (currentProp.isIPv6AddressPendingDelChanged()) {
                currentProp.setIPv6AddressList(currentProp.getIPv6AddressPendingDel(), false);
            }
            this.setIPv6AddressList(backupProp, currentProp, command);
            if (backupProp.isIPv6EnableAutoConfigChanged(currentProp)) {
                this.setIPv6AutoConfigMode(currentProp, command);
            }
            if (backupProp.isIPv6DNSServerChanged(currentProp)) {
                this.setIPv6DNSServer(currentProp, command);
            }
            sessionController.closeSession();
        }
        return resetSession;
    }

    private boolean setIPMIMiscCommand(NetworkSettingProperties backupProp, NetworkSettingProperties currentProp) {
        boolean resetSession = false;
        IPMIOEMHostNameCommand command = new IPMIOEMHostNameCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, command);
        if (null != sessionController) {
            if (backupProp.isGeneralHostnameChanged(currentProp)) {
                this.setHostname(currentProp, command);
            }
            sessionController.closeSession();
        }
        return resetSession;
    }

    private boolean getLANProtocol(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            try {
                byte mode = command.getIPProtocol();
                properties[0].setIPv4Enable(mode == 0 || mode == 2);
                properties[0].setIPv6Enable(mode == 1 || mode == 2);
                properties[0].setIPv6ProtocolSupport(true);
            }
            catch (IPMIException e2) {
                properties[0].setIPv4Enable(true);
                properties[0].setIPv6Enable(false);
                properties[0].setIPv6ProtocolSupport(false);
            }
        }
        return true;
    }

    private boolean getIPv4DHCPMode(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            properties[0].setIPv4DhcpMode(command.getLanSettingType());
        }
        return true;
    }

    private boolean getIPv4Address(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            properties[0].setIPv4Address(command.getIP());
        }
        return true;
    }

    private boolean getIPv4SubnetMask(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            properties[0].setIPv4SubMask(command.getSubnetMask());
        }
        return true;
    }

    private boolean getIPv4Gateway(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            properties[0].setIPv4Gateway(command.getGatewayIP());
        }
        return true;
    }

    private boolean getIPv4DNSServer(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            try {
                byte[] dns = command.getIPV4DNS();
                if (null != dns && dns.length > 0) {
                    boolean primaryAddress = true;
                    StringBuilder builder1 = new StringBuilder();
                    StringBuilder builder2 = new StringBuilder();
                    for (int i2 = 0; i2 < dns.length; ++i2) {
                        if (dns[i2] == 0) {
                            primaryAddress = false;
                            continue;
                        }
                        if (primaryAddress) {
                            builder1.append((char)dns[i2]);
                            continue;
                        }
                        builder2.append((char)dns[i2]);
                    }
                    properties[0].setIPv4PrimaryDNSServer(builder1.toString(), false);
                    properties[0].setIPv4SecondaryDNSServer(builder2.toString(), false);
                } else {
                    properties[0].setIPv4PrimaryDNSServer("", false);
                    properties[0].setIPv4SecondaryDNSServer("", false);
                }
            }
            catch (IPMIException e2) {
                properties[0].setIPv4PrimaryDNSServer("", false);
                properties[0].setIPv4SecondaryDNSServer("", false);
            }
        }
        return true;
    }

    private boolean getIPv6DHCPMode(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            try {
                properties[0].setIPv6DhcpMode(command.getIPV6DHCPMode());
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean getIPv6AddressList(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            byte[] addressBytes = null;
            try {
                addressBytes = command.getIPV6AddressList();
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
            if (null != addressBytes) {
                int counts = addressBytes.length / 17;
                ArrayList<String> addressList = new ArrayList<String>();
                for (int idx = 0; idx < counts; ++idx) {
                    byte[] temp = new byte[17];
                    temp = Arrays.copyOfRange(addressBytes, idx * 17, idx * 17 + 17);
                    List<String> stringList = NetworkSettingUtility.bytesToHexStringList(temp);
                    StringBuffer strBuffer = new StringBuffer();
                    for (int strIdx = 0; strIdx < 17; strIdx += 2) {
                        if (strIdx < 16) {
                            if (strIdx != 0) {
                                strBuffer.append(":");
                            }
                            strBuffer.append(stringList.get(strIdx));
                            strBuffer.append(stringList.get(strIdx + 1));
                            continue;
                        }
                        strBuffer.append("/");
                        strBuffer.append(Integer.parseInt(stringList.get(stringList.size() - 1), 16));
                    }
                    addressList.add(NetworkSettingUtility.shortenAddress(strBuffer.toString(), true));
                }
                properties[0].setIPv6AddressList(addressList);
            }
        }
        return true;
    }

    private boolean getIPv6AutoConfigMode(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            try {
                properties[0].setIPv6EnableAutoConfig(command.isAutoConfig());
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean getIPv6DNSServer(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            try {
                byte[] dns = command.getIPV6DNS();
                if (dns != null) {
                    StringBuilder builder = new StringBuilder();
                    for (int i2 = 0; i2 < dns.length; ++i2) {
                        builder.append((char)dns[i2]);
                    }
                    properties[0].setIPv6DNSServer(NetworkSettingUtility.shortenAddress(builder.toString(), false));
                } else {
                    properties[0].setIPv6DNSServer("");
                }
            }
            catch (IPMIException e2) {
                properties[0].setIPv6DNSServer("");
            }
        }
        return true;
    }

    private boolean getIPv6DUID(NetworkSettingProperties[] properties, IPMIOEMIpv6Command command) {
        if (null != command) {
            try {
                List<String> stringList = NetworkSettingUtility.bytesToHexStringList(command.getDuid());
                StringBuffer stringBuffer = new StringBuffer();
                for (String str : stringList) {
                    stringBuffer.append(str + " ");
                }
                properties[0].setIPv6DUID(stringBuffer.toString());
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean getIPv6StaticRouteMode(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            try {
                properties[0].setIPv6EnableStaticRoute(command.isRouteStaticEnabled());
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean getIPv6StaticRouteAddressList(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            ArrayList<String> addressList = new ArrayList<String>();
            ArrayList<String> prefixList = new ArrayList<String>();
            addressList.add(NetworkSettingUtility.standardizeAddress(command.getStaticRouterIP1(), false));
            addressList.add(NetworkSettingUtility.standardizeAddress(command.getStaticRouterIP2(), false));
            try {
                prefixList.add(NetworkSettingUtility.standardizeAddress(command.getStaticRouterPrefixValue1(), false) + "/" + command.getStaticRouterPrefixLength1());
                prefixList.add(NetworkSettingUtility.standardizeAddress(command.getStaticRouterPrefixValue2(), false) + "/" + command.getStaticRouterPrefixLength2());
            }
            catch (IPMIException iPMIException) {
                // empty catch block
            }
            properties[0].setIPv6RouterAddressList(addressList);
            properties[0].setIPv6PrefixRouteList(prefixList);
        }
        return true;
    }

    private boolean getHostname(NetworkSettingProperties[] properties, IPMIOEMHostNameCommand command) {
        block3: {
            if (null != command) {
                try {
                    properties[0].setGeneralHostname(command.getIPMIHostName());
                }
                catch (Exception e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getMACAddress(NetworkSettingProperties[] properties, IPMILanCommand command) {
        if (null != command) {
            properties[0].setGeneralMACAddress(command.getMAC());
        }
        return true;
    }

    private boolean getVLANMode(NetworkSettingProperties[] properties, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    properties[0].setGeneralEnableVLAN(command.isVLANEnabled());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getVLANID(NetworkSettingProperties[] properties, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    properties[0].setGeneralVLANID(String.valueOf(command.getVLANTag()));
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getLANInterfaceMode(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block3: {
            if (null != command) {
                try {
                    properties[0].setGeneralLanInterfaceMode(command.getLANMode());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getLANInterfaceSupportMask(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block3: {
            if (null != command) {
                try {
                    byte[] mask = command.getLANModeCap();
                    properties[0].setGeneralLanInterfaceSupportMask(mask != null ? mask[0] : 0);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getRMCPPort(NetworkSettingProperties[] properties) {
        String port = "623";
        properties[0].setGeneralRMCPPort(port);
        return true;
    }

    private boolean getActivedInterface(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block4: {
            if (null != command) {
                try {
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length > 1) {
                        String activedInterface = status[1] == 0 ? "Dedicate" : "Share";
                        properties[0].setGeneralActivedInterface(activedInterface);
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block4;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getDedicatedLinkMode(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block3: {
            if (null != command) {
                try {
                    String linkMode = command.getDedicatedLinkMode();
                    properties[0].setGeneralDedicatedLinkeMode(linkMode);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getDedicatedStatus(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block4: {
            if (null != command) {
                try {
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        properties[0].setGeneralDedicatedStatus(status[4] == 0 ? "Disconnected" : "Connected");
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block4;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getDedicatedSpeed(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block4: {
            if (null != command) {
                try {
                    String speed = "";
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        speed = status[4] != 0 ? (status[5] == 0 ? "10M" : (status[5] == 1 ? "100M" : (status[5] == 2 ? "1G" : (status[5] == 3 ? "10G" : "Unknown")))) : "Unknown";
                    }
                    properties[0].setGeneralDedicatedSpeed(speed);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block4;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getDedicatedDuplexMode(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block6: {
            if (null != command) {
                try {
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        if (status[4] != 0) {
                            properties[0].setGeneralDedicatedDuplex(status[3] == 0 ? "Half Duplex" : "Full Duplex");
                        } else {
                            properties[0].setGeneralDedicatedDuplex("Unknown");
                        }
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block6;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getShareStatus(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block4: {
            if (null != command) {
                try {
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        properties[0].setGeneralShareStatus(status[7] == 0 ? "Disconnected" : "Connected");
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block4;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getShareSpeed(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block10: {
            if (null != command) {
                try {
                    String speed = "";
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        byte state = status[8];
                        switch (state) {
                            case 1: 
                            case 2: {
                                speed = "10M";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                speed = "100M";
                                break;
                            }
                            case 6: 
                            case 7: {
                                speed = "1G";
                                break;
                            }
                            case 8: {
                                speed = "10G";
                                break;
                            }
                            default: {
                                speed = "Unknown";
                            }
                        }
                    }
                    properties[0].setGeneralShareSpeed(speed);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block10;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean getShareDuplexMode(NetworkSettingProperties[] properties, IPMIAMIOEMCommand command) {
        block8: {
            if (null != command) {
                try {
                    String duplexMode = null;
                    byte[] status = command.getNetworkLinkStatus();
                    if (null != status && status.length == 9) {
                        byte state = status[8];
                        switch (state) {
                            case 1: 
                            case 3: 
                            case 6: {
                                duplexMode = "Half Duplex";
                                break;
                            }
                            case 2: 
                            case 4: 
                            case 5: 
                            case 7: {
                                duplexMode = "Full Duplex";
                                break;
                            }
                            default: {
                                duplexMode = "Unknown";
                            }
                        }
                        properties[0].setGeneralShareDuplex(duplexMode);
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block8;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setLANProtocol(NetworkSettingProperties property, IPMILanCommand command) {
        block6: {
            if (null != command) {
                try {
                    int mode = 0;
                    if (property.isIPv4Enable()) {
                        mode = 0;
                    }
                    if (property.isIPv6Enable()) {
                        mode = 1;
                    }
                    if (property.isIPv4Enable() && property.isIPv6Enable()) {
                        mode = 2;
                    }
                    command.setIPProtocol((byte)mode);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block6;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv4DHCPMode(NetworkSettingProperties property, IPMILanCommand command) {
        if (null != command) {
            command.setLanSettingType((byte)property.getIpv4DhcpMode());
        }
        return true;
    }

    private boolean setIPv4Address(NetworkSettingProperties property, IPMILanCommand command) {
        if (null != command) {
            command.setIP(property.getIPv4Address());
        }
        return true;
    }

    private boolean setIPv4SubnetMask(NetworkSettingProperties property, IPMILanCommand command) {
        if (null != command) {
            command.setSubnetMask(property.getIPv4SubMask());
        }
        return true;
    }

    private boolean setIPv4Gateway(NetworkSettingProperties property, IPMILanCommand command) {
        if (null != command) {
            command.setGatewayIP(property.getIPv4Gateway());
        }
        return true;
    }

    private boolean setIPv4DNSServer(NetworkSettingProperties property, IPMIOEMIpv6Command command) {
        block7: {
            if (null != command) {
                try {
                    boolean isSecondaryDNSEmpty;
                    boolean isPrimaryDNSEmpty = null == property.getIPv4PrimaryDNSServer() || property.getIPv4PrimaryDNSServer().isEmpty();
                    boolean bl = isSecondaryDNSEmpty = null == property.getIPv4SecondaryDNSServer() || property.getIPv4SecondaryDNSServer().isEmpty();
                    if (isPrimaryDNSEmpty && isSecondaryDNSEmpty) {
                        command.clearIPV4DNS();
                    } else {
                        String[] primarySubAddr = (isPrimaryDNSEmpty ? "0.0.0.0" : property.getIPv4PrimaryDNSServer()).split("\\.");
                        String[] subAddrSubAddr = (isSecondaryDNSEmpty ? "0.0.0.0" : property.getIPv4SecondaryDNSServer()).split("\\.");
                        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                        for (String value : primarySubAddr) {
                            byteBuffer.put(Integer.valueOf(value).byteValue());
                        }
                        for (String value : subAddrSubAddr) {
                            byteBuffer.put(Integer.valueOf(value).byteValue());
                        }
                        command.setIPV4DNS(byteBuffer.array());
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block7;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6DHCPMode(NetworkSettingProperties property, IPMIOEMIpv6Command command) {
        block3: {
            if (null != command) {
                try {
                    command.setIPV6DHCPMode(property.getIpv6DhcpMode());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6AddressList(NetworkSettingProperties backupProperty, NetworkSettingProperties property, IPMIOEMIpv6Command command) {
        if (null != command) {
            byte[] addressBytes;
            for (String addressStr : property.getIPv6AddressList()) {
                if (backupProperty.getIPv6AddressList().contains(addressStr)) continue;
                addressBytes = NetworkSettingUtility.ipv6IPStrToBytes(NetworkSettingUtility.extendedAddress(addressStr, true));
                try {
                    command.setIPV6Address(addressBytes, true);
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) continue;
                    e2.printStackTrace();
                }
            }
            for (String addressStr : backupProperty.getIPv6AddressList()) {
                if (property.getIPv6AddressList().contains(addressStr)) continue;
                addressBytes = NetworkSettingUtility.ipv6IPStrToBytes(NetworkSettingUtility.extendedAddress(addressStr, true));
                try {
                    command.setIPV6Address(addressBytes, false);
                }
                catch (IPMIException e3) {
                    if (!IPMIView20.showException) continue;
                    e3.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6AutoConfigMode(NetworkSettingProperties property, IPMIOEMIpv6Command command) {
        block3: {
            if (null != command) {
                try {
                    command.setAutoConfigMode(property.isIPv6AutoConfigEnable());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6DNSServer(NetworkSettingProperties property, IPMIOEMIpv6Command command) {
        block5: {
            if (null != command) {
                try {
                    if (null == property.getIPv6DNSServer() || property.getIPv6DNSServer().isEmpty()) {
                        command.clearIPV6DNS();
                    } else {
                        command.setIPV6DNS(NetworkSettingUtility.extendedAddress(property.getIPv6DNSServer(), false));
                    }
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block5;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6StaticRouteMode(NetworkSettingProperties property, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setRouteStatus(property.isIPv6StaticRouteEnable());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6StaticRouteAddressList(NetworkSettingProperties property, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setStaticRouterAddress(1, NetworkSettingUtility.extendedAddress(property.getIPv6RouterAddressList().get(0), false));
                    command.setStaticRouterAddress(2, NetworkSettingUtility.extendedAddress(property.getIPv6RouterAddressList().get(1), false));
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setIPv6RoutePrefixAddressList(NetworkSettingProperties property, IPMILanCommand command) {
        if (null != command) {
            int id = 1;
            for (String prefix : property.getIPv6PrefixRouteList()) {
                block4: {
                    String prefixAddr = prefix.split("/")[0];
                    String prefixLen = prefix.split("/")[1];
                    try {
                        command.setStaticRouterPrefixValue(id, NetworkSettingUtility.extendedAddress(prefixAddr, false));
                        command.setStaticRouterPrefixLength(id, Integer.valueOf(prefixLen));
                    }
                    catch (IPMIException e2) {
                        if (!IPMIView20.showException) break block4;
                        e2.printStackTrace();
                    }
                }
                ++id;
            }
        }
        return true;
    }

    private boolean setHostname(NetworkSettingProperties property, IPMIOEMHostNameCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setIPMIHostName(property.getGeneralHostname());
                }
                catch (Exception e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setVLANMode(NetworkSettingProperties property, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setVLANEnabled(property.isGeneralVLANEnable(), Integer.valueOf(property.getGeneralVLANID()));
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setVLANID(NetworkSettingProperties property, IPMILanCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setVLANEnabled(property.isGeneralVLANEnable(), Integer.valueOf(property.getGeneralVLANID()));
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean setLANInterfaceMode(NetworkSettingProperties property, IPMIAMIOEMCommand command) {
        block3: {
            if (null != command) {
                try {
                    command.setLANMode((byte)property.getGeneralLanInterfaceMode());
                }
                catch (IPMIException e2) {
                    if (!IPMIView20.showException) break block3;
                    e2.printStackTrace();
                }
            }
        }
        return true;
    }
}

