/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.ComboTabListener;
import IPMIView20.DropShadowPanel;
import IPMIView20.IPMIView20;
import IPMIView20.NetworkSettingControl;
import IPMIView20.NetworkSettingInterface;
import IPMIView20.NetworkSettingUtility;
import IPMIView20.RoundTextField;
import IPMIView20.ToggleSwitch;
import IPMIView20.WideComboBox;
import IPMIView20.WideComboBoxItem;
import IPMIView20.blade.SWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class NetworkSettingView
extends JPanel
implements NetworkSettingInterface,
ComboTabListener {
    private static final long serialVersionUID = 1L;
    private final Integer INVALID_IPV4_ADDRESS = 0;
    private final Integer INVALID_IPV4_SUBMASK = 1;
    private final Integer INVALID_IPV4_GATEWAY = 2;
    private final Integer INVALID_IPV4_PRIMARY_DNS = 3;
    private final Integer INVALID_IPV4_SECONDARY_DNS = 4;
    private final Integer INVALID_IPV6_ADDRESS = 5;
    private final Integer INVALID_IPV6_DNS = 6;
    private final Integer INVALID_IPV6_ROUTE_PREFIX = 7;
    private final Integer INVALID_IPV6_ROUTE_ADDRESS = 8;
    private final Integer INVALID_IPV6_ADD_DEL = 9;
    private final Integer INVALID_VLAN_ID = 10;
    private static final String ICON_COLLAPSE = "/images/advanced.png";
    private static final String ICON_EXT_ADD = "/images/btn_Add.png";
    private static final String ICON_EXT_MINUS = "/images/btn_minus.png";
    private static final String ICON_ADD = "/images/network_edit.png";
    private static final String ICON_DEL = "/images/network_delete.png";
    private static final String ICON_ADD_CHECKED = "/images/network_edit_checked.png";
    private static final String ICON_DEL_CHECKED = "/images/network_delete_checked.png";
    private final Map<Integer, String> errCodeMappingMap = new HashMap<Integer, String>(){
        {
            this.put(NetworkSettingView.this.INVALID_IPV4_ADDRESS, "IPv4 Address is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV4_SUBMASK, "IPv4 Subnet Mask is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV4_GATEWAY, "IPv4 Gateway is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV4_PRIMARY_DNS, "IPv4 DNS1 is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV4_SECONDARY_DNS, "IPv4 DNS2 is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV6_DNS, "IPv6 DNS is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV6_ADDRESS, "IPv6 Address is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV6_ROUTE_PREFIX, "IPv6 Router Prefix is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV6_ROUTE_ADDRESS, "IPv6 Router Address is invalid formatt!");
            this.put(NetworkSettingView.this.INVALID_IPV6_ADD_DEL, "Please selecet IPv6 address add/delete icon.");
            this.put(NetworkSettingView.this.INVALID_VLAN_ID, "VLAN ID is in invalid range!");
        }
    };
    private Set<Integer> errCodeRecorderSet = new HashSet<Integer>();
    private JPanel ipv4SettingPanel = new JPanel();
    private JPanel ipv4SettingAdvancedTitlePanel = new JPanel();
    private JPanel ipv4SettingAdvancedPanel = new JPanel();
    private JPanel ipv6SettingAdvancedTitlePanel = new JPanel();
    private JPanel ipv6SettingAdvancedPanel = new JPanel();
    private JPanel ipv6SettingPanel = new JPanel();
    private JPanel ipSettingBasePanel = new JPanel();
    private JPanel instance = this;
    private JLabel ipv4TitleLabel = new JLabel();
    private JLabel ipv4AddressLabel = new JLabel();
    private JLabel ipv4SubnetMaskLabel = new JLabel();
    private JLabel ipv4GatewayAddressLabel = new JLabel();
    private JLabel ipv4AdvanceSettingLabel = new JLabel();
    private JLabel ipv4AdvanceSettingToggleLabel = new JLabel();
    private JLabel ipv4PrimaryDNSLabel = new JLabel();
    private JLabel ipv4SecondaryDNSLabel = new JLabel();
    private JLabel ipv6TitleLabel = new JLabel();
    private JLabel ipv6DHCPLabel = new JLabel();
    private JLabel ipv6AddressLabel = new JLabel();
    private JLabel ipv6AddressListLabel = new JLabel();
    private JLabel ipv6AdvanceSettingLabel = new JLabel();
    private JLabel ipv6AdvanceSettingToggleLabel = new JLabel();
    private JLabel ipv6AutoConfigLabel = new JLabel();
    private JLabel ipv6DNSLabel = new JLabel();
    private JLabel ipv6DUIDLabel = new JLabel();
    private JLabel ipv6StaticRouteLabel = new JLabel();
    private JLabel ipv6StaticRouteListLabel = new JLabel();
    private JLabel ipv6PrefixRouteLabel = new JLabel();
    private JLabel ipv6RouteAddressLabel = new JLabel();
    private JLabel generalTitleLabel = new JLabel();
    private JLabel generalHostnameLabel = new JLabel();
    private JLabel generalMACLabel = new JLabel();
    private JLabel generalVLANLabel = new JLabel();
    private JLabel generalVLANIDLabel = new JLabel();
    private JLabel generalLANInterfaceLabel = new JLabel();
    private JLabel generalRMCPPortLabel = new JLabel();
    private JLabel generalActiveInterfaceLabel = new JLabel();
    private JLabel generalActiveInterfaceValueLabel = new JLabel();
    private JLabel generalDedicatedTitleLabel = new JLabel();
    private JLabel generalDedicatedLinkLabel = new JLabel();
    private JLabel generalDedicatedLinkValueLabel = new JLabel();
    private JLabel generalDedicatedStatusLabel = new JLabel();
    private JLabel generalDedicatedStatusValueLabel = new JLabel();
    private JLabel generalDedicatedSpeedLabel = new JLabel();
    private JLabel generalDedicatedSpeedValueLabel = new JLabel();
    private JLabel generalDedicatedDuplexLabel = new JLabel();
    private JLabel generalDedicatedDuplexValueLabel = new JLabel();
    private JLabel generalShareTitleLabel = new JLabel();
    private JLabel generalShareStatusLabel = new JLabel();
    private JLabel generalShareStatusValueLabel = new JLabel();
    private JLabel generalShareSpeedLabel = new JLabel();
    private JLabel generalShareSpeedValueLabel = new JLabel();
    private JLabel generalShareDuplexLabel = new JLabel();
    private JLabel generalShareDuplexValueLabel = new JLabel();
    private JRadioButton ipv4DHCPRadioButton = new JRadioButton();
    private JRadioButton ipv4StaticIPRadioButton = new JRadioButton();
    private JRadioButton ipv6DHCPDisableRadioButton = new JRadioButton();
    private JRadioButton ipv6DHCPStatelessRadioButton = new JRadioButton();
    private JRadioButton ipv6StatefulRadioButton = new JRadioButton();
    private JRadioButton generalDedicatedRadioButton = new JRadioButton();
    private JRadioButton generalShareRadioButton = new JRadioButton();
    private JRadioButton generalFailoverRadioButton = new JRadioButton();
    private RoundTextField ipv4AddressTextField = new RoundTextField();
    private RoundTextField ipv4SubnetMaskTextField = new RoundTextField();
    private RoundTextField ipv4GatewayTextField = new RoundTextField();
    private RoundTextField ipv4PrimaryDNSTextField = new RoundTextField();
    private RoundTextField ipv4SecondaryDNSTextField = new RoundTextField();
    private RoundTextField ipv6AddressTextField = new RoundTextField();
    private RoundTextField ipv6DNSTextField = new RoundTextField();
    private RoundTextField ipv6DUIDTextField = new RoundTextField();
    private RoundTextField ipv6RoutePrefixTextField = new RoundTextField();
    private RoundTextField ipv6RouteAddressTextField = new RoundTextField();
    private RoundTextField generalHostnameTextField = new RoundTextField();
    private RoundTextField generalMACTextField = new RoundTextField();
    private RoundTextField generalVLANIDTextField = new RoundTextField();
    private RoundTextField generalRMCPPortTextField = new RoundTextField();
    private JToggleButton ipv6AddressAddButton = new JToggleButton();
    private JToggleButton ipv6AddressDelButton = new JToggleButton();
    private JToggleButton ipv6RouteListDelButton = new JToggleButton();
    private ButtonGroup ipv4RadioButtonGroup = new ButtonGroup();
    private ButtonGroup ipv6RadioButtonGroup = new ButtonGroup();
    private ButtonGroup lanInterfaceRadioButtonGroup = new ButtonGroup();
    private Component ipv4ExtensionComponent = Box.createVerticalStrut(165);
    private Icon advIcon = new ImageIcon(this.getClass().getResource("/images/advanced.png"));
    private Icon addIcon = new ImageIcon(this.getClass().getResource("/images/btn_Add.png"));
    private Icon minusIcon = new ImageIcon(this.getClass().getResource("/images/btn_minus.png"));
    private Icon addDevIcon = new ImageIcon(this.getClass().getResource("/images/network_edit.png"));
    private Icon delDevIcon = new ImageIcon(this.getClass().getResource("/images/network_delete.png"));
    private Icon addDevCheckedIcon = new ImageIcon(this.getClass().getResource("/images/network_edit_checked.png"));
    private Icon delDevCheckedIcon = new ImageIcon(this.getClass().getResource("/images/network_delete_checked.png"));
    private PopupWrapper ipv4AddressPopup = new PopupWrapper();
    private PopupWrapper ipv4SubnetMaskPopup = new PopupWrapper();
    private PopupWrapper ipv4GatewayPopup = new PopupWrapper();
    private PopupWrapper ipv4PrimaryDNSPopup = new PopupWrapper();
    private PopupWrapper ipv4SecondaryDNSPopup = new PopupWrapper();
    private PopupWrapper ipv6AddressPopup = new PopupWrapper();
    private PopupWrapper ipv6DNSPopup = new PopupWrapper();
    private PopupWrapper ipv6RoutePrefixPopup = new PopupWrapper();
    private PopupWrapper ipv6RouteAddressPopup = new PopupWrapper();
    private PopupWrapper generalVLANIDPopup = new PopupWrapper();
    private DropShadowPanel ipv4SettingBasePanel = new DropShadowPanel();
    private DropShadowPanel ipv6SettingBasePanel = new DropShadowPanel();
    private DropShadowPanel generalSettingPanel = new DropShadowPanel();
    private ToggleSwitch ipv4EnableToggleButton = new ToggleSwitch();
    private ToggleSwitch ipv6EnableToggleButton = new ToggleSwitch();
    private ToggleSwitch ipv6AutoConfigToggleButton = new ToggleSwitch();
    private ToggleSwitch ipv6StaticRouteToggleButton = new ToggleSwitch();
    private ToggleSwitch generalVLANToggleButton = new ToggleSwitch();
    private WideComboBox<WideComboBoxItem<String>> ipv6AddressListComboBox = new WideComboBox();
    private WideComboBox<WideComboBoxItem<String>> ipv6StaticRouteComboBox = new WideComboBox();
    private boolean ipv4AdvanceEnable = false;
    private boolean ipv6AdvanceEnable = false;
    private boolean enableTabChangeReload = true;
    private boolean enableSubTabChangeReload = false;
    private String defaultFont;
    private SWindow popupWindow;
    private ComboTabListener comboTabListener;
    private NetworkSettingControl controller = new NetworkSettingControl(this);

    private void setComponentsLayout() {
        MigLayout mainlayout = new MigLayout("", "[grow][][grow]", "[]1[]");
        MigLayout ipV4Layout = new MigLayout("", "10[]3[grow]12", "15[]10[]5[]25[]10[]10[]10[]12");
        MigLayout ipV6layout = new MigLayout("", "10[]3[][grow]5", "15[]10[]5[]5[]10[]10[]18[]14");
        MigLayout ipV4ADlayout = new MigLayout("", "15[]15[grow]5", "[]");
        MigLayout ipV6ADlayout = new MigLayout("", "5[]3[]3[grow]8", "10[]5[]5[]5[]5[]5[]5[]7");
        MigLayout generalLayout = new MigLayout("", "20[]170![]", "15[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]10[]15");
        this.setLayout(mainlayout);
        this.ipv4SettingAdvancedPanel.setLayout(ipV4ADlayout);
        this.ipv6SettingAdvancedPanel.setLayout(ipV6ADlayout);
        this.ipv4SettingBasePanel.setLayout(new BoxLayout(this.ipv4SettingBasePanel, 1));
        this.ipv6SettingBasePanel.setLayout(new BoxLayout(this.ipv6SettingBasePanel, 1));
        this.ipv4SettingAdvancedTitlePanel.setLayout(new BoxLayout(this.ipv4SettingAdvancedTitlePanel, 0));
        this.ipv6SettingAdvancedTitlePanel.setLayout(new BoxLayout(this.ipv6SettingAdvancedTitlePanel, 0));
        this.ipSettingBasePanel.setLayout(new BoxLayout(this.ipSettingBasePanel, 0));
        this.ipv4SettingPanel.setLayout(ipV4Layout);
        this.ipv6SettingPanel.setLayout(ipV6layout);
        this.generalSettingPanel.setLayout(generalLayout);
        this.ipv4AdvanceSettingToggleLabel.setHorizontalAlignment(11);
        this.ipv6AdvanceSettingToggleLabel.setHorizontalAlignment(11);
        this.ipv4SettingPanel.add((Component)this.ipv4TitleLabel, "cell 0 0");
        this.ipv4SettingPanel.add((Component)this.ipv4EnableToggleButton, "cell 0 0, gapleft 20");
        this.ipv4SettingPanel.add((Component)this.ipv4DHCPRadioButton, "cell 0 1 2 1");
        this.ipv4SettingPanel.add((Component)this.ipv4StaticIPRadioButton, "cell 0 2 2 1");
        this.ipv4SettingPanel.add((Component)this.ipv4AddressLabel, "cell 0 3");
        this.ipv4SettingPanel.add((Component)this.ipv4AddressTextField, "cell 1 3, growx, gapright 15");
        this.ipv4SettingPanel.add((Component)this.ipv4SubnetMaskLabel, "cell 0 4");
        this.ipv4SettingPanel.add((Component)this.ipv4SubnetMaskTextField, "cell 1 4, growx, gapright 15");
        this.ipv4SettingPanel.add((Component)this.ipv4GatewayAddressLabel, "cell 0 5");
        this.ipv4SettingPanel.add((Component)this.ipv4GatewayTextField, "cell 1 5, growx, gapright 15");
        this.ipv4SettingPanel.add((Component)this.ipv4SettingAdvancedTitlePanel, "cell 0 6 2 1, growx");
        this.ipv4SettingAdvancedPanel.add((Component)this.ipv4PrimaryDNSLabel, "cell 0 0, gapleft 10");
        this.ipv4SettingAdvancedPanel.add((Component)this.ipv4PrimaryDNSTextField, "cell 1 0, growx, gapright 22");
        this.ipv6SettingPanel.add((Component)this.ipv6TitleLabel, "cell 0 0");
        this.ipv6SettingPanel.add((Component)this.ipv6EnableToggleButton, "cell 0 0, gapleft 20");
        this.ipv6SettingPanel.add((Component)this.ipv6DHCPLabel, "cell 0 1");
        this.ipv6SettingPanel.add((Component)this.ipv6DHCPDisableRadioButton, "cell 2 1");
        this.ipv6SettingPanel.add((Component)this.ipv6DHCPStatelessRadioButton, "cell 2 2");
        this.ipv6SettingPanel.add((Component)this.ipv6StatefulRadioButton, "cell 2 3");
        this.ipv6SettingPanel.add((Component)this.ipv6AddressLabel, "cell 0 4");
        this.ipv6SettingPanel.add(this.ipv6AddressListComboBox, "cell 2 4, gapleft 5");
        this.ipv6SettingPanel.add((Component)this.ipv6AddressListLabel, "cell 0 5");
        this.ipv6SettingPanel.add((Component)this.ipv6AddressDelButton, "cell 1 5, align right");
        this.ipv6SettingPanel.add((Component)this.ipv6AddressAddButton, "cell 1 5, align right");
        this.ipv6SettingPanel.add((Component)this.ipv6AddressTextField, "cell 2 5, growx, gapleft 5, gapright 15");
        this.ipv6SettingPanel.add((Component)this.ipv6SettingAdvancedTitlePanel, "cell 0 6 3 1, growx");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6AutoConfigLabel, "cell 0 0, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6AutoConfigToggleButton, "cell 2 0, gapleft 11");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6DNSLabel, "cell 0 1, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6DNSTextField, "cell 2 1, growx, gapleft 11, gapright 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6DUIDLabel, "cell 0 2, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6DUIDTextField, "cell 2 2, growx, gapleft 11, gapright 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6StaticRouteLabel, "cell 0 3, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6StaticRouteToggleButton, "cell 2 3, gapleft 11");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6StaticRouteListLabel, "cell 0 4, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6RouteListDelButton, "cell 1 4, gapleft 25");
        this.ipv6SettingAdvancedPanel.add(this.ipv6StaticRouteComboBox, "cell 2 4, gapleft 11");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6PrefixRouteLabel, "cell 0 5, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6RoutePrefixTextField, "cell 2 5, growx, gapleft 11, gapright 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6RouteAddressLabel, "cell 0 6, gapleft 15");
        this.ipv6SettingAdvancedPanel.add((Component)this.ipv6RouteAddressTextField, "cell 2 6, growx, gapleft 11, gapright 15");
        this.generalSettingPanel.add((Component)this.generalTitleLabel, "cell 0 0");
        this.generalSettingPanel.add((Component)this.generalHostnameLabel, "cell 0 1");
        this.generalSettingPanel.add((Component)this.generalHostnameTextField, "cell 1 1");
        this.generalSettingPanel.add((Component)this.generalMACLabel, "cell 0 2");
        this.generalSettingPanel.add((Component)this.generalMACTextField, "cell 1 2");
        this.generalSettingPanel.add((Component)this.generalVLANLabel, "cell 0 3");
        this.generalSettingPanel.add((Component)this.generalVLANToggleButton, "cell 1 3");
        this.generalSettingPanel.add((Component)this.generalVLANIDLabel, "cell 0 4");
        this.generalSettingPanel.add((Component)this.generalVLANIDTextField, "cell 1 4");
        this.generalSettingPanel.add((Component)this.generalLANInterfaceLabel, "cell 0 5");
        this.generalSettingPanel.add((Component)this.generalDedicatedRadioButton, "cell 1 5");
        this.generalSettingPanel.add((Component)this.generalShareRadioButton, "cell 1 5");
        this.generalSettingPanel.add((Component)this.generalFailoverRadioButton, "cell 1 5");
        this.generalSettingPanel.add((Component)this.generalRMCPPortLabel, "cell 0 6");
        this.generalSettingPanel.add((Component)this.generalRMCPPortTextField, "cell 1 6");
        this.generalSettingPanel.add((Component)this.generalActiveInterfaceLabel, "cell 0 7");
        this.generalSettingPanel.add((Component)this.generalActiveInterfaceValueLabel, "cell 1 7");
        this.generalSettingPanel.add((Component)this.generalDedicatedTitleLabel, "cell 0 8");
        this.generalSettingPanel.add((Component)this.generalDedicatedLinkLabel, "cell 0 9");
        this.generalSettingPanel.add((Component)this.generalDedicatedLinkValueLabel, "cell 1 9");
        this.generalSettingPanel.add((Component)this.generalDedicatedStatusLabel, "cell 0 10");
        this.generalSettingPanel.add((Component)this.generalDedicatedStatusValueLabel, "cell 1 10");
        this.generalSettingPanel.add((Component)this.generalDedicatedSpeedLabel, "cell 0 11");
        this.generalSettingPanel.add((Component)this.generalDedicatedSpeedValueLabel, "cell 1 11");
        this.generalSettingPanel.add((Component)this.generalDedicatedDuplexLabel, "cell 0 12");
        this.generalSettingPanel.add((Component)this.generalDedicatedDuplexValueLabel, "cell 1 12");
        this.generalSettingPanel.add((Component)this.generalShareTitleLabel, "cell 0 13");
        this.generalSettingPanel.add((Component)this.generalShareStatusLabel, "cell 0 14");
        this.generalSettingPanel.add((Component)this.generalShareStatusValueLabel, "cell 1 14");
        this.generalSettingPanel.add((Component)this.generalShareSpeedLabel, "cell 0 15");
        this.generalSettingPanel.add((Component)this.generalShareSpeedValueLabel, "cell 1 15");
        this.generalSettingPanel.add((Component)this.generalShareDuplexLabel, "cell 0 16");
        this.generalSettingPanel.add((Component)this.generalShareDuplexValueLabel, "cell 1 16");
        this.ipv6SettingBasePanel.add(this.ipv6SettingPanel);
        this.ipv6SettingBasePanel.add(this.ipv6SettingAdvancedPanel);
        this.ipv4SettingBasePanel.add(this.ipv4SettingPanel);
        this.ipv4SettingBasePanel.add(this.ipv4SettingAdvancedPanel);
        this.ipv4SettingBasePanel.add(this.ipv4ExtensionComponent);
        this.ipv4SettingAdvancedTitlePanel.add(this.ipv4AdvanceSettingLabel);
        this.ipv4SettingAdvancedTitlePanel.add(Box.createHorizontalGlue());
        this.ipv4SettingAdvancedTitlePanel.add(this.ipv4AdvanceSettingToggleLabel);
        this.ipv6SettingAdvancedTitlePanel.add(this.ipv6AdvanceSettingLabel);
        this.ipv6SettingAdvancedTitlePanel.add(Box.createHorizontalGlue());
        this.ipv6SettingAdvancedTitlePanel.add(this.ipv6AdvanceSettingToggleLabel);
        this.ipSettingBasePanel.add(this.ipv4SettingBasePanel);
        this.ipSettingBasePanel.add(this.ipv6SettingBasePanel);
        this.add((Component)this.ipSettingBasePanel, "dock north");
        this.add((Component)this.generalSettingPanel, "dock south");
    }

    private void setComponentMisc() {
        this.ipv6AddressAddButton.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.ipv6AddressDelButton.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.ipv6RouteListDelButton.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.ipv4SettingAdvancedPanel.setVisible(false);
        this.ipv4ExtensionComponent.setVisible(false);
        this.ipv6SettingAdvancedPanel.setVisible(false);
        this.ipv4RadioButtonGroup.add(this.ipv4DHCPRadioButton);
        this.ipv4RadioButtonGroup.add(this.ipv4StaticIPRadioButton);
        this.ipv6RadioButtonGroup.add(this.ipv6DHCPDisableRadioButton);
        this.ipv6RadioButtonGroup.add(this.ipv6DHCPStatelessRadioButton);
        this.ipv6RadioButtonGroup.add(this.ipv6StatefulRadioButton);
        this.lanInterfaceRadioButtonGroup.add(this.generalDedicatedRadioButton);
        this.lanInterfaceRadioButtonGroup.add(this.generalShareRadioButton);
        this.lanInterfaceRadioButtonGroup.add(this.generalFailoverRadioButton);
        this.ipv4DHCPRadioButton.setSelected(true);
        this.ipv6DHCPDisableRadioButton.setSelected(true);
        this.generalDedicatedRadioButton.setSelected(true);
        this.ipv6DUIDTextField.setEditable(false);
        this.generalMACTextField.setEditable(false);
        this.generalRMCPPortTextField.setEditable(false);
    }

    private void setComponentsColor() {
        this.setBackground(new Color(240, 240, 240));
        this.ipv6AddressAddButton.setBackground(new Color(240, 240, 240));
        this.ipv6AddressDelButton.setBackground(new Color(240, 240, 240));
        this.ipv6RouteListDelButton.setBackground(new Color(192, 192, 192));
        this.ipv4SettingAdvancedPanel.setBackground(Color.LIGHT_GRAY);
        this.ipv6SettingAdvancedPanel.setBackground(Color.LIGHT_GRAY);
        this.ipv6AutoConfigToggleButton.setFillBackround(true);
        this.ipv6StaticRouteToggleButton.setFillBackround(true);
    }

    private void setComponentsSize() {
        int textFieldWidth = 150;
        int textFieldHeight = 20;
        this.generalHostnameTextField.setMinimumSize(new Dimension(150, 20));
        this.generalMACTextField.setMinimumSize(new Dimension(150, 20));
        this.generalVLANIDTextField.setMinimumSize(new Dimension(150, 20));
        this.generalRMCPPortTextField.setMinimumSize(new Dimension(150, 20));
        this.generalVLANToggleButton.setMinimumSize(new Dimension(30, 20));
        int toggleBtnWidth = 57;
        int toggleBtnHeight = 20;
        this.ipv4EnableToggleButton.setMinimumSize(new Dimension(57, 20));
        this.ipv6EnableToggleButton.setMinimumSize(new Dimension(57, 20));
        this.ipv6AutoConfigToggleButton.setMinimumSize(new Dimension(57, 20));
        this.ipv6StaticRouteToggleButton.setMinimumSize(new Dimension(57, 20));
        this.generalVLANToggleButton.setMinimumSize(new Dimension(57, 20));
    }

    private void setComponentsFontAndText() {
        int titleFontSize = 12;
        this.ipv4TitleLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.ipv4AdvanceSettingLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.ipv6TitleLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.ipv6AdvanceSettingLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.generalTitleLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.generalDedicatedTitleLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.generalShareTitleLabel.setFont(new Font(this.defaultFont, 1, 12));
        this.ipv4EnableToggleButton.setFont(this.defaultFont);
        this.ipv6EnableToggleButton.setFont(this.defaultFont);
        this.ipv6AutoConfigToggleButton.setFont(this.defaultFont);
        this.ipv6StaticRouteToggleButton.setFont(this.defaultFont);
        this.generalVLANToggleButton.setFont(this.defaultFont);
        this.ipv4TitleLabel.setText("IPv4");
        this.ipv4AddressLabel.setText("IP Address");
        this.ipv4SubnetMaskLabel.setText("Subnet Mask");
        this.ipv4GatewayAddressLabel.setText("Gateway");
        this.ipv4AdvanceSettingLabel.setText("Advanced Settings");
        this.ipv4PrimaryDNSLabel.setText("DNS Server1 IP");
        this.ipv4SecondaryDNSLabel.setText("DNS Server2 IP");
        this.ipv6TitleLabel.setText("IPv6");
        this.ipv6DHCPLabel.setText("DHCP");
        this.ipv6AddressLabel.setText("IPv6 Address");
        this.ipv6AddressListLabel.setText("Address List");
        this.ipv6AdvanceSettingLabel.setText("Advanced Settings");
        this.ipv6AutoConfigLabel.setText("Auto Configuration");
        this.ipv6DNSLabel.setText("DNS Server IP");
        this.ipv6DUIDLabel.setText("DUID");
        this.ipv6StaticRouteLabel.setText("Enable Static Route");
        this.ipv6StaticRouteListLabel.setText("Static Route List");
        this.ipv6PrefixRouteLabel.setText("Prefix to Route");
        this.ipv6RouteAddressLabel.setText("Router Address");
        this.generalTitleLabel.setText("General");
        this.generalHostnameLabel.setText("Hostname");
        this.generalMACLabel.setText("MAC Address");
        this.generalVLANLabel.setText("VLAN");
        this.generalVLANIDLabel.setText("VLAN ID");
        this.generalLANInterfaceLabel.setText("LAN Interface");
        this.generalRMCPPortLabel.setText("RMCP Port");
        this.generalActiveInterfaceLabel.setText("Active Interface");
        this.generalActiveInterfaceValueLabel.setText("Dedicated");
        this.generalDedicatedTitleLabel.setText("Dedicated");
        this.generalDedicatedLinkLabel.setText("Link");
        this.generalDedicatedStatusLabel.setText("Status");
        this.generalDedicatedStatusValueLabel.setText("Connected");
        this.generalDedicatedSpeedLabel.setText("Speed");
        this.generalDedicatedSpeedValueLabel.setText("1G");
        this.generalDedicatedDuplexLabel.setText("Duplex");
        this.generalDedicatedDuplexValueLabel.setText("Full Duplex");
        this.generalShareTitleLabel.setText("Share");
        this.generalShareStatusLabel.setText("Status");
        this.generalShareStatusValueLabel.setText("Disconnected");
        this.generalShareSpeedLabel.setText("Speed");
        this.generalShareSpeedValueLabel.setText("Unknown");
        this.generalShareDuplexLabel.setText("Duplex");
        this.generalShareDuplexValueLabel.setText("Unknown");
        this.ipv4DHCPRadioButton.setText("Obtain an IP address automatically (use DHCP)");
        this.ipv4StaticIPRadioButton.setText("Use the following IP address");
        this.ipv6DHCPDisableRadioButton.setText("DHCPv6 Disabled");
        this.ipv6DHCPStatelessRadioButton.setText("DHCPv6 Stateless");
        this.ipv6StatefulRadioButton.setText("DHCPv6 Stateful");
        this.generalDedicatedRadioButton.setText("Dedicated");
        this.generalShareRadioButton.setText("Share");
        this.generalFailoverRadioButton.setText("Failover");
    }

    private void setComponentsIcon() {
        this.ipv4AdvanceSettingLabel.setIcon(this.advIcon);
        this.ipv4AdvanceSettingToggleLabel.setIcon(this.addIcon);
        this.ipv6AdvanceSettingLabel.setIcon(this.advIcon);
        this.ipv6AdvanceSettingToggleLabel.setIcon(this.addIcon);
        this.ipv6AddressAddButton.setIcon(this.addDevIcon);
        this.ipv6AddressDelButton.setIcon(this.delDevIcon);
        this.ipv6RouteListDelButton.setIcon(this.delDevIcon);
    }

    private void setComponentsListenser() {
        this.ipv4EnableToggleButton.addActionListenser(e2 -> {
            this.setIPv4PanelEnable(e2, false);
            this.controller.getProperties().setIPv4Enable(e2);
        });
        this.ipv6EnableToggleButton.addActionListenser(e2 -> {
            this.setIPv6PanelEnable(e2, false);
            this.controller.getProperties().setIPv6Enable(e2);
        });
        this.ipv6AutoConfigToggleButton.addActionListenser(e2 -> this.controller.getProperties().setIPv6EnableAutoConfig(e2));
        this.ipv6StaticRouteToggleButton.addActionListenser(e2 -> {
            this.setRouterPanelEnable(e2);
            this.controller.getProperties().setIPv6EnableStaticRoute(e2);
        });
        this.generalVLANToggleButton.addActionListenser(e2 -> {
            this.generalVLANIDTextField.setEnabled(e2);
            this.controller.getProperties().setGeneralEnableVLAN(e2);
        });
        this.ipv6AddressListComboBox.addActionListener(e2 -> {
            int selectedIdx = this.ipv6AddressListComboBox.getSelectedIndex();
            this.ipv6AddressTextField.setText(selectedIdx <= 0 ? "" : this.controller.getProperties().getIPv6AddressList().get(selectedIdx - 1));
            this.setPopupVisible(this.ipv6AddressTextField, this.ipv6AddressPopup, false, this.INVALID_IPV6_ADDRESS);
            this.ipv6AddressAddButton.setSelected(false);
            this.ipv6AddressDelButton.setSelected(false);
        });
        this.ipv6StaticRouteComboBox.addActionListener(e2 -> {
            int selectedIdx = this.ipv6StaticRouteComboBox.getSelectedIndex();
            this.ipv6RoutePrefixTextField.setText(selectedIdx <= 0 ? "" : this.controller.getProperties().getIPv6PrefixRouteList().get(selectedIdx - 1));
            this.ipv6RouteAddressTextField.setText(selectedIdx <= 0 ? "" : this.controller.getProperties().getIPv6RouterAddressList().get(selectedIdx - 1));
            this.setPopupVisible(this.ipv6RoutePrefixTextField, this.ipv6RoutePrefixPopup, false, this.INVALID_IPV6_ROUTE_PREFIX);
            this.setPopupVisible(this.ipv6RouteAddressTextField, this.ipv6RouteAddressPopup, false, this.INVALID_IPV6_ROUTE_ADDRESS);
        });
        ActionListener radioButtonListener = e2 -> {
            if (e2.getSource() == this.ipv4DHCPRadioButton) {
                this.controller.getProperties().setIPv4DhcpMode(2);
                this.setIPv4StaticConfigEnabled(false);
            } else if (e2.getSource() == this.ipv4StaticIPRadioButton) {
                this.controller.getProperties().setIPv4DhcpMode(1);
                this.setIPv4StaticConfigEnabled(true);
            } else if (e2.getSource() == this.ipv6DHCPDisableRadioButton) {
                this.controller.getProperties().setIPv6DhcpMode(2);
            } else if (e2.getSource() == this.ipv6DHCPStatelessRadioButton) {
                this.controller.getProperties().setIPv6DhcpMode(0);
            } else if (e2.getSource() == this.ipv6StatefulRadioButton) {
                this.controller.getProperties().setIPv6DhcpMode(1);
            } else if (e2.getSource() == this.generalDedicatedRadioButton) {
                this.controller.getProperties().setGeneralLanInterfaceMode(0);
            } else if (e2.getSource() == this.generalShareRadioButton) {
                this.controller.getProperties().setGeneralLanInterfaceMode(1);
            } else if (e2.getSource() == this.generalFailoverRadioButton) {
                this.controller.getProperties().setGeneralLanInterfaceMode(2);
            }
        };
        this.ipv4DHCPRadioButton.addActionListener(radioButtonListener);
        this.ipv4StaticIPRadioButton.addActionListener(radioButtonListener);
        this.ipv6DHCPDisableRadioButton.addActionListener(radioButtonListener);
        this.ipv6DHCPStatelessRadioButton.addActionListener(radioButtonListener);
        this.ipv6StatefulRadioButton.addActionListener(radioButtonListener);
        this.generalDedicatedRadioButton.addActionListener(radioButtonListener);
        this.generalShareRadioButton.addActionListener(radioButtonListener);
        this.generalFailoverRadioButton.addActionListener(radioButtonListener);
        MouseListener advancePanelMouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                Object obj = e2.getSource();
                if (obj.equals(NetworkSettingView.this.ipv4AdvanceSettingLabel) || obj.equals(NetworkSettingView.this.ipv4AdvanceSettingToggleLabel) || obj.equals(NetworkSettingView.this.ipv4SettingAdvancedTitlePanel)) {
                    NetworkSettingView.this.ipv4AdvanceEnable = !NetworkSettingView.this.ipv4AdvanceEnable;
                    SwingUtilities.invokeLater(() -> {
                        NetworkSettingView.this.ipv4AdvanceSettingToggleLabel.setIcon(NetworkSettingView.this.ipv4AdvanceEnable ? NetworkSettingView.this.minusIcon : NetworkSettingView.this.addIcon);
                        NetworkSettingView.this.ipv4ExtensionComponent.setVisible(NetworkSettingView.this.ipv4AdvanceEnable && NetworkSettingView.this.ipv6AdvanceEnable);
                        NetworkSettingView.this.ipv4SettingAdvancedPanel.setVisible(NetworkSettingView.this.ipv4AdvanceEnable);
                        NetworkSettingView.this.instance.invalidate();
                        NetworkSettingView.this.instance.repaint();
                    });
                } else if (obj.equals(NetworkSettingView.this.ipv6AdvanceSettingLabel) || obj.equals(NetworkSettingView.this.ipv6AdvanceSettingToggleLabel) || obj.equals(NetworkSettingView.this.ipv6SettingAdvancedTitlePanel)) {
                    NetworkSettingView.this.ipv6AdvanceEnable = !NetworkSettingView.this.ipv6AdvanceEnable;
                    SwingUtilities.invokeLater(() -> {
                        NetworkSettingView.this.ipv6AdvanceSettingToggleLabel.setIcon(NetworkSettingView.this.ipv6AdvanceEnable ? NetworkSettingView.this.minusIcon : NetworkSettingView.this.addIcon);
                        NetworkSettingView.this.ipv4ExtensionComponent.setVisible(NetworkSettingView.this.ipv6AdvanceEnable && NetworkSettingView.this.ipv4AdvanceEnable);
                        NetworkSettingView.this.ipv6SettingAdvancedPanel.setVisible(NetworkSettingView.this.ipv6AdvanceEnable);
                    });
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                NetworkSettingView.this.instance.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                NetworkSettingView.this.instance.setCursor(new Cursor(0));
            }
        };
        FocusListener textFieldFocusLostListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e2) {
                NetworkSettingView.this.checkTextField(e2);
            }

            @Override
            public void focusGained(FocusEvent e2) {
            }
        };
        MouseListener textFieldMouseClickedListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                NetworkSettingView.this.checkTextField(e2);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        };
        this.ipv4AdvanceSettingLabel.addMouseListener(advancePanelMouseListener);
        this.ipv4AdvanceSettingToggleLabel.addMouseListener(advancePanelMouseListener);
        this.ipv4SettingAdvancedTitlePanel.addMouseListener(advancePanelMouseListener);
        this.ipv6AdvanceSettingLabel.addMouseListener(advancePanelMouseListener);
        this.ipv6AdvanceSettingToggleLabel.addMouseListener(advancePanelMouseListener);
        this.ipv6SettingAdvancedTitlePanel.addMouseListener(advancePanelMouseListener);
        this.ipv4AddressTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv4SubnetMaskTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv4GatewayTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv4PrimaryDNSTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv4SecondaryDNSTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv6DNSTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv6AddressTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv6RoutePrefixTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv6RouteAddressTextField.addFocusListener(textFieldFocusLostListener);
        this.generalHostnameTextField.addFocusListener(textFieldFocusLostListener);
        this.generalVLANIDTextField.addFocusListener(textFieldFocusLostListener);
        this.ipv4AddressTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv4SubnetMaskTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv4GatewayTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv4PrimaryDNSTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv4SecondaryDNSTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv6DNSTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv6AddressTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv6RoutePrefixTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv6RouteAddressTextField.addMouseListener(textFieldMouseClickedListener);
        this.generalHostnameTextField.addMouseListener(textFieldMouseClickedListener);
        this.generalVLANIDTextField.addMouseListener(textFieldMouseClickedListener);
        this.ipv6AddressAddButton.addItemListener(e2 -> {
            if (e2.getStateChange() == 1) {
                this.ipv6AddressAddButton.setIcon(this.addDevCheckedIcon);
                this.ipv6AddressDelButton.setIcon(this.delDevIcon);
                this.ipv6AddressDelButton.setSelected(false);
                this.ipv6AddressDelButton.setBorder(new EmptyBorder(2, 2, 2, 2));
                this.controller.getProperties().setIPv6AddressPendingAdd(this.ipv6AddressTextField.getText());
                this.controller.getProperties().clearIPv6AddressPendingDel();
                this.errCodeRecorderSet.remove(this.INVALID_IPV6_ADD_DEL);
            } else if (e2.getStateChange() == 2) {
                this.ipv6AddressAddButton.setIcon(this.addDevIcon);
                this.controller.getProperties().clearIPv6AddressPendingAdd();
                if (!this.ipv6AddressDelButton.isSelected() && !this.ipv6AddressTextField.getText().isEmpty()) {
                    this.errCodeRecorderSet.remove(this.INVALID_IPV6_ADD_DEL);
                }
            }
        });
        this.ipv6AddressDelButton.addItemListener(e2 -> {
            if (e2.getStateChange() == 1) {
                this.ipv6AddressDelButton.setIcon(this.delDevCheckedIcon);
                this.ipv6AddressAddButton.setIcon(this.addDevIcon);
                this.ipv6AddressAddButton.setSelected(false);
                this.ipv6AddressDelButton.setBorder(new EmptyBorder(2, -2, 0, 0));
                this.controller.getProperties().setIPv6AddressPendingDel(this.ipv6AddressTextField.getText());
                this.controller.getProperties().clearIPv6AddressPendingAdd();
                this.errCodeRecorderSet.remove(this.INVALID_IPV6_ADD_DEL);
            } else if (e2.getStateChange() == 2) {
                this.ipv6AddressDelButton.setIcon(this.delDevIcon);
                this.ipv6AddressDelButton.setBorder(new EmptyBorder(2, 2, 2, 2));
                this.controller.getProperties().clearIPv6AddressPendingDel();
                if (!this.ipv6AddressAddButton.isSelected() && !this.ipv6AddressTextField.getText().isEmpty()) {
                    this.errCodeRecorderSet.remove(this.INVALID_IPV6_ADD_DEL);
                }
            }
        });
        this.ipv6RouteListDelButton.addItemListener(e2 -> {
            if (e2.getStateChange() == 1) {
                this.ipv6RouteListDelButton.setIcon(this.delDevCheckedIcon);
                this.ipv6RouteListDelButton.setBorder(new EmptyBorder(2, -2, 0, 0));
                if (this.ipv6StaticRouteComboBox.getSelectedIndex() > 0) {
                    this.controller.getProperties().clearIPv6RouteAddressList(this.ipv6StaticRouteComboBox.getSelectedIndex() - 1);
                    this.controller.getProperties().clearIPv6PrefixRouteList(this.ipv6StaticRouteComboBox.getSelectedIndex() - 1);
                }
            } else if (e2.getStateChange() == 2) {
                this.ipv6RouteListDelButton.setIcon(this.delDevIcon);
                this.ipv6RouteListDelButton.setBorder(new EmptyBorder(2, 2, 2, 2));
                if (this.ipv6StaticRouteComboBox.getSelectedIndex() > 0) {
                    int index = this.ipv6StaticRouteComboBox.getSelectedIndex() - 1;
                    this.controller.getProperties().setIPv6RouterAddressList(this.controller.getProfile().retrieve().getIPv6RouterAddressList().get(index), index);
                    this.controller.getProperties().setIPv6PrefixRouteList(this.controller.getProfile().retrieve().getIPv6RouterAddressList().get(index), index);
                }
            }
        });
    }

    public NetworkSettingView(ComboTabListener listener, String font) {
        this.popupWindow = new SWindow(IPMIView20.getInstance());
        this.comboTabListener = listener;
        this.defaultFont = font;
        this.setComponentsLayout();
        this.setComponentMisc();
        this.setComponentsColor();
        this.setComponentsSize();
        this.setComponentsFontAndText();
        this.setComponentsIcon();
        this.setComponentsListenser();
    }

    public void init(CSession session) {
        this.controller.setControlSession(session);
        this.controller.setControllerConfig();
    }

    public void load() {
        if (this.enableTabChangeReload) {
            this.clearPopups();
            this.setTextfieldValid(true);
            this.disableWholePage();
            this.controller.load(false);
            this.enableTabChangeReload = false;
        }
    }

    public void close() {
        if (this.popupWindow != null) {
            new Thread(() -> this.popupWindow.setVisible(false)).start();
        }
    }

    private void setIPv4PanelEnable(boolean enable, boolean setToggleSwitch) {
        this.ipv4EnableToggleButton.setEnabled(setToggleSwitch ? enable : this.ipv4EnableToggleButton.isEnabled());
        this.ipv4DHCPRadioButton.setEnabled(enable);
        this.ipv4StaticIPRadioButton.setEnabled(enable);
        this.setIPv4StaticConfigEnabled(enable && this.ipv4StaticIPRadioButton.isSelected());
    }

    private void setIPv6PanelEnable(boolean enable, boolean setToggleSwitch) {
        this.ipv6EnableToggleButton.setEnabled(setToggleSwitch ? enable : this.ipv6EnableToggleButton.isEnabled());
        this.ipv6DHCPDisableRadioButton.setEnabled(enable);
        this.ipv6DHCPStatelessRadioButton.setEnabled(enable);
        this.ipv6StatefulRadioButton.setEnabled(enable);
        this.ipv6AddressTextField.setEnabled(enable);
        this.ipv6DNSTextField.setEnabled(enable);
        this.ipv6RoutePrefixTextField.setEnabled(enable);
        this.ipv6RouteAddressTextField.setEnabled(enable);
        this.ipv6AddressListComboBox.setEnabled(enable);
        this.ipv6StaticRouteComboBox.setEnabled(enable);
        this.ipv6AutoConfigToggleButton.setEnabled(enable);
        this.ipv6StaticRouteToggleButton.setEnabled(enable);
        this.ipv6AddressAddButton.setEnabled(enable);
        this.ipv6AddressDelButton.setEnabled(enable);
        this.ipv6RouteListDelButton.setEnabled(enable);
    }

    private void setRouterPanelEnable(boolean enable) {
        this.ipv6StaticRouteComboBox.setEnabled(enable);
        this.ipv6RoutePrefixTextField.setEnabled(enable);
        this.ipv6RouteAddressTextField.setEnabled(enable);
        this.ipv6RouteListDelButton.setEnabled(enable);
    }

    private void setGeneralPanelEnable(boolean enable) {
        this.generalHostnameTextField.setEnabled(enable);
        this.generalVLANToggleButton.setEnabled(enable);
        this.generalDedicatedRadioButton.setEnabled(enable);
        this.generalShareRadioButton.setEnabled(enable);
        this.generalFailoverRadioButton.setEnabled(enable);
    }

    private void setIPv4StaticConfigEnabled(boolean enabled) {
        this.ipv4AddressTextField.setEnabled(enabled);
        this.ipv4SubnetMaskTextField.setEnabled(enabled);
        this.ipv4GatewayTextField.setEnabled(enabled);
        this.ipv4PrimaryDNSTextField.setEnabled(enabled);
        this.ipv4SecondaryDNSTextField.setEnabled(enabled);
    }

    private void disableWholePage() {
        this.setIPv4PanelEnable(false, true);
        this.setIPv6PanelEnable(false, true);
        this.setGeneralPanelEnable(false);
    }

    private void checkTextField(ComponentEvent e2) {
        RoundTextField textfield = (RoundTextField)e2.getSource();
        String input = textfield.getText();
        if (textfield.equals(this.ipv4AddressTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv4Address(input);
            this.setPopupVisible(this.ipv4AddressTextField, this.ipv4AddressPopup, invalidInput, this.INVALID_IPV4_ADDRESS);
        } else if (textfield.equals(this.ipv4SubnetMaskTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv4SubMask(input);
            this.setPopupVisible(this.ipv4SubnetMaskTextField, this.ipv4SubnetMaskPopup, invalidInput, this.INVALID_IPV4_SUBMASK);
        } else if (textfield.equals(this.ipv4GatewayTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv4Gateway(input);
            this.setPopupVisible(this.ipv4GatewayTextField, this.ipv4GatewayPopup, invalidInput, this.INVALID_IPV4_GATEWAY);
        } else if (textfield.equals(this.ipv4PrimaryDNSTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv4PrimaryDNSServer(input, true);
            this.setPopupVisible(this.ipv4PrimaryDNSTextField, this.ipv4PrimaryDNSPopup, invalidInput, this.INVALID_IPV4_PRIMARY_DNS);
        } else if (textfield.equals(this.ipv4SecondaryDNSTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv4SecondaryDNSServer(input, true);
            this.setPopupVisible(this.ipv4SecondaryDNSTextField, this.ipv4SecondaryDNSPopup, invalidInput, this.INVALID_IPV4_SECONDARY_DNS);
        } else if (textfield.equals(this.ipv6DNSTextField)) {
            boolean invalidInput = !this.controller.getProperties().setIPv6DNSServer(input);
            this.setPopupVisible(this.ipv6DNSTextField, this.ipv6DNSPopup, invalidInput, this.INVALID_IPV6_DNS);
        } else if (textfield.equals(this.ipv6AddressTextField)) {
            if (!input.isEmpty()) {
                if (!NetworkSettingUtility.isValidIPv6(input, true) || !NetworkSettingUtility.isValidIPv6Prefix(input)) {
                    this.setPopupVisible(this.ipv6AddressTextField, this.ipv6AddressPopup, true, this.INVALID_IPV6_ADDRESS);
                } else if (!this.ipv6AddressPopup.isPopupEmpty()) {
                    this.setPopupVisible(this.ipv6AddressTextField, this.ipv6AddressPopup, false, this.INVALID_IPV6_ADDRESS);
                }
                if (!this.ipv6AddressAddButton.isSelected() && !this.ipv6AddressDelButton.isSelected()) {
                    this.errCodeRecorderSet.add(this.INVALID_IPV6_ADD_DEL);
                }
            } else {
                this.setPopupVisible(this.ipv6AddressTextField, this.ipv6AddressPopup, false, this.INVALID_IPV6_ADDRESS);
                this.errCodeRecorderSet.remove(this.INVALID_IPV6_ADD_DEL);
            }
        } else if (textfield.equals(this.ipv6RoutePrefixTextField)) {
            if (this.ipv6StaticRouteComboBox.getSelectedIndex() > 0) {
                boolean invalidInput = !this.controller.getProperties().setIPv6PrefixRouteList(input, this.ipv6StaticRouteComboBox.getSelectedIndex() - 1);
                this.setPopupVisible(this.ipv6RoutePrefixTextField, this.ipv6RoutePrefixPopup, invalidInput, this.INVALID_IPV6_ROUTE_PREFIX);
            }
        } else if (textfield.equals(this.ipv6RouteAddressTextField)) {
            if (this.ipv6StaticRouteComboBox.getSelectedIndex() > 0) {
                boolean invalidInput = !this.controller.getProperties().setIPv6RouterAddressList(input, this.ipv6StaticRouteComboBox.getSelectedIndex() - 1);
                this.setPopupVisible(this.ipv6RouteAddressTextField, this.ipv6RouteAddressPopup, invalidInput, this.INVALID_IPV6_ROUTE_ADDRESS);
            }
        } else if (textfield.equals(this.generalHostnameTextField)) {
            this.controller.getProperties().setGeneralHostname(input);
        } else if (textfield.equals(this.generalVLANIDTextField)) {
            boolean invalidInput = !this.controller.getProperties().setGeneralVLANID(input);
            this.setPopupVisible(this.generalVLANIDTextField, this.generalVLANIDPopup, invalidInput, this.INVALID_VLAN_ID);
        }
    }

    private String getAdditionalAlert() {
        String additionalAlert = "";
        if (this.controller.getProperties().isIPv4StaticMode() && this.controller.getProperties().isIPv4AddressChanged(this.controller.getProfile().retrieve())) {
            additionalAlert = additionalAlert + "\r\n\r\nIf IPv4 address is changed, session will be disconnected.\r\nYou have to reconnect with new IP address later.";
        }
        if (!this.controller.getProperties().isIPv4Enable() && this.controller.getProperties().isIPv6Enable() && (this.controller.getProperties().isIPv6AddressPendingAddChanged() || this.controller.getProperties().isIPv6AddressPendingDelChanged())) {
            additionalAlert = additionalAlert + "\r\n\r\nIf IPv6 address is changed, session will be disconnected.\r\nYou have to reconnect with new IP address later.";
        }
        return additionalAlert;
    }

    private void clearPopups() {
        this.setPopupVisible(this.ipv4AddressTextField, this.ipv4AddressPopup, false, this.INVALID_IPV4_ADDRESS);
        this.setPopupVisible(this.ipv4SubnetMaskTextField, this.ipv4SubnetMaskPopup, false, this.INVALID_IPV4_SUBMASK);
        this.setPopupVisible(this.ipv4GatewayTextField, this.ipv4GatewayPopup, false, this.INVALID_IPV4_GATEWAY);
        this.setPopupVisible(this.ipv4PrimaryDNSTextField, this.ipv4PrimaryDNSPopup, false, this.INVALID_IPV4_PRIMARY_DNS);
        this.setPopupVisible(this.ipv4SecondaryDNSTextField, this.ipv4SecondaryDNSPopup, false, this.INVALID_IPV4_SECONDARY_DNS);
        this.setPopupVisible(this.ipv6DNSTextField, this.ipv6DNSPopup, false, this.INVALID_IPV6_DNS);
        this.setPopupVisible(this.ipv6AddressTextField, this.ipv6AddressPopup, false, this.INVALID_IPV6_ADDRESS);
        this.setPopupVisible(this.ipv6RoutePrefixTextField, this.ipv6RoutePrefixPopup, false, this.INVALID_IPV6_ROUTE_PREFIX);
        this.setPopupVisible(this.ipv6RouteAddressTextField, this.ipv6RouteAddressPopup, false, this.INVALID_IPV6_ROUTE_ADDRESS);
        this.setPopupVisible(this.generalVLANIDTextField, this.generalVLANIDPopup, false, this.INVALID_VLAN_ID);
    }

    private void setTextfieldValid(boolean valid) {
        this.ipv4AddressTextField.setValid(valid);
        this.ipv4SubnetMaskTextField.setValid(valid);
        this.ipv4GatewayTextField.setValid(valid);
        this.ipv4PrimaryDNSTextField.setValid(valid);
        this.ipv4SecondaryDNSTextField.setValid(valid);
        this.ipv6AddressTextField.setValid(valid);
        this.ipv6DNSTextField.setValid(valid);
        this.ipv6DUIDTextField.setValid(valid);
        this.ipv6RoutePrefixTextField.setValid(valid);
        this.ipv6RouteAddressTextField.setValid(valid);
        this.generalHostnameTextField.setValid(valid);
        this.generalMACTextField.setValid(valid);
        this.generalVLANIDTextField.setValid(valid);
        this.generalRMCPPortTextField.setValid(valid);
    }

    private void setPopupVisible(RoundTextField parent, PopupWrapper popup, boolean visible, Integer errorCode) {
        if (visible) {
            if (popup.isPopupEmpty()) {
                JLabel label = new JLabel(this.errCodeMappingMap.get(errorCode));
                JPanel panel = new JPanel();
                label.setForeground(Color.WHITE);
                panel.setBackground(new Color(255, 148, 148));
                panel.add(label);
                popup.setPopup(PopupFactory.getSharedInstance().getPopup(parent, panel, parent.getLocationOnScreen().x, parent.getLocationOnScreen().y + parent.getSize().height));
            }
            popup.instance.show();
            parent.setValid(false);
            this.errCodeRecorderSet.add(errorCode);
        } else {
            if (!popup.isPopupEmpty()) {
                popup.instance.hide();
                popup.instance = null;
            }
            parent.setValid(true);
            this.errCodeRecorderSet.remove(errorCode);
        }
    }

    private boolean reload() {
        this.controller.update();
        if (this.controller.isPrivilegeSufficient()) {
            this.ipv4EnableToggleButton.setActivated(this.controller.getProperties().isIPv4Enable());
            this.ipv6EnableToggleButton.setActivated(this.controller.getProperties().isIPv6Enable());
            this.ipv6AutoConfigToggleButton.setActivated(this.controller.getProperties().isIPv6AutoConfigEnable());
            this.ipv6StaticRouteToggleButton.setActivated(this.controller.getProperties().isIPv6StaticRouteEnable());
            this.generalVLANToggleButton.setActivated(this.controller.getProperties().isGeneralVLANEnable());
            this.ipv6AutoConfigToggleButton.setEnabled(this.ipv6EnableToggleButton.isEnabled());
            this.ipv6StaticRouteToggleButton.setEnabled(this.ipv6EnableToggleButton.isEnabled());
            this.ipv4DHCPRadioButton.setSelected(this.controller.getProperties().getIpv4DhcpMode() == 2);
            this.ipv4StaticIPRadioButton.setSelected(this.controller.getProperties().getIpv4DhcpMode() == 1);
            this.ipv6DHCPDisableRadioButton.setSelected(this.controller.getProperties().getIpv6DhcpMode() == 2);
            this.ipv6DHCPStatelessRadioButton.setSelected(this.controller.getProperties().getIpv6DhcpMode() == 0);
            this.ipv6StatefulRadioButton.setSelected(this.controller.getProperties().getIpv6DhcpMode() == 1);
            this.generalDedicatedRadioButton.setSelected(this.controller.getProperties().getGeneralLanInterfaceMode() == 0);
            this.generalShareRadioButton.setSelected(this.controller.getProperties().getGeneralLanInterfaceMode() == 1);
            this.generalFailoverRadioButton.setSelected(this.controller.getProperties().getGeneralLanInterfaceMode() == 2);
            this.ipv4AddressTextField.setText(this.controller.getProperties().getIPv4Address());
            this.ipv4SubnetMaskTextField.setText(this.controller.getProperties().getIPv4SubMask());
            this.ipv4GatewayTextField.setText(this.controller.getProperties().getIPv4Gateway());
            this.ipv4PrimaryDNSTextField.setText(this.controller.getProperties().getIPv4PrimaryDNSServer());
            this.ipv4SecondaryDNSTextField.setText(this.controller.getProperties().getIPv4SecondaryDNSServer());
            this.ipv6DNSTextField.setText(this.controller.getProperties().getIPv6DNSServer());
            this.ipv6DUIDTextField.setText(this.controller.getProperties().getIPv6DUID());
            this.generalHostnameTextField.setText(this.controller.getProperties().getGeneralHostname());
            this.generalMACTextField.setText(this.controller.getProperties().getGeneralMACAddress());
            this.generalVLANIDTextField.setText(!this.controller.getProperties().getGeneralVLANID().equals("0") ? this.controller.getProperties().getGeneralVLANID() : "");
            this.generalVLANIDTextField.setEnabled(this.controller.getProperties().isGeneralVLANEnable());
            this.generalRMCPPortTextField.setText(this.controller.getProperties().getGeneralRMCPPort());
            this.ipv6AddressListComboBox.removeAllItems();
            this.ipv6StaticRouteComboBox.removeAllItems();
            this.ipv6AddressListComboBox.addItem(new WideComboBoxItem<String>("IPv6 Address List"));
            this.ipv6StaticRouteComboBox.addItem(new WideComboBoxItem<String>("IPv6 Static Route List"));
            this.controller.getProperties().getIPv6AddressList().forEach(s -> this.ipv6AddressListComboBox.addItem(new WideComboBoxItem<String>((String)s)));
            this.controller.getProperties().getIPv6PrefixRouteList().forEach(s -> this.ipv6StaticRouteComboBox.addItem(new WideComboBoxItem<String>((String)s)));
            this.generalActiveInterfaceValueLabel.setText(this.controller.getProperties().getGeneralActivedInterface());
            this.generalDedicatedLinkValueLabel.setText(this.controller.getProperties().getGeneralDedicatedLinkeMode());
            this.generalDedicatedStatusValueLabel.setText(this.controller.getProperties().getGeneralDedicatedStatus());
            this.generalDedicatedSpeedValueLabel.setText(this.controller.getProperties().getGeneralDedicatedSpeed());
            this.generalDedicatedDuplexValueLabel.setText(this.controller.getProperties().getGeneralDedicatedDuplex());
            this.generalShareStatusValueLabel.setText(this.controller.getProperties().getGeneralShareStatus());
            this.generalShareSpeedValueLabel.setText(this.controller.getProperties().getGeneralShareSpeed());
            this.generalShareDuplexValueLabel.setText(this.controller.getProperties().getGeneralShareDuplex());
            this.setIPv4PanelEnable(this.controller.getProperties().isIPv4Enable(), false);
            this.setIPv6PanelEnable(this.controller.getProperties().isIPv6Enable(), false);
            this.setRouterPanelEnable(this.controller.getProperties().isIPv6StaticRouteEnable());
            this.setGeneralPanelEnable(true);
            this.generalDedicatedRadioButton.setEnabled(this.controller.getProperties().isGeneralLanInterfaceDedicatedSupport());
            this.generalShareRadioButton.setEnabled(this.controller.getProperties().isGeneralLanInterfaceShareSupport());
            this.generalFailoverRadioButton.setEnabled(this.controller.getProperties().isGeneralLanInterfaceFailoverSupport());
            this.ipv4EnableToggleButton.setEnabled(true);
            this.ipv6EnableToggleButton.setEnabled(this.controller.getProperties().isIPv6ProtocolSupport());
            this.ipv6AddressAddButton.setSelected(false);
            this.ipv6AddressDelButton.setSelected(false);
            this.ipv6RouteListDelButton.setSelected(false);
            this.printProfile();
        } else {
            this.ipv4AddressTextField.setText("");
            this.ipv4SubnetMaskTextField.setText("");
            this.ipv4GatewayTextField.setText("");
            this.ipv4PrimaryDNSTextField.setText("");
            this.ipv4SecondaryDNSTextField.setText("");
            this.ipv6DNSTextField.setText("");
            this.ipv6DUIDTextField.setText("");
            this.generalHostnameTextField.setText("");
            this.generalMACTextField.setText("");
            this.generalVLANIDTextField.setText("");
            this.generalRMCPPortTextField.setText("");
            this.generalActiveInterfaceValueLabel.setText("");
            this.generalDedicatedLinkValueLabel.setText("");
            this.generalDedicatedStatusValueLabel.setText("");
            this.generalDedicatedSpeedValueLabel.setText("");
            this.generalDedicatedDuplexValueLabel.setText("");
            this.generalShareStatusValueLabel.setText("");
            this.generalShareSpeedValueLabel.setText("");
            this.generalShareDuplexValueLabel.setText("");
            this.disableWholePage();
            this.comboTabListener.toolbarStatus(3, 1);
        }
        return true;
    }

    private void printProfile() {
    }

    private void getRunningAction(boolean init) {
        this.comboTabListener.toolbarStatus(1, new int[0]);
        this.comboTabListener.toolbarStatus(2, new int[0]);
        this.clearPopups();
        this.setTextfieldValid(true);
        this.disableWholePage();
        if (!init) {
            new Thread(() -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.popupWindow.setMessage("Loading...", "", "");
                        this.popupWindow.setVisible(true);
                    });
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }).start();
        }
    }

    private void setRunningAction() {
        this.comboTabListener.toolbarStatus(2, new int[0]);
        this.disableWholePage();
        new Thread(() -> {
            try {
                this.popupWindow.setMessage("Setting...", "", "");
                SwingUtilities.invokeAndWait(() -> this.popupWindow.setVisible(true));
            }
            catch (InterruptedException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
        }).start();
    }

    private void getDoneAction(boolean init) {
        if (!init) {
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    this.popupWindow.setMessage("Done", "", "");
                    Thread.sleep(1000L);
                    SwingUtilities.invokeAndWait(() -> {
                        this.popupWindow.setVisible(false);
                        this.comboTabListener.toolbarStatus(0, new int[0]);
                        this.reload();
                        this.instance.invalidate();
                        this.instance.repaint();
                    });
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }).start();
        } else {
            new Thread(() -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        this.comboTabListener.toolbarStatus(0, new int[0]);
                        this.reload();
                        this.instance.invalidate();
                        this.instance.repaint();
                    });
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
            }).start();
        }
    }

    private void setDoneAction(boolean param) {
        if (param) {
            new Thread(() -> {
                try {
                    Thread.sleep(1500L);
                    this.popupWindow.setMessage("Done", "", "");
                    this.repaint();
                    Thread.sleep(1500L);
                    SwingUtilities.invokeAndWait(() -> this.popupWindow.setVisible(false));
                }
                catch (InterruptedException | InvocationTargetException e2) {
                    e2.printStackTrace();
                }
                Object[] options = new Object[]{"OK"};
                int result = JOptionPane.showOptionDialog(this.ipv4SettingBasePanel, "IP address has been changed. Please connect with new IP.", "", 2, 1, null, options, options[0]);
                if (result == 0 || result == -1) {
                    SwingUtilities.invokeLater(() -> IPMIView20.getInstance().closeInactivatelySession());
                }
            }).start();
        } else {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            this.controller.load(false);
        }
    }

    @Override
    public void updateStatus(int status, boolean param) {
        if (status == 0) {
            this.getDoneAction(param);
        } else if (status == 1) {
            this.setDoneAction(param);
        } else if (status == 2) {
            this.getRunningAction(param);
        } else if (status == 3) {
            this.setRunningAction();
        }
    }

    @Override
    public void updateMessage(String message) {
    }

    @Override
    public void toolbarAction(int actionType) {
        if (actionType == 5) {
            if (this.enableSubTabChangeReload) {
                this.controller.load(true);
            } else {
                this.enableSubTabChangeReload = true;
            }
        } else if (actionType == 4) {
            this.controller.load(false);
        } else if (actionType == 1) {
            if (this.errCodeRecorderSet.isEmpty()) {
                if (this.controller.isPrivilegeSufficient()) {
                    if (!this.controller.getProperties().isLanProtocolValid()) {
                        JOptionPane.showMessageDialog(this, "You can not both disable IPv4 and IPv6");
                    } else {
                        Object[] confirms = new Object[]{"Yes", "No"};
                        String confirmationMessage = "Are you sure you want to SAVE the modified Network parameter(s)?" + this.getAdditionalAlert();
                        int result = JOptionPane.showOptionDialog(this.ipv4SettingBasePanel, confirmationMessage, "", 2, 3, null, confirms, confirms[1]);
                        if (result == 0) {
                            this.controller.save();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Insufficient privilege to save network settings");
                    this.reload();
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                this.errCodeRecorderSet.forEach(k -> stringBuffer.append(this.errCodeMappingMap.get(k) + "\n"));
                JOptionPane.showMessageDialog(this, stringBuffer.toString(), "Error", 0);
            }
        }
    }

    private class PopupWrapper {
        public Popup instance = null;

        private PopupWrapper() {
        }

        public void setPopup(Popup popup) {
            this.instance = popup;
        }

        public boolean isPopupEmpty() {
            return this.instance == null;
        }
    }
}

