/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.NewVersionUpdateControl;
import IPMIView20.NewVersionUpdateInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class NewVersionUpdateView
extends JDialog
implements NewVersionUpdateInterface {
    private JPanel centerPanel;
    private JPanel southPanel;
    private JPanel logoPanel;
    private JPanel infoPanel;
    private JPanel infoFirstPanel;
    private JPanel infoSecondPanel;
    private JPanel progressPanel;
    private JLabel logoLabel;
    private JLabel titileLabel;
    private JLabel currentLabel;
    private JButton secondaryButton;
    private JButton primaryButton;
    private JProgressBar progressBar;
    private NewVersionUpdateControl controller;
    private String filePath;
    private boolean isWindowsOS;
    private int dialogState;

    public NewVersionUpdateView(JFrame jframe) {
        super((Frame)jframe, false);
        this.init();
        this.initComponents();
    }

    public void setDialogLayoutType(int type) {
        if (this.dialogState != 0 && this.dialogState != 1) {
            this.setButtonStatus(type);
            this.setComponentsText(type);
            this.dialogState = type;
        }
    }

    public void setButtonStatus(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 4: {
                this.primaryButton.setVisible(true);
                this.primaryButton.setEnabled(true);
                this.secondaryButton.setVisible(true);
                this.secondaryButton.setEnabled(true);
                break;
            }
            case 2: 
            case 6: {
                this.primaryButton.setVisible(true);
                this.primaryButton.setEnabled(true);
                this.secondaryButton.setVisible(false);
                this.secondaryButton.setEnabled(false);
                break;
            }
            case 3: {
                this.primaryButton.setVisible(false);
                this.primaryButton.setEnabled(false);
                this.secondaryButton.setVisible(false);
                this.secondaryButton.setEnabled(false);
            }
        }
    }

    public void setComponentsText(int type) {
        switch (type) {
            case 1: {
                this.secondaryButton.setText(L.t("main.New_version.cancel"));
                this.primaryButton.setText(L.t("main.New_version.hide"));
                this.titileLabel.setText(L.t("main.New_version.title.downloading"));
                break;
            }
            case 2: {
                this.currentLabel.setText(L.t("main.New_version.failed_download"));
                this.primaryButton.setText(L.t("main.New_version.ok"));
                this.titileLabel.setText(L.t("main.New_version.title.downloading"));
                break;
            }
            case 0: {
                this.secondaryButton.setText(L.t("main.New_version.not_now"));
                this.primaryButton.setText(L.t("main.New_version.open"));
                this.titileLabel.setText(L.t("main.New_version.title.downloading"));
                break;
            }
            case 3: {
                this.primaryButton.setText("");
                this.secondaryButton.setText("");
                this.titileLabel.setText(L.t("main.New_version.title.checking"));
                this.currentLabel.setText(L.t("main.New_version.checking"));
                break;
            }
            case 4: {
                this.secondaryButton.setText(L.t("main.New_version.not_now"));
                this.primaryButton.setText(L.t("main.New_version.download"));
                this.titileLabel.setText(L.t("main.New_version.title.checking"));
                this.currentLabel.setText(L.t("main.New_version.available1") + this.controller.getFileVersion() + L.t("main.New_version.available2"));
                break;
            }
            case 6: {
                this.primaryButton.setText(L.t("main.New_version.ok"));
                this.secondaryButton.setText("");
                this.titileLabel.setText(L.t("main.New_version.title.checking"));
                this.currentLabel.setText(L.t("main.New_version.latest"));
            }
        }
    }

    public void setNewVersionChecking() {
        if (this.dialogState == 0 || this.dialogState == 1) {
            return;
        }
        new Thread(() -> {
            block5: {
                this.setCursor(new Cursor(3));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    if (!IPMIView20.instance.DEBUG) break block5;
                    e1.printStackTrace();
                }
            }
            try {
                this.isWindowsOS = this.controller.isWindowsOS();
                boolean hasNewVer = this.controller.isNewVersionExists(this.isWindowsOS) || IPMIView20.forceUpdate;
                this.setDialogLayoutType(hasNewVer ? 4 : 6);
            }
            catch (Exception e2) {
                if (IPMIView20.instance.DEBUG) {
                    e2.printStackTrace();
                }
                this.setDialogLayoutType(2);
            }
            this.setCursor(new Cursor(0));
        }).start();
    }

    public void setIsWindowsOS(boolean status) {
        this.isWindowsOS = status;
    }

    private void init() {
        this.isWindowsOS = false;
        this.dialogState = 3;
        this.controller = new NewVersionUpdateControl(this);
    }

    private void initComponents() {
        this.newComponents();
        this.setComponetsMisc(3);
        this.setComponentsText(3);
        this.setComponentsSize();
        this.setComponentsLayout();
        this.setComponentsListenser();
    }

    private void newComponents() {
        this.centerPanel = new JPanel();
        this.southPanel = new JPanel();
        this.logoPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.infoFirstPanel = new JPanel();
        this.infoSecondPanel = new JPanel();
        this.progressPanel = new JPanel();
        this.logoLabel = new JLabel();
        this.titileLabel = new JLabel();
        this.currentLabel = new JLabel();
        this.secondaryButton = new JButton();
        this.primaryButton = new JButton();
        this.progressBar = new JProgressBar();
    }

    private void setComponetsMisc(int type) {
        ImageIcon imageIcon = new ImageIcon(new ImageIcon(this.getClass().getResource("/images/superLogo2014.jpg")).getImage().getScaledInstance(145, 75, 4));
        this.logoLabel.setIcon(imageIcon);
        this.logoLabel.setBackground(Color.WHITE);
        this.southPanel.setBackground(Color.LIGHT_GRAY);
        this.progressBar.setVisible(false);
        this.progressBar.setStringPainted(true);
        this.setResizable(false);
        this.setButtonStatus(type);
    }

    private void setComponentsSize() {
        this.setMinimumSize(new Dimension(500, 250));
        this.southPanel.setMinimumSize(new Dimension(100, 40));
        this.southPanel.setPreferredSize(new Dimension(100, 40));
        this.primaryButton.setMaximumSize(new Dimension(110, 22));
        this.primaryButton.setPreferredSize(new Dimension(110, 22));
        this.secondaryButton.setMaximumSize(new Dimension(110, 22));
        this.secondaryButton.setPreferredSize(new Dimension(110, 22));
        this.logoPanel.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        this.logoPanel.setMinimumSize(new Dimension(150, Integer.MIN_VALUE));
        this.logoPanel.setPreferredSize(new Dimension(150, Integer.MAX_VALUE));
        this.infoPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.infoPanel.setPreferredSize(new Dimension(300, 80));
        int infoSubPanelW = 400;
        int infoSubPanelH = 15;
        this.infoFirstPanel.setPreferredSize(new Dimension(infoSubPanelW, 30));
        this.infoFirstPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
        this.infoFirstPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        this.infoSecondPanel.setPreferredSize(new Dimension(infoSubPanelW, 100));
        this.infoSecondPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.infoSecondPanel.setMinimumSize(new Dimension(infoSubPanelW, infoSubPanelH));
        int infoSubPanelComW = 370;
        int infoSubPanelComH = 30;
        this.titileLabel.setPreferredSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.titileLabel.setMaximumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.titileLabel.setMinimumSize(new Dimension(infoSubPanelComW, infoSubPanelComH));
        this.currentLabel.setPreferredSize(new Dimension(infoSubPanelComW, 100));
        this.currentLabel.setMaximumSize(new Dimension(infoSubPanelComW, 100));
        this.currentLabel.setMinimumSize(new Dimension(infoSubPanelComW, 100));
        this.progressPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 25));
        this.progressPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 25));
        this.progressBar.setMaximumSize(new Dimension(620, 25));
        this.progressBar.setPreferredSize(new Dimension(620, 25));
    }

    private void setComponentsLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        this.southPanel.setLayout(new BoxLayout(this.southPanel, 0));
        this.logoPanel.setLayout(new BoxLayout(this.logoPanel, 1));
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoFirstPanel.setLayout(new BoxLayout(this.infoFirstPanel, 0));
        this.infoSecondPanel.setLayout(new BoxLayout(this.infoSecondPanel, 0));
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
        this.infoFirstPanel.add(this.titileLabel);
        this.infoSecondPanel.add(this.currentLabel);
        this.infoPanel.add(this.infoFirstPanel);
        this.infoPanel.add(this.infoSecondPanel);
        this.infoPanel.add(Box.createVerticalGlue());
        this.infoPanel.add(this.progressBar);
        this.infoPanel.add(Box.createVerticalStrut(20));
        this.southPanel.add(Box.createHorizontalGlue());
        this.southPanel.add(this.secondaryButton);
        this.southPanel.add(Box.createHorizontalStrut(10));
        this.southPanel.add(this.primaryButton);
        this.southPanel.add(Box.createHorizontalStrut(20));
        this.centerPanel.add(Box.createVerticalStrut(10));
        this.centerPanel.add(this.logoPanel);
        this.centerPanel.add(Box.createVerticalStrut(10));
        this.centerPanel.add(this.infoPanel);
        this.logoPanel.add(this.logoLabel);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.infoFirstPanel.setAlignmentX(0.0f);
        this.infoSecondPanel.setAlignmentX(0.0f);
        this.progressPanel.setAlignmentX(0.0f);
    }

    private void setComponentsListenser() {
        this.secondaryButton.addActionListener(e2 -> this.secondaryButtonActionEvent(e2));
        this.primaryButton.addActionListener(e2 -> this.primaryButtonActionEvent(e2));
    }

    private void secondaryButtonActionEvent(ActionEvent e2) {
        if (this.dialogState == 4 || this.dialogState == 0) {
            this.dispose();
        } else if (this.dialogState == 1) {
            Object[] confirms = new Object[]{"Yes", "No"};
            String confirmationMessage = L.t("main.New_version.confirm.cancel_download");
            int result = JOptionPane.showOptionDialog(this, confirmationMessage, L.t("main.New_version.confirm.title"), 2, 3, null, confirms, confirms[1]);
            if (result == 0) {
                this.controller.setDownloadTaskCancel();
            }
        }
    }

    private void primaryButtonActionEvent(ActionEvent e2) {
        if (this.dialogState == 4) {
            this.controller.download(this.isWindowsOS);
        } else if (this.dialogState == 1 || this.dialogState == 2 || this.dialogState == 6) {
            this.dispose();
        } else if (this.dialogState == 0) {
            Object[] confirms = new Object[]{"Yes", "No"};
            String confirmationMessage = L.t("main.New_version.confirm.open");
            int result = JOptionPane.showOptionDialog(this, confirmationMessage, L.t("main.New_version.confirm.title"), 2, 3, null, confirms, confirms[1]);
            if (result == 0) {
                new Thread(() -> SwingUtilities.invokeLater(() -> {
                    if (this.controller.open(this.filePath)) {
                        IPMIView20.getInstance().exitApplication();
                    } else {
                        this.currentLabel.setText(L.t("main.New_version.not_found"));
                    }
                })).start();
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            super.processWindowEvent(e2);
            this.setVisible(false);
        } else {
            super.processWindowEvent(e2);
        }
    }

    @Override
    public void updateProgress(int value) {
        this.progressBar.setValue(value);
    }

    @Override
    public void updateState(int state, String ... args) {
        this.dialogState = state;
        switch (state) {
            case 0: {
                if (args == null) break;
                this.filePath = args[0];
                this.currentLabel.setText("<html>" + L.t("main.New_version.done_line1") + "<br>" + L.t("main.New_version.done_line2") + "<br><br><p style=\"color:blue;font-style:italic;width:200px\">" + this.filePath + "</p></html>");
                this.setComponentsText(this.dialogState);
                this.setButtonStatus(this.dialogState);
                break;
            }
            case 1: {
                if (args == null) break;
                this.setComponentsText(this.dialogState);
                if (args[0].equals("0")) {
                    this.setButtonStatus(this.dialogState);
                    this.currentLabel.setText(L.t("main.New_version.checking"));
                    break;
                }
                if (args[0].equals("1")) {
                    this.currentLabel.setText(L.t("main.New_version.prepare"));
                    break;
                }
                this.progressBar.setVisible(true);
                this.currentLabel.setText(L.t("main.New_version.continue"));
                break;
            }
            case 2: {
                this.setComponentsText(this.dialogState);
                this.setButtonStatus(this.dialogState);
                break;
            }
            case 5: {
                this.progressBar.setValue(0);
                this.progressBar.setVisible(false);
                this.dispose();
            }
        }
    }
}

