/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class RoundTextField
extends JTextField {
    private static final Color COLOR_GAINED = new Color(138, 210, 234);
    private static final Color COLOR_LOST = new Color(228, 231, 234);
    private static final Color COLOR_FAILURE = new Color(255, 148, 148);
    private static final long serialVersionUID = 1L;
    private static final int ARC = 5;
    private Color currentColor;
    private boolean isValid;
    private boolean isFocusGained;

    public RoundTextField() {
        this.setOpaque(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e2) {
                RoundTextField.this.isFocusGained = true;
                ((JTextField)e2.getSource()).invalidate();
                ((JTextField)e2.getSource()).repaint();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                RoundTextField.this.isFocusGained = false;
                ((JTextField)e2.getSource()).invalidate();
                ((JTextField)e2.getSource()).repaint();
            }
        });
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
        super.invalidate();
        super.repaint();
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        g2.setColor(this.getBackground());
        g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        super.paintComponent(g2);
    }

    @Override
    protected void paintBorder(Graphics g2) {
        if (this.isFocusGained) {
            this.currentColor = COLOR_GAINED;
        } else if (!this.isFocusGained && this.isValid) {
            this.currentColor = COLOR_LOST;
        } else if (!this.isFocusGained && !this.isValid) {
            this.currentColor = COLOR_FAILURE;
        }
        g2.setColor(this.currentColor);
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
    }
}

