/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.SensorsReadingInterface;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SessionControllerFactory;
import java.util.ArrayList;
import java.util.List;

public class SensorsReadingControl {
    public List<ReadingData> tempReadings = new ArrayList<ReadingData>();
    public List<ReadingData> volReadings = new ArrayList<ReadingData>();
    public List<ReadingData> fanReadings = new ArrayList<ReadingData>();
    public List<ReadingData> batReadings = new ArrayList<ReadingData>();
    public List<ReadingData> psuReadings = new ArrayList<ReadingData>();
    public List<ReadingData> physicalSecurityReadings = new ArrayList<ReadingData>();
    public List<ReadingData> others1Readings = new ArrayList<ReadingData>();
    public List<ReadingData> others2Readings = new ArrayList<ReadingData>();
    private IPMIInterfaceConfig interfaceConfig = new IPMIInterfaceConfig();
    private SensorsReadingInterface sensorsReadingListener = null;

    public SensorsReadingControl(SensorsReadingInterface listener) {
        this.sensorsReadingListener = listener;
    }

    public void setControlSession(CSession session) {
        this.interfaceConfig.setIp(session.SIP);
        this.interfaceConfig.setUserName(session.userID);
        this.interfaceConfig.setPassword(new String(session.UserPassword));
        this.interfaceConfig.setPrivilege(session.MaxLevel[0]);
        this.interfaceConfig.setSmcRAKP(session.isSMCRAKP);
    }

    public void getData() {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.interfaceConfig, ipmiSDRCommand);
        byte[] guid = new IPMIMessagingCommand(ipmiSDRCommand.getIPMIInterface()).getSystemGUID();
        boolean ispowerOn = false;
        try {
            ispowerOn = new IPMIChassisCommand(ipmiSDRCommand.getIPMIInterface()).isPowerOn();
        }
        catch (IPMIException e2) {
            e2.printStackTrace();
        }
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo == null) {
            return;
        }
        ArrayList<String> sdrStringList = new ArrayList<String>();
        try {
            sdrStringList.addAll(ipmiSDRCommand.getSDRBuffer(sdrInfo.getRecordCount(), false, ispowerOn, guid));
        }
        catch (IPMIException iPMIException) {
        }
        catch (Exception e3) {
            System.out.println("Get SDR failed:" + e3.getMessage());
            return;
        }
        sessionController.closeSession();
        this.sdrStringHandler(sdrStringList);
    }

    private void sdrStringHandler(List<String> buffer) {
        this.tempReadings.clear();
        this.volReadings.clear();
        this.fanReadings.clear();
        this.batReadings.clear();
        this.psuReadings.clear();
        this.others1Readings.clear();
        this.others2Readings.clear();
        this.physicalSecurityReadings.clear();
        for (String str : buffer) {
            String[] items = str.split("\\|");
            if (items.length < 2) {
                return;
            }
            String itemStatus = items[1].trim();
            String itemName = items[2].trim().replaceFirst("\\([0-9]{1,5}\\) ", "");
            String itemReading = null;
            String itemReadingL = null;
            String itemReadingH = null;
            String itemDesc = null;
            int itemSensorType = Integer.valueOf(items[0].trim());
            int itemStatusType = itemStatus.equalsIgnoreCase("OK") ? 0 : (itemStatus.equalsIgnoreCase("Fail") ? 1 : 2);
            if (items.length > 5) {
                itemReading = items[3].trim();
                itemReadingL = items[4].trim();
                itemReadingH = items[5].trim();
            } else {
                itemDesc = items[3].trim();
            }
            if (itemSensorType == 1) {
                this.tempReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemReadingL, itemReadingH));
                continue;
            }
            if (itemSensorType == 2) {
                this.volReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemReadingL, itemReadingH));
                continue;
            }
            if (itemSensorType == 4) {
                this.fanReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemReadingL, itemReadingH));
                continue;
            }
            if (itemSensorType == 5) {
                this.physicalSecurityReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemDesc));
                continue;
            }
            if (itemSensorType == 8) {
                this.psuReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemDesc));
                continue;
            }
            if (itemSensorType == 41) {
                this.batReadings.add(new ReadingData(itemStatusType, itemName, itemReading, itemDesc));
                continue;
            }
            if (items.length > 5) {
                this.others1Readings.add(new ReadingData(itemStatusType, itemName, itemReading, itemReadingL, itemReadingH));
                continue;
            }
            this.others2Readings.add(new ReadingData(itemStatusType, itemName, itemReading, itemDesc));
        }
        this.sensorsReadingListener.updateStatus(0);
    }

    public static class ReadingData {
        public static final int SENSOR_STATUS_OK = 0;
        public static final int SENSOR_STATUS_FAIL = 1;
        public static final int SENSOR_STATUS_NONE = 2;
        public int sensorStatus;
        public String sensorName;
        public String sensorReading;
        public String lowLimit;
        public String highLimit;
        public String description;

        public ReadingData(int status, String name, String reading, String desc) {
            this.sensorStatus = status;
            this.sensorName = name;
            this.sensorReading = reading;
            this.description = desc;
        }

        public ReadingData(int status, String name, String reading, String low, String high) {
            this.sensorStatus = status;
            this.sensorName = name;
            this.sensorReading = reading;
            this.lowLimit = low;
            this.highLimit = high;
        }
    }
}

