/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableCellFilterRenderer
extends JLabel
implements TableCellRenderer {
    private final Color SELECTED_BACKGROUND = new Color(67, 146, 224);
    private String keywordString;

    public TableCellFilterRenderer() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
    }

    public void setKeyword(String keyword) {
        this.keywordString = keyword;
    }

    public void clearKeyword() {
        this.keywordString = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String matchString = null;
        if (null != value && null != this.keywordString && this.keywordString.length() > 0) {
            String cellStr = String.valueOf(value);
            int matchBeginIdx = cellStr.toLowerCase().indexOf(this.keywordString.toLowerCase());
            int matchEndIdx = matchBeginIdx + this.keywordString.length();
            String prefixStr = matchBeginIdx >= 0 ? cellStr.substring(0, matchBeginIdx) : cellStr;
            String matchStr = matchBeginIdx >= 0 ? cellStr.substring(matchBeginIdx, matchEndIdx) : "";
            String suffixStr = matchBeginIdx >= 0 ? cellStr.substring(matchEndIdx) : "";
            matchString = "<html><font color = " + (isSelected ? "WHITE" : "BLACK") + ">" + prefixStr + "</font><font color = #D94C4C>" + matchStr + "</font><font color = " + (isSelected ? "WHITE" : "BLACK") + ">" + suffixStr + "</font></html>";
        }
        this.setText(matchString == null ? (value == null ? null : value.toString()) : matchString);
        this.setForeground(matchString == null ? (isSelected ? Color.WHITE : Color.BLACK) : table.getForeground());
        this.setBackground(isSelected ? this.SELECTED_BACKGROUND : Color.WHITE);
        this.setOpaque(true);
        return this;
    }
}

