/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.GlobalDefine;
import IPMIView20.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TrapReceiver
extends JFrame {
    String version = System.getProperty("java.vm.version");
    String BuildSeq = " V2.0 (build:041104) JVM:" + this.version;
    TrapListener TrapCapture;
    BerDecoder berDecoder = new BerDecoder();
    DefaultMutableTreeNode rootNode;
    DefaultTreeModel treeModel;
    String TrapName;
    String OID;
    String AgentIP;
    String xMessage;
    GlobalDefine gd = new GlobalDefine();
    static TrapReceiver instance = new TrapReceiver();
    private JTabbedPane jTabbedPane1;
    private JPanel Traps;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    private JPanel jPanel7;
    private JLabel jLabel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;

    public static TrapReceiver getInstance() {
        return instance;
    }

    public TrapReceiver() {
        this.initComponents();
        ImageIcon image = new ImageIcon(this.getClass().getResource("/images/Middle.gif"));
        this.setIconImage(image.getImage());
        this.jLabel1.setVisible(false);
        this.jRadioButton1.setVisible(false);
        this.jRadioButton2.setVisible(false);
        this.rootNode = new DefaultMutableTreeNode("Traps");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.jTree1.setModel(this.treeModel);
        this.jTree1.setEditable(true);
        this.jTree1.getSelectionModel().setSelectionMode(1);
        this.setSize(320, 400);
        this.center();
        try {
            this.TrapCapture = new TrapListener(this);
            this.TrapCapture.start();
        }
        catch (IOException ie) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(this, "Another Trap Receiver program is running on this system,\nIPMITrap can not run.\n(For Windows, please check Services in Control Panel.)");
            System.exit(0);
        }
    }

    private void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.Traps = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel7 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.setTitle("Trap Receiver" + this.BuildSeq);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TrapReceiver.this.exitForm(evt);
            }
        });
        this.Traps.setLayout(new BorderLayout());
        this.Traps.setName("");
        this.jScrollPane1.setViewportView(this.jTree1);
        this.Traps.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText("Sort By:");
        this.jLabel1.setForeground(Color.black);
        this.jPanel7.add(this.jLabel1);
        this.jRadioButton1.setText("Time");
        this.jPanel7.add(this.jRadioButton1);
        this.jRadioButton2.setText("Sender");
        this.jPanel7.add(this.jRadioButton2);
        this.Traps.add((Component)this.jPanel7, "North");
        this.jTabbedPane1.addTab("Traps", this.Traps);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        TrapReceiver.getInstance().show();
    }

    private void decodeTrap(byte[] databuff, int datalength) {
        int offset = 0;
        DefaultMutableTreeNode TrapNode = new DefaultMutableTreeNode("SNMP Trap");
        this.treeModel.insertNodeInto(TrapNode, this.rootNode, this.rootNode.getChildCount());
        offset = this.getMessagePreamble(TrapNode, databuff, offset);
        offset = this.getPDUHeader(TrapNode, databuff, offset);
        offset = this.getPDUBody(TrapNode, databuff, offset, datalength);
        Thread th = new Thread(){

            @Override
            public void run() {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(TrapReceiver.getInstance(), TrapReceiver.this.OID + "\n" + TrapReceiver.this.AgentIP + "\n" + TrapReceiver.this.xMessage);
                TrapReceiver.this.xMessage = "";
            }
        };
        th.start();
    }

    private int getMessagePreamble(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode("SNMP Header");
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getMessageLength(childNode, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getMessageVersion(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getCommunity(childNode, this.berDecoder.parseString(databuff, offset));
        }
        catch (AsnDecodingException asnDecodingException) {
            // empty catch block
        }
        return offset;
    }

    private int getPDUHeader(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode("PDU Header");
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getPDUType(childNode, this.berDecoder.parseHeader(databuff, offset));
            offset = this.getEnterpriseMIB(childNode, this.berDecoder.parseObjectId(databuff, offset));
            offset = this.getAgentIP(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getGTrapType(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getSTrapType(childNode, this.berDecoder.parseInteger32(databuff, offset));
            offset = this.getTimeStamp(childNode, this.berDecoder.parseUInteger64(databuff, offset));
        }
        catch (AsnDecodingException asnDecodingException) {
            // empty catch block
        }
        return offset;
    }

    private int getPDUBody(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset, int datalength) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode("PDU Body");
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        try {
            offset = this.getLengthBind(childNode, this.berDecoder.parseHeader(databuff, offset));
            while (offset < datalength) {
                DefaultMutableTreeNode childNode1 = new DefaultMutableTreeNode("Bind");
                this.treeModel.insertNodeInto(childNode1, childNode, childNode.getChildCount());
                offset = this.getBindLength(childNode1, this.berDecoder.parseHeader(databuff, offset));
                offset = this.getBind(childNode1, databuff, offset);
            }
        }
        catch (AsnDecodingException asnDecodingException) {
            // empty catch block
        }
        return offset;
    }

    private int getMessageLength(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Length: " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getMessageVersion(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Message Version: v" + (xx + 1));
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getCommunity(DefaultMutableTreeNode TrapNode, Object[] value) {
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        try {
            strout.write((byte[])value[2]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String yy = strout.toString();
        String string = new String("Community: " + yy);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[0];
        return xx;
    }

    private int getPDUType(DefaultMutableTreeNode TrapNode, Object[] value) {
        byte zz = (Byte)value[1];
        String string = zz == -92 ? new String("Type: Trap") : new String("Type: unknown");
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[2];
        string = new String("length: " + xx);
        childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getEnterpriseMIB(DefaultMutableTreeNode TrapNode, Object[] value) {
        String string = new String("");
        int[] xx = (int[])value[2];
        int xxl = xx.length;
        string = "" + xx[0];
        for (int i2 = 1; i2 < xxl; ++i2) {
            string = string + "." + xx[i2];
        }
        this.OID = string = new String("Enterprise: " + string);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int yy = (Integer)value[0];
        return yy;
    }

    private int getAgentIP(DefaultMutableTreeNode TrapNode, Object[] value) {
        String string = new String("");
        int xx = (Integer)value[2];
        StringBuffer buf = new StringBuffer();
        buf.append(xx >> 24 & 0xFF);
        buf.append('.');
        buf.append(xx >> 16 & 0xFF);
        buf.append('.');
        buf.append(xx >> 8 & 0xFF);
        buf.append('.');
        buf.append(xx & 0xFF);
        this.AgentIP = string = new String("Agent IP: " + buf);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getGTrapType(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Generic Trap Type: " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getSTrapType(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Specific Trap Type: " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getTimeStamp(DefaultMutableTreeNode TrapNode, Object[] value) {
        long yy = ((BigInteger)value[2]).longValue();
        String string = new String("Timeticks : " + yy);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        int xx = (Integer)value[0];
        return xx;
    }

    private int getLengthBind(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Total Length of Variable Binding: " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getBindLength(DefaultMutableTreeNode TrapNode, Object[] value) {
        int xx = (Integer)value[2];
        String string = new String("Length of Binding: " + xx);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
        xx = (Integer)value[0];
        return xx;
    }

    private int getBind(DefaultMutableTreeNode TrapNode, byte[] databuff, int offset) {
        Object[] value = new Object[3];
        String string = new String("");
        Logger.writeLog(new String(databuff));
        try {
            value = this.berDecoder.parseObjectId(databuff, offset);
            int[] xx = (int[])value[2];
            int xxl = xx.length;
            string = "" + xx[0];
            for (int i2 = 1; i2 < xxl; ++i2) {
                string = string + "." + xx[i2];
            }
            string = new String("OID: " + string);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(string);
            this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            offset = (Integer)value[0];
            value = this.berDecoder.parseString(databuff, offset);
            if (string.compareTo("OID: 1.3.6.1.4.1.3183.1.1.1") == 0) {
                childNode = new DefaultMutableTreeNode("PET Data");
                this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
                this.parsePET(childNode, (byte[])value[2]);
            } else {
                ByteArrayOutputStream strout = new ByteArrayOutputStream();
                try {
                    strout.write((byte[])value[2]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String yy = strout.toString();
                string = new String("Value: " + yy);
                if (yy != null) {
                    this.xMessage = yy;
                }
                childNode = new DefaultMutableTreeNode(string);
                this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            }
            offset = (Integer)value[0];
        }
        catch (AsnDecodingException asnDecodingException) {
            // empty catch block
        }
        return offset;
    }

    private void parsePET(DefaultMutableTreeNode TrapNode, byte[] value) {
        DefaultMutableTreeNode childNode;
        ByteArrayOutputStream strout = new ByteArrayOutputStream();
        byte[] eventData = null;
        byte genericOffset = 0;
        byte sensorNumber = 0;
        byte length = 0;
        byte recordType = 0;
        byte sensorType = 0;
        byte[] sensorName = null;
        String description = null;
        for (int j2 = 0; j2 < value.length; ++j2) {
            if ((value[j2] & 0xFF) != 128) continue;
            eventData = new byte[3];
            System.arraycopy(value, 31, eventData, 0, 3);
            genericOffset = (byte)(eventData[0] & 0xF);
            sensorNumber = value[29];
            length = value[j2 + 1];
            recordType = value[j2 + 2];
            sensorType = value[j2 + 3];
            sensorName = new byte[length];
            description = sensorType == 1 || sensorType == 2 || sensorType == 3 || sensorType == 4 ? this.gd.LookupEventType(1, genericOffset) : this.gd.LookupSensorType(sensorType, genericOffset);
            System.arraycopy(value, j2 + 4, sensorName, 0, length);
            this.xMessage = "[ " + new String(sensorName) + " ] " + description;
            childNode = new DefaultMutableTreeNode(this.xMessage);
            this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
            break;
        }
        String string = "";
        boolean quota = false;
        boolean square = false;
        for (int i2 = 0; i2 < value.length; ++i2) {
            if (value[i2] < 32 || value[i2] > 126) {
                if (!square) {
                    if (quota) {
                        string = string + "\"";
                        quota = false;
                    }
                    string = string + "[";
                    square = true;
                }
                string = string + "x" + new String(Integer.toHexString(this.byteToInt(value[i2]))).toUpperCase();
                continue;
            }
            if (!quota) {
                if (square) {
                    string = string + "]";
                    square = false;
                }
                string = string + "\"";
                quota = true;
            }
            strout.write(value, i2, 1);
            String yy = strout.toString();
            string = string + yy;
        }
        if (square) {
            string = string + "]";
        }
        if (quota) {
            string = string + "\"";
        }
        childNode = new DefaultMutableTreeNode(string);
        this.treeModel.insertNodeInto(childNode, TrapNode, TrapNode.getChildCount());
    }

    public int byteToInt(byte b2) {
        return b2 < 0 ? 256 + b2 : b2;
    }

    public class AsnDecodingException
    extends Exception {
        public AsnDecodingException() {
        }

        public AsnDecodingException(String why) {
            super(why);
        }
    }

    public class BerDecoder {
        private static final byte LONG_LENGTH = -128;
        private static final byte HIGH_BIT = -128;
        private static final byte EXTENSION_ID = 31;
        private static final byte CONSTRUCTOR = 32;

        public Object[] ASNDecode(byte[] databuff, int[] startoffset) {
            Object[] rVar;
            int n = startoffset[0];
            startoffset[0] = n + 1;
            switch (databuff[n]) {
                case 2: {
                    rVar = new Object[1];
                    break;
                }
                default: {
                    rVar = new Object[2];
                }
            }
            return rVar;
        }

        protected int byteToInt(byte b2) {
            return b2 < 0 ? 256 + b2 : b2;
        }

        protected long byteToLong(byte b2) {
            return b2 < 0 ? 256L + (long)b2 : (long)b2;
        }

        protected boolean isConstructor(byte b2) {
            return (b2 & 0x20) == 32;
        }

        protected boolean isExtensionId(byte b2) {
            return (b2 & 0x1F) == 31;
        }

        public Object[] parseLength(byte[] buf, int startOffset) throws AsnDecodingException {
            byte numBytes;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] retVals = new Object[2];
            if (((numBytes = buf[startOffset++]) & 0xFFFFFF80) == 0) {
                numBytes = (byte)(numBytes & 0x7F);
                retVals[1] = new Integer(this.byteToInt(numBytes));
            } else if ((numBytes = (byte)(numBytes & 0x7F)) == 1) {
                if (buf.length - startOffset < 1) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                retVals[1] = new Integer(this.byteToInt(buf[startOffset++]));
            } else if (numBytes == 2) {
                if (buf.length - startOffset < 2) {
                    throw new AsnDecodingException("Buffer underflow error");
                }
                int val = this.byteToInt(buf[startOffset++]) << 8 | this.byteToInt(buf[startOffset++]);
                retVals[1] = new Integer(val);
            } else {
                throw new AsnDecodingException("Invalid ASN.1 length");
            }
            retVals[0] = new Integer(startOffset);
            return retVals;
        }

        public Object[] parseHeader(byte[] buf, int startOffset) throws AsnDecodingException {
            byte asnType;
            if (buf.length - startOffset < 1) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            if (this.isExtensionId(asnType = buf[startOffset++])) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            Object[] lenVals = this.parseLength(buf, startOffset);
            Object[] rVals = new Object[]{lenVals[0], new Byte(asnType), lenVals[1]};
            return rVals;
        }

        public Object[] parseInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 4) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            int asnValue = 0;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToInt(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Integer(asnValue)};
            return rVals;
        }

        public Object[] parseUInteger32(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 5) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            long asnValue = 0L;
            if ((buf[startOffset] & 0xFFFFFF80) == -128) {
                asnValue = -1L;
            }
            while (asnLength-- > 0) {
                asnValue = asnValue << 8 | this.byteToLong(buf[startOffset++]);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, new Long(asnValue &= 0xFFFFFFFFL)};
            return rVals;
        }

        public Object[] parseUInteger64(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength > 9) {
                throw new AsnDecodingException("Integer too large: cannot decode");
            }
            byte[] asnBuf = new byte[asnLength];
            for (int i2 = 0; i2 < asnLength; ++i2) {
                asnBuf[i2] = buf[startOffset++];
            }
            BigInteger asnValue = new BigInteger(asnBuf);
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, asnValue};
            return rVals;
        }

        public Object[] parseNull(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            if ((Integer)hdrVals[2] != 0) {
                throw new AsnDecodingException("Malformed ASN.1 Type");
            }
            Object[] rVals = new Object[]{hdrVals[0], hdrVals[1]};
            return rVals;
        }

        public Object[] parseString(byte[] buf, int startOffset) throws AsnDecodingException {
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Insufficent buffer length");
            }
            byte[] opaque = new byte[asnLength];
            try {
                this.copy(buf, startOffset, opaque, 0, asnLength);
            }
            catch (ArrayIndexOutOfBoundsException err) {
                throw new AsnDecodingException("Buffer underflow exception");
            }
            Object[] rVals = new Object[]{new Integer(startOffset + asnLength), asnType, opaque};
            return rVals;
        }

        public Object[] parseObjectId(byte[] buf, int startOffset) throws AsnDecodingException {
            int[] retOids;
            Object[] hdrVals = this.parseHeader(buf, startOffset);
            startOffset = (Integer)hdrVals[0];
            Byte asnType = (Byte)hdrVals[1];
            int asnLength = (Integer)hdrVals[2];
            if (buf.length - startOffset < asnLength) {
                throw new AsnDecodingException("Buffer underflow error");
            }
            if (asnLength == 0) {
                int[] ids = new int[2];
                ids[1] = 0;
                ids[0] = 0;
                Object[] rVals = new Object[]{new Integer(startOffset), asnType, ids};
                return rVals;
            }
            int idsOff = 0;
            int[] ids = new int[asnLength + 1];
            --asnLength;
            int oid = this.byteToInt(buf[startOffset++]);
            ids[idsOff++] = oid / 40;
            ids[idsOff++] = oid % 40;
            while (asnLength > 0) {
                oid = 0;
                boolean done = false;
                do {
                    --asnLength;
                    byte b2 = buf[startOffset++];
                    oid = oid << 7 | b2 & 0x7F;
                    if ((b2 & 0xFFFFFF80) != 0) continue;
                    done = true;
                } while (!done);
                ids[idsOff++] = oid;
            }
            if (idsOff == ids.length) {
                retOids = ids;
            } else {
                retOids = new int[idsOff];
                this.copy(ids, 0, retOids, 0, idsOff);
            }
            Object[] rVals = new Object[]{new Integer(startOffset), asnType, retOids};
            return rVals;
        }

        protected void copy(byte[] src, int srcOff, byte[] dest, int destOff, int bytesToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < bytesToCopy || src.length - srcOff < bytesToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = bytesToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }

        protected void copy(int[] src, int srcOff, int[] dest, int destOff, int intsToCopy) throws ArrayIndexOutOfBoundsException {
            if (dest.length - destOff < intsToCopy || src.length - srcOff < intsToCopy) {
                throw new ArrayIndexOutOfBoundsException("Destination or source buffer is insufficent");
            }
            for (int x = intsToCopy - 1; x >= 0; --x) {
                dest[destOff + x] = src[srcOff + x];
            }
        }
    }

    private class TrapListener
    extends Thread {
        protected DatagramSocket socket = new DatagramSocket(162);
        protected BufferedReader in = null;
        protected boolean KeepWating = true;

        public TrapListener(TrapReceiver trapReceiver2) throws IOException {
        }

        @Override
        public void run() {
            byte[] bufin = new byte[256];
            byte[] bufx = new byte[256];
            byte[] bufout = new byte[7];
            try {
                this.socket.setSoTimeout(5000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            while (this.KeepWating) {
                try {
                    DatagramPacket packet = new DatagramPacket(bufin, bufin.length);
                    this.socket.receive(packet);
                    int dataLength = packet.getLength();
                    TrapReceiver.this.decodeTrap(bufin, dataLength);
                }
                catch (IOException iOException) {}
            }
            this.socket.close();
        }

        public void stopTR() {
            this.KeepWating = false;
        }
    }
}

