/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMISession;
import IPMIView20.L;
import IPMIView20.UserAccountInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.UserAccountHelper;
import com.supermicro.ipmi.text.UserAccountProperty;
import java.util.ArrayList;
import java.util.List;

public class UsersAccountControl {
    private List<UserAccountProperty> accountPropList;
    private IPMIInterfaceConfig ipmiInterfaceConfig;
    private UserAccountInterface userAccountStateListener;
    private UserAccountHelper userAccounthelper;
    private boolean isSystemLockdown;

    public UsersAccountControl(IPMIInterfaceConfig config, UserAccountInterface listener) {
        this.ipmiInterfaceConfig = config;
        this.userAccountStateListener = listener;
        this.userAccounthelper = new UserAccountHelper();
        this.accountPropList = new ArrayList<UserAccountProperty>(UserAccountHelper.USER_ID_END);
    }

    public List<UserAccountProperty> getAccountList() {
        return this.accountPropList;
    }

    public void loadAccountList(boolean updateMsg) {
        UserAccountProperty reservedAccount = new UserAccountProperty();
        this.accountPropList.clear();
        this.accountPropList.add(reservedAccount);
        this.userAccountStateListener.updateState(1, new String[0]);
        this.userAccountStateListener.updateState(2, updateMsg ? L.t("user.Loading_Users_Information") : null);
        ISessionController sessionController = null;
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand, 30);
        if (sessionController == null) {
            this.userAccountStateListener.updateState(2, L.t("user.Loading_Users_Information_failed"));
            this.userAccountStateListener.updateState(3, new String[0]);
            return;
        }
        int numberOfUsers = ipmiMessagingCommand.getNumberOfAvailableUser();
        sessionController.closeSession();
        for (int id = UserAccountHelper.USER_ID_BEGIN; id <= numberOfUsers; ++id) {
            ipmiMessagingCommand = null;
            ipmiMessagingCommand = new IPMIMessagingCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand, 30);
            if (sessionController == null) {
                this.userAccountStateListener.updateState(2, L.t("user.Loading_Users_Information_failed"));
                this.userAccountStateListener.updateState(3, new String[0]);
                return;
            }
            this.accountPropList.add(this.userAccounthelper.getUser(ipmiMessagingCommand, (byte)id));
            sessionController.closeSession();
        }
        this.userAccountStateListener.updateState(2, updateMsg ? L.t("user.Loading_Users_Information_done") : null);
        this.userAccountStateListener.updateState(0, new String[0]);
    }

    public boolean createAccount(UserAccountProperty property) {
        this.userAccountStateListener.updateState(1, new String[0]);
        new Thread(() -> {
            ISessionController sessionController = null;
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand);
            if (sessionController == null) {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed"));
                this.userAccountStateListener.updateState(3, new String[0]);
                return;
            }
            byte userID = this.findAvailableUserID(ipmiMessagingCommand);
            if (userID == 0) {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed") + " " + L.t("user.Supports_Maximun") + this.userAccounthelper.getNumberOfAvailableUser(ipmiMessagingCommand) + L.t("user.Maximun_User"));
                this.userAccountStateListener.updateState(3, new String[0]);
                return;
            }
            int result = this.userAccounthelper.addUser(ipmiMessagingCommand, userID, property.getUsername(), property.getPassword(), property.getNetworkPrivilegeByte());
            if (result == 0) {
                if (property.isEnabledSOL()) {
                    this.userAccounthelper.setUserSOL(ipmiMessagingCommand, userID);
                } else {
                    this.userAccounthelper.clearUserSOL(ipmiMessagingCommand, userID);
                }
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_done"));
            } else if (result == 5) {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed") + " " + L.t("user.Supports_Maximun") + this.userAccounthelper.getNumberOfAvailableUser(ipmiMessagingCommand) + L.t("user.Maximun_User"));
            } else if (result == 4) {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed") + " " + L.t("user.Change_user_password_rules_mismatch"));
            } else {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed"));
            }
            sessionController.closeSession();
            this.loadAccountList(false);
        }).start();
        return true;
    }

    public boolean modifyAccount(UserAccountProperty property) {
        this.userAccountStateListener.updateState(1, new String[0]);
        new Thread(() -> {
            ISessionController sessionController = null;
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand);
            if (sessionController == null) {
                this.userAccountStateListener.updateState(2, L.t("user.Modify_user_failed"));
                this.userAccountStateListener.updateState(3, new String[0]);
                return;
            }
            int result = this.userAccounthelper.modifyUser(ipmiMessagingCommand, property.getUserIDByte(), property.getUsername(), property.getPassword(), property.getNetworkPrivilegeByte());
            if (result == 0) {
                if (property.isEnabledSOL()) {
                    this.userAccounthelper.setUserSOL(ipmiMessagingCommand, property.getUserIDByte());
                } else {
                    this.userAccounthelper.clearUserSOL(ipmiMessagingCommand, property.getUserIDByte());
                }
                this.userAccountStateListener.updateState(2, L.t("user.Modify_user_done"));
            } else if (result == 4) {
                this.userAccountStateListener.updateState(2, L.t("user.Add_new_user_failed") + " " + L.t("user.Change_user_password_rules_mismatch"));
            } else {
                this.userAccountStateListener.updateState(2, L.t("user.Modify_user_failed"));
            }
            sessionController.closeSession();
            this.loadAccountList(false);
        }).start();
        return true;
    }

    public boolean deleteAccount(int userID) {
        this.userAccountStateListener.updateState(1, new String[0]);
        new Thread(() -> {
            boolean isLegacyDevice;
            ISessionController sessionController = null;
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand);
            if (sessionController == null) {
                this.userAccountStateListener.updateState(2, L.t("user.Delete_user_failed"));
                this.userAccountStateListener.updateState(3, new String[0]);
                return;
            }
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            boolean bl = isLegacyDevice = IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid);
            if (this.userAccounthelper.deleteUser(ipmiMessagingCommand, (byte)userID, isLegacyDevice) != 0) {
                this.userAccountStateListener.updateState(2, L.t("user.Delete_user_failed"));
                this.userAccountStateListener.updateState(3, new String[0]);
            }
            sessionController.closeSession();
            this.userAccountStateListener.updateState(2, L.t("user.Delete_user_done"));
            this.loadAccountList(false);
        }).start();
        return true;
    }

    public boolean isValidUsername(String username) {
        return UserAccountHelper.isValidUsernameLength(username);
    }

    public int isValidPassword(String username, String password, boolean isLegacyDevices) {
        return UserAccountHelper.isValidPassword(password, username, !isLegacyDevices);
    }

    public boolean isLegacyDevices() {
        ISessionController sessionController = null;
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        sessionController = SessionControllerFactory.createSessionControllerWithRetry(this.ipmiInterfaceConfig, ipmiMessagingCommand, 30);
        if (sessionController == null) {
            return false;
        }
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isBeforeX12(guid);
    }

    public boolean isSystemLockdown() {
        return this.isSystemLockdown;
    }

    public void checkSystemLockdownStatus() {
        this.isSystemLockdown = IPMISession.checkIfSystemLockdown(this.ipmiInterfaceConfig);
    }

    private byte findAvailableUserID(IPMIMessagingCommand command) {
        byte userID = 0;
        for (int i2 = UserAccountHelper.USER_ID_BEGIN + 1; i2 <= UserAccountHelper.USER_ID_END; ++i2) {
            String name = command.getUserNameByID((byte)i2);
            if (name != null && name.length() != 0) continue;
            userID = (byte)i2;
            break;
        }
        return userID;
    }
}

