/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.AccountComponent;
import IPMIView20.AccountEditorDialog;
import IPMIView20.CSession;
import IPMIView20.ComboTabListener;
import IPMIView20.DropShadowPanel;
import IPMIView20.L;
import IPMIView20.UserAccountInterface;
import IPMIView20.UsersAccountControl;
import IPMIView20.UsersAdvancedSettingsView;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.UserAccountHelper;
import com.supermicro.ipmi.text.UserAccountProperty;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UsersAccountView
extends JPanel
implements ComboTabListener,
UserAccountInterface {
    private DropShadowPanel stretchPanel = new DropShadowPanel();
    private DropShadowPanel userListPanel = new DropShadowPanel();
    private UsersAdvancedSettingsView advancedPanel = new UsersAdvancedSettingsView();
    private AccountEditorDialog accountEditorDialog = new AccountEditorDialog();
    private IPMIInterfaceConfig interfaceConfig = new IPMIInterfaceConfig();
    private ComboTabListener comboTabListener = null;
    private UsersAccountControl userAccountControl = null;
    private JLabel mainWindowToolbarBottomMessage;
    private boolean enableSubTabChangeReload = false;
    private boolean isAdvancePanelEnabled = false;
    private CSession currentSession;

    public void init(CSession cSession, JLabel xMessage) {
        this.interfaceConfig.setIp(cSession.SIP);
        this.interfaceConfig.setUserName(cSession.userID);
        this.interfaceConfig.setPassword(cSession.getPasswordStr());
        this.interfaceConfig.setPrivilege(cSession.MaxLevel[0]);
        this.interfaceConfig.setSmcRAKP(cSession.isSMCRAKP);
        this.mainWindowToolbarBottomMessage = xMessage;
        this.currentSession = cSession;
    }

    public void load(CSession session) {
        new Thread(() -> {
            if (this.userAccountControl == null) {
                this.userAccountControl = new UsersAccountControl(this.interfaceConfig, this);
            }
            this.userAccountControl.checkSystemLockdownStatus();
            this.isAdvancePanelEnabled = session.hasPrivilegeAdmin() && !this.userAccountControl.isSystemLockdown();
            this.comboTabListener.toolbarStatus(1, new int[0]);
            this.comboTabListener.toolbarStatus(2, new int[0]);
            this.advancedPanel.setController(this.interfaceConfig, this);
            this.accountEditorDialog.setController(this.userAccountControl);
            this.advancedPanel.loadProfile(false);
            this.userAccountControl.loadAccountList(false);
            this.advancedPanel.setComponentEnabled(this.isAdvancePanelEnabled);
            this.currentSession.Loading = -1;
        }).start();
    }

    public UsersAccountView(ComboTabListener listener) {
        this.setComponentsLayout();
        this.setComponentsColor();
        this.setComponentsSize();
        this.setComponentsListenser(listener);
    }

    public AccountEditorDialog getAccountEditor() {
        return this.accountEditorDialog;
    }

    public UsersAccountControl getUsersAccountControl() {
        return this.userAccountControl;
    }

    private boolean isPrivilegeAdministrator() {
        return this.interfaceConfig.getPrivilege() == 4;
    }

    private boolean isPrivilegeOperator() {
        return this.interfaceConfig.getPrivilege() == 3;
    }

    private void setComponentsLayout() {
        this.setLayout(new BorderLayout());
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 1));
        this.userListPanel.setLayout(new BoxLayout(this.userListPanel, 1));
        this.userListPanel.add(new AccountComponent(-1));
        this.userListPanel.add(new AccountComponent(0));
        this.add((Component)this.advancedPanel, "North");
        this.add((Component)this.userListPanel, "Center");
        this.add((Component)this.stretchPanel, "South");
    }

    private void setComponentsColor() {
        this.stretchPanel.setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
    }

    private void setComponentsSize() {
        int minW = Integer.MAX_VALUE;
        int minH = 160;
        this.advancedPanel.setMinimumSize(new Dimension(minW, minH));
        this.advancedPanel.setMaximumSize(new Dimension(minW, minH));
        this.advancedPanel.setPreferredSize(new Dimension(320, 50));
        this.stretchPanel.setMinimumSize(new Dimension(Integer.MAX_VALUE, 1));
        this.stretchPanel.setPreferredSize(new Dimension(320, 1));
        this.stretchPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
    }

    private void setComponentsListenser(ComboTabListener listener) {
        this.comboTabListener = listener;
    }

    private void loadAccountComponentList() {
        List<UserAccountProperty> accountList = this.userAccountControl.getAccountList();
        SwingUtilities.invokeLater(() -> {
            this.clearUserListPanel();
            for (int idx = UserAccountHelper.USER_ID_BEGIN; idx < accountList.size(); ++idx) {
                UserAccountProperty prop = (UserAccountProperty)accountList.get(idx);
                if (this.isPrivilegeAdministrator()) {
                    this.addUserAccount(prop);
                    continue;
                }
                if (!this.isPrivilegeOperator()) continue;
                this.addUserAccountWithLimitation(prop);
            }
            this.userListPanel.updateUI();
        });
    }

    private void addUserAccount(UserAccountProperty prop) {
        if (!prop.getUsername().isEmpty()) {
            AccountComponent comp = new AccountComponent(this, prop.getUserIDByte());
            comp.setUserID(prop.getUserID());
            comp.setUserName(prop.getUsername());
            comp.setNetworkPrivileges(prop.getNetworkPrivilege());
            comp.setSolPrivileges(prop.isEnabledSOL());
            comp.setUserStatus(prop.getAccountState() == 1);
            if (!this.userAccountControl.isSystemLockdown()) {
                comp.setEnabledModifyButton();
                if (comp.isDeletableAccount()) {
                    comp.setEnabledDeleteButton();
                }
            }
            this.userListPanel.add(comp);
        }
    }

    private void addUserAccountWithLimitation(UserAccountProperty prop) {
        if (!prop.getUsername().isEmpty() && prop.getNetworkPrivilegeByte() <= 3) {
            AccountComponent comp = new AccountComponent(this, prop.getUserIDByte());
            comp.setUserID(prop.getUserID());
            comp.setUserName(prop.getUsername());
            comp.setNetworkPrivileges(prop.getNetworkPrivilege());
            comp.setSolPrivileges(prop.isEnabledSOL());
            comp.setUserStatus(prop.getAccountState() == 1);
            this.userListPanel.add(comp);
        }
    }

    private void clearUserListPanel() {
        Component[] comps;
        for (Component comp : comps = this.userListPanel.getComponents()) {
            if (!(comp instanceof AccountComponent) || ((AccountComponent)comp).isReservedComponent()) continue;
            this.userListPanel.remove(comp);
        }
    }

    private void showSystemLockdownMessageDialog() {
        SwingUtilities.invokeLater(() -> {
            this.mainWindowToolbarBottomMessage.setText(L.t("user.InSystemLockdownMode"));
            JOptionPane.showMessageDialog(this, L.t("user.InSystemLockdownMode"), L.t("user.Forbidden"), 0);
        });
    }

    @Override
    public void toolbarAction(int actionType) {
        if (actionType == 5) {
            if (this.enableSubTabChangeReload) {
                new Thread(() -> {
                    this.advancedPanel.loadProfile(false);
                    this.userAccountControl.loadAccountList(false);
                }).start();
            } else {
                this.enableSubTabChangeReload = true;
            }
        } else if (actionType == 4) {
            new Thread(() -> {
                this.advancedPanel.loadProfile(true);
                this.userAccountControl.loadAccountList(true);
            }).start();
        } else if (actionType == 2) {
            if (this.userAccountControl.isSystemLockdown()) {
                this.showSystemLockdownMessageDialog();
            } else {
                this.accountEditorDialog.setLocationRelativeTo(this.userListPanel);
                this.accountEditorDialog.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
                this.accountEditorDialog.createUser();
                this.accountEditorDialog.setVisible(true);
            }
        } else if (actionType == 1) {
            if (this.userAccountControl.isSystemLockdown()) {
                this.showSystemLockdownMessageDialog();
            } else {
                this.advancedPanel.saveProfile();
            }
        }
    }

    @Override
    public void updateState(int state, String ... msg) {
        if (state == 1) {
            this.comboTabListener.toolbarStatus(1, new int[0]);
            this.comboTabListener.toolbarStatus(2, new int[0]);
            this.advancedPanel.setComponentEnabled(false);
        } else if (state == 2) {
            if (null != msg && null != msg[0]) {
                SwingUtilities.invokeLater(() -> this.mainWindowToolbarBottomMessage.setText(msg[0]));
            }
        } else if (state == 3) {
            this.comboTabListener.toolbarStatus(0, new int[0]);
        } else if (state == 0) {
            this.advancedPanel.setComponentEnabled(this.isAdvancePanelEnabled);
            if (this.isAdvancePanelEnabled) {
                this.comboTabListener.toolbarStatus(0, new int[0]);
            } else {
                this.comboTabListener.toolbarStatus(0, 4);
            }
            this.loadAccountComponentList();
        }
    }
}

