/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.group;

import IPMIView20.IPMIView20;
import IPMIView20.IconTextField;
import IPMIView20.L;
import IPMIView20.TableCellFilterRenderer;
import IPMIView20.group.FilterCondition;
import IPMIView20.group.PPanel;
import IPMIView20.group.SELMessageCenterObserver;
import IPMIView20.group.SELPanel_jClearButton_actionAdapter;
import IPMIView20.group.SELPanel_jHostComboBox_itemAdapter;
import IPMIView20.group.SELPanel_jSaveButton_actionAdapter;
import IPMIView20.group.SEL_JCheckBox1_actionAdapter;
import IPMIView20.group.SEL_JComboBox1_itemAdapter;
import IPMIView20.group.SEL_JQueryButton_actionAdapter;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.group.CommandForGettingMELRecords;
import com.supermicro.ipmi.group.CommandForGettingSELRecords;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

public class SELPanel
extends PPanel
implements Observer {
    private static final int EVENT_TYPE_HEL = 0;
    private static final int EVENT_TYPE_MEL = 1;
    private int eventType = 0;
    private String last_update_hel;
    private String last_update_mel;
    private ArrayList<String> helHostList;
    private ArrayList<String> melHostList;
    Timer timer;
    FilterCondition hostFilter = null;
    TableSorter helTableSorter;
    TableSorter melTableSorter;
    CommandForGettingSELRecords commandForGettingSELRecords;
    CommandForGettingMELRecords commandForGettingMELRecords;
    TableCellFilterRenderer filterCellRender;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel1_1 = new JPanel();
    ButtonGroup eventTypeButtonGroup = new ButtonGroup();
    BorderLayout borderLayout1_1 = new BorderLayout();
    JRadioButton helRadioButton = new JRadioButton();
    JRadioButton melRadioButton = new JRadioButton();
    IconTextField keywordTextField = new IconTextField();
    JPanel jPanel2 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton jQueryButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JTable jTable = new JTable();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jPanel3 = new JPanel();
    public JComboBox jComboBox1 = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    public JCheckBox jCheckBox1 = new JCheckBox();
    JPanel jPanel5 = new JPanel();
    JLabel jLastUpdateLabel = new JLabel();
    JPanel jPanel6 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox<String> jHostComboBox = new JComboBox();
    BorderLayout borderLayout4 = new BorderLayout();
    Host host = null;
    Result result = null;
    static boolean isRunning = false;
    JToolBar jToolBar1 = new JToolBar();
    BorderLayout borderLayout5 = new BorderLayout();
    JButton jSaveButton = new JButton();
    JButton jClearButton = new JButton();
    String pathName;
    static JFileChooser fileChooser;

    public SELPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(L.t("sel.Event"));
        this.setLayout(this.borderLayout1);
        this.jQueryButton.setToolTipText(L.t("group.table.toolbar.Get"));
        this.jQueryButton.setIcon(this.listIcon);
        this.jQueryButton.addActionListener(new SEL_JQueryButton_actionAdapter(this));
        this.jPanel1_1.setBorder(new TitledBorder(L.t("cmm.SEL.Event_Type")));
        this.jPanel1_1.setLayout(new FlowLayout(0, 10, 5));
        this.jPanel1_1.add(this.helRadioButton);
        this.jPanel1_1.add(this.melRadioButton);
        this.jPanel1_1.add(this.keywordTextField);
        this.helRadioButton.setPreferredSize(new Dimension(100, 20));
        this.melRadioButton.setPreferredSize(new Dimension(120, 20));
        this.keywordTextField.setPreferredSize(new Dimension(120, 20));
        this.keywordTextField.setIcon(new ImageIcon(this.getClass().getResource("/images/search.PNG")));
        this.helRadioButton.setText(L.t("cmm.SEL.Event_Type_Health"));
        this.melRadioButton.setText(L.t("cmm.SEL.Event_Type_Maintenance"));
        this.eventTypeButtonGroup.add(this.helRadioButton);
        this.eventTypeButtonGroup.add(this.melRadioButton);
        this.helRadioButton.setSelected(true);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jLabel2.setText(L.t("group.sel.seconds"));
        this.jPanel4.setLayout(this.borderLayout3);
        this.jCheckBox1.setText(L.t("group.sel.Refresh_every"));
        this.jCheckBox1.addActionListener(new SEL_JCheckBox1_actionAdapter(this));
        this.jComboBox1.addItemListener(new SEL_JComboBox1_itemAdapter(this));
        this.jTable.setAutoResizeMode(0);
        this.jLabel1.setText(L.t("group.sel.Host_colon") + "  ");
        this.jPanel6.setLayout(this.borderLayout4);
        this.jHostComboBox.addItemListener(new SELPanel_jHostComboBox_itemAdapter(this));
        this.jPanel2.setLayout(this.borderLayout5);
        this.jToolBar1.setFloatable(false);
        this.jSaveButton.setToolTipText(L.t("group.table.toolbar.Save"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.addActionListener(new SELPanel_jSaveButton_actionAdapter(this));
        this.jClearButton.setToolTipText(L.t("group.table.toolbar.Clear"));
        this.jClearButton.setIcon(this.deleteIcon);
        this.jClearButton.addActionListener(new SELPanel_jClearButton_actionAdapter(this));
        this.add((Component)this.jPanel1, "Center");
        this.jToolBar1.add(this.jQueryButton);
        this.jToolBar1.add(this.jClearButton);
        this.jToolBar1.add(this.jSaveButton);
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add(this.jCheckBox1);
        this.jPanel3.add(this.jComboBox1);
        this.jPanel3.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel5.add(this.jLastUpdateLabel);
        this.jPanel1.add((Component)this.jPanel6, "North");
        this.jPanel6.add(this.jHostComboBox, "Center");
        this.jPanel6.add((Component)this.jLabel1, "West");
        this.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jToolBar1, "Center");
        this.jPanel2.add((Component)this.jPanel1_1, "South");
    }

    private void myInit() {
        this.jComboBox1.addItem("10");
        this.jComboBox1.addItem("20");
        this.jComboBox1.addItem("30");
        this.jComboBox1.addItem("45");
        this.jComboBox1.addItem("60");
        this.jComboBox1.addItem("90");
        this.jComboBox1.addItem("120");
        this.jComboBox1.setSelectedIndex(4);
        this.last_update_hel = "";
        this.last_update_mel = "";
        this.helHostList = new ArrayList();
        this.melHostList = new ArrayList();
        this.commandForGettingSELRecords = new CommandForGettingSELRecords();
        this.commandForGettingMELRecords = new CommandForGettingMELRecords();
        this.filterCellRender = new TableCellFilterRenderer();
        this.helRadioButton.addActionListener(e2 -> this.eventTypeRadioButtonSelected(e2));
        this.melRadioButton.addActionListener(e2 -> this.eventTypeRadioButtonSelected(e2));
        this.keywordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e2) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e2) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                this.update();
            }

            public void update() {
                if (SELPanel.this.jHostComboBox.getItemCount() > 0 && !SELPanel.this.jHostComboBox.getSelectedItem().equals(L.t("group.sel.All"))) {
                    SELPanel.this.jHostComboBox.setSelectedItem(L.t("group.sel.All"));
                }
                if (null != SELPanel.this.keywordTextField.getText() && SELPanel.this.keywordTextField.getText().length() > 0) {
                    SELPanel.this.jHostComboBox.setEnabled(false);
                    SELPanel.this.filterCellRender.setKeyword(SELPanel.this.keywordTextField.getText());
                    SELPanel.this.initialKeywordTableFilterCondition((TableSorter)SELPanel.this.jTable.getModel(), SELPanel.this.keywordTextField.getText());
                } else {
                    SELPanel.this.jHostComboBox.setEnabled(true);
                    SELPanel.this.filterCellRender.clearKeyword();
                    SELPanel.this.initialTableFilterCondition((TableSorter)SELPanel.this.jTable.getModel());
                }
                ((TableSorter)SELPanel.this.jTable.getModel()).filter();
            }
        });
        this.showHeader();
    }

    public void initialTableFilterCondition(TableSorter ts) {
        ts.removeAllFilterCondition();
        ts.matchAll = true;
        this.hostFilter = new FilterCondition();
        this.hostFilter.filterOperator = 0;
        this.hostFilter.filterColumnIndex = 0;
        this.hostFilter.filterValue = "*";
        ts.addFilterCondition(this.hostFilter);
    }

    public void initialKeywordTableFilterCondition(TableSorter ts, String keyword) {
        ts.removeAllFilterCondition();
        ts.matchAll = false;
        int columeIdx = 0;
        while (columeIdx < ts.getColumnCount()) {
            FilterCondition keywordfilter = new FilterCondition();
            keywordfilter.filterOperator = 4;
            keywordfilter.filterColumnIndex = columeIdx++;
            keywordfilter.filterValue = keyword;
            ts.addFilterCondition(keywordfilter);
        }
    }

    public void showHeader() {
        this.helTableSorter = new TableSorter(new DefaultTableModel(this.getHeader(0).toArray(), 0));
        this.melTableSorter = new TableSorter(new DefaultTableModel(this.getHeader(1).toArray(), 0));
        this.jTable.setModel(this.helTableSorter);
    }

    public ArrayList<String> getHeader(int type) {
        ArrayList<String> headerList = new ArrayList<String>();
        if (type == 0) {
            headerList.add(L.t("group.sel.Host"));
            headerList.add(L.t("group.sel.IP"));
            headerList.add(L.t("sel.Severity"));
            headerList.add(L.t("sel.DateTime"));
            headerList.add(L.t("sel.Sensor_Type"));
            headerList.add(L.t("sel.Sensor"));
            headerList.add(L.t("sel.Description"));
        } else {
            headerList.add(L.t("group.sel.Host"));
            headerList.add(L.t("group.sel.IP"));
            headerList.add(L.t("sel.Severity"));
            headerList.add(L.t("cmm.SEL.Time_Stamp"));
            headerList.add(L.t("cmm.SEL.Interface"));
            headerList.add(L.t("cmm.SEL.User"));
            headerList.add(L.t("cmm.SEL.Source"));
            headerList.add(L.t("cmm.SEL.Description"));
        }
        return headerList;
    }

    public void doQuery() {
        if (!this.isShowMeNow()) {
            return;
        }
        this.jQueryButton.setEnabled(false);
        this.jClearButton.setEnabled(false);
        this.jSaveButton.setEnabled(false);
        this.jHostComboBox.removeAllItems();
        if (this.eventType == 0) {
            this.helHostList.clear();
        } else {
            this.melHostList.clear();
        }
        if (!this.initialData()) {
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            return;
        }
        ((TableSorter)this.jTable.getModel()).cancelFilter();
        ((TableSorter)this.jTable.getModel()).filterConditions.clear();
        this.setTableHeader(this.eventType, true);
        SELMessageCenterObserver selMessageCenterObserver = new SELMessageCenterObserver(this);
        MessageCenter.getInstance().addObserver(selMessageCenterObserver);
        this.hostManager.addObserver(this);
        try {
            this.hostManager.run(this.eventType == 0 ? this.commandForGettingSELRecords : this.commandForGettingMELRecords);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            MessageCenter.getInstance().deleteObserver(selMessageCenterObserver);
            this.hostManager.deleteObserver(this);
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            this.setLastUpdate();
            if (this.eventType == 0) {
                this.helHostList.add(L.t("group.sel.All"));
                this.helHostList.forEach(o -> this.jHostComboBox.addItem((String)o));
            } else {
                this.melHostList.add(L.t("group.sel.All"));
                this.melHostList.forEach(o -> this.jHostComboBox.addItem((String)o));
            }
            this.jHostComboBox.setSelectedItem(L.t("group.sel.All"));
            this.xMessage.setText(L.t("group.sel.Finish"));
        }
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        if (arg instanceof Host) {
            this.host = (Host)arg;
            this.xMessage.setText(L.t("group.sel.Getting_SEL_data_from") + " " + this.host.getIp() + " ...");
            return;
        }
        if (arg instanceof Result) {
            this.result = (Result)arg;
            if (this.result.booleanResult) {
                if (this.eventType == 0) {
                    for (int i2 = 0; i2 < this.host.selRecords.size(); ++i2) {
                        ArrayList raw;
                        if (this.host.isBeforeX12) {
                            raw = this.makeFormatedData(this.host, (SELRecord)this.host.selRecords.get(i2));
                            ((DefaultTableModel)this.helTableSorter.getTableModel()).addRow(raw.toArray());
                            continue;
                        }
                        raw = (ArrayList)this.host.selRecords.get(i2);
                        ((DefaultTableModel)this.helTableSorter.getTableModel()).insertRow(((DefaultTableModel)this.helTableSorter.getTableModel()).getRowCount(), raw.toArray());
                    }
                    this.jTable.setModel(this.helTableSorter);
                    this.helTableSorter.setTableHeader(this.jTable.getTableHeader());
                    this.helTableSorter.fireTableDataChanged();
                    this.helHostList.add(this.host.getHostname());
                } else {
                    for (int i3 = 0; i3 < this.host.melRecords.size(); ++i3) {
                        ArrayList raw = (ArrayList)this.host.melRecords.get(i3);
                        ((DefaultTableModel)this.melTableSorter.getTableModel()).insertRow(((DefaultTableModel)this.melTableSorter.getTableModel()).getRowCount(), raw.toArray());
                    }
                    this.jTable.setModel(this.melTableSorter);
                    this.melTableSorter.setTableHeader(this.jTable.getTableHeader());
                    this.melTableSorter.fireTableDataChanged();
                    this.melHostList.add(this.host.getHostname());
                }
                this.setTableCellRenderer();
                this.jTable.invalidate();
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), this.result.description + "\n" + this.result.host.getIp());
            }
        }
    }

    public ArrayList makeFormatedData(Host host, SELRecord selRecord) {
        ArrayList<String> raw = new ArrayList<String>();
        raw.add(host.getHostname());
        raw.add(host.getIp());
        raw.add("");
        raw.add(ByteUtility.fourByteToDateFormat2(selRecord.getTimeStamp()));
        raw.add(GlobalDefine.getSensorType(selRecord.getSensorType() & 0xFF));
        raw.add((String)SDRRecord.sensorNumberToSensorName.get("" + (selRecord.getSensorNumber() & 0xFF)));
        raw.add(GlobalDefine.getEventType((byte)(selRecord.getEventDir() | selRecord.getEventType()), selRecord.getSensorType(), selRecord.getEventData1(), selRecord.getEventData2(), selRecord.getEventData3(), host.productID, selRecord.getSensorNumber()));
        return raw;
    }

    public void jQueryButton_actionPerformed(ActionEvent e2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SELPanel.this.doQuery();
            }
        };
        thread.start();
    }

    public void jCheckBox1_actionPerformed(ActionEvent e2) {
        this.setReflashTimer();
    }

    private void setReflashTimer() throws NumberFormatException {
        String flashRateStr = (String)this.jComboBox1.getSelectedItem();
        int flashRate = Integer.parseInt(flashRateStr);
        if (this.jCheckBox1.isSelected()) {
            TimerTask tt = new TimerTask(){

                @Override
                public void run() {
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            if (SELPanel.this.loginID == null || SELPanel.this.loginID.length() == 0 || SELPanel.this.loginPassword == null || SELPanel.this.loginPassword.length() == 0) {
                                return;
                            }
                            if (isRunning) {
                                return;
                            }
                            isRunning = true;
                            SELPanel.this.doQuery();
                            isRunning = false;
                        }
                    };
                    th.start();
                }
            };
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer();
            this.timer.schedule(tt, flashRate * 1000, (long)(flashRate * 1000));
        } else {
            this.timer.cancel();
        }
    }

    public void setLastUpdate() {
        SimpleDateFormat f2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (this.eventType == 0) {
            this.last_update_hel = L.t("group.sel.last_update_colon") + f2.format(Calendar.getInstance().getTime()) + " (" + this.helTableSorter.getTableModel().getRowCount() + ")";
            this.jLastUpdateLabel.setText(this.last_update_hel);
        } else {
            this.last_update_mel = L.t("group.sel.last_update_colon") + f2.format(Calendar.getInstance().getTime()) + " (" + this.melTableSorter.getTableModel().getRowCount() + ")";
            this.jLastUpdateLabel.setText(this.last_update_mel);
        }
    }

    public void jComboBox1_itemStateChanged(ItemEvent e2) {
        if (this.jCheckBox1.isSelected()) {
            this.setReflashTimer();
        }
    }

    public void handleMessageCenterObserver(Observable o, Object arg) {
        MessageCenter.ClassMessage classMessage = (MessageCenter.ClassMessage)arg;
        if (classMessage.from.equals("com.supermicro.ipmi.IPMISELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMISDRCommand")) {
            this.xMessage.setText(classMessage.content);
        }
    }

    public void jHostComboBox_itemStateChanged(ItemEvent e2) {
        String host = (String)this.jHostComboBox.getSelectedItem();
        if (host == null) {
            return;
        }
        String value = "";
        value = host.equals(L.t("group.sel.All")) ? "*" : host;
        this.hostFilter.filterValue = value;
        ((TableSorter)this.jTable.getModel()).filter();
    }

    public void jClearButton_actionPerformed(ActionEvent e2) {
        if (this.eventType == 0) {
            this.helTableSorter.cancelFilter();
            this.helTableSorter.filterConditions.clear();
            this.helTableSorter.removeAllFilterCondition();
            this.helHostList.clear();
            int rowCount = this.helTableSorter.getTableModel().getRowCount();
            for (int i2 = 0; i2 < rowCount; ++i2) {
                ((DefaultTableModel)this.helTableSorter.getTableModel()).removeRow(0);
            }
        } else {
            this.melTableSorter.cancelFilter();
            this.melTableSorter.filterConditions.clear();
            this.melTableSorter.removeAllFilterCondition();
            this.melHostList.clear();
            int rowCount = this.melTableSorter.getTableModel().getRowCount();
            for (int i3 = 0; i3 < rowCount; ++i3) {
                ((DefaultTableModel)this.melTableSorter.getTableModel()).removeRow(0);
            }
        }
        this.jHostComboBox.removeAllItems();
    }

    public void jSaveButton_actionPerformed(ActionEvent e2) {
        int rowCount;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if ((rowCount = this.jTable.getModel().getRowCount()) == 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.No_data"));
            return;
        }
        boolean save = false;
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Do_you_want_to_overwrite_it"), L.t("group.table.toolbar.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int i2;
                StringBuffer sb = new StringBuffer();
                ArrayList<String> list = SELPanel.this.getHeader(SELPanel.this.eventType);
                for (i2 = 0; i2 < list.size(); ++i2) {
                    sb.append((Object)list.get(i2));
                    if (i2 == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i2 = 0; i2 < SELPanel.this.jTable.getRowCount(); ++i2) {
                    for (int j2 = 0; j2 < SELPanel.this.jTable.getColumnCount(); ++j2) {
                        sb.append((String)((TableSorter)SELPanel.this.jTable.getModel()).getValueAt(i2, j2));
                        if (j2 == SELPanel.this.jTable.getColumnCount() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    FileOutputStream outputStream = new FileOutputStream(SELPanel.this.pathName);
                    if (SELPanel.this.pathName.endsWith(".csv")) {
                        byte[] utf8Bom = new byte[]{-17, -69, -65};
                        outputStream.write(utf8Bom);
                    }
                    outputStream.write(sb.toString().getBytes("UTF-8"));
                    outputStream.close();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.save_to") + " " + SELPanel.this.pathName + " " + L.t("group.table.toolbar.completed"));
                }
                catch (IOException e2) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("group.table.toolbar.Warning"), 0);
                }
            }
        };
        thread.start();
    }

    private void eventTypeRadioButtonSelected(ActionEvent e2) {
        if (e2.getSource().equals(this.helRadioButton)) {
            this.eventType = 0;
            this.setTableHeader(0, false);
            this.jLastUpdateLabel.setText(this.last_update_hel);
            this.jHostComboBox.removeAllItems();
            this.helHostList.forEach(o -> this.jHostComboBox.addItem((String)o));
        } else if (e2.getSource().equals(this.melRadioButton)) {
            this.eventType = 1;
            this.setTableHeader(1, false);
            this.jLastUpdateLabel.setText(this.last_update_mel);
            this.jHostComboBox.removeAllItems();
            this.melHostList.forEach(o -> this.jHostComboBox.addItem((String)o));
        }
        this.keywordTextField.setText("");
        this.filterCellRender.clearKeyword();
        this.setTableCellRenderer();
        if (this.jHostComboBox.getItemCount() > 0) {
            this.jHostComboBox.setSelectedItem(L.t("group.sel.All"));
        }
    }

    private void setTableHeaderWidth(int type) {
        int[] helColWidths = new int[]{100, 80, 65, 110, 85, 60, 300};
        int[] melColWidths = new int[]{100, 80, 65, 110, 70, 100, 90, 230};
        int[] colWidths = type == 0 ? helColWidths : melColWidths;
        int colCount = this.jTable.getColumnModel().getColumnCount();
        for (int idx = 0; idx < colCount; ++idx) {
            this.jTable.getColumnModel().getColumn(idx).setPreferredWidth(colWidths[idx]);
        }
    }

    private void setTableHeader(int type, boolean clearAll) {
        this.jTable.removeAll();
        if (type == 0) {
            if (this.helTableSorter == null || clearAll) {
                this.helTableSorter = new TableSorter(new DefaultTableModel(this.getHeader(0).toArray(), 0));
            }
            this.initialTableFilterCondition(this.helTableSorter);
            this.jTable.setModel(this.helTableSorter);
        } else {
            if (this.melTableSorter == null || clearAll) {
                this.melTableSorter = new TableSorter(new DefaultTableModel(this.getHeader(1).toArray(), 0));
            }
            this.initialTableFilterCondition(this.melTableSorter);
            this.jTable.setModel(this.melTableSorter);
        }
        this.setTableHeaderWidth(type);
        this.jTable.invalidate();
    }

    private void setTableCellRenderer() {
        for (int i2 = 0; i2 < this.jTable.getColumnCount(); ++i2) {
            this.jTable.getColumnModel().getColumn(i2).setCellRenderer(this.filterCellRender);
        }
    }
}

