/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.L;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class FanStatusPanel
extends JPanel {
    private JLabel statusTitleLabel;
    private JLabel modelNameLabel;
    private JLabel modelNameValueLabel;
    private JLabel powerStatusLabel;
    private JLabel powerStatusIconLabel;
    private JLabel powerStatusValueLabel;
    private JLabel fan1SpeedLabel;
    private JLabel fan1SpeedValueLabel;
    private JLabel fan1SpeedUnitLabel;
    private JLabel fan2SpeedLabel;
    private JLabel fan2SpeedValueLabel;
    private JLabel fan2SpeedUnitLabel;
    private JLabel fwVersionLabel;
    private JLabel fwVersionValueLabel;
    private JLabel fruVersionLabel;
    private JLabel fruVersionValueLabel;
    private JPanel infoPanel;
    private JPanel statusPanel;
    private JPanel modelNamePanel;
    private JPanel powerStatusPanel;
    private JPanel fan1SpeedPanel;
    private JPanel fan2SpeedPanel;
    private JPanel fwVersionPanel;
    private JPanel fruVersionPanel;
    private JSeparator titleSeparator;
    private Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    private Icon failedRedIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));

    public FanStatusPanel(PowerSupplyInfo info) {
        this.statusTitleLabel = new JLabel();
        this.modelNameLabel = new JLabel();
        this.modelNameValueLabel = new JLabel();
        this.powerStatusLabel = new JLabel();
        this.powerStatusIconLabel = new JLabel();
        this.powerStatusValueLabel = new JLabel();
        this.fan1SpeedLabel = new JLabel();
        this.fan1SpeedValueLabel = new JLabel();
        this.fan2SpeedLabel = new JLabel();
        this.fan2SpeedValueLabel = new JLabel();
        this.fan1SpeedUnitLabel = new JLabel();
        this.fan2SpeedUnitLabel = new JLabel();
        this.fwVersionLabel = new JLabel();
        this.fruVersionLabel = new JLabel();
        this.fwVersionValueLabel = new JLabel();
        this.fruVersionValueLabel = new JLabel();
        this.titleSeparator = new JSeparator();
        this.infoPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.modelNamePanel = new JPanel();
        this.powerStatusPanel = new JPanel();
        this.fan1SpeedPanel = new JPanel();
        this.fan2SpeedPanel = new JPanel();
        this.fwVersionPanel = new JPanel();
        this.fruVersionPanel = new JPanel();
        this.initComponents();
        this.update(info);
    }

    public void update(PowerSupplyInfo fanInfo) {
        if (fanInfo.isPresent()) {
            this.powerStatusIconLabel.setIcon(this.okGreenIcon);
            this.modelNameValueLabel.setText(fanInfo.getModelName());
            this.powerStatusValueLabel.setText(L.t("cmm.nodeStatus.fan.on"));
            this.fan1SpeedValueLabel.setText(String.valueOf(fanInfo.getFan1Speed()));
            this.fan2SpeedValueLabel.setText(String.valueOf(fanInfo.getFan2Speed()));
            this.fwVersionValueLabel.setText(fanInfo.getfirmwareVer());
            this.fruVersionValueLabel.setText(String.valueOf(fanInfo.fruVer));
        } else {
            this.powerStatusIconLabel.setIcon(this.failedRedIcon);
            this.modelNameValueLabel.setText("N/A");
            this.powerStatusValueLabel.setText(L.t("cmm.nodeStatus.fan.off"));
            this.fan1SpeedValueLabel.setText("N/A");
            this.fan2SpeedValueLabel.setText("N/A");
            this.fwVersionValueLabel.setText("N/A");
            this.fruVersionValueLabel.setText("N/A");
        }
    }

    private void initComponents() {
        this.setComponetsMisc();
        this.setComponentsText();
        this.setComponentsSize();
        this.setComponentsLayout();
    }

    private void setComponetsMisc() {
        this.powerStatusIconLabel.setIcon(this.okGreenIcon);
        this.titleSeparator.setOrientation(0);
    }

    private void setComponentsLayout() {
        this.setLayout(new AbsoluteLayout());
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.modelNamePanel.setLayout(new BoxLayout(this.modelNamePanel, 0));
        this.powerStatusPanel.setLayout(new BoxLayout(this.powerStatusPanel, 0));
        this.fan1SpeedPanel.setLayout(new BoxLayout(this.fan1SpeedPanel, 0));
        this.fan2SpeedPanel.setLayout(new BoxLayout(this.fan2SpeedPanel, 0));
        this.fwVersionPanel.setLayout(new BoxLayout(this.fwVersionPanel, 0));
        this.fruVersionPanel.setLayout(new BoxLayout(this.fruVersionPanel, 0));
        this.statusPanel.add(this.statusTitleLabel);
        this.statusPanel.add(Box.createHorizontalGlue());
        this.modelNamePanel.add(this.modelNameLabel);
        this.modelNamePanel.add(this.modelNameValueLabel);
        this.powerStatusPanel.add(this.powerStatusLabel);
        this.powerStatusPanel.add(this.powerStatusIconLabel);
        this.powerStatusPanel.add(Box.createHorizontalStrut(5));
        this.powerStatusPanel.add(this.powerStatusValueLabel);
        this.fan1SpeedPanel.add(this.fan1SpeedLabel);
        this.fan1SpeedPanel.add(this.fan1SpeedValueLabel);
        this.fan1SpeedPanel.add(this.fan1SpeedUnitLabel);
        this.fan2SpeedPanel.add(this.fan2SpeedLabel);
        this.fan2SpeedPanel.add(this.fan2SpeedValueLabel);
        this.fan2SpeedPanel.add(this.fan2SpeedUnitLabel);
        this.fwVersionPanel.add(this.fwVersionLabel);
        this.fwVersionPanel.add(this.fwVersionValueLabel);
        this.fruVersionPanel.add(this.fruVersionLabel);
        this.fruVersionPanel.add(this.fruVersionValueLabel);
        this.infoPanel.add(this.statusPanel);
        this.infoPanel.add(this.titleSeparator);
        this.infoPanel.add(Box.createVerticalStrut(5));
        this.infoPanel.add(this.modelNamePanel);
        this.infoPanel.add(this.powerStatusPanel);
        this.infoPanel.add(this.fan1SpeedPanel);
        this.infoPanel.add(this.fan2SpeedPanel);
        this.infoPanel.add(this.fwVersionPanel);
        this.infoPanel.add(this.fruVersionPanel);
        this.infoPanel.add(Box.createVerticalGlue());
        this.add((Component)this.infoPanel, new AbsoluteConstraints(48, 7, 200, 200));
    }

    private void setComponentsText() {
        this.statusTitleLabel.setForeground(Color.BLUE);
        this.statusTitleLabel.setText(L.t("cmm.nodeStatus.fan.status"));
        this.modelNameLabel = new JLabel(L.t("cmm.nodeStatus.fan.modelName"));
        this.powerStatusLabel = new JLabel(L.t("cmm.nodeStatus.fan.powerStatus"));
        this.powerStatusValueLabel = new JLabel(L.t("cmm.nodeStatus.fan.on"));
        this.fan1SpeedLabel = new JLabel(L.t("cmm.nodeStatus.fan.fan1Speed"));
        this.fan2SpeedLabel = new JLabel(L.t("cmm.nodeStatus.fan.fan2Speed"));
        this.fan1SpeedUnitLabel = new JLabel(L.t("cmm.nodeStatus.fan.rpm"));
        this.fan2SpeedUnitLabel = new JLabel(L.t("cmm.nodeStatus.fan.rpm"));
        this.fwVersionLabel = new JLabel(L.t("cmm.nodeStatus.fan.fwVer"));
        this.fruVersionLabel = new JLabel(L.t("cmm.nodeStatus.fan.fruVer"));
        this.modelNameValueLabel = new JLabel("Fish Test");
        this.fan1SpeedValueLabel = new JLabel("9820");
        this.fan2SpeedValueLabel = new JLabel("11500");
        this.fwVersionValueLabel = new JLabel("1.0.15");
        this.fruVersionValueLabel = new JLabel("1.0");
    }

    private void setComponentsSize() {
        this.titleSeparator.setMaximumSize(new Dimension(Integer.MAX_VALUE, 3));
        this.statusPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.modelNamePanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.powerStatusPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fan1SpeedPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fan2SpeedPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fwVersionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fruVersionPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fan1SpeedPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 30));
        this.fan2SpeedPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 30));
        this.statusTitleLabel.setPreferredSize(new Dimension(100, 30));
        int wid = 110;
        this.modelNameLabel.setPreferredSize(new Dimension(wid, 25));
        this.powerStatusPanel.setPreferredSize(new Dimension(wid, 25));
        this.fan1SpeedLabel.setPreferredSize(new Dimension(wid, 25));
        this.fan2SpeedLabel.setPreferredSize(new Dimension(wid, 25));
        this.fwVersionPanel.setPreferredSize(new Dimension(wid, 25));
        this.fruVersionPanel.setPreferredSize(new Dimension(wid, 25));
        this.modelNameLabel.setMaximumSize(new Dimension(wid, 25));
        this.powerStatusLabel.setMaximumSize(new Dimension(wid, 25));
        this.fan1SpeedLabel.setMaximumSize(new Dimension(wid, 25));
        this.fan2SpeedLabel.setMaximumSize(new Dimension(wid, 25));
        this.fwVersionLabel.setMaximumSize(new Dimension(wid, 25));
        this.fruVersionLabel.setMaximumSize(new Dimension(wid, 25));
        int wid2 = 45;
        this.fan1SpeedValueLabel.setMaximumSize(new Dimension(wid2, 25));
        this.fan2SpeedValueLabel.setMaximumSize(new Dimension(wid2, 25));
    }
}

