/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.micro.LabelMicroBladeComponent;
import IPMIView20.micro.NodeStatusPanel;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelMicroBladeNode
extends LabelMicroBladeComponent {
    public LabelMicroBladeNode() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (!LabelMicroBladeNode.this.isExist) {
                    return;
                }
                LabelMicroBladeNode.this.setCursor(new Cursor(12));
                LabelMicroBladeNode.this.setBorderVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                LabelMicroBladeNode.this.setCursor(new Cursor(0));
                LabelMicroBladeNode.this.setBorderVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (!LabelMicroBladeNode.this.isExist) {
                    return;
                }
                LabelMicroBladeNode.this.setGroupUnSellect();
                LabelMicroBladeNode.this.isSelected = true;
                LabelMicroBladeNode.this.nodestatusPanel.flipcards("N" + LabelMicroBladeNode.this.number);
                LabelMicroBladeNode.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
            }
        });
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/labelBlade-Microblade.jpg")));
    }

    @Override
    public void paintComponent(Graphics g2) {
        Color backupColor;
        super.paintComponent(g2);
        this.setEnabled(this.isExist);
        if (!this.isExist) {
            this.numberVisible = false;
            this.showAlertVisisble = false;
            this.showFlashingVisisble = false;
            this.uidVisible = false;
            this.powerVisible = false;
        } else {
            this.numberVisible = true;
            this.powerVisible = true;
        }
        this.setOpaque(false);
        if (this.uidVisible) {
            if (this.uidIconX == 0 && this.uidIconY == 0) {
                this.uidIconX = (this.getWidth() - this.uidIcon.getIconWidth()) / 2 + 3;
                this.uidIconY = (this.getHeight() - this.uidIcon.getIconHeight()) / 2 + 10;
            }
            g2.drawImage(this.uidIcon.getImage(), this.uidIconX, this.uidIconY, this.uidIcon.getIconWidth(), this.uidIcon.getIconHeight(), null);
        }
        if (this.showAlertVisisble) {
            if (this.alertIconX == 0 && this.alertIconY == 0) {
                this.alertIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2 + 3;
                this.alertIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2 - 5;
            }
            g2.drawImage(this.alertIcon.getImage(), this.alertIconX, this.alertIconY, this.alertIcon.getIconWidth(), this.alertIcon.getIconHeight(), null);
        } else if (this.showFlashingVisisble) {
            if (this.flashIconX == 0 && this.flashIconY == 0) {
                this.flashIconX = (this.getWidth() - this.flashIcon.getIconWidth()) / 2 + 3;
                this.flashIconY = (this.getHeight() - this.flashIcon.getIconHeight()) / 2 - 5;
            }
            g2.drawImage(this.flashIcon.getImage(), this.flashIconX, this.flashIconY, this.flashIcon.getIconWidth(), this.flashIcon.getIconHeight(), null);
        }
        if (this.showRedrectangular) {
            backupColor = g2.getColor();
            g2.setColor(Color.RED);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
        if (this.numberVisible) {
            backupColor = g2.getColor();
            g2.setColor(Color.black);
            g2.drawString("" + (this.number % 4 + 1), this.numberX + 1, this.numberY + 1);
            g2.setColor(Color.white);
            g2.drawString("" + (this.number % 4 + 1), this.numberX, this.numberY);
            g2.setColor(backupColor);
        }
        if (this.borderVisible) {
            backupColor = g2.getColor();
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
        if (this.powerVisible) {
            if (this.powerIconX == 0 && this.powerIconY == 0) {
                this.powerIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2 + 3;
                this.powerIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2 + 25;
            }
            ImageIcon icon = null;
            switch (this.powerStatus) {
                case 1: {
                    icon = this.powerOnIcon;
                    break;
                }
                case 0: {
                    icon = this.powerOffIcon;
                    break;
                }
                case 2: {
                    icon = this.powerFailureIcon;
                }
            }
            if (icon != null) {
                g2.drawImage(icon.getImage(), this.powerIconX, this.powerIconY, icon.getIconWidth(), icon.getIconHeight(), null);
            }
        }
        if (this.isSelected) {
            backupColor = g2.getColor();
            g2.setColor(Color.MAGENTA);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
    }

    public void update(Observable o) {
        this.microbladeEntity = (MicroBladeEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelMicroBladeNode.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        if (!this.isExist) {
            this.setEnabled(false);
            if (this.isSelected && !this.isEnabled()) {
                this.nodestatusPanel.flipcards("first");
            }
            return;
        }
        this.setEnabled(true);
        NodeSensorInfo nodesensorInfo = this.microbladeEntity.getNodeSensorInfos()[this.number];
        this.setPowerStatus(nodesensorInfo.getPowerStatus());
        if (nodesensorInfo.getUid() == 2) {
            this.setUidVisible(true);
        } else {
            this.setUidVisible(false);
        }
        this.setAlertVisible(nodesensorInfo.error() >> 1 == NodeStatusPanel.NODE_STATE_ERROR);
        this.setFlashingVisible(nodesensorInfo.error() >> 1 == NodeStatusPanel.NODE_STATE_FLASHING);
        this.repaint();
    }
}

