/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.IPMIView20;
import IPMIView20.micro.LabelMicroBladeComponent;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import dyorgio.runtime.run.as.root.NotAuthorizedException;
import dyorgio.runtime.run.as.root.RootExecutor;
import dyorgio.runtime.run.as.root.UserCanceledException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LabelMicroBladeNodeForKVM
extends LabelMicroBladeComponent {
    String bmcIP = "";
    String id = "ADMIN";
    String password = "ADMIN";
    String cmmIP = "";
    ISessionController sessionController;

    public LabelMicroBladeNodeForKVM(final JLabel xMessage) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (!LabelMicroBladeNodeForKVM.this.isExist) {
                    return;
                }
                LabelMicroBladeNodeForKVM.this.setCursor(new Cursor(12));
                LabelMicroBladeNodeForKVM.this.setBorderVisible(true);
                LabelMicroBladeNodeForKVM.this.setToolTipText("IP: " + LabelMicroBladeNodeForKVM.this.bmcIP);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                LabelMicroBladeNodeForKVM.this.setCursor(new Cursor(0));
                LabelMicroBladeNodeForKVM.this.setBorderVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
                LabelMicroBladeNodeForKVM.this.setCursor(new Cursor(3));
                LabelMicroBladeNodeForKVM.this.startKVMFnction(xMessage);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                LabelMicroBladeNodeForKVM.this.setCursor(new Cursor(0));
            }
        });
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/labelBlade-Microblade.jpg")));
    }

    private void startKVMFnction(JLabel xMessage) {
        new Thread(() -> {
            xMessage.setText("Loading ...");
            int vmType = 0;
            int port = 5900;
            IPMIInterfaceConfig config = this.initIPMIInterfaceConfig();
            this.createSessionController(config);
            IPMIInterface rmcp = this.startSessionConnect(config);
            IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
            ipmiOEMPortServiceCommand.setIPMIInterface(rmcp);
            try {
                port = ipmiOEMPortServiceCommand.getPort((byte)2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
            int stunnelVer = 0;
            try {
                stunnelVer = ipmiOEMPortServiceCommand.getPort((byte)15);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConfigAccessor ca = new ConfigAccessor(".", "stunnel.properties");
            if (ca.getProperty("vm_security") == null) {
                ca.setProperty("vm_security", "off");
            }
            String isVMStunnel = ca.getProperty("vm_security");
            boolean isForceStunnelVer11 = false;
            if (isVMStunnel.equalsIgnoreCase("on")) {
                isForceStunnelVer11 = true;
            }
            if (stunnelVer > 0) {
                if (isForceStunnelVer11) {
                    stunnelVer = 11;
                } else if (stunnelVer == 13) {
                    stunnelVer = 11;
                }
                try {
                    StunnelParameters parameters = StunnelParameterBuilder.run(stunnelVer, this.bmcIP, ipmiOEMPortServiceCommand, guid, config.getIp(), config.getPassword());
                    if (stunnelVer == 5) {
                        StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                        if (!StunnelUtility.preCheck(parameters, config, stunnelVer)) {
                            StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                            stunnelVer = 11;
                            parameters = StunnelParameterBuilder.run(stunnelVer, this.bmcIP, ipmiOEMPortServiceCommand, guid, config.getIp(), config.getPassword());
                            StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                        }
                    } else {
                        StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                    }
                    LabelMicroBladeNodeForKVM.lunchKVMFromJRE(parameters.getStunnelIP(), this.id, this.password, parameters.getSturnnlPortList(), vmType, this.bmcIP, parameters.getStunnelFolder(), stunnelVer, xMessage, this.cmmIP);
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, e2.getMessage());
                }
            } else {
                LabelMicroBladeNodeForKVM.lunchKVMFromJRE(this.bmcIP, this.id, this.password, port, vmType, this.cmmIP);
            }
            this.sessionController.closeSession();
        }).start();
    }

    private static void lunchKVMFromJRE(String ip, String id, String pw, int port, int vmType, String cmmIP) {
        File jre = new File("jre");
        try {
            if (System.getProperty("os.name").indexOf("Windows") < 0) {
                String tmpPath = StunnelUtility.getTmpDir();
                FileWriter fw = new FileWriter(tmpPath + ip + ".temp");
                fw.write("ID: " + id + "\n");
                fw.write("Password: " + pw + "\n");
                fw.write("Port: " + port + "\n");
                fw.write("Vm: " + vmType + "\n");
                fw.close();
            }
        }
        catch (IOException tmpPath) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : (System.getProperty("os.name").indexOf("Mac") >= 0 ? "./jre/Contents/Home/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR" : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR")) : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : "java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR");
        try {
            Runtime.getRuntime().exec(execString);
            IPMIView20.kvmSessionMap.put(cmmIP, 1);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private static void lunchKVMFromJRE(String ip, String id, String pw, List<Integer> portList, int vmType, String BMCIP, String stunnleFolder, int stunnelVer, JLabel xMessage, String cmmIP) {
        File f2;
        String kvmJar = "iKVM.jar";
        if (stunnelVer == 9 || stunnelVer == 11) {
            kvmJar = "iKVM_ssl.jar";
            if (stunnelVer == 11) {
                KVMSessionConnection connection = new KVMSessionConnection(BMCIP, id, pw);
                try {
                    KVMUser user = connection.getLoginUser();
                    if (user == null) {
                        System.out.print("Could not establish KVM connction");
                        return;
                    }
                    id = user.getUsername();
                    pw = user.getPassword();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (!(f2 = new File(kvmJar)).exists()) {
            System.out.println("Cannot find " + kvmJar);
            return;
        }
        File jre = new File("jre");
        int vmPort = 623;
        if (portList.size() > 1) {
            vmPort = portList.get(1);
        }
        try {
            if (System.getProperty("os.name").indexOf("Windows") < 0) {
                String tmpPath = StunnelUtility.getTmpDir();
                FileWriter fw = new FileWriter(tmpPath + BMCIP + ".temp");
                fw.write("ID: " + id + "\n");
                fw.write("Password: " + pw + "\n");
                fw.write("Port: " + portList.get(0) + "\n");
                fw.write("Vm: " + vmType + "\n");
                fw.write("Vm_port: " + vmPort + "\n");
                fw.write("Version: " + stunnelVer + "\n");
                fw.close();
            }
        }
        catch (IOException tmpPath) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + "   0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : (System.getProperty("os.name").indexOf("Mac") >= 0 ? "./jre/Contents/Home/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder : "./jre/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder)) : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "java -Djava.library.path=. -jar  " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder);
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            String executeString = execString;
            try {
                RootExecutor rootExecutor = new RootExecutor(new String[0]);
                rootExecutor.run(() -> {
                    try {
                        Runtime.getRuntime().exec(executeString);
                    }
                    catch (IOException e2) {
                        xMessage.setText(e2.getMessage());
                    }
                });
                xMessage.setText("Loading ... Done");
                IPMIView20.kvmSessionMap.put(cmmIP, 1);
            }
            catch (IOException e2) {
                xMessage.setText("IO Exceptino");
            }
            catch (UserCanceledException e3) {
                xMessage.setText("User Cancel");
            }
            catch (NotAuthorizedException e4) {
                xMessage.setText("User Not Authorized");
            }
            catch (Exception e5) {
                xMessage.setText("Exception " + e5.getMessage());
            }
        } else {
            try {
                Runtime.getRuntime().exec(execString);
                IPMIView20.kvmSessionMap.put(cmmIP, 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
        }
    }

    ISessionController createSessionController(IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.sessionController = IPMIVersion.getSessionController(ipmiInterfaceConfig);
        if (this.sessionController == null) {
            System.out.println("divice didn't exist");
            return null;
        }
        return this.sessionController;
    }

    IPMIInterface startSessionConnect(IPMIInterfaceConfig ipmiInterfaceConfig) {
        IPMINetworkInterface rmcp = this.sessionController.startup(ipmiInterfaceConfig);
        if (rmcp == null) {
            System.out.println("Network error");
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        return rmcp;
    }

    private IPMIInterfaceConfig initIPMIInterfaceConfig() {
        IPMIInterfaceConfig ipmiInterfaceConfig = new IPMIInterfaceConfig();
        ipmiInterfaceConfig.setIp(this.bmcIP);
        ipmiInterfaceConfig.setUserName(this.id);
        ipmiInterfaceConfig.setPassword(this.password);
        ipmiInterfaceConfig.setRetry(2);
        ipmiInterfaceConfig.setTimeout(5);
        ipmiInterfaceConfig.setCipherSuiteID((byte)3);
        return ipmiInterfaceConfig;
    }

    @Override
    public void paintComponent(Graphics g2) {
        Color backupColor;
        super.paintComponent(g2);
        this.setEnabled(this.isExist);
        if (!this.isExist) {
            this.numberVisible = false;
            this.showAlertVisisble = false;
            this.uidVisible = false;
            this.powerVisible = false;
        } else {
            this.numberVisible = true;
            this.powerVisible = true;
        }
        this.setOpaque(false);
        if (this.uidVisible) {
            if (this.uidIconX == 0 && this.uidIconY == 0) {
                this.uidIconX = (this.getWidth() - this.uidIcon.getIconWidth()) / 2 + 3;
                this.uidIconY = (this.getHeight() - this.uidIcon.getIconHeight()) / 2 + 10;
            }
            g2.drawImage(this.uidIcon.getImage(), this.uidIconX, this.uidIconY, this.uidIcon.getIconWidth(), this.uidIcon.getIconHeight(), null);
        }
        if (this.showAlertVisisble) {
            if (this.alertIconX == 0 && this.alertIconY == 0) {
                this.alertIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2 + 3;
                this.alertIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2 - 5;
            }
            g2.drawImage(this.alertIcon.getImage(), this.alertIconX, this.alertIconY, this.alertIcon.getIconWidth(), this.alertIcon.getIconHeight(), null);
        }
        if (this.showRedrectangular) {
            backupColor = g2.getColor();
            g2.setColor(Color.RED);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
        if (this.numberVisible) {
            backupColor = g2.getColor();
            g2.setColor(Color.black);
            g2.drawString("" + (this.number % 4 + 1), this.numberX + 1, this.numberY + 1);
            g2.setColor(Color.white);
            g2.drawString("" + (this.number % 4 + 1), this.numberX, this.numberY);
            g2.setColor(backupColor);
        }
        if (this.borderVisible) {
            backupColor = g2.getColor();
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
        if (this.powerVisible) {
            if (this.powerIconX == 0 && this.powerIconY == 0) {
                this.powerIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2 + 3;
                this.powerIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2 + 25;
            }
            ImageIcon icon = null;
            switch (this.powerStatus) {
                case 1: {
                    icon = this.powerOnIcon;
                    break;
                }
                case 0: {
                    icon = this.powerOffIcon;
                    break;
                }
                case 2: {
                    icon = this.powerFailureIcon;
                }
            }
            if (icon != null) {
                g2.drawImage(icon.getImage(), this.powerIconX, this.powerIconY, icon.getIconWidth(), icon.getIconHeight(), null);
            }
        }
        if (this.isSelected) {
            backupColor = g2.getColor();
            g2.setColor(Color.MAGENTA);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
    }

    public String getBmcIP() {
        return this.bmcIP;
    }

    public void setBmcIP(String bmcIP) {
        this.bmcIP = bmcIP;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCmmIP() {
        return this.cmmIP;
    }

    public void setCmmIP(String cmmIP) {
        this.cmmIP = cmmIP;
    }
}

