/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.micro.LabelMicroBladeComponent;
import com.supermicro.ipmi.microblade.MicroBladeEntity;
import com.supermicro.ipmi.microblade.SwitchInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class LabelMicroBladeSwitch
extends LabelMicroBladeComponent {
    boolean powerStatusForSwitch;

    public LabelMicroBladeSwitch() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e2) {
                if (!LabelMicroBladeSwitch.this.isExist) {
                    return;
                }
                LabelMicroBladeSwitch.this.setCursor(new Cursor(12));
                LabelMicroBladeSwitch.this.setBorderVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                LabelMicroBladeSwitch.this.setCursor(new Cursor(0));
                LabelMicroBladeSwitch.this.setBorderVisible(false);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (!LabelMicroBladeSwitch.this.isExist) {
                    return;
                }
                LabelMicroBladeSwitch.this.setGroupUnSellect();
                LabelMicroBladeSwitch.this.isSelected = true;
                LabelMicroBladeSwitch.this.nodestatusPanel.flipcards("S" + LabelMicroBladeSwitch.this.number);
                LabelMicroBladeSwitch.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
            }
        });
    }

    public void setIcon(SwitchInfo info, boolean isUp, boolean isShortUnit) {
        int displayType = info.isPresent() ? info.switchType : (isShortUnit ? 5 : 7);
        switch (displayType) {
            case 0: {
                this.setIcon(new ImageIcon(this.getClass().getResource("/images/labelMicrobladeSwitchSBMIBSE3616Up.jpg")));
                break;
            }
            case 1: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchGEM001Up.jpg" : "/images/labelMicrobladeSwitchGEM001Below.jpg")));
                break;
            }
            case 2: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchXEM002Up.jpg" : "/images/labelMicrobladeSwitchXEM002Below.jpg")));
                break;
            }
            case 4: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchXEM001Up.jpg" : "/images/labelMicrobladeSwitchXEM001Below.jpg")));
                break;
            }
            case 5: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchGEM004Up.jpg" : "/images/labelMicrobladeSwitchGEM004Below.jpg")));
                break;
            }
            case 7: {
                this.setIcon(new ImageIcon(this.getClass().getResource("/images/labelMicrobladeSwitchSBMOPAC4020Up.jpg")));
                break;
            }
            case 10: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchXEM100Up.jpg" : "/images/labelMicrobladeSwitchXEM100Below.jpg")));
                break;
            }
            default: {
                this.setIcon(new ImageIcon(this.getClass().getResource(isUp ? "/images/labelMicrobladeSwitchGEM004Up.jpg" : "/images/labelMicrobladeSwitchGEM004Below.jpg")));
            }
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        Color backupColor;
        super.paintComponent(g2);
        this.setEnabled(this.isExist);
        if (!this.isExist) {
            this.numberVisible = false;
            this.showAlertVisisble = false;
            this.uidVisible = false;
            this.powerVisible = false;
        }
        this.setOpaque(false);
        if (this.uidVisible) {
            if (this.uidIconX == 0 && this.uidIconY == 0) {
                this.uidIconX = (this.getWidth() - this.uidIcon.getIconWidth()) / 2 + 15;
                this.uidIconY = (this.getHeight() - this.uidIcon.getIconHeight()) / 2;
            }
            g2.drawImage(this.uidIcon.getImage(), this.uidIconX, this.uidIconY, this.uidIcon.getIconWidth(), this.uidIcon.getIconHeight(), null);
        }
        if (this.showAlertVisisble) {
            if (this.alertIconX == 0 && this.alertIconY == 0) {
                this.alertIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2;
                this.alertIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2;
            }
            g2.drawImage(this.alertIcon.getImage(), this.alertIconX, this.alertIconY, this.alertIcon.getIconWidth(), this.alertIcon.getIconHeight(), null);
        }
        if (this.numberVisible) {
            backupColor = g2.getColor();
            g2.setColor(Color.black);
            g2.drawString("" + (this.number + 1), this.numberX + 1, this.numberY + 1);
            g2.setColor(Color.white);
            g2.drawString("" + (this.number + 1), this.numberX, this.numberY);
            g2.setColor(backupColor);
        }
        if (this.borderVisible) {
            backupColor = g2.getColor();
            g2.setColor(this.borderColor);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
        if (this.powerVisible) {
            if (this.powerIconX == 0 && this.powerIconY == 0) {
                this.powerIconX = (this.getWidth() - this.alertIcon.getIconWidth()) / 2 - 15;
                this.powerIconY = (this.getHeight() - this.alertIcon.getIconHeight()) / 2;
            }
            ImageIcon icon = null;
            icon = this.powerStatusForSwitch ? this.powerOnIcon : this.powerOffIcon;
            g2.drawImage(icon.getImage(), this.powerIconX, this.powerIconY, icon.getIconWidth(), icon.getIconHeight(), null);
        }
        if (this.isSelected) {
            backupColor = g2.getColor();
            g2.setColor(Color.MAGENTA);
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(backupColor);
        }
    }

    public boolean getPowerStatusForSwitch() {
        return this.powerStatusForSwitch;
    }

    public void setPowerStatus(boolean powerStatus) {
        this.powerStatusForSwitch = powerStatus;
        if (this.powerVisible) {
            this.repaint();
        }
    }

    public void update(Observable o) {
        this.microbladeEntity = (MicroBladeEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LabelMicroBladeSwitch.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        if (!this.isExist) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        SwitchInfo switchinfo = this.microbladeEntity.getSwitchInfos()[this.number];
        this.setPowerStatus(switchinfo.getPowerStatus());
        if (switchinfo.getUid()) {
            this.setUidVisible(true);
        } else {
            this.setUidVisible(false);
        }
        if (switchinfo.error == 0) {
            this.setAlertVisible(false);
        } else {
            this.setAlertVisible(true);
        }
        this.repaint();
    }
}

