/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.micro;

import IPMIView20.CMMSessionPanel;
import IPMIView20.L;
import IPMIView20.blade.JFanPanel;
import IPMIView20.blade.JSliderObserver;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.SliderObservable;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.microblade.SystemMiscInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class PowerSupplyStatusPanel
extends JPanel
implements ActionListener {
    public static int FAN_FULL_SPEED_RPM = 15000;
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static final int POWER_OFF_STATUS = 0;
    public static final int POWER_ON_STATUS = 1;
    public static final int POWER_FAILURE_STATUS = 2;
    IPMIInterfaceConfig config;
    PowerSupplyInfo powersupplyInfo;
    SystemMiscInfo systemMiscInfo;
    int number;
    ButtonGroup jFanSpeedButtomGroup = new ButtonGroup();
    ButtonGroup jFanSpeedModeRadioButtonGroup = new ButtonGroup();
    ButtonGroup jFanModeRadioMenuItemButtonGroup = new ButtonGroup();
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon fanSpeed1Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed1.gif"));
    Icon fanSpeed2Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed2.gif"));
    Icon fanSpeed3Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed3.gif"));
    Icon fanSpeed4Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed4.gif"));
    JFanPanel fan1Panel = new JFanPanel();
    JFanPanel fan2Panel = new JFanPanel();
    JTempPanel tempPanel = new JTempPanel();
    SliderObservable sliderObservable = null;
    JPanel jPowerPanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    JPanel jControlPanel = new JPanel();
    JPanel jStatusPanel = new JPanel();
    JPanel jFanPanel = new JPanel();
    JPanel jTemperaturePanel = new JPanel();
    JPanel jPowerControlPanel = new JPanel();
    JPanel jFanSpeedControlPanel = new JPanel();
    JLabel title1 = new JLabel(L.t("cmm.nodeStatus.power_supply.status"));
    JSeparator js1 = new JSeparator();
    JLabel title2 = new JLabel(L.t("cmm.nodeStatus.power_supply.centralized_power_fan_speed_control"));
    JSeparator js2 = new JSeparator();
    JLabel title3 = new JLabel(L.t("cmm.nodeStatus.power_supply.power_control"));
    JSeparator js3 = new JSeparator();
    JLabel title4 = new JLabel(L.t("cmm.nodeStatus.power_supply.power_supply_temperature"));
    JSeparator js4 = new JSeparator();
    JLabel title5 = new JLabel(L.t("cmm.nodeStatus.power_supply.power_supply_fan"));
    JSeparator js5 = new JSeparator();
    JLabel jModelNameLabel = new JLabel();
    JLabel jModelNameStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.model_name"));
    JLabel jFirmwareVersionLabel = new JLabel();
    JLabel jFirmwareVersionStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.fw_version"));
    JLabel jFRUVersionStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.fru_version"));
    JLabel jFRUVersionLabel = new JLabel();
    JLabel jFan2SpeedLabel = new JLabel();
    JLabel jFan2StatusLabel = new JLabel();
    JLabel jFan2StatusStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.fan_2_status"));
    JLabel jFan1SpeedLabel = new JLabel();
    JLabel jFan1StatusLabel = new JLabel();
    JLabel jFan1StatusStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.fan_1_status"));
    JLabel jWattsLabel = new JLabel();
    JLabel jWattsStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.watts"));
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.power_status"));
    JLabel jPowerStatusIcon = new JLabel();
    JLabel jACCurrentString = new JLabel(L.t("cmm.nodeStatus.power_supply.ac_rms_current"));
    JLabel jACCurrentLabel = new JLabel();
    JLabel jDCCurrentString = new JLabel(L.t("cmm.nodeStatus.power_supply.dc_current"));
    JLabel jDCCurrentLabel = new JLabel();
    JLabel jspeedLabel = new JLabel(L.t("cmm.nodeStatus.power_supply.speed_level"));
    JLabel jlabel2 = new JLabel();
    JLabel jlabel3 = new JLabel();
    JButton jPowerOffButton = new JButton(L.t("Power Off"));
    JButton jPowerOnButton = new JButton(L.t("Power On"));
    JButton jSpeed1Button = new JButton();
    JButton jSpeed2Button = new JButton();
    JButton jSpeed3Button = new JButton();
    JButton jSpeed4Button = new JButton();
    JComboBox cb_fanSpeed;
    JRadioButton jFanAutomaticRadioButton = new JRadioButton(L.t("cmm.nodeStatus.power_supply.automatic"));
    JRadioButton jFanManualRadioButton = new JRadioButton(L.t("cmm.nodeStatus.power_supply.manual"));
    BorderLayout borderlayout1 = new BorderLayout();
    BorderLayout borderlayout2 = new BorderLayout();
    GridLayout gridlayout1 = new GridLayout(0, 1);
    public JSliderObserver jSlider1 = new JSliderObserver();
    boolean initSensors = false;

    public PowerSupplyStatusPanel(CMMSessionPanel cmm, int index) {
        this.setLayout(new MigLayout("", "[20::200][][0:60:80][][20::200]", ""));
        this.config = cmm.ipmiInterfaceConfig;
        this.powersupplyInfo = cmm.microbladeEntity.getPowerSupplyInfos()[index];
        this.systemMiscInfo = cmm.microbladeEntity.getSystemMiscInfo();
        this.number = index;
        this.title1.setForeground(Color.blue);
        this.title2.setForeground(Color.BLUE);
        this.title3.setForeground(Color.blue);
        this.title4.setForeground(Color.BLUE);
        this.title5.setForeground(Color.BLUE);
        this.jStatusPanel.setLayout(new MigLayout("", "", "0[]3[]5[]3[]3[]3[]3[]3[]3[]3[]3[]3[]5"));
        this.jStatusPanel.add((Component)this.title1, "cell 0 0");
        this.jStatusPanel.add((Component)this.js1, "cell 0 1, span 3, growx");
        this.jStatusPanel.add((Component)this.jModelNameStringLabel, "cell 0 2");
        this.jStatusPanel.add((Component)this.jModelNameLabel, "cell 1 2");
        this.jStatusPanel.add((Component)this.jPowerStatusStringLabel, "cell 0 3");
        this.jStatusPanel.add((Component)this.jPowerStatusIcon, "cell 1 3");
        this.jStatusPanel.add((Component)this.jPowerStatusLabel, "cell 1 3");
        this.jStatusPanel.add((Component)this.jFan1StatusStringLabel, "cell 0 4");
        this.jStatusPanel.add((Component)this.jFan1StatusLabel, "cell 1 4");
        this.jStatusPanel.add((Component)this.jFan1SpeedLabel, "cell 1 4");
        this.jStatusPanel.add((Component)this.jFan2StatusStringLabel, "cell 0 5");
        this.jStatusPanel.add((Component)this.jFan2StatusLabel, "cell 1 5");
        this.jStatusPanel.add((Component)this.jFan2SpeedLabel, "cell 1 5");
        this.jStatusPanel.add((Component)this.jWattsStringLabel, "cell 0 6");
        this.jStatusPanel.add((Component)this.jWattsLabel, "cell 1 6");
        this.jStatusPanel.add((Component)this.jDCCurrentString, "cell 0 7");
        this.jStatusPanel.add((Component)this.jDCCurrentLabel, "cell 1 7");
        this.jStatusPanel.add((Component)this.jACCurrentString, "cell 0 8");
        this.jStatusPanel.add((Component)this.jACCurrentLabel, "cell 1 8");
        this.jStatusPanel.add((Component)this.jFirmwareVersionStringLabel, "cell 0 9");
        this.jStatusPanel.add((Component)this.jFirmwareVersionLabel, "cell 1 9");
        this.jStatusPanel.add((Component)this.jFRUVersionStringLabel, "cell 0 10");
        this.jStatusPanel.add((Component)this.jFRUVersionLabel, "cell 1 10");
        String[] speedString = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.cb_fanSpeed = new JComboBox<String>(speedString);
        this.jFanAutomaticRadioButton.addActionListener(this);
        this.jFanManualRadioButton.addActionListener(this);
        this.cb_fanSpeed.addActionListener(this);
        this.jControlPanel.setLayout(new MigLayout("", "", "0[]3[]3[]3[]0"));
        this.jspeedLabel.setForeground(Color.BLUE);
        this.jFanSpeedModeRadioButtonGroup.add(this.jFanAutomaticRadioButton);
        this.jFanSpeedModeRadioButtonGroup.add(this.jFanManualRadioButton);
        this.jControlPanel.add((Component)this.title2, "cell 0 0, span 3");
        this.jControlPanel.add((Component)this.js2, "cell 0 1, span 3, growx");
        this.jControlPanel.add((Component)this.jFanAutomaticRadioButton, "cell 0 2");
        this.jControlPanel.add((Component)this.jFanManualRadioButton, "cell 0 3");
        this.jControlPanel.add((Component)this.jspeedLabel, "cell 1 3");
        this.jControlPanel.add((Component)this.cb_fanSpeed, "cell 2 3");
        this.jTemperaturePanel.add(this.tempPanel);
        this.jFanPanel.add(this.fan1Panel);
        this.jFanPanel.add(this.fan2Panel);
        this.tempPanel.tempMeter.setPreferredSize(new Dimension(135, 31));
        this.fan1Panel.fanMeter.setPreferredSize(new Dimension(72, 72));
        this.fan2Panel.fanMeter.setPreferredSize(new Dimension(72, 72));
        this.fan1Panel.init(L.t("cmm.single.power.Fan1"), (byte)0, (byte)0, "", "");
        this.fan2Panel.init(L.t("cmm.single.power.Fan2"), (byte)0, (byte)0, "", "");
        this.tempPanel.init(L.t("cmm.single.power.Temperature"), (byte)0, (byte)0, "", "");
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel(L.t("cmm.single.power.Min")));
        labelTable.put(new Integer(4), new JLabel(L.t("cmm.single.power.Max")));
        this.jSlider1.setLabelTable(labelTable);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setSnapToTicks(true);
        this.jPowerPanel.setLayout(new MigLayout("", "", ""));
        this.jPowerPanel.add((Component)this.title4, "cell 0 4, span 2");
        this.jPowerPanel.add((Component)this.js4, "cell 0 5, span 3 , growx");
        this.jPowerPanel.add((Component)this.jTemperaturePanel, "cell 1 6, span 2, align center");
        this.jPowerPanel.add((Component)this.title5, "cell 0 8");
        this.jPowerPanel.add((Component)this.js5, "cell 0 9, span 3 , growx");
        this.jPowerPanel.add((Component)this.jFanPanel, "cell 1 10, span 2, align center");
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.addActionListener(this);
        this.jPowerOnButton.addActionListener(this);
        this.jLeftPanel.setLayout(new MigLayout("", "", ""));
        this.jLeftPanel.add((Component)this.jStatusPanel, "cell 0 0");
        this.jLeftPanel.add((Component)this.jControlPanel, "cell 0 1");
        this.add((Component)this.jLeftPanel, "cell 1 0");
        this.add((Component)this.jPowerPanel, "cell 3 0");
        this.refresh(this.powersupplyInfo, this.systemMiscInfo);
    }

    public void update(PowerSupplyInfo ps, SystemMiscInfo sm) {
        this.powersupplyInfo = ps;
        this.systemMiscInfo = sm;
        SwingUtilities.invokeLater(new Runnable(){
            private PowerSupplyInfo p;
            private SystemMiscInfo s;
            {
                this.p = PowerSupplyStatusPanel.this.powersupplyInfo;
                this.s = PowerSupplyStatusPanel.this.systemMiscInfo;
            }

            @Override
            public void run() {
                try {
                    PowerSupplyStatusPanel.this.refresh(this.p, this.s);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void refresh(PowerSupplyInfo pws, SystemMiscInfo sm) {
        if (pws.powerStatus == 0) {
            this.jPowerStatusIcon.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.nodeStatus.power_supply.power_off"));
        } else if (pws.powerStatus == 1) {
            this.jPowerStatusIcon.setIcon(this.powerOnIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.nodeStatus.power_supply.power_on"));
        } else if (pws.powerStatus == 2) {
            this.jPowerStatusIcon.setIcon(this.powerFailureIcon);
            this.jPowerStatusLabel.setText(L.t("cmm.nodeStatus.power_supply.power_failure"));
        }
        this.jModelNameLabel.setText(pws.getModelName());
        this.jWattsLabel.setText(Integer.toString(pws.getPSWatt()));
        this.jDCCurrentLabel.setText(pws.getDCOutputCurr() > 0 ? pws.getDCOutputCurr() + " A" : "N/A");
        this.jACCurrentLabel.setText(Float.toString(pws.getACRMSCur()) + "A");
        this.jFirmwareVersionLabel.setText(pws.getfirmwareVer());
        this.jFRUVersionLabel.setText(Byte.toString(pws.fruVer));
        this.jFanAutomaticRadioButton.removeActionListener(this);
        this.jFanManualRadioButton.removeActionListener(this);
        this.cb_fanSpeed.removeActionListener(this);
        if (sm.fanMode == 0) {
            this.jFanAutomaticRadioButton.setSelected(true);
            this.cb_fanSpeed.setEnabled(false);
        } else {
            this.jFanManualRadioButton.setSelected(true);
            this.cb_fanSpeed.setEnabled(true);
        }
        this.cb_fanSpeed.setSelectedIndex(sm.userFanSpeed);
        int fan1RPM = pws.getFan1Speed();
        int fan1RPMLimit = pws.getFan1SpeedLimit();
        if (fan1RPM == 0) {
            this.jFan1StatusLabel.setForeground(Color.BLACK);
            this.jFan1StatusLabel.setText("N/A");
        } else if (fan1RPM <= fan1RPMLimit) {
            this.jFan1StatusLabel.setForeground(Color.RED);
            this.jFan1StatusLabel.setIcon(this.xRedIcon);
            this.jFan1StatusLabel.setText(L.t("cmm.single.power.Abnormal"));
        } else {
            this.jFan1StatusLabel.setForeground(Color.GREEN);
            this.jFan1StatusLabel.setIcon(this.okGreenIcon);
            this.jFan1StatusLabel.setText(L.t("cmm.single.power.Normal"));
        }
        int fan2RPM = pws.getFan2Speed();
        int fan2RPMLimit = pws.getFan2SpeedLimit();
        if (fan2RPM == 0) {
            this.jFan2StatusLabel.setForeground(Color.BLACK);
            this.jFan2StatusLabel.setText("N/A");
        } else if (fan2RPM <= fan2RPMLimit) {
            this.jFan2StatusLabel.setForeground(Color.RED);
            this.jFan2StatusLabel.setIcon(this.xRedIcon);
            this.jFan2StatusLabel.setText(L.t("cmm.single.power."));
        } else {
            this.jFan2StatusLabel.setForeground(Color.GREEN);
            this.jFan2StatusLabel.setIcon(this.okGreenIcon);
            this.jFan2StatusLabel.setText(L.t("cmm.single.power.Normal"));
        }
        byte fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte temp = pws.temp;
        byte tempLimit = pws.tempHLimit;
        if (!this.initSensors) {
            this.fan1Panel.init(L.t("cmm.nodeStatus.power_supply.fan_1"), fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
            this.fan2Panel.init(L.t("cmm.nodeStatus.power_supply.fan_2"), fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
            this.tempPanel.init(L.t("cmm.nodeStatus.power_supply.temperature"), temp, tempLimit, "" + temp, "" + tempLimit);
            this.initSensors = true;
        }
        if (fan1RPM == 0) {
            this.fan1Panel.setNA();
        } else {
            this.fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
        }
        if (fan2RPM == 0) {
            this.fan2Panel.setNA();
        } else {
            this.fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
        }
        if (temp == -1) {
            this.tempPanel.setNA();
        } else {
            this.tempPanel.updateValue(temp, "" + temp);
        }
        this.jFanAutomaticRadioButton.addActionListener(this);
        this.jFanManualRadioButton.addActionListener(this);
        this.cb_fanSpeed.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.jFanAutomaticRadioButton) {
            this.cb_fanSpeed.setEnabled(false);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    PowerSupplyStatusPanel.this.setFanMode(true);
                }
            };
            thread.start();
        } else if (e2.getSource() == this.jFanManualRadioButton) {
            this.cb_fanSpeed.setEnabled(true);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    PowerSupplyStatusPanel.this.setFanMode(false);
                }
            };
            thread.start();
        } else if (e2.getSource() == this.cb_fanSpeed) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    PowerSupplyStatusPanel.this.setFanSpeedIndex(PowerSupplyStatusPanel.this.cb_fanSpeed.getSelectedIndex());
                }
            };
            thread.start();
        } else if (e2.getSource() == this.jPowerOffButton) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.single.power.Are_you_sure_power_off"), "Confirmation", 0);
                    if (result == 1) {
                        return;
                    }
                    PowerSupplyStatusPanel.this.powerOff();
                }
            };
            thread.start();
        } else if (e2.getSource() == this.jPowerOnButton) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int result = JOptionPane.showConfirmDialog(null, L.t("cmm.single.power.Are_you_sure_power_on"), "Confirmation", 0);
                    if (result == 1) {
                        return;
                    }
                    PowerSupplyStatusPanel.this.powerOn();
                }
            };
            thread.start();
        }
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setPowerStatus(this.number + 1, false);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setPowerStatus(this.number + 1, true);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, L.t("cmm.single.power.Power_on_failed"));
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void setFanMode(boolean isAuto) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setFanMode(isAuto);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    private void setFanSpeedIndex(int index) {
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController != null) {
            try {
                ipmiMicroBladeOEMCommand.setFanSpeed(index);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(null, ex.toString());
            }
        }
    }

    public void setUserPrivilege() {
        this.jPowerOffButton.setEnabled(false);
        this.jPowerOnButton.setEnabled(false);
        this.jFanAutomaticRadioButton.setEnabled(false);
        this.jFanManualRadioButton.setEnabled(false);
        this.jspeedLabel.setVisible(false);
        this.cb_fanSpeed.setVisible(false);
    }

    public void setOperatorPrivilege() {
        this.jPowerOffButton.setEnabled(true);
        this.jPowerOnButton.setEnabled(true);
        this.jFanAutomaticRadioButton.setEnabled(true);
        this.jFanManualRadioButton.setEnabled(true);
        this.jspeedLabel.setVisible(true);
        this.cb_fanSpeed.setVisible(true);
    }

    public void setAdministratorPrivilege() {
        this.jPowerOffButton.setEnabled(true);
        this.jPowerOnButton.setEnabled(true);
        this.jFanAutomaticRadioButton.setEnabled(true);
        this.jFanManualRadioButton.setEnabled(true);
        this.jspeedLabel.setVisible(true);
        this.cb_fanSpeed.setVisible(true);
    }

    public static void main(String[] args) {
        PowerSupplyStatusPanel p = new PowerSupplyStatusPanel(null, 0);
        JFrame frame = new JFrame();
        frame.setContentPane(p);
        frame.setSize(800, 550);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

