/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.trap.TrapDaemonPackage;
import IPMIView20.trap.TrapReceiverTray;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;

public class TrapDaemon
implements WrapperListener {
    private Receiver receiver;
    public static final String AUTO_START = "AUTO_START";
    public static final String DEMAND_START = "DEMAND_START";
    public static final String AUTO = "auto";
    public static final String DEMAND = "demand";
    public static final String OS_WINDOWS = "Windows";
    public static final String OS_LINUX = "Linux";
    public static final String LINUX_SERVICE_DIR = "/etc/init.d/";
    private TrapReceiverTray trapReceiverTray;
    private TrapDaemonServerSocket trapDaemonServerSocket;

    public void controlEvent(int event) {
        System.out.println("TrapDaemon: controlEvent(" + event + ")");
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            System.out.println("TrapDaemon:   Ignoring logoff event");
        } else {
            WrapperManager.stop((int)0);
        }
        System.out.println("TrapDaemon controlEvent: " + new Date());
    }

    public Integer start(String[] args) {
        Properties properties = WrapperManager.getProperties();
        String osName = System.getProperty("os.name");
        if (osName.startsWith(OS_WINDOWS)) {
            try {
                this.trapReceiverTray = TrapReceiverTray.getInstance();
                this.trapReceiverTray.setProperties(properties);
                this.trapReceiverTray.refreshServiceState();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (osName.contains(OS_LINUX)) {
            this.receiver = new Receiver();
            this.trapDaemonServerSocket = new TrapDaemonServerSocket("Trap Daemon Server Socket");
            this.receiver.getTrapCollector().addObserver(this.trapDaemonServerSocket);
            this.trapDaemonServerSocket.setTrapReceiverState(this.receiver.startReceiver());
            this.trapDaemonServerSocket.start();
        }
        System.out.println("TrapDaemon Started");
        if (properties.getProperty("wrapper.logfile.loglevel").equalsIgnoreCase("debug")) {
            System.err.println("Dump Wrapper Properties:");
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                System.err.println("  " + name + "=" + properties.getProperty(name));
            }
            System.out.println();
        }
        return null;
    }

    public int stop(int arg0) {
        this.trapDaemonServerSocket.close();
        System.out.println("TrapDaemon Stopped");
        return 0;
    }

    public static void main(String[] args) {
        System.out.println("TrapDaemon Starting ...");
        WrapperManager.start((WrapperListener)new TrapDaemon(), (String[])args);
        WrapperManager.addWrapperEventListener((WrapperEventListener)new WrapperEventListener(){

            public void fired(WrapperEvent wrapperEvent) {
                if (wrapperEvent instanceof WrapperControlEvent) {
                    // empty if block
                }
            }
        }, (long)3L);
    }

    private class TrapDaemonServerSocket
    extends Thread
    implements Observer {
        private ArrayList sockets;
        private boolean acceptLoop;
        private boolean trapReceiverState;

        public TrapDaemonServerSocket(String string) {
            super(string);
            this.acceptLoop = true;
            this.sockets = new ArrayList();
        }

        @Override
        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(51000);
                while (this.acceptLoop) {
                    System.out.println("TrapDaemonServerSocket Listening ...");
                    Socket socket = serverSocket.accept();
                    System.out.println("TrapDaemonServerSocket acceptted");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                    TrapDaemonPackage trapDaemonPackage = new TrapDaemonPackage();
                    ArrayList<BaseTrap> traps = new ArrayList<BaseTrap>();
                    traps.addAll(TrapDaemon.this.receiver.getTrapCollector().getSNMPv1Traps());
                    traps.addAll(TrapDaemon.this.receiver.getTrapCollector().getSNMPv3Traps());
                    trapDaemonPackage.setCode((byte)103);
                    trapDaemonPackage.setObject(new Boolean(this.trapReceiverState));
                    objectOutputStream.writeObject(trapDaemonPackage);
                    objectOutputStream.reset();
                    try {
                        String script = new File(".").getCanonicalPath() + System.getProperty("file.separator") + WrapperManager.getProperties().getProperty("wrapper.name");
                        trapDaemonPackage.setCode((byte)102);
                        trapDaemonPackage.setObject(script);
                        objectOutputStream.writeObject(trapDaemonPackage);
                        objectOutputStream.reset();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    trapDaemonPackage.setCode((byte)101);
                    trapDaemonPackage.setObject(WrapperManager.getProperties());
                    objectOutputStream.writeObject(trapDaemonPackage);
                    objectOutputStream.reset();
                    if (traps.size() != 0) {
                        trapDaemonPackage.setCode((byte)100);
                        for (int i2 = 0; i2 < traps.size(); ++i2) {
                            trapDaemonPackage.setObject(traps.get(i2));
                            objectOutputStream.writeObject(trapDaemonPackage);
                            objectOutputStream.reset();
                        }
                    }
                    this.sockets.add(objectOutputStream);
                }
                for (ObjectOutputStream objectOutputStream : this.sockets) {
                    objectOutputStream.close();
                }
                serverSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }

        @Override
        public void update(Observable o, Object obj) {
            for (ObjectOutputStream objectOutputStream : this.sockets) {
                try {
                    objectOutputStream.writeObject(obj);
                    objectOutputStream.reset();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }

        public void close() {
            this.acceptLoop = false;
        }

        public void setTrapReceiverState(boolean trapReceiverState) {
            this.trapReceiverState = trapReceiverState;
        }
    }
}

