/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.ByteUtility;
import IPMIView20.ConfigAccessor;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.algo.AES_CBC_128;
import IPMIView20.trap.Consumer;
import IPMIView20.trap.EmailDialog;
import IPMIView20.trap.Storage;
import IPMIView20.trap.TrapEmailSetting;
import IPMIView20.trap.TrapViewFrame;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class TrapEmail {
    TrapViewFrame trapViewFrame;
    Storage storage;
    Consumer consumer;
    EmailDialog emailDialog = new EmailDialog();
    public TrapEmailSetting setting = new TrapEmailSetting();

    public TrapEmail(TrapViewFrame trapViewFrame) {
        this.trapViewFrame = trapViewFrame;
        this.storage = new Storage();
        this.consumer = new Consumer(this.storage, this);
        this.consumer.start();
        this.load();
    }

    public void save() {
        String propertyFolder = IPMIView20.propertyFolder;
        if (propertyFolder.length() == 0) {
            propertyFolder = ".";
        }
        ConfigAccessor config = ConfigAccessor.getInstance(propertyFolder, "email.properties");
        config.setProperty("smtp", this.setting.smtpServer);
        config.setProperty("from", this.setting.from);
        config.setProperty("to", this.setting.to);
        config.setProperty("username", this.setting.username);
        config.setProperty("password", this.encrypt(this.setting.password));
        config.setProperty("enable", this.setting.isEmail ? "1" : "0");
        config.setProperty("authentication", this.setting.isAuthentication ? "1" : "0");
    }

    public void load() {
        String propertyFolder = IPMIView20.propertyFolder;
        if (propertyFolder.length() == 0) {
            propertyFolder = ".";
        }
        ConfigAccessor config = ConfigAccessor.getInstance(propertyFolder, "email.properties");
        this.setting.smtpServer = config.getProperty("smtp");
        this.setting.from = config.getProperty("from");
        this.setting.to = config.getProperty("to");
        this.setting.username = config.getProperty("username");
        this.setting.password = this.decrypt(config.getProperty("password"));
        String isEmail = config.getProperty("enable");
        String isAuthentication = config.getProperty("authentication");
        this.setting.isEmail = "1".equals(isEmail);
        this.setting.isAuthentication = "1".equals(isAuthentication);
    }

    public String encrypt(String str) {
        if (str == null) {
            return null;
        }
        AES_CBC_128 aes = new AES_CBC_128();
        byte[] key = new byte[]{83, 85, 80, 69, 82, 77, 73, 67, 82, 79, 1, 2, 3, 4, 5, 6};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] input = new byte[str.getBytes().length + (16 - str.getBytes().length % 16)];
        System.arraycopy(str.getBytes(), 0, input, 0, str.getBytes().length);
        byte[] encryptedBytes = aes.encrypt(iv, key, input);
        return ByteUtility.bytesToHexNoSpace(encryptedBytes);
    }

    public String decrypt(String str) {
        if (str == null) {
            return null;
        }
        AES_CBC_128 aes = new AES_CBC_128();
        byte[] key = new byte[]{83, 85, 80, 69, 82, 77, 73, 67, 82, 79, 1, 2, 3, 4, 5, 6};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] binArray = ByteUtility.toBinArray(str);
        byte[] decryptedByte = aes.decrypt(iv, key, binArray);
        if (decryptedByte == null) {
            return "";
        }
        return new String(decryptedByte).trim();
    }

    public static void main(String[] args) {
        TrapEmail email = new TrapEmail(null);
        String en = email.encrypt("1234567890");
        String de = email.decrypt(en);
        System.out.println("en =" + en);
        System.out.println("de =" + de);
    }

    public void start() {
    }

    public void stop() {
    }

    public void sendToQueue(BaseTrap trap) {
        if (this.setting.isEmail) {
            this.storage.put(trap);
        }
    }

    public static void main_(String[] args) {
        TrapEmail te = new TrapEmail(null);
        te.load();
    }

    public void showDialog2() {
        this.emailDialog.jIsEmailCheckBox.setSelected(this.setting.isEmail);
        this.emailDialog.jSMTPTextField.setText(this.setting.smtpServer);
        this.emailDialog.jFromTextField.setText(this.setting.from);
        this.emailDialog.jToTextField.setText(this.setting.to);
        this.emailDialog.jIsAuthenticationCheckBox.setSelected(this.setting.isAuthentication);
        this.emailDialog.jUsernameTextField.setText(this.setting.username);
        this.emailDialog.jPasswordField.setText(this.setting.password);
        Object[] message = new Object[]{this.emailDialog.mainPanel};
        boolean flag = true;
        while (flag) {
            int result = JOptionPane.showOptionDialog(this.trapViewFrame, message, L.t("trap.email.Email_Alert"), 2, -1, null, null, null);
            if (result == 0) {
                boolean result2 = this.emailDialog.check();
                if (!result2) continue;
                this.setting.isEmail = this.emailDialog.jIsEmailCheckBox.isSelected();
                this.setting.smtpServer = this.emailDialog.jSMTPTextField.getText();
                this.setting.from = this.emailDialog.jFromTextField.getText();
                this.setting.to = this.emailDialog.jToTextField.getText();
                this.setting.isAuthentication = this.emailDialog.jIsAuthenticationCheckBox.isSelected();
                this.setting.username = this.emailDialog.jUsernameTextField.getText();
                this.setting.password = new String(this.emailDialog.jPasswordField.getPassword());
                this.save();
                flag = false;
                continue;
            }
            flag = false;
        }
    }

    public void showDialog() {
        JCheckBox isEmail = new JCheckBox("Email Alert");
        JCheckBox isAuthentication = new JCheckBox("Authentication");
        JTextField smtpServer = new JTextField(20);
        JTextField from = new JTextField(20);
        JTextField to = new JTextField(20);
        JTextField username = new JTextField(20);
        JPasswordField password = new JPasswordField(20);
        JButton test = new JButton("Test");
        JLabel testLabel = new JLabel();
        JPanel p0 = new JPanel();
        p0.setLayout(new FlowLayout(0));
        p0.add(isEmail);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        p1.add(new JLabel("SMTP Server:"));
        p1.add(smtpServer);
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(1, 2));
        p2.add(new JLabel("From:"));
        p2.add(from);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(1, 2));
        p3.add(new JLabel("To:"));
        p3.add(to);
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(0));
        p4.add(isAuthentication);
        JPanel p5 = new JPanel();
        p5.setLayout(new GridLayout(1, 2));
        p5.add(new JLabel("Username:"));
        p5.add(username);
        JPanel p6 = new JPanel();
        p6.setLayout(new GridLayout(1, 2));
        p6.add(new JLabel("Password:"));
        p6.add(password);
        JPanel p7 = new JPanel();
        p7.setLayout(new FlowLayout(3));
        p7.add(test);
        p7.add(testLabel);
        Object[] message = new Object[]{isEmail, p1, p2, p3, isAuthentication, p5, p6, p7};
        boolean flag = true;
        while (flag) {
            int result = JOptionPane.showOptionDialog(this.trapViewFrame, message, "Email Alert", 2, 1, null, null, null);
            if (result == 0) {
                if (smtpServer.getText().length() == 0 || from.getText().length() == 0 || to.getText().length() == 0) {
                    flag = true;
                    JOptionPane.showMessageDialog(null, "Please input email data");
                    continue;
                }
                flag = false;
                continue;
            }
            flag = false;
        }
    }
}

