/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.trap.FilterCondition;
import IPMIView20.trap.SplashWindow;
import IPMIView20.trap.TableSorter;
import IPMIView20.trap.TrapChart;
import IPMIView20.trap.TrapTree;
import IPMIView20.trap.TrapTreeV3;
import IPMIView20.trap.TrapViewFrame;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.TrapCollector;
import com.supermicro.ipmi.trap.parser.SNMPv1Parser;
import com.supermicro.ipmi.trap.parser.SNMPv3Parser;
import com.supermicro.ipmi.trap.traps.BaseTrap;
import com.supermicro.ipmi.trap.traps.SNMPv1Trap;
import com.supermicro.ipmi.trap.traps.SNMPv3Trap;
import com.supermicro.ipmi.trap.traps.TrapFactory;
import com.supermicro.ipmi.trap.usm.UserTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TrapViewController
implements Observer {
    TrapViewFrame trapViewFrame;
    public Receiver receiver;
    TrapChart trapChart;
    boolean enableShowAlertWindows = true;
    FilterCondition senderCondition;
    FilterCondition communityCondition;
    FilterCondition sensorCondition;
    FilterCondition senderV3Condition;
    FilterCondition usernameCondition;
    FilterCondition sensorTypeCondition;
    FilterCondition sensorNameCondition;
    String fileVersion = "supermicro-trap-v1";
    String fileV3Version = "supermicro-trap-v3";
    List<Vector<Object>> listDecryptedTrapV3;
    List<UserTable> listUserTable;
    SplashWindow sw = null;

    public TrapViewController(TrapViewFrame trapViewFrame) {
        this.trapViewFrame = trapViewFrame;
        this.listDecryptedTrapV3 = new ArrayList<Vector<Object>>();
        this.receiver = new Receiver();
        this.receiver.getTrapCollector().addObserver(this);
        this.initialUI();
    }

    public void initialUI() {
        this.receiver.getTrapCollector().clear();
        IPMIView20 instance = IPMIView20.getInstance();
        if (null != instance) {
            instance.toolbar.clearTrapButton();
            instance.toolbar.setTrapButtonStatus();
        }
        this.initialTable();
        this.initialFilterTree();
        this.initialTrapTree();
        this.initialTableFilterCondition();
    }

    public void clearTrapCollector() {
        this.receiver.getTrapCollector().clear();
    }

    public int getTrapCollectorSize() {
        return this.receiver.getTrapCollector().getTotalTraps();
    }

    public boolean startReceiver() {
        return this.receiver.startReceiver();
    }

    public void stopreceiver() {
        this.receiver.stopReceiver();
    }

    public void cancelFilter() {
        TableSorter tsV1 = (TableSorter)this.trapViewFrame.jTrapV1Table.getModel();
        TableSorter tsV3 = (TableSorter)this.trapViewFrame.jTrapV3Table.getModel();
        tsV1.cancelFilter();
        tsV3.cancelFilter();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BaseTrap) {
            this.updateTable((TrapCollector)o, (BaseTrap)arg);
            this.updateTree((TrapCollector)o, (BaseTrap)arg);
            if (!this.trapViewFrame.isLoading) {
                this.updateStatusBar((TrapCollector)o, (BaseTrap)arg);
                this.updateInfoDialog((TrapCollector)o, (BaseTrap)arg);
                this.trapViewFrame.trapEmail.sendToQueue((BaseTrap)arg);
            }
        }
    }

    public void initialTable() {
        Object[] columnsV1 = new Object[]{L.t("trap.control.Num"), L.t("trap.control.Sender"), L.t("trap.control.Community"), L.t("trap.control.Sensor"), L.t("trap.control.Description"), L.t("trap.control.LocalTimeStamp")};
        DefaultTableModel dtmV1 = new DefaultTableModel(columnsV1, 0);
        TableSorter tsV1 = new TableSorter(dtmV1);
        this.trapViewFrame.jTrapV1Table.setModel(tsV1);
        tsV1.setTableHeader(this.trapViewFrame.jTrapV1Table.getTableHeader());
        this.trapViewFrame.jTrapV1Table.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.trapViewFrame.jTrapV1Table.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.trapViewFrame.jTrapV1Table.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.trapViewFrame.jTrapV1Table.getColumnModel().getColumn(3).setPreferredWidth(10);
        Object[] columnsV3 = new Object[]{L.t("trap.control.Num"), L.t("trap.control.Sender"), L.t("trap.control.LocalTimeStamp"), L.t("trap.control.Username"), L.t("trap.control.SensorType"), L.t("trap.control.SensorName"), L.t("trap.control.Description")};
        DefaultTableModel dtmV3 = new DefaultTableModel(columnsV3, 0);
        TableSorter tsV3 = new TableSorter(dtmV3);
        this.trapViewFrame.jTrapV3Table.setModel(tsV3);
        tsV3.setTableHeader(this.trapViewFrame.jTrapV3Table.getTableHeader());
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(3).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(4).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(5).setPreferredWidth(10);
        this.trapViewFrame.jTrapV3Table.getColumnModel().getColumn(6).setPreferredWidth(10);
    }

    public void initialTableFilterCondition() {
        this.initialSNMPv1TableFilterCondition();
        this.initialSNMPv3TableFilterCondition();
    }

    private void initialSNMPv1TableFilterCondition() {
        this.senderCondition = new FilterCondition();
        this.communityCondition = new FilterCondition();
        this.sensorCondition = new FilterCondition();
        this.senderCondition.filterOperator = 0;
        this.communityCondition.filterOperator = 0;
        this.sensorCondition.filterOperator = 0;
        this.senderCondition.filterColumnIndex = 1;
        this.communityCondition.filterColumnIndex = 2;
        this.sensorCondition.filterColumnIndex = 3;
        this.senderCondition.filterValue = "*";
        this.communityCondition.filterValue = "*";
        this.sensorCondition.filterValue = "*";
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).addFilterCondition(this.senderCondition);
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).addFilterCondition(this.communityCondition);
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).addFilterCondition(this.sensorCondition);
    }

    private void initialSNMPv3TableFilterCondition() {
        this.senderV3Condition = new FilterCondition();
        this.usernameCondition = new FilterCondition();
        this.sensorTypeCondition = new FilterCondition();
        this.sensorNameCondition = new FilterCondition();
        this.senderV3Condition.filterOperator = 0;
        this.usernameCondition.filterOperator = 0;
        this.sensorTypeCondition.filterOperator = 0;
        this.sensorNameCondition.filterOperator = 0;
        this.senderV3Condition.filterColumnIndex = 1;
        this.usernameCondition.filterColumnIndex = 3;
        this.sensorTypeCondition.filterColumnIndex = 4;
        this.sensorNameCondition.filterColumnIndex = 5;
        this.senderV3Condition.filterValue = "*";
        this.usernameCondition.filterValue = "*";
        this.sensorTypeCondition.filterValue = "*";
        this.sensorNameCondition.filterValue = "*";
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).addFilterCondition(this.senderV3Condition);
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).addFilterCondition(this.usernameCondition);
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).addFilterCondition(this.sensorTypeCondition);
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).addFilterCondition(this.sensorNameCondition);
    }

    public void setSenderCondition(Object o) {
        this.senderCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void setCommunityCondition(Object o) {
        this.communityCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void setSensorCondition(Object o) {
        this.sensorCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void setSenderV3Condition(Object o, int type) {
        if (type == 0) {
            this.senderV3Condition.filterValue = o;
        } else if (type == 1) {
            this.usernameCondition.filterValue = o;
        } else if (type == 2) {
            this.sensorTypeCondition.filterValue = o;
        } else if (type == 3) {
            this.sensorNameCondition.filterValue = o;
        }
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).filter();
        this.updateV3FilterConditionMessage();
    }

    public void updateFilterConditionMessage() {
        String message = "";
        message = message + L.t("trap.control.Sender") + " = " + this.senderCondition.filterValue;
        message = message + " , " + L.t("trap.control.Community") + " = " + this.communityCondition.filterValue;
        message = message + " , " + L.t("trap.control.Sensor") + " = " + this.sensorCondition.filterValue;
        this.trapViewFrame.jFilterLabel.setText(message);
    }

    public void updateV3FilterConditionMessage() {
        String message = "";
        message = message + L.t("trap.control.Sender") + " = " + this.senderV3Condition.filterValue;
        message = message + " , " + L.t("trap.control.Username") + " = " + this.usernameCondition.filterValue;
        message = message + " , " + L.t("trap.control.SensorType") + " = " + this.sensorTypeCondition.filterValue;
        message = message + " , " + L.t("trap.control.SensorName") + " = " + this.sensorNameCondition.filterValue;
        this.trapViewFrame.jFilterLabel.setText(message);
    }

    public void resetFilterConditionMessage() {
        this.trapViewFrame.jFilterLabel.setText("");
    }

    public void updateTable(TrapCollector trapCollector, BaseTrap baseTrap) {
        if (baseTrap.getTrapType() == 0) {
            SNMPv1Trap trapV1 = (SNMPv1Trap)baseTrap;
            Object[] row = new Object[]{trapCollector.getTrapV1Count(), trapV1.getIp(), trapV1.getCommunity(), trapV1.getSensor(), trapV1.getDescription(), trapV1.getTime()};
            TableSorter ts = (TableSorter)this.trapViewFrame.jTrapV1Table.getModel();
            DefaultTableModel dtm = (DefaultTableModel)ts.getTableModel();
            dtm.addRow(row);
            ((TableSorter)this.trapViewFrame.jTrapV1Table.getModel()).filter();
        } else if (baseTrap.getTrapType() == 1) {
            this.decodeSNMPv3Trap(true);
        }
        this.trapViewFrame.jclear2Button.setEnabled(true);
        this.trapViewFrame.jSaveButton.setEnabled(true);
    }

    public void decoder(SNMPv3Parser parser, SNMPv3Trap trapV3, DefaultTableModel dtm) {
        int errorType = 0;
        String userName = null;
        String sensorType = null;
        String sensorName = null;
        String description = null;
        Object timeStamp = null;
        for (int userIndex = 0; userIndex < this.listUserTable.size(); ++userIndex) {
            int authEnum;
            parser.setup();
            if (!parser.isUsernameMatch(trapV3, this.listUserTable.get(userIndex).getName())) {
                if (errorType > 0) continue;
                description = L.t("trap.control.Username_Mismatch");
                continue;
            }
            userName = this.listUserTable.get(userIndex).getName();
            String authProtocol = this.listUserTable.get(userIndex).getAuthProtocol().getProtocol();
            int n = authEnum = authProtocol.contentEquals("MD5") ? 0 : 1;
            if (!parser.isAuthenticated(trapV3, this.listUserTable.get(userIndex).getAuthPassword().getBytes(), authEnum)) {
                if (errorType > 1) continue;
                errorType = 1;
                description = L.t("trap.control.Authentication_Failed");
                continue;
            }
            String privProtocol = this.listUserTable.get(userIndex).getPrivProtocol().getProtocol();
            int privEnum = privProtocol.contentEquals("DES") ? 0 : 1;
            byte[] decryptedPDU = parser.decrypt(trapV3, this.listUserTable.get(userIndex).getPrivPassword().getBytes(), privEnum, authEnum);
            if (null == decryptedPDU && errorType <= 2) {
                errorType = 2;
                description = L.t("trap.control.Decryption_Failed");
                continue;
            }
            if (decryptedPDU != null && parser.loadPDU(trapV3, decryptedPDU)) {
                sensorType = trapV3.getSelSensorType();
                sensorName = trapV3.getSelSensorName();
                description = trapV3.getSelDescription();
            } else if (decryptedPDU == null || errorType <= 3) {
                errorType = 3;
                description = L.t("trap.control.Decryption_Failed");
            }
            if (parser.isLoadSuccessful()) break;
        }
        if (this.listUserTable.size() == 0) {
            description = L.t("trap.control.Setting_File_Is_Empty");
        }
        Vector<Object> rowVector = new Vector<Object>();
        rowVector.add(trapV3.getNum());
        rowVector.add(trapV3.getTrapSourceIP());
        rowVector.add(timeStamp);
        rowVector.add(userName);
        rowVector.add(sensorType);
        rowVector.add(sensorName);
        rowVector.add(description);
        dtm.addRow(rowVector);
        ((TableSorter)this.trapViewFrame.jTrapV3Table.getModel()).filter();
        this.listDecryptedTrapV3.add(rowVector);
    }

    public void decodeSNMPv3Trap(boolean isObserveCall) {
        if (this.receiver != null && this.receiver.getTrapCollector() != null && this.receiver.getTrapCollector().getSNMPv3Traps() != null) {
            ArrayList<SNMPv3Trap> listSNMPv3Trap = this.receiver.getTrapCollector().getSNMPv3Traps();
            SNMPv3Parser parser = new SNMPv3Parser();
            TableSorter tableSorter = (TableSorter)this.trapViewFrame.jTrapV3Table.getModel();
            DefaultTableModel defaultTableModel = (DefaultTableModel)tableSorter.getTableModel();
            if (isObserveCall) {
                if (listSNMPv3Trap != null && listSNMPv3Trap.size() > 0) {
                    this.decoder(parser, listSNMPv3Trap.get(listSNMPv3Trap.size() - 1), defaultTableModel);
                }
            } else {
                defaultTableModel.setRowCount(0);
                this.listDecryptedTrapV3.clear();
                for (int index = 0; index < listSNMPv3Trap.size(); ++index) {
                    this.decoder(parser, listSNMPv3Trap.get(index), defaultTableModel);
                }
            }
        }
    }

    public void initialFilterTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        DefaultMutableTreeNode rootNodeV3 = new DefaultMutableTreeNode(L.t("trap.control.All"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        DefaultTreeModel treeModelV3 = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jSenderTree.setModel(treeModel);
        this.trapViewFrame.jSenderTree.setSelectionPath(new TreePath(rootNode));
        rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jCommunityTree.setModel(treeModel);
        this.trapViewFrame.jCommunityTree.setSelectionPath(new TreePath(rootNode));
        rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jSensorTree.setModel(treeModel);
        this.trapViewFrame.jSensorTree.setSelectionPath(new TreePath(rootNode));
        rootNodeV3 = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModelV3 = new DefaultTreeModel(rootNodeV3);
        this.trapViewFrame.jTreeSenderV3.setModel(treeModelV3);
        this.trapViewFrame.jTreeSenderV3.setSelectionPath(new TreePath(rootNodeV3));
        rootNodeV3 = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModelV3 = new DefaultTreeModel(rootNodeV3);
        this.trapViewFrame.jTreeUsername.setModel(treeModelV3);
        this.trapViewFrame.jTreeUsername.setSelectionPath(new TreePath(rootNodeV3));
        rootNodeV3 = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModelV3 = new DefaultTreeModel(rootNodeV3);
        this.trapViewFrame.jTreeSensorType.setModel(treeModelV3);
        this.trapViewFrame.jTreeSensorType.setSelectionPath(new TreePath(rootNodeV3));
        rootNodeV3 = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModelV3 = new DefaultTreeModel(rootNodeV3);
        this.trapViewFrame.jTreeSensorName.setModel(treeModelV3);
        this.trapViewFrame.jTreeSensorName.setSelectionPath(new TreePath(rootNodeV3));
    }

    public void initialTrapTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(L.t("trap.control.Trap"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jTrapTree.setModel(treeModel);
        this.trapViewFrame.jTrapTree.setSelectionPath(new TreePath(rootNode));
    }

    public void updateUserTable(List<UserTable> listUserTable) {
        this.listUserTable = listUserTable;
    }

    public void updateTree(TrapCollector trapCollector, BaseTrap baseTrap) {
        if (baseTrap.getTrapType() == 0) {
            this.updateV1Tree(trapCollector, TrapFactory.getSNMPv1Trap(baseTrap));
        } else if (baseTrap.getTrapType() == 1) {
            this.updateV3Tree(trapCollector, TrapFactory.getSNMPv3Trap(baseTrap));
        }
    }

    public void updateV1Tree(TrapCollector trapCollector, SNMPv1Trap trapV1) {
        TreeNode node;
        int i2;
        boolean find = false;
        DefaultTreeModel treeModel = (DefaultTreeModel)this.trapViewFrame.jSenderTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode child = null;
        find = false;
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(trapV1.getIp())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV1.getIp());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jSenderTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jCommunityTree.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(trapV1.getCommunity())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV1.getCommunity());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jCommunityTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jSensorTree.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(trapV1.getSensor())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV1.getSensor());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jSensorTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
    }

    public void updateV3Tree(TrapCollector trapCollector, SNMPv3Trap trapV3) {
        TreeNode node;
        int i2;
        boolean find = false;
        DefaultTreeModel treeModel = (DefaultTreeModel)this.trapViewFrame.jTreeSenderV3.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode child = null;
        find = false;
        for (int i3 = 0; i3 < root.getChildCount(); ++i3) {
            TreeNode node2 = root.getChildAt(i3);
            if (!node2.toString().equals(trapV3.getTrapSourceIP())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV3.getTrapSourceIP());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jTreeSenderV3.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jTreeUsername.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        String username = new String(trapV3.getMsgUserName(), StandardCharsets.UTF_8);
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(username)) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(username);
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jTreeUsername.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jTreeSensorType.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(trapV3.getSelSensorType())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV3.getSelSensorType());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jTreeSensorType.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jTreeSensorName.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i2 = 0; i2 < root.getChildCount(); ++i2) {
            node = root.getChildAt(i2);
            if (!node.toString().equals(trapV3.getSelSensorName())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trapV3.getSelSensorName());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jTreeSensorName.scrollPathToVisible(new TreePath(child.getPath()));
        }
    }

    public void showTrapTree(int type, int index) {
        BaseTrap baseTrap = null;
        if (type == 0) {
            baseTrap = this.receiver.getTrapCollector().getSNMPv1Traps().get(index);
        } else if (type == 1) {
            baseTrap = this.receiver.getTrapCollector().getSNMPv3Traps().get(index);
        }
        if (baseTrap != null) {
            this.showTrapTree(baseTrap);
        }
    }

    public void clearTrapTree() {
        DefaultTreeModel model = (DefaultTreeModel)this.trapViewFrame.jTrapTree.getModel();
        if (null != model) {
            model.setRoot(null);
            model.reload();
        }
    }

    public List<Vector<Object>> getCacheList() {
        return this.listDecryptedTrapV3;
    }

    public void clearCacheList() {
        this.listDecryptedTrapV3.clear();
    }

    private void showTrapTree(BaseTrap baseTrap) {
        block4: {
            block3: {
                if (0 != baseTrap.getTrapType()) break block3;
                SNMPv1Trap trapV1 = TrapFactory.getSNMPv1Trap(baseTrap);
                if (trapV1.getUiObject1() == null) {
                    TrapTree tt = new TrapTree();
                    tt.decodeTrap(trapV1.getDataBuff(), trapV1.getDataLength());
                    trapV1.setUiObject1(tt);
                }
                ((DefaultTreeModel)this.trapViewFrame.jTrapTree.getModel()).setRoot(((TrapTree)trapV1.getUiObject1()).rootNode);
                for (int i2 = 0; i2 < this.trapViewFrame.jTrapTree.getRowCount(); ++i2) {
                    this.trapViewFrame.jTrapTree.expandRow(i2);
                }
                break block4;
            }
            if (1 != baseTrap.getTrapType()) break block4;
            SNMPv3Trap trapV3 = TrapFactory.getSNMPv3Trap(baseTrap);
            TrapTreeV3 trapTreeV3 = new TrapTreeV3();
            trapTreeV3.loadTrapTree(trapV3);
            ((DefaultTreeModel)this.trapViewFrame.jTrapTree.getModel()).setRoot(trapTreeV3.getRootNode());
            for (int i3 = 0; i3 < this.trapViewFrame.jTrapTree.getRowCount(); ++i3) {
                this.trapViewFrame.jTrapTree.expandRow(i3);
            }
        }
    }

    public boolean save(String filename, boolean isTrapV1) {
        File f2 = new File(filename);
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(f2);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        dos = new DataOutputStream(fos);
        try {
            if (isTrapV1) {
                dos.writeBytes(this.fileVersion);
                for (int i2 = 0; i2 < this.receiver.getTrapCollector().getTrapV1Count(); ++i2) {
                    SNMPv1Trap trapV1 = this.receiver.getTrapCollector().getSNMPv1Traps().get(i2);
                    dos.writeByte(trapV1.getDataLength());
                    dos.write(trapV1.getDataBuff(), 0, trapV1.getDataLength());
                }
            } else {
                dos.writeBytes(this.fileV3Version);
                for (int i3 = 0; i3 < this.receiver.getTrapCollector().getTrapV3Count(); ++i3) {
                    SNMPv3Trap trapV3 = this.receiver.getTrapCollector().getSNMPv3Traps().get(i3);
                    dos.writeInt(trapV3.getNum());
                    dos.writeByte(trapV3.getTrapSourceIP().length());
                    dos.write(trapV3.getTrapSourceIP().getBytes(), 0, trapV3.getTrapSourceIP().length());
                    dos.writeInt(trapV3.getWholeMsgLength());
                    dos.write(trapV3.getMsgWholeMsg(), 0, trapV3.getWholeMsgLength());
                }
            }
            dos.close();
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public int load(String filename) {
        File f2 = new File(filename);
        FileInputStream fis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(f2);
        }
        catch (FileNotFoundException ex) {
            return -1;
        }
        dis = new DataInputStream(fis);
        int length = 0;
        int fileType = 0;
        byte[] buff = null;
        boolean eof = false;
        byte[] fileVersionBytes = new byte[this.fileVersion.length()];
        try {
            dis.read(fileVersionBytes);
        }
        catch (IOException ex1) {
            this.trapViewFrame.statusBar.setText(L.t("trap.control.file_error"));
            try {
                fis.close();
                dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
        }
        boolean isSNMPv1 = this.fileVersion.equals(new String(fileVersionBytes));
        boolean isSNMPv3 = this.fileV3Version.equals(new String(fileVersionBytes));
        if (!isSNMPv1 && !isSNMPv3) {
            this.trapViewFrame.statusBar.setText(L.t("trap.control.file") + " \"" + filename + "\" " + L.t("trap.control.format_error"));
            try {
                fis.close();
                dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
        }
        do {
            try {
                if (isSNMPv1) {
                    length = dis.readByte() & 0xFF;
                    buff = new byte[length];
                    int readCount = dis.read(buff);
                    if (readCount <= 0) continue;
                    SNMPv1Parser parserV1 = new SNMPv1Parser();
                    BaseTrap baseTrap = parserV1.decode(buff, length);
                    this.receiver.getTrapCollector().put(null, baseTrap);
                    fileType = 0;
                    continue;
                }
                if (!isSNMPv3) continue;
                int num = dis.readInt();
                byte addrLength = dis.readByte();
                byte[] addrBytes = new byte[addrLength];
                int readCount = dis.read(addrBytes);
                String addrString = null;
                if (readCount > 0) {
                    addrString = new String(addrBytes, StandardCharsets.UTF_8);
                }
                length = dis.readInt();
                buff = new byte[length];
                readCount = dis.read(buff);
                SNMPv3Parser parserV3 = new SNMPv3Parser();
                BaseTrap baseTrap = null;
                if (readCount > 0) {
                    baseTrap = parserV3.decode(buff, length);
                }
                if (baseTrap != null) {
                    baseTrap.setNum(num);
                    baseTrap.setTrapSourceIP(addrString);
                    this.receiver.getTrapCollector().setSNMPv3Traps(TrapFactory.getSNMPv3Trap(baseTrap));
                    this.updateTable(this.receiver.getTrapCollector(), baseTrap);
                    this.updateTree(this.receiver.getTrapCollector(), baseTrap);
                    fileType = 1;
                    continue;
                }
                fileType = -1;
            }
            catch (Exception ex2) {
                eof = true;
            }
        } while (!eof);
        try {
            fis.close();
            dis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileType;
    }

    public void updateStatusBar(TrapCollector o, BaseTrap baseTrap) {
        String msg = null;
        if (baseTrap.getTrapType() == 0) {
            SNMPv1Trap trap = (SNMPv1Trap)baseTrap;
            msg = L.t("trap.control.sender") + " IP =" + trap.getIp() + ", " + L.t("trap.control.content") + " = [ " + trap.getSensor() + " ] " + trap.getDescription();
        } else if (baseTrap.getTrapType() == 1) {
            SNMPv3Trap trap = (SNMPv3Trap)baseTrap;
            msg = L.t("trap.control.sender") + " IP =" + trap.getTrapSourceIP() + ", " + L.t("trap.control.content") + " = [ " + trap.getSelSensorName() + " ] " + trap.getSelDescription();
        }
        this.trapViewFrame.statusBar.setText(L.t("trap.control.a_trap_received") + ": " + msg);
    }

    public void updateInfoDialog(TrapCollector o, BaseTrap baseTrap) {
        String msg3;
        String msg2;
        String msg1;
        BaseTrap trap;
        if (baseTrap.getTrapType() == 0) {
            trap = (SNMPv1Trap)baseTrap;
            msg1 = L.t("trap.control.a_trap_received");
            msg2 = L.t("trap.control.Sender") + ": " + ((SNMPv1Trap)trap).getIp();
            msg3 = L.t("trap.control.content") + ": [ " + ((SNMPv1Trap)trap).getSensor() + " ] " + ((SNMPv1Trap)trap).getDescription();
        } else if (baseTrap.getTrapType() == 1) {
            trap = (SNMPv3Trap)baseTrap;
            msg1 = L.t("trap.control.a_trap_received");
            msg2 = L.t("trap.control.Sender") + ": " + trap.getTrapSourceIP();
            msg3 = L.t("trap.control.content") + ": [ " + (((SNMPv3Trap)trap).getSelSensorName() != null ? ((SNMPv3Trap)trap).getSelSensorName() : "Unknown") + " ] " + (((SNMPv3Trap)trap).getSelDescription() != null ? ((SNMPv3Trap)trap).getSelDescription() : "Unknown");
        } else {
            return;
        }
        String os = System.getProperties().get("os.name").toString();
        if (os.indexOf("Window") == -1) {
            return;
        }
        if (!this.enableShowAlertWindows) {
            return;
        }
        if (this.sw == null) {
            this.sw = new SplashWindow(this.trapViewFrame, msg1, msg2, msg3);
        } else {
            this.sw.setMessage(msg1, msg2, msg3);
        }
        this.sw.repaint();
        this.sw.show();
        this.sw.setWatchDogTime(10);
    }

    public void updateChart() {
    }
}

