/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirectionException;
import com.ami.iusb.SMCUtil;
import com.ami.iusb.protocol.FloppyProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FloppyRedir
extends Thread {
    JViewerApp app;
    private PacketMaster packetMaster;
    private FloppyProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private boolean physicalDevice;
    private String sourceFloppy = null;
    private int nBytesRedirected = 0;
    private static final int PORT = 5123;
    private static final int START_LOCAL_IMAGE_REDIRECTION = 240;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    public static final int AUTH_CMD = 242;
    public static final int TRANSFER_CMD = 243;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int CONNECTION_DENIED = 2;
    private static final int LOGIN_FAILED = 3;
    private static final int CONNECTION_IN_USE = 4;
    private static final int CONNECTION_PERM_DENIED = 5;
    private static final int OTHER_ERROR = 6;
    private static final int MEDIA_IN_DETACH_STATE = 7;
    private static final int MAX_READ_SECTORS = 256;
    private static final int MAX_READ_SIZE = 131072;

    public FloppyRedir(boolean bl, JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.physicalDevice = bl;
        this.protocol = new FloppyProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(131072);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131072);
    }

    private void floppyConnect(String string, int n, boolean bl) throws IOException {
        this.packetMaster = new PacketMaster(string, n, false, this.protocol, bl);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connect();
    }

    private void floppyDisconnect() {
        try {
            this.packetMaster.close();
        }
        catch (IOException iOException) {
            System.err.println(LocaleStrings.GetString("5_2_FLOPPYREDIR") + iOException.getMessage());
        }
    }

    public boolean startRedirection(String string, int n, boolean bl, String string2, String string3) throws RedirectionException {
        block17: {
            if (this.running) {
                return true;
            }
            try {
                this.floppyConnect(string, n, bl);
                this.SendAuth_SessionToken(string2);
                IUSBSCSI iUSBSCSI = this.recvRequest();
                if (iUSBSCSI.opcode == 241) {
                    if (iUSBSCSI.connectionStatus != 1) {
                        this.floppyDisconnect();
                        if (iUSBSCSI.connectionStatus == 5) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_3_FLOPPYREDIR"));
                        } else if (iUSBSCSI.connectionStatus == 7) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_10_FLOPPYREDIR"));
                        } else if (iUSBSCSI.connectionStatus == 3) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_11_FLOPPYREDIR"));
                        } else if (iUSBSCSI.m_otherIP != null) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_4_FLOPPYREDIR") + iUSBSCSI.m_otherIP);
                        } else {
                            this.app.generalErrorMessage(LocaleStrings.GetString("5_5_FLOPPYREDIR"));
                        }
                        return false;
                    }
                    break block17;
                }
                this.floppyDisconnect();
                throw new RedirectionException(LocaleStrings.GetString("5_6_FLOPPYREDIR") + iUSBSCSI.opcode);
            }
            catch (IOException iOException) {
                throw new RedirectionException(iOException.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(this.physicalDevice);
        }
        this.sourceFloppy = string3;
        try {
            if (!this.openFloppy(string3.getBytes("UTF-8"))) {
                this.app.generalErrorMessage(LocaleStrings.GetString("5_7_FLOPPYREDIR"));
                this.deleteFloppyReader();
                this.floppyDisconnect();
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Path UTF-8 encoding error!");
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            try {
                this.packetMaster.wakeup();
                this.redirThread.join();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(LocaleStrings.GetString("5_8_FLOPPYREDIR"));
            }
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.floppyDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeFloppy();
            this.deleteFloppyReader();
            this.app.reportFloppyAbnormal();
        }
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket(true);
    }

    public boolean isRedirActive() {
        return this.running;
    }

    @Override
    public void run() {
        int n = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI iUSBSCSI = this.recvRequest();
                if (iUSBSCSI == null) continue;
                int n2 = this.executeFloppySCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(n2);
                IUSBSCSI iUSBSCSI2 = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(iUSBSCSI2);
                this.nBytesRedirected += (n += n2) / 1024;
                n %= 1024;
            }
            catch (IOException iOException) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(iOException.getMessage());
                return;
            }
            catch (RedirectionException redirectionException) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(redirectionException.getMessage());
                return;
            }
        }
    }

    public String[] getFloppyList() {
        if (!this.physicalDevice) {
            this.DisplayErrorMsg(LocaleStrings.GetString("5_9_FLOPPYREDIR"));
            return null;
        }
        String[] stringArray = null;
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(true);
            stringArray = this.listFloppyDrives();
            this.deleteFloppyReader();
        }
        return stringArray;
    }

    public String getLIBFLOPPYVersion() {
        String string;
        if (this.nativeReaderPointer == -1L) {
            this.newFloppyReader(false);
            string = this.getVersion();
            this.deleteFloppyReader();
        } else {
            string = this.getVersion();
        }
        return string;
    }

    public void DisplayErrorMsg(String string) {
        this.app.generalErrorMessage(string);
    }

    public void handleError(String string) {
        this.DisplayErrorMsg(string);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDevice;
    }

    public String getSourceDrive() {
        return this.sourceFloppy;
    }

    public void SendAuth_SessionToken(String string) throws RedirectionException, IOException {
        int n = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader iUSBHeader = IUSBHeader.createCDROMHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(string.getBytes());
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public void sendTransferCmd() throws RedirectionException, IOException {
        int n = 30;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(62);
        IUSBHeader iUSBHeader = IUSBHeader.createCDROMHeader(n);
        iUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-13);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.position(0);
        IUSBSCSI iUSBSCSI = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(iUSBSCSI);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    public byte ReadKeybdLEDStatus() {
        return this.GetLEDStatus();
    }

    private native String[] listFloppyDrives();

    private native void newFloppyReader(boolean var1);

    private native void deleteFloppyReader();

    private native boolean openFloppy(byte[] var1);

    private native void closeFloppy();

    private native int executeFloppySCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    private native byte GetLEDStatus();

    static {
        String string = System.getProperty("os.name");
        String string2 = "";
        String string3 = "";
        string2 = System.getProperty("os.arch").indexOf("64") != -1 ? "64" : "32";
        string3 = string.startsWith("Windows") ? "javafloppywrapper" + string2 + ".dll" : "libjavafloppywrapper" + string2 + ".so";
        File file = new File(string3);
        if (file.exists()) {
            try {
                System.loadLibrary("javafloppywrapper" + string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(LocaleStrings.GetString("5_1_FLOPPYREDIR"));
            }
        } else {
            try {
                SMCUtil.loadLib("javafloppywrapper" + string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

