/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.protocol.RedirHeader;
import com.ami.kvm.jviewer.Debug;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class IUSBHeader
extends RedirHeader {
    public String signature;
    public int major;
    public int minor;
    public int packetHeaderLen;
    public int headerChecksum;
    public long dataPacketLen;
    public int serverCaps;
    public int deviceType;
    public int protocol;
    public int direction;
    public int deviceNumber;
    public int interfaceNumber;
    public byte[] clientData = new byte[2];
    public long sequenceNumber;
    public byte[] reserved = new byte[4];
    public static final int HEADER_LEN = 32;
    private static final int IUSB_MAJOR = 1;
    private static final int IUSB_MINOR = 0;

    public IUSBHeader() {
        this.headerLen = 32;
    }

    public static IUSBHeader createKeyboardHeader(int n) {
        IUSBHeader iUSBHeader = new IUSBHeader();
        iUSBHeader.signature = "IUSB    ";
        iUSBHeader.packetHeaderLen = 32;
        iUSBHeader.major = 1;
        iUSBHeader.minor = 0;
        iUSBHeader.sequenceNumber = 0L;
        iUSBHeader.direction = 128;
        iUSBHeader.dataPacketLen = n;
        iUSBHeader.deviceType = 48;
        iUSBHeader.deviceNumber = 2;
        iUSBHeader.interfaceNumber = 0;
        iUSBHeader.protocol = 16;
        return iUSBHeader;
    }

    public static IUSBHeader createMouseHeader(int n) {
        IUSBHeader iUSBHeader = new IUSBHeader();
        iUSBHeader.signature = "IUSB    ";
        iUSBHeader.packetHeaderLen = 32;
        iUSBHeader.major = 1;
        iUSBHeader.minor = 0;
        iUSBHeader.sequenceNumber = 0L;
        iUSBHeader.direction = 128;
        iUSBHeader.dataPacketLen = n;
        iUSBHeader.deviceType = 49;
        iUSBHeader.deviceNumber = 2;
        iUSBHeader.interfaceNumber = 1;
        iUSBHeader.protocol = 32;
        return iUSBHeader;
    }

    public static IUSBHeader createCDROMHeader(int n) {
        IUSBHeader iUSBHeader = new IUSBHeader();
        iUSBHeader.signature = "IUSB    ";
        iUSBHeader.packetHeaderLen = 32;
        iUSBHeader.major = 1;
        iUSBHeader.minor = 0;
        iUSBHeader.sequenceNumber = 0L;
        iUSBHeader.direction = 128;
        iUSBHeader.dataPacketLen = n;
        iUSBHeader.deviceType = 5;
        iUSBHeader.deviceNumber = 0;
        iUSBHeader.interfaceNumber = 0;
        iUSBHeader.protocol = 1;
        return iUSBHeader;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws RedirProtocolException, BufferUnderflowException {
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        this.signature = new String(byArray);
        if (!this.signature.equals("IUSB    ")) {
            Debug.out.dump(byArray);
            throw new RedirProtocolException("Invalid header signature");
        }
        this.major = byteBuffer.get() & 0xFF;
        this.minor = byteBuffer.get() & 0xFF;
        this.packetHeaderLen = byteBuffer.get() & 0xFF;
        this.headerChecksum = byteBuffer.get() & 0xFF;
        this.dataPacketLen = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = byteBuffer.get() & 0xFF;
        this.deviceType = byteBuffer.get() & 0xFF;
        this.protocol = byteBuffer.get() & 0xFF;
        this.direction = byteBuffer.get() & 0xFF;
        this.deviceNumber = byteBuffer.get() & 0xFF;
        this.interfaceNumber = byteBuffer.get() & 0xFF;
        byteBuffer.get(this.clientData);
        this.sequenceNumber = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        byteBuffer.get(this.reserved);
    }

    @Override
    public void write(ByteBuffer byteBuffer) {
        byteBuffer.put(this.signature.getBytes());
        byteBuffer.put((byte)(this.major & 0xFF));
        byteBuffer.put((byte)(this.minor & 0xFF));
        byteBuffer.put((byte)(this.packetHeaderLen & 0xFF));
        byteBuffer.put((byte)(this.headerChecksum & 0xFF));
        byteBuffer.putInt((int)(this.dataPacketLen & 0xFFFFFFFFFFFFFFFFL));
        byteBuffer.put((byte)(this.serverCaps & 0xFF));
        byteBuffer.put((byte)(this.deviceType & 0xFF));
        byteBuffer.put((byte)(this.protocol & 0xFF));
        byteBuffer.put((byte)(this.direction & 0xFF));
        byteBuffer.put((byte)(this.deviceNumber & 0xFF));
        byteBuffer.put((byte)(this.interfaceNumber & 0xFF));
        byteBuffer.put(this.clientData);
        byteBuffer.putInt((int)(this.sequenceNumber & 0xFFFFFFFFFFFFFFFFL));
        byteBuffer.put(this.reserved);
        int n = 0;
        for (int k = 0; k < byteBuffer.limit(); ++k) {
            n = n + (byteBuffer.get(k) & 0xFF) & 0xFF;
        }
        byteBuffer.put(11, -((byte)(n & 0xFF)));
    }
}

