/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class Client {
    public static final int RETRY_COUNT = 3;
    public static final int TIMEOUT = 1;
    protected SocketChannel m_sockCh = null;
    protected SocketChannel m_HIDsockCh = null;
    protected byte[] m_ipAddr;
    protected int m_port;
    protected int m_HIDport;
    protected SSLWrapper ssl_wrapper;
    protected SSLWrapper HIDssl_wrapper;

    public Client(byte[] byArray, int n, int n2) {
        this.m_ipAddr = byArray;
        this.m_port = n;
        this.m_HIDport = n2;
        this.ssl_wrapper = null;
        this.HIDssl_wrapper = null;
    }

    public SocketChannel getSockChannel() {
        return this.m_sockCh;
    }

    public SocketChannel getHIDSockChannel() {
        return this.m_HIDsockCh;
    }

    public int connect() throws IOException {
        this.m_sockCh = SocketChannel.open();
        this.m_sockCh.connect(new InetSocketAddress(InetAddress.getByAddress(this.m_ipAddr), this.m_port));
        this.m_sockCh.configureBlocking(false);
        int n = 3;
        while (!this.m_sockCh.finishConnect()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n-- > 0) continue;
            return -1;
        }
        this.m_sockCh.socket().setTcpNoDelay(true);
        this.m_sockCh.socket().setKeepAlive(true);
        return 0;
    }

    public int HIDconnect() throws IOException {
        this.m_HIDsockCh = SocketChannel.open();
        this.m_HIDsockCh.connect(new InetSocketAddress(InetAddress.getByAddress(this.m_ipAddr), this.m_HIDport));
        this.m_HIDsockCh.configureBlocking(false);
        int n = 3;
        while (!this.m_HIDsockCh.finishConnect()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n-- > 0) continue;
            return -1;
        }
        this.m_HIDsockCh.socket().setTcpNoDelay(true);
        this.m_HIDsockCh.socket().setKeepAlive(true);
        return 0;
    }

    public int sendMessage(byte[] byArray, int n) {
        int n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            if (this.ssl_wrapper != null) {
                this.ssl_wrapper.write(byteBuffer);
            } else {
                n2 = this.m_sockCh.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            Debug.out.println("Send message failed");
        }
        return n;
    }

    public int sendHIDMessage(byte[] byArray, int n) {
        int n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            if (this.HIDssl_wrapper != null) {
                this.HIDssl_wrapper.write(byteBuffer);
            } else {
                n2 = this.m_HIDsockCh.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            Debug.out.println("Send message failed");
        }
        return n;
    }

    public void close() {
        try {
            if (this.m_sockCh != null) {
                this.m_sockCh.close();
            }
            if (this.m_HIDsockCh != null) {
                this.m_HIDsockCh.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void onReadEvent();

    public abstract void onHIDReadEvent();

    public abstract boolean IsVideoDataAvailable();

    public abstract boolean IsHIDDataAvailable();
}

