/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.Client;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class NWListener
implements Runnable {
    private Selector m_select = null;
    private boolean m_run = false;
    private Client m_clnt;
    private SelectionKey VideoSelectionKey;
    private SelectionKey HIDSelectionKey;
    static int count = 0;

    public NWListener() {
        try {
            this.m_select = Selector.open();
        }
        catch (IOException iOException) {
            Debug.out.println(iOException);
        }
        this.m_run = true;
    }

    public int addChannels(Client client) {
        try {
            SocketChannel socketChannel = client.getSockChannel();
            SocketChannel socketChannel2 = client.getHIDSockChannel();
            this.VideoSelectionKey = socketChannel.register(this.m_select, 1);
            this.HIDSelectionKey = socketChannel2.register(this.m_select, 1);
            this.m_clnt = client;
        }
        catch (ClosedChannelException closedChannelException) {
            Debug.out.println(closedChannelException);
            return -1;
        }
        return 0;
    }

    public void removeChannels(Client client) {
        this.destroyListener();
        SocketChannel socketChannel = client.getSockChannel();
        SocketChannel socketChannel2 = client.getHIDSockChannel();
        socketChannel.keyFor(this.m_select).cancel();
        socketChannel2.keyFor(this.m_select).cancel();
    }

    public void startListener() {
        this.m_run = true;
    }

    public void destroyListener() {
        this.m_run = false;
        this.m_select.wakeup();
        try {
            this.m_select.selectNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.m_run) {
            if (this.m_clnt.IsVideoDataAvailable()) {
                this.m_clnt.onReadEvent();
                continue;
            }
            if (this.m_clnt.IsHIDDataAvailable()) {
                this.m_clnt.onHIDReadEvent();
                continue;
            }
            try {
                this.m_select.select();
            }
            catch (IOException iOException) {
                Debug.out.println("NW_LISTENER " + iOException);
            }
            if (!this.m_run) continue;
            if (this.VideoSelectionKey.isReadable()) {
                this.m_clnt.onReadEvent();
            }
            if (!this.HIDSelectionKey.isReadable()) continue;
            this.m_clnt.onHIDReadEvent();
        }
    }
}

