/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class ComponentWriter {
    public static final char[] hex = "0123456789ABCDEF".toCharArray();

    public static void testRead(BufferedImage bufferedImage) {
        System.out.println("testRead");
        for (int k = 0; k < 200; ++k) {
            int n = bufferedImage.getRGB(200, k);
            byte[] byArray = new byte[4];
            ComponentWriter.intTo4Bytes(byArray, 0, n);
            System.out.println(ComponentWriter.bytesToHex(byArray) + ",");
        }
    }

    public static void intTo4Bytes(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 3];
        int n = 0;
        for (int k = 0; k < byArray.length; ++k) {
            cArray[n++] = hex[(byArray[k] & 0xF0) >> 4];
            cArray[n++] = hex[byArray[k] & 0xF];
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    public static BufferedImage captureScreen(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        Object var3_3 = null;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static File writeimage(BufferedImage bufferedImage, File file) throws IOException {
        String string = null;
        try {
            string = ComponentWriter.getSuffix(file);
        }
        catch (IOException iOException) {
            string = "png";
            file = new File(file.getAbsolutePath() + "." + string);
        }
        if (!string.equalsIgnoreCase("jpg") && !string.equalsIgnoreCase("png")) {
            string = "png";
            file = new File(file.getAbsolutePath() + "." + string);
        }
        if (!ImageIO.write((RenderedImage)bufferedImage, string, file)) {
            throw new IOException("No writer for " + file);
        }
        return file;
    }

    public static File write(Component component, File file) throws IOException {
        int n = component.getWidth();
        int n2 = component.getHeight();
        String string = null;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        component.paint(graphics2D);
        graphics2D.dispose();
        try {
            string = ComponentWriter.getSuffix(file);
        }
        catch (IOException iOException) {
            string = "png";
            file = new File(file.getAbsolutePath() + "." + string);
        }
        if (!string.equalsIgnoreCase("jpg") && !string.equalsIgnoreCase("png")) {
            string = "png";
            file = new File(file.getAbsolutePath() + "." + string);
        }
        if (!ImageIO.write((RenderedImage)bufferedImage, string, file)) {
            throw new IOException("No writer for " + file);
        }
        return file;
    }

    public static String getSuffix(File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new IOException("No suffix in file " + file);
        }
        return string.substring(1 + n);
    }

    public static void main(String[] stringArray) throws IOException {
        final JTextArea jTextArea = new JTextArea();
        jTextArea.read(new FileReader(new File("c:\\COMMAND.TXT")), null);
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("write");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ComponentWriter.write(jTextArea, new File("test.png"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
        jToolBar.add(jButton);
        JFrame jFrame = new JFrame("ComponentWriter");
        jFrame.setDefaultCloseOperation(3);
        Container container = jFrame.getContentPane();
        container.add(new JScrollPane(jTextArea));
        container.add((Component)jToolBar, "North");
        jFrame.setSize(400, 300);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

