/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DevicePanel
extends JPanel {
    public static final int DEVICE_TYPE_CDROM = 0;
    public static final int DEVICE_TYPE_FLOPPY = 1;
    private static final int DEFAULT_NUM_DRIVES = 1;
    private ButtonGroup m_deviceButtonGroup;
    private JRadioButton[] m_deviceButtons;
    public JButton m_browseButton;
    private JTextField m_imagePath;
    private int m_deviceType;

    public DevicePanel(String[] stringArray, int n) {
        super(new GridLayout(stringArray != null && stringArray.length > 1 ? stringArray.length + 1 : 2, 1, 0, 0));
        int n2 = stringArray != null ? stringArray.length + 1 : 1;
        this.m_deviceType = n;
        this.m_deviceButtons = new JRadioButton[n2];
        this.m_deviceButtonGroup = new ButtonGroup();
        this.m_deviceButtons[0] = new JRadioButton(n == 0 ? "ISO Image" : "Floppy Image");
        this.m_deviceButtons[0].setBackground(Color.WHITE);
        this.m_deviceButtonGroup.add(this.m_deviceButtons[0]);
        this.m_deviceButtons[0].setSelected(true);
        int n3 = 1;
        int n4 = 0;
        while (n3 < n2) {
            this.m_deviceButtons[n3] = new JRadioButton(stringArray[n4]);
            this.m_deviceButtons[n3].setBackground(Color.WHITE);
            this.m_deviceButtonGroup.add(this.m_deviceButtons[n3]);
            ++n3;
            ++n4;
        }
        JPanel jPanel = new JPanel(new BorderLayout(2, 0));
        jPanel.setBackground(Color.WHITE);
        this.m_imagePath = new JTextField(15);
        this.m_imagePath.setBorder(null);
        this.m_browseButton = new JButton(LocaleStrings.GetString("A_1_DP"));
        jPanel.add((Component)this.m_deviceButtons[0], "West");
        jPanel.add((Component)this.m_imagePath, "Center");
        jPanel.add((Component)this.m_browseButton, "East");
        this.add(jPanel);
        for (n4 = 1; n4 < n2; ++n4) {
            this.add(this.m_deviceButtons[n4]);
        }
        this.setBackground(Color.WHITE);
    }

    public boolean isImageSelected() {
        return this.m_deviceButtons[0].getModel() == this.m_deviceButtonGroup.getSelection();
    }

    public void setImagePath(String string) {
        this.m_imagePath.setText(string);
    }

    public String getImagePath() {
        return this.m_imagePath.getText();
    }

    public String selectedDeviceString() {
        Enumeration<AbstractButton> enumeration = this.m_deviceButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != this.m_deviceButtonGroup.getSelection()) continue;
            return jRadioButton.getText();
        }
        return "";
    }

    public void disableAll() {
        for (int k = 0; k < this.m_deviceButtons.length; ++k) {
            this.m_deviceButtons[k].setEnabled(false);
        }
        this.m_browseButton.setEnabled(false);
        this.m_imagePath.setEnabled(false);
    }

    public void enableAll() {
        for (int k = 0; k < this.m_deviceButtons.length; ++k) {
            this.m_deviceButtons[k].setEnabled(true);
        }
        this.m_browseButton.setEnabled(true);
        this.m_imagePath.setEnabled(true);
    }

    public void SelectRadioButton(String string) {
        JRadioButton jRadioButton;
        Enumeration<AbstractButton> enumeration = this.m_deviceButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().equals(string)) continue;
            jRadioButton.setSelected(true);
            return;
        }
        enumeration = this.m_deviceButtonGroup.getElements();
        if (enumeration.hasMoreElements()) {
            jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setSelected(true);
            this.m_imagePath.setText(string);
        }
    }

    public void SelectRadioButton(int n) {
        if (n >= 0 && n < this.m_deviceButtonGroup.getButtonCount()) {
            Enumeration<AbstractButton> enumeration = this.m_deviceButtonGroup.getElements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                if (n2 == n) {
                    jRadioButton.setSelected(true);
                    return;
                }
                ++n2;
            }
        }
    }
}

