/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerContainer;
import com.ami.kvm.jviewer.gui.JViewerPanel;
import com.ami.kvm.jviewer.gui.JViewerParams;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.WindowFrame;
import com.ami.kvm.jviewer.gui.vMediaDialog;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.USBMouseRep;
import com.ami.kvm.jviewer.video.JVVideo;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.softkeyboard.SoftKeyboardDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class JViewerApp {
    SoftKeyboardDialog softKeyboardDialog;
    private String serverIP;
    private String userID;
    private String password;
    private byte priv;
    public static boolean cmTest = false;
    public static final int FULL_FRAME_MODE = 0;
    public static final int WINDOW_FRAME_MODE = 1;
    public static final int PANEL_MODE = 2;
    private JViewerParams params = new JViewerParams();
    private JFrame m_frame;
    private JViewerContainer jviewerContainer;
    private WindowFrame m_wndFrame;
    private JViewerPanel jViewerPanel;
    private KVMClient m_KVMClnt;
    public JViewerView m_view;
    private FSFrame m_fsFrame;
    private IUSBRedirSession m_IUSBSession;
    public vMediaDialog m_mediaDlg = null;
    private int m_wndMode;
    private boolean panelMode;
    private String m_session_token;
    private boolean m_bUseSSL = false;
    private byte[] m_serverIP;
    private int m_serverPort;
    private int m_HIDPort;
    private int m_cdPort;
    private int m_fdPort;
    public boolean m_FullKeyboard = false;
    private boolean m_bVMUseSSL = false;
    private boolean m_bVideoPaused = false;
    public static boolean showCursor = false;
    private boolean connected = false;
    JVVideo vidClnt = null;
    BufferedImage orgImage = null;
    BufferedImage capImage = null;

    public void createUI() {
        this.m_wndFrame = new WindowFrame(this);
        this.m_fsFrame = new FSFrame(this);
        this.m_IUSBSession = new IUSBRedirSession(this);
        this.jViewerPanel = new JViewerPanel(this);
        this.jviewerContainer = this.m_wndFrame;
        this.m_view = new JViewerView(1024, 768, this);
    }

    public JViewerView getRCView() {
        return this.m_view;
    }

    public KVMClient getKVMClient() {
        return this.m_KVMClnt;
    }

    public JVMenu getJVMenu() {
        if (this.isPanelMode()) {
            return this.jviewerContainer.getMenu();
        }
        return this.jviewerContainer.getMenu();
    }

    public void setFrame(JFrame jFrame) {
        this.m_frame = jFrame;
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public String getSessionToken() {
        if (this.m_session_token == null) {
            try {
                this.m_session_token = this.helpGetKVMSessionToken();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Failed to get session token", "Error", 0);
            }
        }
        return this.m_session_token;
    }

    public void setStatus(String string) {
        this.jviewerContainer.setStatus(string);
    }

    public void resetStatus() {
        this.jviewerContainer.resetStatus();
    }

    public boolean isFullScreenMode() {
        return this.m_wndMode == 0;
    }

    public void setAppWndLabel(String string) {
        try {
            String string2 = this.m_bUseSSL ? "(SSL) " : " ";
            byte by = this.m_view.GetUSBMouseMode();
            this.jviewerContainer.setWndLabel(string2 + " " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAppWndLabelPowerOff() {
        this.jviewerContainer.setWndLabel(" " + LocaleStrings.GetString("D_1_JVAPP"));
    }

    public int getCDPort() {
        return this.m_cdPort;
    }

    public int getFDPort() {
        return this.m_fdPort;
    }

    public boolean isSecureConnection() {
        return this.m_bUseSSL;
    }

    public void helpConnectToServer(String string, String string2, String string3, byte by, int n, int n2, int n3, int n4) throws Exception {
        this.serverIP = string;
        this.userID = string2;
        this.password = string3;
        this.priv = by;
        this.OnConnectToServer(JViewerApp.getServerIP(string), n, n2, null, false, false, n3, n4, 511);
        try {
            byte by2 = this.getMouseMode();
            this.getJVMenu().setMouseMode(by2);
        }
        catch (Exception exception) {
            this.getJVMenu().menuItemMouseModeAbsolute.setEnabled(false);
            this.getJVMenu().menuItemMouseModeRelative.setEnabled(false);
        }
    }

    public void helpConnectToServer(String string, String string2, String string3, byte by) throws Exception {
        this.helpConnectToServer(string, string2, string3, by, 5901, 5900, 5120, 5123);
    }

    public String helpGetKVMSessionToken() throws Exception {
        IPMIInterfaceConfig iPMIInterfaceConfig = new IPMIInterfaceConfig();
        iPMIInterfaceConfig.setIp(this.serverIP);
        iPMIInterfaceConfig.setUserName(this.userID);
        iPMIInterfaceConfig.setPassword(this.password);
        iPMIInterfaceConfig.setPrivilege(this.priv);
        ISessionController iSessionController = IPMIVersion.getSessionController(iPMIInterfaceConfig);
        IPMIAMIOEMCommand iPMIAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface iPMINetworkInterface = iSessionController.startup(iPMIInterfaceConfig);
        if (iPMINetworkInterface == null) {
            throw new Exception("Can't login");
        }
        iPMIAMIOEMCommand.setIPMIInterface(iPMINetworkInterface);
        String string = iPMIAMIOEMCommand.getKVMSessionToken();
        iSessionController.closeSession();
        return string;
    }

    public void OnConnectToServer(byte[] byArray, int n, int n2, String string, boolean bl, boolean bl2, int n3, int n4, int n5) {
        int n6;
        JVMenu jVMenu;
        this.m_serverIP = byArray;
        this.m_serverPort = n;
        this.m_HIDPort = n2;
        this.m_session_token = string;
        if (this.panelMode) {
            this.jViewerPanel.attachView();
            this.m_wndMode = 2;
            this.jviewerContainer = this.jViewerPanel;
            jVMenu = this.jviewerContainer.getMenu();
            jVMenu.notifyFullScreen(false);
        } else {
            this.m_wndFrame.attachView();
            this.m_wndMode = 1;
            this.m_frame = this.m_wndFrame;
            this.jviewerContainer = this.m_wndFrame;
            jVMenu = this.jviewerContainer.getMenu();
            jVMenu.notifyFullScreen(false);
        }
        this.m_bUseSSL = bl;
        this.m_cdPort = n3;
        this.m_fdPort = n4;
        this.m_bVMUseSSL = bl2;
        if (!this.getParams().isKVMEnabled() && (n6 = JOptionPane.showConfirmDialog(this.m_frame, LocaleStrings.GetString("D_20_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0)) == 1) {
            if (!this.panelMode) {
                System.exit(0);
            }
            return;
        }
        if (this.getParams().isKVMUser() && this.getParams().isKVMEnabled()) {
            this.OnVideoStartRedirection();
        } else if (this.getParams().isVMediaUser()) {
            this.OnvMedia();
        }
        this.OnShowCursor(false);
        Debug.out.println("isKVM User " + this.getParams().isKVMUser());
        Debug.out.println("isVMedia User " + this.getParams().isVMediaUser());
    }

    public void OnVideoStartRedirection() {
        Object object;
        Debug.out.println("OnVideoStartRedirection");
        this.vidClnt = new JVVideo(this);
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.m_HIDPort, this.vidClnt, this.m_bUseSSL, this);
        if (-1 == this.m_KVMClnt.startRedirection()) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_2_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            if (!this.panelMode) {
                System.exit(0);
            }
            this.connected = false;
            return;
        }
        JVFrame.setServerIP(this.m_serverIP);
        this.m_view.addKMListeners();
        Debug.out.println("End of OnVideoStartRedirection");
        this.OnVideoRefresh();
        if (this.isPanelMode()) {
            this.jViewerPanel.setConnectedUIStatus();
        }
        this.connected = true;
        if (cmTest) {
            object = new Thread(){

                @Override
                public void run() {
                    JViewerApp.this.cmTest();
                }
            };
            ((Thread)object).start();
        }
        if (this.softKeyboardDialog == null) {
            this.softKeyboardDialog = new SoftKeyboardDialog();
        }
        this.softKeyboardDialog.setKVMClient(this.m_KVMClnt);
        object = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension = this.softKeyboardDialog.getSize();
        if (dimension.height > ((Dimension)object).height) {
            dimension.height = ((Dimension)object).height;
        }
        if (dimension.width > ((Dimension)object).width) {
            dimension.width = ((Dimension)object).width;
        }
        this.softKeyboardDialog.setLocation((((Dimension)object).width - dimension.width) / 2, (((Dimension)object).height - dimension.height) / 2);
    }

    public void cmTest() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_view.sendDVO();
        this.OnVideoRefresh();
        int n = this.testVideoSignal();
        System.exit(n);
    }

    public int testVideoSignal() {
        this.orgImage = null;
        try {
            this.orgImage = ImageIO.read(new File("kvm.bmp"));
        }
        catch (IOException iOException) {
            this.captureScreenToFile();
            return 6;
        }
        this.capImage = this.m_view.GetRedirImage();
        if (this.capImage == null) {
            return 1;
        }
        if (this.orgImage == null) {
            return 2;
        }
        int n = 8;
        int n2 = this.capImage.getWidth();
        int n3 = this.capImage.getHeight();
        int n4 = n2 / n;
        int n5 = n3 / n;
        for (int k = 1; k <= n; ++k) {
            for (int i2 = 1; i2 <= n; ++i2) {
                int n6 = k * n4 - n4 / 2;
                int n7 = i2 * n5 - n5 / 2;
                int n8 = -1;
                int n9 = -1;
                boolean bl = false;
                try {
                    n8 = this.capImage.getRGB(n6, n7);
                    n9 = this.orgImage.getRGB(n6, n7);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                }
                if (!bl && n8 == n9) continue;
                this.captureScreenToFile();
                this.orgImage = null;
                this.capImage = null;
                if (bl) {
                    System.out.println("Resolution don't match");
                    return 7;
                }
                if (n8 == n9) continue;
                System.out.println("Color is different at (" + k + "," + i2 + ")");
                return 5;
            }
        }
        this.orgImage = null;
        this.capImage = null;
        return 0;
    }

    private void captureScreenToFile() {
        BufferedImage bufferedImage = this.m_view.GetRedirImage();
        File file = new File(this.serverIP + "_" + JViewerApp.getSystemDateTime() + "-kvm.bmp");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "bmp", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getSystemDateTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = "";
        int n = gregorianCalendar.get(1);
        string = string + n + "-";
        int n2 = gregorianCalendar.get(2) + 1;
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2 + "-";
        int n3 = gregorianCalendar.get(5);
        if (n3 < 10) {
            string = string + "0";
        }
        string = string + n3 + "-";
        int n4 = gregorianCalendar.get(11);
        if (n4 < 10) {
            string = string + "0";
        }
        string = string + n4 + ".";
        int n5 = gregorianCalendar.get(12);
        if (n5 < 10) {
            string = string + "0";
        }
        string = string + n5 + ".";
        int n6 = gregorianCalendar.get(13);
        if (n6 < 10) {
            string = string + "0";
        }
        string = string + n6 + "." + gregorianCalendar.get(14);
        return string;
    }

    public void OnVideoStopRedirection() {
        Debug.out.println("OnVideoStopRedirection");
        this.m_view.removeKMListeners();
        JVFrame.setServerIP(null);
        if (this.m_KVMClnt != null) {
            this.m_KVMClnt.stopRedirection();
        }
        if (this.isPanelMode()) {
            this.jViewerPanel.setDisconnectedUIStatus();
        }
        this.connected = false;
        this.m_session_token = null;
        this.vidClnt.clearBuffer();
        this.m_KVMClnt.getFragReader().clearBuffer();
        this.m_view.clearBuffer();
        this.OnCloseSoftKeyboard();
        System.gc();
    }

    public void OnVideoRestart() {
        Debug.out.println("OnVideoRestart");
        this.OnVideoStopRedirection();
        this.OnVideoStartRedirection();
    }

    public void OnVideoFullScreen(boolean bl) {
        Debug.out.println("OnVideoFullScreen =" + bl);
        if (bl) {
            this.setScreenMode(0);
            if (this.panelMode && this.isConnected()) {
                this.jViewerPanel.showFullScreenModeMessage();
                this.jViewerPanel.setAllDisableUIStatus();
            }
        } else if (this.panelMode) {
            this.jViewerPanel.hideFullScreenModeMessage();
            if (this.isConnected()) {
                this.jViewerPanel.setConnectedUIStatus();
            }
            this.setScreenMode(2);
        } else {
            this.setScreenMode(1);
        }
    }

    public void setScreenMode(int n) {
        switch (n) {
            case 0: {
                this.setFullScreenMode();
                break;
            }
            case 1: {
                this.setWindowScreenMode();
                break;
            }
            case 2: {
                this.setPanelScreenMode();
            }
        }
        this.OnVideoRefresh();
    }

    private void setPanelScreenMode() {
        this.m_fsFrame.detachView();
        this.m_wndFrame.detachView();
        this.jViewerPanel.attachView();
        this.m_frame = this.m_wndFrame;
        this.jviewerContainer = this.jViewerPanel;
        this.m_wndMode = 2;
        this.jviewerContainer.getMenu().notifyFullScreen(false);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    private void setWindowScreenMode() {
        this.m_fsFrame.detachView();
        this.jViewerPanel.detachView();
        this.m_wndFrame.attachView();
        this.m_frame = this.m_wndFrame;
        this.jviewerContainer = this.m_wndFrame;
        this.m_wndMode = 1;
        this.jviewerContainer.getMenu().notifyFullScreen(false);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    private void setFullScreenMode() {
        if (this.m_wndMode == 2) {
            this.jViewerPanel.detachView();
        } else if (this.m_wndMode == 1) {
            this.m_wndFrame.detachView();
        }
        this.m_fsFrame.attachView();
        this.m_frame = this.m_fsFrame;
        this.jviewerContainer = this.m_fsFrame;
        this.m_wndMode = 0;
        this.jviewerContainer.getMenu().notifyFullScreen(true);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    public void OnVideoExit() {
        Debug.out.println("OnVideoExit");
        this.jviewerContainer.exitApp();
    }

    public void OnVideoPause() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.sendPauseVideo() != 0) {
            this.m_view.DisableKMListeners(true);
            this.m_bVideoPaused = true;
        }
    }

    public void OnVideoResume() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.sendResumeVideo() != 0) {
            this.m_view.DisableKMListeners(false);
            this.m_bVideoPaused = false;
        }
    }

    public void OnVideoRefresh() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_KVMClnt.sendRefreshVideo();
    }

    public void OnVideoCapture() {
        if (!this.m_KVMClnt.redirection() || this.m_view == null) {
            return;
        }
        String string = "";
        try {
            Object object;
            Object object2;
            boolean bl = false;
            do {
                object2 = new JFileChooser();
                class JpegImageFilter
                extends FileFilter {
                    JpegImageFilter() {
                    }

                    @Override
                    public boolean accept(File file) {
                        String string = file.getName();
                        return string.endsWith(".bmp") || file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "bmp";
                    }

                    public String getExtension(String string) {
                        int n = string.lastIndexOf(".");
                        return n != -1 ? string.substring(n + 1) : "";
                    }
                }
                ((JFileChooser)object2).setFileFilter(new JpegImageFilter());
                if (((JFileChooser)object2).showSaveDialog(this.m_frame) == 0) {
                    int n;
                    File file;
                    string = ((JFileChooser)object2).getSelectedFile().getAbsolutePath();
                    object = new JpegImageFilter().getExtension(string).toLowerCase();
                    if (!((String)object).equals("bmp")) {
                        string = string + ".bmp";
                    }
                    if ((file = new File(string)).exists() && (n = JOptionPane.showConfirmDialog(this.m_frame, LocaleStrings.GetString("D_3_JVAPP"), LocaleStrings.GetString("D_4_JVAPP"), 0)) != 0) {
                        continue;
                    }
                } else {
                    return;
                }
                bl = true;
            } while (!bl);
            object2 = this.m_view.GetRedirImage();
            object = new File(string);
            ImageIO.write((RenderedImage)object2, "bmp", (File)object);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_5_JVAPP") + string, LocaleStrings.GetString("A_1_GLOBAL"), 0);
        }
    }

    public void OnKeyboardHoldRightAltKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldRightAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 3, bl);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        this.jviewerContainer.getMenu().notifyRAlt(bl);
    }

    public void OnKeyboardHoldLeftAltKey(boolean bl) {
        Debug.out.println("OnKeyboardHoldLeftAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, bl);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        this.jviewerContainer.getMenu().notifyLAlt(bl);
    }

    public void OnKeyboardLeftWindowsKeyHoldDown(boolean bl) {
        Debug.out.println("OnKeyboardLeftWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(524, 2, bl);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        this.jviewerContainer.getMenu().notifyLWinDown(bl);
    }

    public void OnKeyboardLeftWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardLeftWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(524, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(524, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardRightWindowsKeyHoldDown(boolean bl) {
        Debug.out.println("OnKeyboardRightWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(524, 3, bl);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        this.jviewerContainer.getMenu().notifyRWinDown(bl);
    }

    public void OnKeyboardRightWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardRightWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(524, 3, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(524, 3, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltCtrlDel() {
        Debug.out.println("OnKeyboardAltCtrlDel");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(127, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(127, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltTab() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(9, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(9, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltEsc() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(27, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(27, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardCtrlEsc() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(27, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(27, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltSpace() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(32, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(32, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltEnter() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(10, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(10, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltHyphen() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(45, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(45, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltF4() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(115, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(115, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardAltPrntScrn() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(154, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(154, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardPrntScrn() {
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(154, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(154, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardF1() {
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(112, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(112, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardPause() {
        USBKeyboardRep uSBKeyboardRep = new USBKeyboardRep();
        uSBKeyboardRep.set(19, 1, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(19, 1, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    private void SendKey(int n, int n2, USBKeyboardRep uSBKeyboardRep) {
        uSBKeyboardRep.set(n, n2, true);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
        uSBKeyboardRep.set(n, n2, false);
        this.m_KVMClnt.sendKMMessage(uSBKeyboardRep);
    }

    public void OnKeyboardFullKeyboard(boolean bl) {
        Debug.out.println("OnKeyboardFullKeyboard");
        this.m_FullKeyboard = bl;
    }

    public void OnUSBMouseSyncCursor(boolean bl) {
        Debug.out.println("OnUSBMouseSyncCursor");
        showCursor = true;
        boolean bl2 = this.m_view.USBsyncCursor(bl);
        if (bl && !bl2) {
            this.jviewerContainer.getMenu().notifyMouseRedir(false);
        } else if (bl && bl2) {
            this.jviewerContainer.getMenu().notifyMouseRedir(true);
        } else if (!bl) {
            this.jviewerContainer.getMenu().notifyMouseRedir(false);
        }
    }

    public void OnShowCursor(boolean bl) {
        Debug.out.println("OnShowCursor");
        if (bl) {
            showCursor = true;
            this.m_view.ShowCursor(true);
        } else {
            showCursor = false;
            this.m_view.ShowCursor(false);
        }
    }

    public void OnHelpAboutJViewer() {
        Debug.out.println("OnHelpAboutJViewer");
        JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("A_1_GLOBAL") + " " + LocaleStrings.GetString("D_7_JVAPP") + " 1.33.01 (SMC 2.04)\n" + LocaleStrings.GetString("D_8_JVAPP"), LocaleStrings.GetString("D_9_JVAPP"), 1);
    }

    public void OnSessionStopCmd(short s) {
        if (s == 1) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_12_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
        } else if (s == 2) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_13_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (s == 4) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_14_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (s == 3) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_15_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (s == 5) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_16_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (s == 6) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_17_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (s == 7) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_21_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_18_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        }
        if (!this.panelMode) {
            System.exit(0);
        }
    }

    public void OnGetMouseMode(short s, byte by) {
        Debug.out.println("Mouse mode response packet received");
        if (s == 0) {
            this.m_view.SetUSBMouseMode(by);
            this.OnUSBMouseSyncCursor(true);
        } else {
            this.m_view.SetUSBMouseMode(USBMouseRep.INVALID_MOUSE_MODE);
        }
    }

    public void OnvMedia() {
        String string = null;
        try {
            string = InetAddress.getByAddress(this.m_serverIP).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Debug.out.println("Invalid IP address");
        }
        this.m_mediaDlg = new vMediaDialog(this.m_frame, this.m_IUSBSession, string, this.getCDPort(), this.getFDPort(), this.m_bVMUseSSL, this.getSessionToken(), this);
        this.m_mediaDlg.DisplayDialog();
        this.m_mediaDlg = null;
    }

    public void OnSoftKeyboard() {
        this.softKeyboardDialog.setVisible(true);
    }

    public void OnCloseSoftKeyboard() {
        this.softKeyboardDialog.setVisible(false);
    }

    public void OnChangeColorMode(byte by) {
        JVMenu jVMenu = this.getJVMenu();
        jVMenu.notifyColorMode(this.m_view.m_current_color_mode);
        this.m_KVMClnt.send_color_mode_pkt(by);
    }

    public void reportCDROMAbnormal() {
        this.m_IUSBSession.stopCDROMAbnormal();
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateCDROMRedirStatus();
        }
    }

    public void reportFloppyAbnormal() {
        this.m_IUSBSession.stopFloppyAbnormal();
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateFloppyRedirStatus();
        }
    }

    public boolean IsCDROMRedirRunning() {
        return this.m_IUSBSession.getCDROMRedirStatus() == 1;
    }

    public boolean IsFloppyRedirRunning() {
        return this.m_IUSBSession.getFloppyRedirStatus() == 1;
    }

    public JViewerParams getParams() {
        return this.params;
    }

    public JViewerPanel getJViewerPanel(JFrame jFrame) {
        this.m_frame = jFrame;
        return this.jViewerPanel;
    }

    public boolean isPanelMode() {
        return this.panelMode;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setPanelMode(boolean bl) {
        this.panelMode = bl;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setServerIP(String string) {
        this.serverIP = string;
    }

    public void generalErrorMessage(String string) {
        JOptionPane.showMessageDialog(this.m_frame, string, LocaleStrings.GetString("A_1_GLOBAL"), 0);
    }

    private static byte[] getServerIP(String string) {
        String[] stringArray;
        boolean bl = false;
        try {
            stringArray = InetAddress.getByName(string);
            string = stringArray.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string.trim().length() <= 0) {
            return null;
        }
        stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int k = 0; k < 4; ++k) {
            try {
                byArray[k] = (byte)Short.parseShort(stringArray[k]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (byArray[k] <= 255) continue;
            return null;
        }
        return byArray;
    }

    public void OnMouseModeAbsolute() {
        byte by = 0;
        try {
            by = this.getMouseMode();
            if (by == 2) {
                this.getJVMenu().setMouseMode(by);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = JOptionPane.showConfirmDialog(this.jViewerPanel, "It needs to restart KVM session. Are you sure to continue ?", "Info", 2);
        if (n != 0) {
            this.getJVMenu().setMouseMode(by);
            return;
        }
        this.m_view.SetUSBMouseMode(USBMouseRep.ABSOLUTE_MOUSE_MODE);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(3));
                    JViewerApp.this.OnVideoStopRedirection();
                    ((JViewerApp)JViewerApp.this).jViewerPanel.jStartButton.setEnabled(false);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.setMouseMode((byte)2);
                    byte by = JViewerApp.this.getMouseMode();
                    JViewerApp.this.getJVMenu().setMouseMode(by);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.OnVideoStartRedirection();
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void OnMouseModeRelative() {
        byte by = 0;
        try {
            by = this.getMouseMode();
            if (by == 1) {
                this.getJVMenu().setMouseMode(by);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = JOptionPane.showConfirmDialog(this.jViewerPanel, "It needs to restart KVM session. Are you sure to continue ?", "Info", 2);
        if (n != 0) {
            this.getJVMenu().setMouseMode(by);
            return;
        }
        this.m_view.SetUSBMouseMode(USBMouseRep.RELATIVE_MOUSE_MODE);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(3));
                    JViewerApp.this.OnVideoStopRedirection();
                    ((JViewerApp)JViewerApp.this).jViewerPanel.jStartButton.setEnabled(false);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.setMouseMode((byte)1);
                    byte by = JViewerApp.this.getMouseMode();
                    JViewerApp.this.getJVMenu().setMouseMode(by);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.OnVideoStartRedirection();
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private void sleep1Sec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopVM() {
        if (this.m_IUSBSession != null) {
            this.m_IUSBSession.StopCDROMRedir();
            this.m_IUSBSession.StopFloppyRedir();
            this.m_IUSBSession.StopISORedir();
        }
    }

    public byte getMouseMode() throws Exception {
        IPMIInterfaceConfig iPMIInterfaceConfig = new IPMIInterfaceConfig();
        iPMIInterfaceConfig.setIp(this.serverIP);
        iPMIInterfaceConfig.setUserName(this.userID);
        iPMIInterfaceConfig.setPassword(this.password);
        iPMIInterfaceConfig.setPrivilege((byte)4);
        IPMIAMIOEMCommand iPMIAMIOEMCommand = new IPMIAMIOEMCommand(null);
        ISessionController iSessionController = SessionControllerFactory.createSessionController(iPMIInterfaceConfig, iPMIAMIOEMCommand);
        if (iSessionController == null) {
            throw new IPMIException("Cannot connect to BMC");
        }
        byte by = iPMIAMIOEMCommand.getMouseMode();
        iSessionController.closeSession();
        return by;
    }

    public boolean setMouseMode(byte by) throws Exception {
        IPMIInterfaceConfig iPMIInterfaceConfig = new IPMIInterfaceConfig();
        iPMIInterfaceConfig.setIp(this.serverIP);
        iPMIInterfaceConfig.setUserName(this.userID);
        iPMIInterfaceConfig.setPassword(this.password);
        iPMIInterfaceConfig.setPrivilege((byte)4);
        IPMIAMIOEMCommand iPMIAMIOEMCommand = new IPMIAMIOEMCommand(null);
        ISessionController iSessionController = SessionControllerFactory.createSessionController(iPMIInterfaceConfig, iPMIAMIOEMCommand);
        if (iSessionController == null) {
            throw new IPMIException("Cannot connect to BMC");
        }
        iPMIAMIOEMCommand.setMouseMode(by);
        iSessionController.closeSession();
        return true;
    }

    public boolean isShowCursor() {
        return showCursor;
    }

    public void setShowCursor(boolean bl) {
        showCursor = bl;
    }
}

