/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.KMEncode;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.USBMouseRep;
import com.ami.kvm.jviewer.video.ColorTable;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class JViewerView
extends JComponent {
    JViewerApp app;
    public static final int DEFAULT_VIEW_WIDTH = 1024;
    public static final int DEFAULT_VIEW_HEIGHT = 768;
    private static final int REL_MOUSE_MIN_WND_WIDTH = 200;
    private static final int REL_MOUSE_MIN_WND_HEIGHT = 200;
    private static final int MOUSE_ACCELERATION = 2;
    private static final int ACCEL_THRESHOLD = 4;
    private int m_width;
    private int m_height;
    private int m_act_width;
    private int m_act_height;
    private BufferedImage m_image = null;
    private int m_mousePrevX = 0;
    private int m_mousePrevY = 0;
    private KMEncode m_keyCoder;
    RCMouseListener m_mouseListener;
    RCKeyListener m_keyListener;
    public static final boolean m_isG4 = true;
    private USBKeyboardRep m_USBKeyRep;
    private USBMouseRep m_USBMouseRep;
    private byte m_USBMouseMode = USBMouseRep.INVALID_MOUSE_MODE;
    private int lastX = -1;
    private int lastY = -1;
    public byte m_current_color_mode = (byte)8;
    private boolean m_bLeftCtrlDown = false;
    private boolean m_bRightCtrlDown = false;
    private boolean m_bLeftAltDown = false;
    private boolean m_bRightAltDown = false;
    private boolean m_bMouseRedirRunning = false;
    private boolean m_bMouseWasOut = true;

    public JViewerView(int n, int n2, JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.setRCView(n, n2, this.m_current_color_mode);
        this.m_USBKeyRep = new USBKeyboardRep();
        this.m_USBMouseRep = new USBMouseRep();
        this.m_mouseListener = new RCMouseListener();
        this.m_keyListener = new RCKeyListener();
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new RCFocusListener());
        this.addMouseListener(new RCDoubleClickListener());
    }

    public void addKMListeners() {
        this.addKeyListener(this.m_keyListener);
    }

    public void removeKMListeners() {
        this.removeKeyListener(this.m_keyListener);
    }

    public void DisableKMListeners(boolean bl) {
        this.m_mouseListener.DisableEvents(bl);
        this.m_keyListener.DisableEvents(bl);
    }

    public short[] imageMemory() {
        WritableRaster writableRaster = this.m_image.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer instanceof DataBufferUShort) {
            DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
            return dataBufferUShort.getData();
        }
        return null;
    }

    public byte[] imageMemory_ByteArray() {
        WritableRaster writableRaster = this.m_image.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
            return dataBufferByte.getData();
        }
        return null;
    }

    public int viewWidth() {
        return this.m_width;
    }

    public int viewHeight() {
        return this.m_height;
    }

    public void setRCView(int n, int n2, byte by) {
        this.m_act_width = this.m_width = n;
        this.m_act_height = this.m_height = n2;
        if (this.m_act_height == 608) {
            this.m_act_height = 600;
        }
        this.m_current_color_mode = by;
        Debug.out.println("View - width: " + this.m_width + " height: " + this.m_height);
        this.setSize(n, n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.setMaximumSize(new Dimension(n, n2));
        this.prepareBufImage();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            Rectangle rectangle = new Rectangle(0, 0, this.m_width, this.m_height);
            Rectangle rectangle2 = rectangle.intersection(graphics.getClipBounds());
            BufferedImage bufferedImage = this.m_image.getSubimage(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.drawImage(bufferedImage, rectangle2.x, rectangle2.y, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ShowCursor(boolean bl) {
        if (bl) {
            this.setCursor(null);
        } else {
            BufferedImage bufferedImage = new BufferedImage(32, 32, 3);
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "Invisible Cursor");
            this.setCursor(cursor);
        }
    }

    public void SetUSBMouseMode(byte by) {
        this.m_USBMouseMode = by;
    }

    public byte GetUSBMouseMode() {
        return this.m_USBMouseMode;
    }

    private void mouse_resync_linux_mode(int n, int n2) {
        this.m_mouseListener.splitandsend(-this.m_width, -this.m_height, true);
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        this.lastX = (int)point.getX();
        this.lastY = (int)point.getY();
        this.m_mouseListener.splitandsend(this.lastX, this.lastY, true);
    }

    public boolean USBsyncCursor(boolean bl) {
        if (bl) {
            if (this.m_bMouseRedirRunning) {
                return true;
            }
            if (this.m_USBMouseMode == USBMouseRep.INVALID_MOUSE_MODE) {
                this.app.generalErrorMessage(LocaleStrings.GetString("E_2_JVIEW"));
                return false;
            }
            if (this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                this.m_bMouseWasOut = true;
            } else if (this.m_USBMouseMode == USBMouseRep.OTHER_MOUSE_MODE) {
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, this);
                this.lastX = (int)point.getX();
                this.lastY = (int)point.getY();
            }
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = true;
        } else {
            this.removeMouseListener(this.m_mouseListener);
            this.removeMouseMotionListener(this.m_mouseListener);
            this.m_bMouseRedirRunning = false;
            this.m_bMouseWasOut = true;
        }
        return true;
    }

    public BufferedImage GetRedirImage() {
        return this.m_image;
    }

    private void prepareBufImage() {
        if (this.m_current_color_mode == 8) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 9);
        } else if (this.m_current_color_mode == 9) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get7BitDirectIndexColorModel());
        } else if (this.m_current_color_mode == 10) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get4BitPaletteIndexColorModel());
        } else if (this.m_current_color_mode == 3) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get4BitGreyIndexColorModel());
        } else if (this.m_current_color_mode == 2) {
            this.m_image = new BufferedImage(this.m_width, this.m_height, 13, ColorTable.get3BitGreyIndexColorModel());
        } else {
            JOptionPane.showMessageDialog(this, LocaleStrings.GetString("E_8_JVIEW"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
        }
        if (this.app != null) {
            this.app.getJVMenu().notifyColorMode(this.m_current_color_mode);
        }
    }

    public void sendDVO() {
        KVMClient kVMClient = this.app.getKVMClient();
        this.m_USBKeyRep.set(68, 1, true);
        kVMClient.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(86, 1, true);
        kVMClient.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(79, 1, true);
        kVMClient.sendKMMessage(this.m_USBKeyRep);
        this.m_USBKeyRep.set(10, 1, true);
        kVMClient.sendKMMessage(this.m_USBKeyRep);
    }

    private void wait100ms() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearBuffer() {
        if (this.m_image != null) {
            this.m_image = null;
        }
    }

    class RCFocusListener
    extends FocusAdapter {
        RCFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            KVMClient kVMClient;
            if (JViewerView.this.m_bLeftCtrlDown) {
                kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(17, 2, false);
                kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bLeftCtrlDown = false;
            }
            if (JViewerView.this.m_bRightCtrlDown) {
                kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(17, 3, false);
                kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bRightCtrlDown = false;
            }
            if (JViewerView.this.m_bLeftAltDown) {
                kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(18, 2, false);
                kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bLeftAltDown = false;
            }
            if (JViewerView.this.m_bRightAltDown) {
                kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBKeyRep.set(18, 3, false);
                kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
                JViewerView.this.m_bRightAltDown = false;
            }
        }
    }

    class RCMouseListener
    extends MouseInputAdapter {
        public static final byte MOUSE_MOVE = 0;
        public static final byte LBUTTON_DOWN = 1;
        public static final byte RBUTTON_DOWN = 2;
        public static final byte MBUTTON_DOWN = 4;
        private byte m_btnStatus = 0;
        private boolean m_bDisable = false;

        RCMouseListener() {
        }

        public void DisableEvents(boolean bl) {
            this.m_bDisable = bl;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.getComponent().requestFocusInWindow();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.m_bDisable) {
                mouseEvent.consume();
                return;
            }
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 1);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 4);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus | 2);
                    break;
                }
                default: {
                    return;
                }
            }
            if (n < JViewerView.this.m_act_width && n2 < JViewerView.this.m_act_height) {
                KVMClient kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, 0, 0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.m_bDisable) {
                mouseEvent.consume();
                return;
            }
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFE);
                    break;
                }
                case 2: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFB);
                    break;
                }
                case 3: {
                    this.m_btnStatus = (byte)(this.m_btnStatus & 0xFFFFFFFD);
                    break;
                }
                default: {
                    return;
                }
            }
            if (n < JViewerView.this.m_act_width && n2 < JViewerView.this.m_act_height) {
                KVMClient kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, 0, 0, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            }
        }

        private Point calculateCenter() {
            Container container = JViewerView.this.getTopLevelAncestor();
            Dimension dimension = container.getSize();
            Point point = new Point(dimension.width / 2, dimension.height / 2);
            return point;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.m_bDisable) {
                mouseEvent.consume();
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                if (n < JViewerView.this.m_act_width && n2 < JViewerView.this.m_act_height) {
                    KVMClient kVMClient = JViewerView.this.app.getKVMClient();
                    JViewerView.this.m_USBMouseRep.set((byte)0, n, n2, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                    kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
                }
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (n >= JViewerView.this.m_act_width || n2 >= JViewerView.this.m_act_height) {
                    JViewerView.this.m_bMouseWasOut = true;
                    return;
                }
                if (JViewerView.this.m_bMouseWasOut) {
                    JViewerView.this.mouse_resync_linux_mode(n, n2);
                    JViewerView.this.m_bMouseWasOut = false;
                    return;
                }
                int n3 = n - JViewerView.this.lastX;
                int n4 = n2 - JViewerView.this.lastY;
                this.splitandsend(n3, n4, true);
                JViewerView.this.lastX = n;
                JViewerView.this.lastY = n2;
            } else {
                if (n >= JViewerView.this.m_act_width || n2 >= JViewerView.this.m_act_height) {
                    return;
                }
                int n5 = n - JViewerView.this.lastX;
                int n6 = n2 - JViewerView.this.lastY;
                this.splitandsend(n5, n6, false);
                JViewerView.this.lastX = n;
                JViewerView.this.lastY = n2;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_bDisable) {
                mouseEvent.consume();
                return;
            }
            this.m_btnStatus = (byte)(this.m_btnStatus | 1);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.ABSOLUTE_MOUSE_MODE) {
                if (n < JViewerView.this.m_act_width && n2 < JViewerView.this.m_act_height) {
                    KVMClient kVMClient = JViewerView.this.app.getKVMClient();
                    JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, n, n2, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                    kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
                }
                return;
            }
            if (JViewerView.this.m_USBMouseMode == USBMouseRep.RELATIVE_MOUSE_MODE) {
                if (n >= JViewerView.this.m_act_width || n2 >= JViewerView.this.m_act_height) {
                    JViewerView.this.m_bMouseWasOut = true;
                    return;
                }
                if (JViewerView.this.m_bMouseWasOut) {
                    JViewerView.this.mouse_resync_linux_mode(n, n2);
                    JViewerView.this.m_bMouseWasOut = false;
                    return;
                }
                int n3 = n - JViewerView.this.lastX;
                int n4 = n2 - JViewerView.this.lastY;
                this.splitandsend(n3, n4, true);
                JViewerView.this.lastX = n;
                JViewerView.this.lastY = n2;
            } else {
                if (n >= JViewerView.this.m_act_width || n2 >= JViewerView.this.m_act_height) {
                    return;
                }
                int n5 = n - JViewerView.this.lastX;
                int n6 = n2 - JViewerView.this.lastY;
                this.splitandsend(n5, n6, false);
                JViewerView.this.lastX = n;
                JViewerView.this.lastY = n2;
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.getComponent().requestFocusInWindow();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JViewerView.this.m_bMouseWasOut = true;
        }

        public void splitandsend(int n, int n2, boolean bl) {
            int n3 = n >= 0 ? 1 : -1;
            int n4 = n2 >= 0 ? 1 : -1;
            n = Math.abs(n);
            n2 = Math.abs(n2);
            do {
                int n5 = n > 126 ? 126 : n;
                int n6 = n2 > 126 ? 126 : n2;
                n -= n5;
                n2 -= n6;
                if (bl) {
                    this.send_linux_mouse_mode_report(n5 * n3, n6 * n4);
                    continue;
                }
                KVMClient kVMClient = JViewerView.this.app.getKVMClient();
                JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, n5 * n3, n6 * n4, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
                kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
            } while (n > 0 || n2 > 0);
        }

        private int ABS(int n) {
            return n < 0 ? -n : n;
        }

        private float ABS(float f2) {
            return f2 < 0.0f ? -f2 : f2;
        }

        private void sendto_linux_target(int n, int n2) {
            KVMClient kVMClient = JViewerView.this.app.getKVMClient();
            JViewerView.this.m_USBMouseRep.set(this.m_btnStatus, n, n2, JViewerView.this.m_USBMouseMode, JViewerView.this.m_width, JViewerView.this.m_height);
            kVMClient.sendKMMessage(JViewerView.this.m_USBMouseRep);
        }

        private int send_linux_mouse_mode_report(int n, int n2) {
            if (this.ABS(n) + this.ABS(n2) < 4) {
                this.sendto_linux_target(n, n2);
                return 0;
            }
            int n3 = n / 2;
            int n4 = n2 / 2;
            if (n3 != 0 || n4 != 0) {
                if (this.ABS(n3) + this.ABS(n4) >= 4) {
                    this.sendto_linux_target(n3, n4);
                } else {
                    for (int k = 0; k < 2; ++k) {
                        this.sendto_linux_target(n3, n4);
                    }
                }
            }
            n3 = n % 2;
            n4 = n2 % 2;
            if (n3 != 0 || n4 != 0) {
                if (this.ABS(n3) + this.ABS(n4) < 4) {
                    this.sendto_linux_target(n3, n4);
                } else {
                    float f2 = (float)(this.ABS(n3) + this.ABS(n4)) / 3.0f;
                    float f3 = (float)n3 / f2;
                    float f4 = (float)n4 / f2;
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    float f7 = 0.0f;
                    float f8 = 0.0f;
                    int n5 = 0;
                    int n6 = 0;
                    while (this.ABS(f5) < (float)this.ABS(n3) || this.ABS(f6) < (float)this.ABS(n4)) {
                        this.sendto_linux_target((int)((f7 += f3) - (float)n5), (int)((f8 += f4) - (float)n6));
                        f5 = f7;
                        f6 = f8;
                        n5 = (int)f5;
                        n6 = (int)f6;
                    }
                }
            }
            return 0;
        }
    }

    class RCDoubleClickListener
    extends MouseInputAdapter {
        private boolean m_bDisable = false;

        RCDoubleClickListener() {
        }

        public void DisableEvents(boolean bl) {
            this.m_bDisable = bl;
        }

        public void StartMouseRedirectionOnDblClick() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.m_bDisable) {
                mouseEvent.consume();
                return;
            }
            if (mouseEvent.getClickCount() == 2 && !JViewerView.this.m_bMouseRedirRunning) {
                Debug.out.println("Double click");
                JViewerView.this.app.OnUSBMouseSyncCursor(true);
            }
        }
    }

    class RCKeyListener
    extends KeyAdapter {
        private boolean m_bDisable = false;

        RCKeyListener() {
        }

        public void DisableEvents(boolean bl) {
            this.m_bDisable = bl;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.m_bDisable) {
                keyEvent.consume();
                return;
            }
            KVMClient kVMClient = JViewerView.this.app.getKVMClient();
            if (keyEvent.getKeyCode() == 524) {
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 144 || keyEvent.getKeyCode() == 20 || keyEvent.getKeyCode() == 145) {
                kVMClient.send_keybd_led_sync_pkt(JViewerView.this.m_USBKeyRep.getModifiers());
                keyEvent.consume();
                return;
            }
            if (!JViewerView.this.app.m_FullKeyboard && (keyEvent.getModifiersEx() & 0x200) == 512) {
                if (JViewerView.this.app.isFullScreenMode()) {
                    if (keyEvent.getKeyCode() == 70) {
                        JViewerView.this.app.OnVideoFullScreen(false);
                    } else if (keyEvent.getKeyCode() == 77) {
                        if (JViewerView.this.m_bMouseRedirRunning) {
                            JViewerView.this.app.OnUSBMouseSyncCursor(false);
                        } else {
                            JViewerView.this.app.OnUSBMouseSyncCursor(true);
                        }
                    } else if (keyEvent.getKeyCode() == 67) {
                        if (JViewerApp.showCursor) {
                            JViewerView.this.app.OnShowCursor(false);
                            JViewerView.this.app.getJVMenu().notifyShowCursor(true);
                        } else {
                            JViewerView.this.app.OnShowCursor(true);
                            JViewerView.this.app.getJVMenu().notifyShowCursor(false);
                        }
                    }
                    keyEvent.consume();
                }
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x80) == 128) {
                if (keyEvent.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = true;
                } else {
                    JViewerView.this.m_bRightCtrlDown = true;
                }
            }
            if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                if (keyEvent.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftAltDown = true;
                } else {
                    JViewerView.this.m_bRightAltDown = true;
                }
            }
            if (keyEvent.getKeyCode() == 112) {
                // empty if block
            }
            JViewerView.this.m_USBKeyRep.set(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), true);
            kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
            keyEvent.consume();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.m_bDisable) {
                keyEvent.consume();
                return;
            }
            KVMClient kVMClient = JViewerView.this.app.getKVMClient();
            if ((keyEvent.getModifiersEx() & 0x200) == 512) {
                return;
            }
            if ((keyEvent.getModifiersEx() & 0x80) == 128) {
                if (keyEvent.getKeyLocation() == 2) {
                    JViewerView.this.m_bLeftCtrlDown = false;
                } else {
                    JViewerView.this.m_bRightCtrlDown = false;
                }
            }
            JViewerView.this.m_USBKeyRep.set(keyEvent.getKeyCode(), keyEvent.getKeyLocation(), false);
            kVMClient.sendKMMessage(JViewerView.this.m_USBKeyRep);
            keyEvent.consume();
        }
    }
}

