/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.IUSBRedirSession;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.DevicePanel;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class vMediaDialog
extends JDialog {
    JViewerApp app;
    JPanel tablePanel;
    DevicePanel cdromDevTable;
    DevicePanel floppyDevTable;
    JTable statusTable;
    JButton floppyButton;
    JButton cdromButton;
    JButton helpButton;
    JButton exitButton;
    private Timer m_updateTimer;
    IUSBRedirSession m_vMediaSession;
    String m_hostIp;
    String m_sessToken;
    int m_cdPort;
    int m_fdPort;
    boolean m_useSSL;
    boolean mediaConnected = false;

    public vMediaDialog(JFrame jFrame, IUSBRedirSession iUSBRedirSession, String string, int n, int n2, boolean bl, String string2, JViewerApp jViewerApp) {
        super(jFrame, LocaleStrings.GetString("G_1_VMD"), true);
        this.app = jViewerApp;
        this.m_vMediaSession = iUSBRedirSession;
        this.m_hostIp = string;
        this.m_cdPort = n;
        this.m_fdPort = n2;
        this.m_useSSL = bl;
        this.m_sessToken = string2;
        ButtonListener buttonListener = new ButtonListener();
        JLabel jLabel = new JLabel(LocaleStrings.GetString("G_2_VMD"));
        JLabel jLabel2 = new JLabel(LocaleStrings.GetString("G_3_VMD"));
        JLabel jLabel3 = new JLabel(LocaleStrings.GetString("G_4_VMD"));
        Object[][] objectArray = new Object[][]{{LocaleStrings.GetString("G_5_VMD"), LocaleStrings.GetString("G_6_VMD"), LocaleStrings.GetString("G_7_VMD")}, {LocaleStrings.GetString("G_8_VMD"), LocaleStrings.GetString("G_6_VMD"), LocaleStrings.GetString("G_7_VMD")}};
        Object[] objectArray2 = new String[]{LocaleStrings.GetString("G_9_VMD"), LocaleStrings.GetString("G_10_VMD"), LocaleStrings.GetString("G_11_VMD")};
        this.statusTable = new JTable(objectArray, objectArray2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.statusTable.setShowGrid(false);
        this.statusTable.setCellSelectionEnabled(false);
        this.statusTable.setCellEditor(null);
        this.statusTable.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.statusTable);
        this.cdromButton = new JButton(LocaleStrings.GetString("G_12_VMD"));
        this.cdromButton.addActionListener(buttonListener);
        this.floppyButton = new JButton(LocaleStrings.GetString("G_13_VMD"));
        this.floppyButton.addActionListener(buttonListener);
        this.helpButton = new JButton(LocaleStrings.GetString("G_14_VMD"));
        this.exitButton = new JButton(LocaleStrings.GetString("G_15_VMD"));
        this.exitButton.addActionListener(buttonListener);
        String[] stringArray = this.getCDROMList();
        this.cdromDevTable = new DevicePanel(stringArray, 0);
        this.cdromDevTable.m_browseButton.addActionListener(buttonListener);
        JScrollPane jScrollPane2 = new JScrollPane(this.cdromDevTable);
        String[] stringArray2 = this.getFloppyList();
        this.floppyDevTable = new DevicePanel(stringArray2, 1);
        this.floppyDevTable.m_browseButton.addActionListener(buttonListener);
        JScrollPane jScrollPane3 = new JScrollPane(this.floppyDevTable);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(2, 2));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane3, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 2));
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(2, 2));
        jPanel3.add((Component)jLabel3, "North");
        jPanel3.add((Component)jScrollPane, "Center");
        this.setBackground(Color.WHITE);
        jPanel.setBounds(10, 10, 475, 100);
        jPanel2.setBounds(10, 120, 475, 100);
        jPanel3.setBounds(10, 230, 475, 100);
        this.floppyButton.setBounds(500, 30, 130, 25);
        this.cdromButton.setBounds(500, 140, 130, 25);
        this.exitButton.setBounds(500, 300, 130, 25);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(null);
        this.tablePanel.add(jPanel);
        this.tablePanel.add(jPanel2);
        this.tablePanel.add(jPanel3);
        this.tablePanel.add(this.cdromButton);
        this.tablePanel.add(this.floppyButton);
        this.tablePanel.add(this.exitButton);
        this.getContentPane().add(this.tablePanel);
        this.updateCDROMRedirStatus();
        this.updateFloppyRedirStatus();
        this.setSize(650, 375);
        this.m_updateTimer = new Timer();
        this.m_updateTimer.schedule((TimerTask)new UpdateReadBytesTask(), 0L, 1000L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                vMediaDialog.this.m_updateTimer.cancel();
            }
        });
    }

    public void DisplayDialog() {
        this.setVisible(true);
    }

    public String[] getCDROMList() {
        String[] stringArray = null;
        try {
            CDROMRedir cDROMRedir = new CDROMRedir(true, this.app);
            stringArray = cDROMRedir.getCDROMList();
            System.gc();
        }
        catch (RedirectionException redirectionException) {
            Debug.out.println("Exception occured while getCDROMList()");
        }
        return stringArray;
    }

    public String[] getFloppyList() {
        String[] stringArray = null;
        FloppyRedir floppyRedir = new FloppyRedir(true, this.app);
        stringArray = floppyRedir.getFloppyList();
        System.gc();
        return stringArray;
    }

    public void disableAllControls() {
        this.cdromDevTable.disableAll();
        this.cdromButton.setEnabled(false);
        this.floppyDevTable.disableAll();
        this.floppyButton.setEnabled(false);
        this.exitButton.setEnabled(false);
    }

    public void enableAllControls() {
        this.cdromDevTable.enableAll();
        this.cdromButton.setEnabled(true);
        this.floppyDevTable.enableAll();
        this.floppyButton.setEnabled(true);
        this.exitButton.setEnabled(true);
    }

    public void updateCDROMRedirStatus() {
        if (this.m_vMediaSession.getCDROMRedirStatus() == 1) {
            this.cdromDevTable.disableAll();
            this.cdromButton.setText(LocaleStrings.GetString("G_18_VMD"));
            this.cdromDevTable.SelectRadioButton(this.m_vMediaSession.getCDROMSource());
            this.statusTable.setValueAt(this.m_vMediaSession.getCDROMSource(), 1, 1);
        } else {
            this.cdromDevTable.enableAll();
            this.cdromButton.setText(LocaleStrings.GetString("G_12_VMD"));
            this.cdromDevTable.SelectRadioButton("");
            this.statusTable.setValueAt(LocaleStrings.GetString("G_6_VMD"), 1, 1);
        }
    }

    public void updateFloppyRedirStatus() {
        if (this.m_vMediaSession.getFloppyRedirStatus() == 1) {
            this.floppyDevTable.disableAll();
            this.floppyButton.setText(LocaleStrings.GetString("G_18_VMD"));
            this.floppyDevTable.SelectRadioButton(this.m_vMediaSession.getFloppySource());
            this.statusTable.setValueAt(this.m_vMediaSession.getFloppySource(), 0, 1);
        } else {
            this.floppyDevTable.enableAll();
            this.floppyButton.setText(LocaleStrings.GetString("G_13_VMD"));
            this.floppyDevTable.SelectRadioButton("");
            this.statusTable.setValueAt(LocaleStrings.GetString("G_6_VMD"), 0, 1);
        }
    }

    public void updateReadBytes() {
        if (this.m_vMediaSession.getCDROMRedirStatus() == 1) {
            this.statusTable.setValueAt(this.m_vMediaSession.getCDROMReadBytes() + " KB", 1, 2);
        }
        if (this.m_vMediaSession.getFloppyRedirStatus() == 1) {
            this.statusTable.setValueAt(this.m_vMediaSession.getFloppyReadBytes() + " KB", 0, 2);
        }
    }

    public void updateFloppyReadBytes() {
    }

    class UpdateReadBytesTask
    extends TimerTask {
        UpdateReadBytesTask() {
        }

        @Override
        public void run() {
            vMediaDialog.this.updateReadBytes();
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == vMediaDialog.this.exitButton) {
                vMediaDialog.this.m_updateTimer.cancel();
                vMediaDialog.this.setVisible(false);
            } else if (object == vMediaDialog.this.cdromDevTable.m_browseButton) {
                String string = vMediaDialog.this.m_vMediaSession.isoImageSelector();
                if (string != null) {
                    vMediaDialog.this.cdromDevTable.setImagePath(string);
                }
            } else if (object == vMediaDialog.this.floppyDevTable.m_browseButton) {
                String string = vMediaDialog.this.m_vMediaSession.floppyImageSelector();
                if (string != null) {
                    vMediaDialog.this.floppyDevTable.setImagePath(string);
                }
            } else if (object == vMediaDialog.this.cdromButton) {
                if (vMediaDialog.this.m_vMediaSession.getCDROMRedirStatus() == 0) {
                    Debug.out.println("Starting cdrom redirection");
                    vMediaDialog.this.disableAllControls();
                    boolean bl = false;
                    if (vMediaDialog.this.cdromDevTable.isImageSelected()) {
                        Debug.out.println("Starting ISO redirection " + vMediaDialog.this.cdromDevTable.getImagePath());
                        bl = vMediaDialog.this.m_vMediaSession.StartISORedir(vMediaDialog.this.m_hostIp, vMediaDialog.this.m_cdPort, vMediaDialog.this.m_useSSL, vMediaDialog.this.m_sessToken, vMediaDialog.this.cdromDevTable.getImagePath());
                    } else {
                        Debug.out.println("Starting cdrom redirection " + vMediaDialog.this.cdromDevTable.selectedDeviceString());
                        bl = vMediaDialog.this.m_vMediaSession.StartCDROMRedir(vMediaDialog.this.m_hostIp, vMediaDialog.this.m_cdPort, vMediaDialog.this.m_useSSL, vMediaDialog.this.m_sessToken, vMediaDialog.this.cdromDevTable.selectedDeviceString());
                    }
                    vMediaDialog.this.enableAllControls();
                    Debug.out.println("cdrom redirection should be running");
                    if (bl) {
                        vMediaDialog.this.updateFloppyRedirStatus();
                        vMediaDialog.this.updateCDROMRedirStatus();
                    }
                    Debug.out.println("after updating cdrom redirection status");
                } else {
                    vMediaDialog.this.m_vMediaSession.StopCDROMRedir();
                    vMediaDialog.this.updateCDROMRedirStatus();
                }
            } else if (object == vMediaDialog.this.floppyButton) {
                if (vMediaDialog.this.m_vMediaSession.getFloppyRedirStatus() == 0) {
                    Debug.out.println("Starting floppy redirection");
                    vMediaDialog.this.disableAllControls();
                    boolean bl = false;
                    if (vMediaDialog.this.floppyDevTable.isImageSelected()) {
                        Debug.out.println("Starting floppy image redirection " + vMediaDialog.this.floppyDevTable.getImagePath());
                        bl = vMediaDialog.this.m_vMediaSession.StartFloppyImageRedir(vMediaDialog.this.m_hostIp, vMediaDialog.this.m_fdPort, vMediaDialog.this.m_useSSL, vMediaDialog.this.m_sessToken, vMediaDialog.this.floppyDevTable.getImagePath());
                    } else {
                        Debug.out.println("Starting floppy redirection " + vMediaDialog.this.floppyDevTable.selectedDeviceString());
                        bl = vMediaDialog.this.m_vMediaSession.StartFloppyRedir(vMediaDialog.this.m_hostIp, vMediaDialog.this.m_fdPort, vMediaDialog.this.m_useSSL, vMediaDialog.this.m_sessToken, vMediaDialog.this.floppyDevTable.selectedDeviceString());
                    }
                    vMediaDialog.this.enableAllControls();
                    Debug.out.println("floppy redirection should be running");
                    if (bl) {
                        vMediaDialog.this.updateFloppyRedirStatus();
                        vMediaDialog.this.updateCDROMRedirStatus();
                    }
                    Debug.out.println("after updating floppy redirection status");
                } else {
                    vMediaDialog.this.m_vMediaSession.StopFloppyRedir();
                    vMediaDialog.this.updateFloppyRedirStatus();
                }
            }
        }
    }
}

