/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.hid.HeaderReader;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.hid.KVMReader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class CtrlReader
implements KVMReader {
    private static final int CTRL_MSG_BODY_SIZE = 128;
    private KVMClient m_client;
    private int m_ctrlIx;
    private ByteBuffer m_ctrlBuf;

    public CtrlReader(KVMClient kVMClient) {
        this.m_client = kVMClient;
        this.m_ctrlIx = 0;
        this.m_ctrlBuf = ByteBuffer.allocate(128);
    }

    @Override
    public void initialize() {
        this.m_ctrlIx = 0;
        this.m_ctrlBuf.clear();
        this.m_ctrlBuf.limit(this.m_client.m_pktHdr.pktSize);
        this.m_ctrlBuf.position(0);
    }

    @Override
    public int read(SocketChannel socketChannel, SSLWrapper sSLWrapper) {
        if (this.m_client.m_pktHdr.pktSize <= 0) {
            return -1;
        }
        try {
            this.m_ctrlIx = sSLWrapper != null ? (this.m_ctrlIx += sSLWrapper.GetBytes(this.m_ctrlBuf)) : (this.m_ctrlIx += socketChannel.read(this.m_ctrlBuf));
            if (this.m_client.m_pktHdr.pktSize <= this.m_ctrlIx) {
                this.m_client.m_ctrlMsg = this.m_ctrlBuf;
                this.m_client.onControlMessage();
                HeaderReader headerReader = this.m_client.getHdrReader();
                headerReader.initialize();
                this.m_client.setState(headerReader);
            }
        }
        catch (Exception exception) {
            Debug.out.println("CTRL_RDR " + exception);
            return -1;
        }
        return 0;
    }
}

