/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.iusb.FloppyRedir;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.communication.Client;
import com.ami.kvm.jviewer.communication.NWListener;
import com.ami.kvm.jviewer.communication.SSLWrapper;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.hid.CtrlReader;
import com.ami.kvm.jviewer.hid.FragNumReader;
import com.ami.kvm.jviewer.hid.FragReader;
import com.ami.kvm.jviewer.hid.HIDCtrlReader;
import com.ami.kvm.jviewer.hid.HIDHeaderReader;
import com.ami.kvm.jviewer.hid.HeaderReader;
import com.ami.kvm.jviewer.hid.KVMReader;
import com.ami.kvm.jviewer.hid.PreLoginPktReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.USBMessage;
import com.ami.kvm.jviewer.video.JVVideo;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.swing.JOptionPane;

public class KVMClient
extends Client {
    public boolean hid_invalid_flag = false;
    JViewerApp app;
    public static final int MAX_SCREEN_WIDTH = 1500;
    public static final int MAX_SCREEN_HEIGHT = 1500;
    public static final int MAX_FRAGMENT_SIZE = 4500000;
    public IVTPPktHdr m_pktPreLoginHdr = null;
    public IVTPPktHdr m_pktHdr;
    public IVTPPktHdr m_HIDpktHdr;
    public short m_fragNum;
    public ByteBuffer m_ctrlMsg;
    public ByteBuffer m_HIDctrlMsg;
    private HeaderReader m_hdrReader;
    private FragNumReader m_fragNumReader;
    private FragReader m_fragReader;
    private CtrlReader m_ctrlReader;
    private HIDHeaderReader m_HIDhdrReader;
    private HIDCtrlReader m_HIDctrlReader;
    private KVMReader m_reader;
    private KVMReader m_HIDreader;
    private JVVideo m_vidClnt;
    private NWListener m_NWListener;
    private volatile Thread m_NWThread;
    private boolean m_redirection = false;
    public static final int INVALID_SESSION = 0;
    public static final int VALID_SESSION = 0;
    public static final int STOP_SESSION_IMMEDIATE = 2;
    public static final int INVALID_VIDEO_SESSION_TOKEN = 3;
    public static final int INVALID_CDROM_SESSION_TOKEN = 4;
    public static final int INVALID_FLOPPY_SESSION_TOKEN = 5;
    private boolean m_bUseSSL = false;
    private boolean m_bHIDUseSSL = true;
    static int count = 0;

    public KVMClient(byte[] byArray, int n, int n2, JVVideo jVVideo, boolean bl, JViewerApp jViewerApp) {
        super(byArray, n, n2);
        this.app = jViewerApp;
        this.m_vidClnt = jVVideo;
        this.m_hdrReader = new HeaderReader(this);
        this.m_fragNumReader = new FragNumReader(this);
        this.m_fragReader = new FragReader(this);
        this.m_ctrlReader = new CtrlReader(this);
        this.m_HIDhdrReader = new HIDHeaderReader(this);
        this.m_HIDctrlReader = new HIDCtrlReader(this);
        this.m_bUseSSL = bl;
        this.m_reader = this.m_hdrReader;
        this.m_HIDreader = this.m_HIDhdrReader;
        this.ssl_wrapper = null;
        this.HIDssl_wrapper = null;
    }

    @Override
    public void onReadEvent() {
        if (this.ssl_wrapper != null) {
            if (this.ssl_wrapper.GetBytesRemaining() == 0) {
                try {
                    this.ssl_wrapper.resetReadBuffer();
                    if (this.ssl_wrapper.read() != 0) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    Debug.out.println("Error while doing ssl_wrapper read\n" + iOException);
                }
            }
            while (this.ssl_wrapper.GetBytesRemaining() > 0) {
                this.m_reader.read(this.m_sockCh, this.ssl_wrapper);
            }
        } else {
            this.m_reader.read(this.m_sockCh, null);
        }
    }

    @Override
    public void onHIDReadEvent() {
        if (this.HIDssl_wrapper != null) {
            if (this.HIDssl_wrapper.GetBytesRemaining() == 0) {
                try {
                    this.HIDssl_wrapper.resetReadBuffer();
                    if (this.HIDssl_wrapper.read() != 0) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    Debug.out.println("Error while doing ssl_wrapper read\n" + iOException);
                }
            }
            while (this.HIDssl_wrapper.GetBytesRemaining() > 0 && !this.hid_invalid_flag) {
                this.m_HIDreader.read(this.m_HIDsockCh, this.HIDssl_wrapper);
            }
        } else {
            if (this.m_HIDsockCh == null) {
                Debug.out.println("m_HIDsockCh is null!!!!!");
            }
            this.m_HIDreader.read(this.m_HIDsockCh, null);
        }
    }

    public void setState(KVMReader kVMReader) {
        this.m_reader = kVMReader;
    }

    public void setHIDState(KVMReader kVMReader) {
        this.m_HIDreader = kVMReader;
    }

    public HeaderReader getHdrReader() {
        return this.m_hdrReader;
    }

    public HIDHeaderReader getHIDHdrReader() {
        return this.m_HIDhdrReader;
    }

    public FragNumReader getFragNumReader() {
        return this.m_fragNumReader;
    }

    public FragReader getFragReader() {
        return this.m_fragReader;
    }

    public CtrlReader getCtrlReader() {
        return this.m_ctrlReader;
    }

    public HIDCtrlReader getHIDCtrlReader() {
        return this.m_HIDctrlReader;
    }

    public void onNewFrame(ByteBuffer byteBuffer) {
        this.m_vidClnt.onNewFrame(byteBuffer);
    }

    public void onHIDPacket() {
        switch (this.m_HIDpktHdr.type) {
            case 10: {
                Debug.out.println("*** Get Mouse Mode Response");
                this.m_HIDctrlMsg.flip();
                this.app.OnGetMouseMode(this.m_HIDpktHdr.status(), this.m_HIDctrlMsg.get());
                break;
            }
            default: {
                short s = this.m_HIDpktHdr.status();
                System.out.println("*** HID Invalid packet: Packet Type:" + this.m_HIDpktHdr.type + ", status = " + s + ",count = " + count++);
                this.app.OnVideoStopRedirection();
                this.app.OnSessionStopCmd((short)0);
                this.hid_invalid_flag = true;
            }
        }
    }

    public void onControlMessage() {
        switch (this.m_pktHdr.type) {
            case 8: {
                Debug.out.println("*** Blank screen");
                this.m_vidClnt.onBlankScreen(this.m_pktHdr.status);
                break;
            }
            case 9: {
                Debug.out.println("*** Stop session");
                this.app.OnVideoStopRedirection();
                this.app.OnSessionStopCmd(this.m_pktHdr.status);
                break;
            }
            case 31: {
                Debug.out.println("PRELOGIN PACKET in control mesasge????");
                break;
            }
            case 33: {
                this.send_KeepAlive_pkt();
                break;
            }
            default: {
                System.out.println("*** Video Invalid packet " + this.m_pktHdr.type);
                if (this.app.isPanelMode()) break;
                System.exit(0);
            }
        }
    }

    public boolean redirection() {
        return this.m_redirection;
    }

    public int startRedirection() {
        String string;
        Object object;
        if (this.m_redirection) {
            return 0;
        }
        try {
            if (-1 == this.connect()) {
                return -1;
            }
        }
        catch (IOException iOException) {
            Debug.out.println("Failed to establish connection");
        }
        Debug.out.println("Video socket connected");
        if (this.m_bUseSSL) {
            this.ssl_wrapper = new SSLWrapper(this.m_sockCh);
            try {
                object = this.ssl_wrapper.initSSL();
                if (object != null) {
                    this.app.OnVideoStopRedirection();
                    JOptionPane.showMessageDialog(this.app.getRCView(), object, LocaleStrings.GetString("A_1_GLOBAL"), 0);
                    if (!this.app.isPanelMode()) {
                        System.exit(0);
                    }
                    return -1;
                }
            }
            catch (IOException iOException) {
                this.app.OnVideoStopRedirection();
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_1_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
                if (!this.app.isPanelMode()) {
                    System.exit(0);
                }
                return -1;
            }
        }
        object = new PreLoginPktReader(this);
        ((PreLoginPktReader)object).initialize();
        if (((PreLoginPktReader)object).readPreLoginPkt(this.m_sockCh, this.ssl_wrapper) != 0) {
            this.app.OnVideoStopRedirection();
            JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_2_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            if (!this.app.isPanelMode()) {
                System.exit(0);
            }
            return -1;
        }
        if (this.m_pktPreLoginHdr.status != 0) {
            this.app.OnVideoStopRedirection();
            if (this.m_pktPreLoginHdr.status == 1) {
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_3_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            } else {
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_4_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            }
            if (!this.app.isPanelMode()) {
                System.exit(0);
            }
            return -1;
        }
        Debug.out.println("Video socket approval received");
        try {
            if (-1 == this.HIDconnect()) {
                this.m_sockCh.close();
                return -1;
            }
        }
        catch (IOException iOException) {
            Debug.out.println("Failed to establish connection");
        }
        Debug.out.println("HID socket connected");
        if (this.m_bHIDUseSSL) {
            this.HIDssl_wrapper = new SSLWrapper(this.m_HIDsockCh);
            try {
                string = this.HIDssl_wrapper.initSSL();
                if (string != null) {
                    this.app.OnVideoStopRedirection();
                    JOptionPane.showMessageDialog(this.app.getRCView(), string, LocaleStrings.GetString("A_1_GLOBAL"), 0);
                    if (!this.app.isPanelMode()) {
                        System.exit(0);
                    }
                    return -1;
                }
            }
            catch (IOException iOException) {
                this.app.OnVideoStopRedirection();
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_5_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
                if (!this.app.isPanelMode()) {
                    System.exit(0);
                }
                return -1;
            }
        }
        Debug.out.println("Waiting for HID approval packet");
        ((PreLoginPktReader)object).initialize();
        if (((PreLoginPktReader)object).readPreLoginPkt(this.m_HIDsockCh, this.HIDssl_wrapper) != 0) {
            this.app.OnVideoStopRedirection();
            JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_6_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            if (!this.app.isPanelMode()) {
                System.exit(0);
            }
            return -1;
        }
        Debug.out.println("Checking HID approval status");
        if (this.m_pktPreLoginHdr.status != 0) {
            this.app.OnVideoStopRedirection();
            if (this.m_pktPreLoginHdr.status == 1) {
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_3_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            } else {
                JOptionPane.showMessageDialog(this.app.getRCView(), LocaleStrings.GetString("2_4_KVMCLIENT"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            }
            if (!this.app.isPanelMode()) {
                System.exit(0);
            }
            return -1;
        }
        Debug.out.println("HID approval received successfully");
        this.m_NWListener = new NWListener();
        if (-1 == this.m_NWListener.addChannels(this)) {
            return -1;
        }
        this.m_NWThread = new Thread((Runnable)this.m_NWListener, "listener");
        this.m_NWListener.startListener();
        this.m_NWThread.start();
        string = new String("zyxwvutsr02938");
        if (Debug.out.isInDebugMode()) {
            IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(2, 0, 0);
            if (iVTPPktHdr.size() != this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size())) {
                Debug.out.println("Failed to send Start Redirection message");
                return -1;
            }
            this.OnValidVideoSession();
        } else {
            IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(12, 99, 0);
            String string2 = this.app.getSessionToken();
            ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + 99);
            byteBuffer.position(0);
            byteBuffer.put(iVTPPktHdr.array());
            byteBuffer.put((byte)0);
            byteBuffer.put(string2.getBytes());
            for (int k = byteBuffer.position(); k < byteBuffer.limit(); ++k) {
                byteBuffer.put((byte)0);
            }
            byteBuffer.position(0);
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            if (byArray.length != this.sendMessage(byArray, byArray.length)) {
                Debug.out.println("Failed to send Session token to the card");
                return -1;
            }
            this.OnValidVideoSession();
        }
        return 0;
    }

    public int OnValidVideoSession() {
        this.m_redirection = true;
        return 0;
    }

    public void stopRedirection() {
        if (!this.m_redirection) {
            return;
        }
        this.m_NWListener.removeChannels(this);
        this.close();
        this.m_NWListener.destroyListener();
        this.m_redirection = false;
        this.m_vidClnt.reset();
        this.m_reader = this.m_hdrReader;
        this.m_reader.initialize();
        this.m_HIDreader = this.m_HIDhdrReader;
        this.m_HIDreader.initialize();
    }

    public int sendKMMessage(USBMessage uSBMessage) {
        if (this.m_redirection) {
            byte[] byArray = uSBMessage.report();
            this.sendHIDMessage(byArray, byArray.length);
        }
        return 0;
    }

    public int send_keybd_led_sync_pkt(byte by) {
        FloppyRedir floppyRedir = new FloppyRedir(true, this.app);
        byte by2 = floppyRedir.ReadKeybdLEDStatus();
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(15, 2, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(by);
        byteBuffer.put(by2);
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (byArray.length != this.sendHIDMessage(byArray, byArray.length)) {
            Debug.out.println("Failed to send LED status packet to the card");
            return -1;
        }
        return 0;
    }

    public int send_color_mode_pkt(byte by) {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(11, 1, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.put(by);
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (byArray.length != this.sendMessage(byArray, byArray.length)) {
            Debug.out.println("Failed to send color mode packet to the card");
            return -1;
        }
        return 0;
    }

    public int sendPauseVideo() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(6, 0, 0);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return 1;
        }
        return 0;
    }

    public int sendResumeVideo() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(7, 0, 0);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return 1;
        }
        return 0;
    }

    public int sendRefreshVideo() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(5, 0, 0);
        if (this.sendMessage(iVTPPktHdr.array(), iVTPPktHdr.size()) != iVTPPktHdr.size()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean IsVideoDataAvailable() {
        return this.ssl_wrapper != null && this.ssl_wrapper.GetBytesRemaining() > 0;
    }

    @Override
    public boolean IsHIDDataAvailable() {
        return this.HIDssl_wrapper != null && this.HIDssl_wrapper.GetBytesRemaining() > 0;
    }

    public int send_KeepAlive_pkt() {
        IVTPPktHdr iVTPPktHdr = new IVTPPktHdr(34, 0, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(iVTPPktHdr.size() + iVTPPktHdr.pktSize());
        byteBuffer.position(0);
        byteBuffer.put(iVTPPktHdr.array());
        byteBuffer.position(0);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        if (byArray.length != this.sendMessage(byArray, byArray.length)) {
            Debug.out.println("Failed to Keep Alive packet to the card");
            return -1;
        }
        return 0;
    }
}

