/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.kvmpkts.KeyProcessor;
import java.awt.event.KeyEvent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class USBKeyProcessor
implements KeyProcessor {
    protected HashMap<Integer, Integer> standardMap = new HashMap();
    protected HashMap<Integer, Integer> keypadMap = new HashMap();
    protected HashMap<Integer, Integer> leftMap = new HashMap();
    protected HashMap<Integer, Integer> rightMap = new HashMap();
    private static byte modifiers = 0;
    private boolean autoKeybreakModeOn = false;
    static final int USB_KEYBOARD_REPORT_SIZE = 8;
    public static USBKeyProcessor instance = new USBKeyProcessor();

    public USBKeyProcessor() {
        this.standardMap.put(65, 4);
        this.standardMap.put(66, 5);
        this.standardMap.put(67, 6);
        this.standardMap.put(68, 7);
        this.standardMap.put(69, 8);
        this.standardMap.put(70, 9);
        this.standardMap.put(71, 10);
        this.standardMap.put(72, 11);
        this.standardMap.put(73, 12);
        this.standardMap.put(74, 13);
        this.standardMap.put(75, 14);
        this.standardMap.put(76, 15);
        this.standardMap.put(77, 16);
        this.standardMap.put(78, 17);
        this.standardMap.put(79, 18);
        this.standardMap.put(80, 19);
        this.standardMap.put(81, 20);
        this.standardMap.put(82, 21);
        this.standardMap.put(83, 22);
        this.standardMap.put(84, 23);
        this.standardMap.put(85, 24);
        this.standardMap.put(86, 25);
        this.standardMap.put(87, 26);
        this.standardMap.put(88, 27);
        this.standardMap.put(89, 28);
        this.standardMap.put(90, 29);
        this.standardMap.put(49, 30);
        this.standardMap.put(50, 31);
        this.standardMap.put(51, 32);
        this.standardMap.put(52, 33);
        this.standardMap.put(53, 34);
        this.standardMap.put(54, 35);
        this.standardMap.put(55, 36);
        this.standardMap.put(56, 37);
        this.standardMap.put(57, 38);
        this.standardMap.put(48, 39);
        this.standardMap.put(10, 40);
        this.standardMap.put(27, 41);
        this.standardMap.put(8, 42);
        this.standardMap.put(9, 43);
        this.standardMap.put(32, 44);
        this.standardMap.put(45, 45);
        this.standardMap.put(61, 46);
        this.standardMap.put(91, 47);
        this.standardMap.put(93, 48);
        this.standardMap.put(92, 49);
        this.standardMap.put(59, 51);
        this.standardMap.put(222, 52);
        this.standardMap.put(192, 53);
        this.standardMap.put(44, 54);
        this.standardMap.put(46, 55);
        this.standardMap.put(47, 56);
        this.standardMap.put(20, 57);
        this.standardMap.put(112, 58);
        this.standardMap.put(113, 59);
        this.standardMap.put(114, 60);
        this.standardMap.put(115, 61);
        this.standardMap.put(116, 62);
        this.standardMap.put(117, 63);
        this.standardMap.put(118, 64);
        this.standardMap.put(119, 65);
        this.standardMap.put(120, 66);
        this.standardMap.put(121, 67);
        this.standardMap.put(122, 68);
        this.standardMap.put(123, 69);
        this.standardMap.put(154, 70);
        this.standardMap.put(145, 71);
        this.standardMap.put(19, 72);
        this.standardMap.put(155, 73);
        this.standardMap.put(36, 74);
        this.standardMap.put(33, 75);
        this.standardMap.put(127, 76);
        this.standardMap.put(35, 77);
        this.standardMap.put(34, 78);
        this.standardMap.put(39, 79);
        this.standardMap.put(37, 80);
        this.standardMap.put(40, 81);
        this.standardMap.put(38, 82);
        this.keypadMap.put(144, 83);
        this.keypadMap.put(111, 84);
        this.keypadMap.put(106, 85);
        this.keypadMap.put(109, 86);
        this.keypadMap.put(107, 87);
        this.keypadMap.put(10, 88);
        this.keypadMap.put(97, 89);
        this.keypadMap.put(35, 89);
        this.keypadMap.put(98, 90);
        this.keypadMap.put(40, 90);
        this.keypadMap.put(99, 91);
        this.keypadMap.put(34, 91);
        this.keypadMap.put(100, 92);
        this.keypadMap.put(37, 92);
        this.keypadMap.put(101, 93);
        this.keypadMap.put(65368, 93);
        this.keypadMap.put(102, 94);
        this.keypadMap.put(39, 94);
        this.keypadMap.put(103, 95);
        this.keypadMap.put(36, 95);
        this.keypadMap.put(104, 96);
        this.keypadMap.put(38, 96);
        this.keypadMap.put(105, 97);
        this.keypadMap.put(33, 97);
        this.keypadMap.put(96, 98);
        this.keypadMap.put(155, 98);
        this.keypadMap.put(110, 99);
        this.keypadMap.put(127, 99);
        this.keypadMap.put(61, 103);
        this.standardMap.put(61440, 104);
        this.standardMap.put(61441, 105);
        this.standardMap.put(61442, 106);
        this.standardMap.put(61443, 107);
        this.standardMap.put(61444, 108);
        this.standardMap.put(61445, 109);
        this.standardMap.put(61446, 110);
        this.standardMap.put(61447, 111);
        this.standardMap.put(61448, 112);
        this.standardMap.put(61449, 113);
        this.standardMap.put(61450, 114);
        this.standardMap.put(61451, 115);
        this.standardMap.put(156, 117);
        this.standardMap.put(65480, 120);
        this.standardMap.put(65481, 121);
        this.standardMap.put(65483, 122);
        this.standardMap.put(65489, 123);
        this.standardMap.put(65485, 124);
        this.standardMap.put(65487, 125);
        this.standardMap.put(65488, 126);
        this.standardMap.put(261, 135);
        this.standardMap.put(241, 136);
        this.standardMap.put(242, 136);
        this.standardMap.put(259, 136);
        this.standardMap.put(260, 136);
        this.standardMap.put(262, 136);
        this.standardMap.put(256, 138);
        this.standardMap.put(257, 138);
        this.standardMap.put(243, 141);
        this.standardMap.put(1000, 137);
        this.standardMap.put(1001, 50);
        this.standardMap.put(1002, 100);
        this.standardMap.put(1003, 135);
        this.standardMap.put(514, 46);
        this.standardMap.put(92, 137);
        this.standardMap.put(513, 52);
        this.standardMap.put(91, 48);
        this.standardMap.put(93, 50);
        this.standardMap.put(512, 47);
        this.standardMap.put(92, 137);
        this.standardMap.put(3, 155);
        this.standardMap.put(12, 156);
        this.standardMap.put(108, 159);
        this.leftMap.put(17, 224);
        this.leftMap.put(16, 225);
        this.leftMap.put(18, 226);
        this.leftMap.put(524, 227);
        this.rightMap.put(17, 228);
        this.rightMap.put(16, 229);
        this.rightMap.put(18, 230);
        this.rightMap.put(524, 231);
    }

    public static USBKeyProcessor getInstance() {
        return instance;
    }

    public void toEnglishKeyboard() {
        this.standardMap.put(514, 46);
        this.standardMap.put(92, 49);
        this.standardMap.put(513, 52);
        this.standardMap.put(91, 47);
        this.standardMap.put(93, 48);
        this.standardMap.put(512, 47);
    }

    public void toJapanKeyboard() {
        this.standardMap.put(514, 46);
        this.standardMap.put(92, 137);
        this.standardMap.put(513, 52);
        this.standardMap.put(91, 48);
        this.standardMap.put(93, 50);
        this.standardMap.put(512, 47);
    }

    @Override
    public void setAutoKeybreakMode(boolean bl) {
        this.autoKeybreakModeOn = bl;
    }

    @Override
    public boolean getAutoKeybreakMode() {
        return this.autoKeybreakModeOn;
    }

    public byte getModifiers() {
        return modifiers;
    }

    @Override
    public byte[] convertKeyCode(int n, int n2, boolean bl) {
        Integer n3 = new Integer(0);
        byte[] byArray = new byte[6];
        boolean bl2 = false;
        switch (n2) {
            case 2: {
                n3 = this.leftMap.get(n);
                break;
            }
            case 4: {
                n3 = this.keypadMap.get(n);
                break;
            }
            case 3: {
                n3 = this.rightMap.get(n);
                break;
            }
            case 1: {
                n3 = this.standardMap.get(n);
                break;
            }
            case 0: {
                System.err.println("Key located in unknown position");
                break;
            }
            default: {
                System.err.println("Unknown key position value");
            }
        }
        if (n3 != null) {
            switch (n) {
                case 17: {
                    if (n2 == 2) {
                        if (bl) {
                            modifiers = (byte)(modifiers | 1);
                            break;
                        }
                        modifiers = (byte)(modifiers & 0xFFFFFFFE);
                        break;
                    }
                    if (bl) {
                        modifiers = (byte)(modifiers | 0x10);
                        break;
                    }
                    modifiers = (byte)(modifiers & 0xFFFFFFEF);
                    break;
                }
                case 16: {
                    if (n2 == 2) {
                        if (bl) {
                            modifiers = (byte)(modifiers | 2);
                            break;
                        }
                        modifiers = (byte)(modifiers & 0xFFFFFFFD);
                        break;
                    }
                    if (bl) {
                        modifiers = (byte)(modifiers | 0x20);
                        break;
                    }
                    modifiers = (byte)(modifiers & 0xFFFFFFDF);
                    break;
                }
                case 18: {
                    if (n2 == 2) {
                        if (bl) {
                            modifiers = (byte)(modifiers | 4);
                            break;
                        }
                        modifiers = (byte)(modifiers & 0xFFFFFFFB);
                        break;
                    }
                    if (bl) {
                        modifiers = (byte)(modifiers | 0x40);
                        break;
                    }
                    modifiers = (byte)(modifiers & 0xFFFFFFBF);
                    break;
                }
                case 524: {
                    if (n2 == 2) {
                        if (bl) {
                            modifiers = (byte)(modifiers | 8);
                            break;
                        }
                        modifiers = (byte)(modifiers & 0xFFFFFFF7);
                        break;
                    }
                    if (bl) {
                        modifiers = (byte)(modifiers | 0x80);
                        break;
                    }
                    modifiers = (byte)(modifiers & 0xFFFFFF7F);
                    break;
                }
                default: {
                    if (bl) {
                        byArray[0] = n3.byteValue();
                        if (!this.autoKeybreakModeOn) break;
                        bl2 = true;
                        break;
                    }
                    if (!this.autoKeybreakModeOn || n == 144 || n == 20 || n == 145) {
                        byArray[0] = 0;
                        break;
                    }
                    return null;
                }
            }
            return this.USBKeyboardRepPkt(byArray, modifiers, bl2);
        }
        System.err.println("Unknown keycode for key: " + KeyEvent.getKeyText(n));
        return null;
    }

    public byte[] USBKeyboardRepPkt(byte[] byArray, byte by, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(by);
        byteBuffer.put(bl ? (byte)1 : 0);
        byteBuffer.put(byArray);
        return byteBuffer.array();
    }
}

