/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.video;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.kvmpkts.FrameHdr;
import com.ami.kvm.jviewer.video.VSCDecoder;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class JVVideo {
    JViewerApp app;
    public static final int MAX_X_RESOLUTION = 1500;
    public static final int MAX_Y_RESOLUTION = 1500;
    public static final int STATUS_BLANK_SCREEN_NORMAL = 0;
    public static final int STATUS_BLANK_SCREEN_POWER_OFF = 1;
    public static final int STATUS_BLANK_SCREEN_IN_POST = 2;
    private Timer m_frTmr;
    private int m_frameRate;
    private JViewerView m_view;
    private short[] m_ImageBuff_USHORT;
    private byte[] m_ImageBuff_BYTE;
    private FrameHdr m_frameHdr;
    private ByteBuffer m_qcompByteBuf;
    static int frame_count = 0;
    Vector<Rectangle> m_RegionVector;
    public short[] m_LRLEBuff_USHORT;
    public byte[] m_LRLEBuff_BYTE;
    public boolean m_IsHostPoweredOff = false;
    public boolean m_IsPostEntered = false;
    public boolean firsttime = true;

    public JVVideo(JViewerApp jViewerApp) {
        this.app = jViewerApp;
        this.m_view = jViewerApp.getRCView();
        this.m_ImageBuff_USHORT = this.m_view.imageMemory();
        this.m_ImageBuff_BYTE = this.m_view.imageMemory_ByteArray();
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        byte[] byArray = new byte[4500000];
        this.m_qcompByteBuf = ByteBuffer.wrap(byArray);
        this.m_frameRate = 0;
        this.m_frTmr = new Timer();
        this.m_frTmr.schedule((TimerTask)new FrameRateTask(), 0L, 1000L);
        this.m_LRLEBuff_USHORT = new short[2250000];
        this.m_LRLEBuff_BYTE = new byte[2250000];
        this.m_RegionVector = new Vector();
    }

    public void onNewFrame(ByteBuffer byteBuffer) {
        ++this.m_frameRate;
        this.m_frameHdr = FrameHdr.set(byteBuffer);
        this.setM_frameHdr(this.m_frameHdr);
        int n = this.m_frameHdr.resY % 16;
        if (n != 0) {
            n = 16 - n;
        }
        this.m_frameHdr.resY = (short)(this.m_frameHdr.resY + n);
        if (this.firsttime) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n2 = this.m_frameHdr.resY;
            short s = this.m_frameHdr.resX;
            if (n2 == 608) {
                n2 = 600;
            }
            if (dimension.height == n2 && dimension.width == s) {
                this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
            } else {
                if (this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                    this.app.OnVideoFullScreen(false);
                }
                this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
            }
            this.firsttime = false;
        }
        if (this.m_view.viewWidth() != this.m_frameHdr.resX || this.m_view.viewHeight() != this.m_frameHdr.resY || this.m_view.m_current_color_mode != this.m_frameHdr.color_mode) {
            this.onResolutionChange();
        }
        this.m_RegionVector.clear();
        VSCDecoder.UnCompress(this.m_ImageBuff_USHORT, this.m_ImageBuff_BYTE, this.m_LRLEBuff_USHORT, this.m_LRLEBuff_BYTE, byteBuffer, this.m_frameHdr, this.m_RegionVector);
        if (n != 0) {
            for (int k = 0; k < this.m_RegionVector.size(); ++k) {
                Rectangle rectangle = this.m_RegionVector.get(k);
                if (rectangle != null && rectangle.y + rectangle.height > this.m_frameHdr.resY - n) {
                    if (this.m_frameHdr.color_mode == 8) {
                        Arrays.fill(this.m_ImageBuff_USHORT, this.m_frameHdr.resX * (this.m_frameHdr.resY - n), this.m_frameHdr.resX * this.m_frameHdr.resY - 1, (short)0);
                    } else {
                        Arrays.fill(this.m_ImageBuff_BYTE, this.m_frameHdr.resX * (this.m_frameHdr.resY - n), this.m_frameHdr.resX * this.m_frameHdr.resY - 1, (byte)0);
                    }
                    rectangle.height = n + 4;
                }
                this.m_view.repaint(rectangle);
            }
        } else {
            for (int k = 0; k < this.m_RegionVector.size(); ++k) {
                this.m_view.repaint(this.m_RegionVector.get(k));
            }
        }
        this.m_RegionVector.clear();
    }

    public void onResolutionChange() {
        Debug.out.println("Resolution change " + this.m_frameHdr.resX + ":" + this.m_frameHdr.resY);
        this.m_view.setRCView(this.m_frameHdr.resX, this.m_frameHdr.resY, this.m_frameHdr.color_mode);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.m_frameHdr.resY;
        short s = this.m_frameHdr.resX;
        if (n == 608) {
            n = 600;
        }
        if (dimension.height == n && dimension.width == s) {
            this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
        } else {
            if (this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                this.app.OnVideoFullScreen(false);
            }
            this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
        }
        if (dimension.height > this.m_frameHdr.resY || dimension.width > this.m_frameHdr.resX || dimension.height <= this.m_frameHdr.resY || dimension.width <= this.m_frameHdr.resX) {
            // empty if block
        }
        this.m_ImageBuff_USHORT = this.m_view.imageMemory();
        this.m_ImageBuff_BYTE = this.m_view.imageMemory_ByteArray();
        if (this.m_ImageBuff_BYTE != null) {
            Debug.out.println("image array byte length " + this.m_ImageBuff_BYTE.length);
        }
        System.gc();
    }

    public void onBlankScreen(short s) {
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        this.m_view.repaint();
        if (s == 2) {
            this.m_IsPostEntered = true;
        } else if (s == 1) {
            this.m_IsHostPoweredOff = true;
        } else {
            this.m_IsHostPoweredOff = false;
            this.m_IsPostEntered = false;
        }
    }

    public void reset() {
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        this.m_view.repaint();
        this.m_frTmr.cancel();
        this.app.setAppWndLabel("0 fps");
    }

    public FrameHdr getM_frameHdr() {
        return this.m_frameHdr;
    }

    public void setM_frameHdr(FrameHdr frameHdr) {
        this.m_frameHdr = frameHdr;
    }

    public void clearBuffer() {
        this.m_ImageBuff_USHORT = null;
        this.m_ImageBuff_BYTE = null;
        this.m_LRLEBuff_USHORT = null;
        this.m_LRLEBuff_BYTE = null;
        if (this.m_qcompByteBuf != null) {
            this.m_qcompByteBuf.clear();
            this.m_qcompByteBuf = null;
        }
    }

    class FrameRateTask
    extends TimerTask {
        Dimension Client_System_prev;

        FrameRateTask() {
        }

        @Override
        public void run() {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.Client_System_prev == null) {
                this.Client_System_prev = dimension;
            }
            if (dimension.width != this.Client_System_prev.width || dimension.height != this.Client_System_prev.height) {
                Debug.out.println("Resolution change in client");
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = ((JVVideo)JVVideo.this).m_frameHdr.resY;
                short s = ((JVVideo)JVVideo.this).m_frameHdr.resX;
                if (n == 608) {
                    n = 600;
                }
                if (dimension2.height == n && dimension2.width == s) {
                    JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
                } else {
                    if (JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                        JVVideo.this.app.OnVideoFullScreen(false);
                    }
                    JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
                }
                if (dimension.height > ((JVVideo)JVVideo.this).m_frameHdr.resY || dimension.width > ((JVVideo)JVVideo.this).m_frameHdr.resX || dimension.height <= ((JVVideo)JVVideo.this).m_frameHdr.resY || dimension.width <= ((JVVideo)JVVideo.this).m_frameHdr.resX) {
                    // empty if block
                }
            }
            this.Client_System_prev = dimension;
            if (JVVideo.this.m_frameRate == 0) {
                if (!JVVideo.this.m_IsPostEntered && JVVideo.this.m_IsHostPoweredOff) {
                    // empty if block
                }
            } else {
                JVVideo.this.app.setAppWndLabel(JVVideo.this.m_frameRate + " fps");
                JVVideo.this.m_IsHostPoweredOff = false;
                JVVideo.this.m_IsPostEntered = false;
            }
            JVVideo.this.m_frameRate = 0;
        }
    }
}

