/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import com.borland.jbcl.layout.PaneConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class PaneNode
implements Serializable {
    transient Component childComponent;
    String name;
    PaneNode childNodeA;
    PaneNode childNodeB;
    Rectangle location = new Rectangle();
    float widthDivide;
    float heightDivide;
    int xOffset;
    int yOffset;
    boolean horizontal;
    boolean reverse = false;

    public PaneNode(String childName, Component child, String position) {
        this.childComponent = child;
        this.name = childName;
        this.widthDivide = 1.0f;
        this.heightDivide = 0.5f;
        this.horizontal = position.equals("Top") || position.equals("Bottom");
        this.reverse = position.equals("Top") || position.equals("Left");
    }

    public PaneNode(PaneNode childA, PaneNode childB, String position, float proportion) {
        this.childNodeA = childA;
        this.childNodeB = childB;
        if (position.equals("Top") || position.equals("Bottom")) {
            this.widthDivide = 1.0f;
            this.heightDivide = proportion;
            this.horizontal = true;
        } else {
            this.widthDivide = proportion;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        }
        this.reverse = position.equals("Top") || position.equals("Left");
    }

    void dump() {
    }

    public void setConstraints(Component child, PaneConstraints constraints) {
        if (this.childComponent != null) {
            return;
        }
        this.reverse = constraints.position.equals("Top") || constraints.position.equals("Left");
        if (constraints.position.equals("Bottom")) {
            this.heightDivide = 1.0f - constraints.proportion;
            this.widthDivide = 1.0f;
            this.horizontal = true;
        } else if (constraints.position.equals("Top")) {
            this.heightDivide = 1.0f - constraints.proportion;
            this.widthDivide = 1.0f;
            this.horizontal = true;
        } else if (constraints.position.equals("Right")) {
            this.widthDivide = 1.0f - constraints.proportion;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        } else if (constraints.position.equals("Left")) {
            this.widthDivide = 1.0f - constraints.proportion;
            this.heightDivide = 1.0f;
            this.horizontal = false;
        }
    }

    public void addChild(String childName, Component child, String position, float proportion) {
        if (this.childComponent != null) {
            this.childNodeA = new PaneNode(this.name, this.childComponent, "Root");
            this.childComponent = null;
            this.name = null;
            this.childNodeB = new PaneNode(childName, child, "Root");
            if ((proportion = 1.0f - proportion) > 1.0f || proportion < 0.0f) {
                proportion = 0.5f;
            }
            if (position == null) {
                position = this.horizontal ? "Right" : "Bottom";
            } else if (position.equals("Right") || position.equals("Bottom")) {
                this.reverse = false;
            } else {
                this.reverse = true;
                if (!(position.equals("Left") || position.equals("Top") || position.equals("Root"))) {
                    proportion = 0.5f;
                }
            }
            if (position.equals("Left") || position.equals("Right")) {
                this.widthDivide = proportion;
                this.heightDivide = 1.0f;
                this.horizontal = false;
            } else {
                this.widthDivide = 1.0f;
                this.heightDivide = proportion;
                this.horizontal = true;
            }
        } else {
            position = this.horizontal ? "Right" : "Bottom";
            this.childNodeB.addChild(childName, child, position, proportion);
        }
    }

    public boolean addChildSplit(String childName, String splitComponent, String position, Component newComponent, float proportion) {
        if (this.childComponent != null) {
            if (this.name != null) {
                if (this.name.equals(splitComponent)) {
                    this.addChild(childName, newComponent, position, proportion);
                    return true;
                }
                return false;
            }
        } else {
            if (!this.childNodeA.addChildSplit(childName, splitComponent, position, newComponent, proportion)) {
                return this.childNodeB.addChildSplit(childName, splitComponent, position, newComponent, proportion);
            }
            return true;
        }
        return false;
    }

    public Dimension getPreferredSize(int gap) {
        Dimension d2 = null;
        try {
            if (this.childComponent != null) {
                d2 = this.childComponent.getPreferredSize();
                return d2;
            }
            Dimension a2 = this.childNodeA.getPreferredSize(gap);
            Dimension b2 = this.childNodeB.getPreferredSize(gap);
            float divisor = this.widthDivide;
            if (!this.horizontal) {
                if ((double)divisor >= 0.999) {
                    d2 = a2;
                }
                d2 = (double)divisor == 0.0 ? b2 : new Dimension((int)Math.max((double)((float)a2.width / divisor), (double)b2.width / (1.0 - (double)divisor)), Math.max(a2.height, b2.height));
                d2.width += gap + gap + 1;
            } else {
                divisor = this.heightDivide;
                d2 = (double)divisor >= 0.999 ? a2 : ((double)divisor == 0.0 ? b2 : new Dimension(Math.max(a2.width, b2.width), (int)Math.max((double)((float)a2.height / divisor), (double)b2.height / (1.0 - (double)divisor))));
                d2.height += gap + gap + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    public String getNodeAComponent() {
        if (this.childComponent != null) {
            return this.name;
        }
        return this.childNodeA.getNodeAComponent();
    }

    public PaneNode getImmediateParent(Component child) {
        if (this.childComponent != null) {
            if (this.childComponent == child) {
                return this;
            }
            return null;
        }
        if (this.childNodeA.childComponent == child) {
            return this;
        }
        if (this.childNodeB.childComponent == child) {
            return this;
        }
        PaneNode rc = this.childNodeA.getImmediateParent(child);
        if (rc != null) {
            return rc;
        }
        return this.childNodeB.getImmediateParent(child);
    }

    void getComponents(Point subscript, String[] componentArray, boolean parentIsNodeB) {
        if (this.childComponent == null) {
            if (parentIsNodeB) {
                componentArray[subscript.x] = this.childNodeA.getNodeAComponent();
                ++subscript.x;
            }
            componentArray[subscript.x] = this.childNodeB.getNodeAComponent();
            ++subscript.x;
            this.childNodeA.getComponents(subscript, componentArray, false);
            this.childNodeB.getComponents(subscript, componentArray, false);
        }
    }

    public PaneNode getParentNode(Component child, PaneNode lastBNode) {
        if (this.childComponent != null) {
            if (this.childComponent == child) {
                return this;
            }
            return null;
        }
        if (this.childNodeA.childComponent == child) {
            if (lastBNode != null) {
                return lastBNode;
            }
            return this.childNodeA;
        }
        if (this.childNodeB.childComponent == child) {
            return this;
        }
        PaneNode resultA = this.childNodeA.getParentNode(child, lastBNode);
        if (resultA != null) {
            return resultA;
        }
        return this.childNodeB.getParentNode(child, this);
    }

    public PaneNode removeChild(Component child) {
        PaneNode rc = null;
        if (this.childNodeA.childComponent == child) {
            rc = this.childNodeA;
            rc.widthDivide = this.widthDivide;
            rc.heightDivide = this.heightDivide;
            rc.reverse = this.reverse;
            rc.horizontal = this.horizontal;
            this.absorbChildNode(this.childNodeB);
            rc.childNodeA = this;
            rc.childNodeB = null;
        } else if (this.childNodeB.childComponent == child) {
            rc = this.childNodeB;
            rc.widthDivide = this.widthDivide;
            rc.heightDivide = this.heightDivide;
            rc.reverse = this.reverse;
            rc.horizontal = this.horizontal;
            this.absorbChildNode(this.childNodeA);
            rc.childNodeA = null;
            rc.childNodeB = this;
        }
        return rc;
    }

    Rectangle getDividerRect(int gap) {
        if (this.childComponent == null) {
            if (this.heightDivide == 1.0f) {
                if (this.reverse) {
                    return new Rectangle(this.childNodeB.location.x + this.childNodeB.location.width, this.childNodeB.location.y, gap, this.childNodeB.location.height);
                }
                return new Rectangle(this.childNodeA.location.x + this.childNodeA.location.width, this.childNodeA.location.y, gap, this.childNodeA.location.height);
            }
            if (this.reverse) {
                return new Rectangle(this.childNodeB.location.x, this.childNodeB.location.y + this.childNodeB.location.height, this.childNodeB.location.width, gap);
            }
            return new Rectangle(this.childNodeA.location.x, this.childNodeA.location.y + this.childNodeA.location.height, this.childNodeA.location.width, gap);
        }
        return new Rectangle(this.location.x - gap, this.yOffset + this.location.y - gap, this.location.width + gap, gap);
    }

    void drag(int x, int y) {
        boolean goodDrag = true;
        if (this.childComponent == null) {
            if (this.heightDivide == 1.0f) {
                this.widthDivide = (float)(x - this.location.x) / (float)this.location.width;
                if (this.reverse) {
                    this.widthDivide = 1.0f - this.widthDivide;
                }
                if (this.widthDivide < 0.0f) {
                    this.widthDivide = 0.0f;
                    goodDrag = false;
                } else if (this.widthDivide >= 1.0f) {
                    this.widthDivide = 0.999f;
                    goodDrag = false;
                }
            } else {
                if (this.reverse) {
                    this.heightDivide = 1.0f - this.heightDivide;
                }
                this.heightDivide = (float)(y - this.location.y) / (float)this.location.height;
                if (this.reverse) {
                    this.heightDivide = 1.0f - this.heightDivide;
                }
                if (this.heightDivide < 0.0f) {
                    goodDrag = false;
                    this.heightDivide = 0.0f;
                } else if (this.heightDivide >= 1.0f) {
                    goodDrag = false;
                    this.heightDivide = 0.999f;
                }
            }
        }
    }

    PaneNode hitTest(int x, int y, int gap) {
        if (this.location != null && this.childComponent == null) {
            int offset = this.heightDivide == 1.0f ? x - (this.location.x + this.xOffset) : y - (this.location.y + this.yOffset);
            if (Math.abs(offset) <= gap) {
                return this;
            }
            if (offset < 0 ^ this.reverse) {
                return this.childNodeA.hitTest(x, y, gap);
            }
            return this.childNodeB.hitTest(x, y, gap);
        }
        return null;
    }

    void assertLocation(Rectangle locationInit, int gap) {
        this.location.x = locationInit.x;
        this.location.y = locationInit.y;
        this.location.width = locationInit.width;
        this.location.height = locationInit.height;
        if (this.childComponent != null) {
            if (!this.childComponent.getBounds().equals(this.location)) {
                this.childComponent.setBounds(this.location.x, this.location.y, this.location.width, this.location.height);
                if (this.childComponent instanceof Container) {
                    ((Container)this.childComponent).doLayout();
                }
            }
        } else {
            Rectangle childALocation = new Rectangle();
            Rectangle childBLocation = new Rectangle();
            this.calculateLocations(this.location, childALocation, childBLocation, gap);
            this.childNodeA.assertLocation(childALocation, gap);
            this.childNodeB.assertLocation(childBLocation, gap);
        }
    }

    void absorbChildNode(PaneNode child) {
        if (child.childComponent != null) {
            this.childComponent = child.childComponent;
            this.name = child.name;
        } else {
            this.childComponent = null;
            this.childNodeA = child.childNodeA;
            this.childNodeB = child.childNodeB;
            this.widthDivide = child.widthDivide;
            this.heightDivide = child.heightDivide;
            this.reverse = child.reverse;
            this.horizontal = child.horizontal;
        }
    }

    void calculateLocations(Rectangle location, Rectangle childALocation, Rectangle childBLocation, int Border2) {
        float proportion;
        Border2 += Border2;
        if (this.heightDivide == 1.0f) {
            proportion = this.widthDivide;
            if (this.reverse) {
                proportion = 1.0f - proportion;
            }
            this.xOffset = (int)((float)(location.width - Border2) * proportion);
            childALocation.x = location.x;
            childALocation.y = location.y;
            childALocation.width = this.xOffset;
            childALocation.height = location.height;
            childBLocation.x = location.x + this.xOffset + Border2;
            childBLocation.y = location.y;
            childBLocation.width = location.width - this.xOffset - Border2;
            childBLocation.height = location.height;
        } else {
            proportion = this.heightDivide;
            if (this.reverse) {
                proportion = 1.0f - proportion;
            }
            this.yOffset = (int)((float)(location.height - Border2) * proportion);
            childALocation.x = location.x;
            childALocation.y = location.y;
            childALocation.width = location.width;
            childALocation.height = this.yOffset;
            childBLocation.x = location.x;
            childBLocation.y = location.y + this.yOffset + Border2;
            childBLocation.width = location.width;
            childBLocation.height = location.height - this.yOffset - Border2;
        }
        if (this.reverse) {
            Rectangle temp = new Rectangle(childALocation.x, childALocation.y, childALocation.width, childALocation.height);
            childALocation.x = childBLocation.x;
            childALocation.y = childBLocation.y;
            childALocation.width = childBLocation.width;
            childALocation.height = childBLocation.height;
            childBLocation.x = temp.x;
            childBLocation.y = temp.y;
            childBLocation.width = temp.width;
            childBLocation.height = temp.height;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.childComponent instanceof Serializable ? this.childComponent : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof Component) {
            this.childComponent = (Component)data;
        }
    }
}

