/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.dx.dataset.Variant;
import com.borland.jb.util.SearchPath;
import com.borland.jbcl.util.ImageCache;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.GrayFilter;

public class ImageLoader
implements Serializable {
    static ImageCache urlImageCache = new ImageCache(32);
    static ImageCache blobImageCache = new ImageCache(16);
    static ImageCache disabledImageCache = new ImageCache(48);

    public static void setUrlImageCacheLimit(int limit) {
        urlImageCache.setLimit(limit);
    }

    public static int getUrlImageCacheLimit() {
        return urlImageCache.getLimit();
    }

    public static void setBlobImageCacheLimit(int limit) {
        blobImageCache.setLimit(limit);
    }

    public static int getBlobImageCacheLimit() {
        return blobImageCache.getLimit();
    }

    public static void setDisabledImageCacheLimit(int limit) {
        disabledImageCache.setLimit(limit);
    }

    public static int getDisabledImageCacheLimit() {
        return disabledImageCache.getLimit();
    }

    public static Image load(String path, Component component) {
        try {
            return component != null ? component.getToolkit().getImage(path) : Toolkit.getDefaultToolkit().getImage(path);
        }
        catch (SecurityException x) {
            return null;
        }
    }

    public static Image load(String path, Component component, boolean wait) {
        Image image = ImageLoader.load(path, component);
        if (image != null && wait) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image load(URL url, Component component) {
        Image image = urlImageCache.get(url.toString());
        if (image != null) {
            return image;
        }
        try {
            image = component != null ? component.getToolkit().getImage(url) : Toolkit.getDefaultToolkit().getImage(url);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (image != null) {
            urlImageCache.put(url.toString(), image, component);
        }
        return image;
    }

    public static Image load(URL url, Component component, boolean wait) {
        Image image = ImageLoader.load(url, component);
        if (image != null && wait) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image loadFromPath(SearchPath path, String name, Component component) {
        try {
            Toolkit toolkit = component == null ? Toolkit.getDefaultToolkit() : component.getToolkit();
            return toolkit.getImage(path.getPath(name));
        }
        catch (SecurityException x) {
            return null;
        }
    }

    public static Image loadFromPath(SearchPath path, String name, Component component, boolean wait) {
        Image image = ImageLoader.loadFromPath(path, name, component);
        if (image != null && wait) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    public static Image loadFromResource(String name, Component component) {
        return ImageLoader.loadFromResource(name, component, component.getClass());
    }

    public static Image loadFromResource(String name, Class cl) {
        return ImageLoader.loadFromResource(name, null, cl);
    }

    public static Image loadFromResource(String name, Component component, Class cl) {
        try {
            URL url = cl.getResource(name);
            if (url == null) {
                return null;
            }
            Image image = urlImageCache.get(url.toString());
            if (image != null) {
                return image;
            }
            Object content = url.getContent();
            if (content instanceof Image) {
                image = (Image)content;
            } else if (content instanceof ImageProducer) {
                image = component != null ? component.createImage((ImageProducer)content) : Toolkit.getDefaultToolkit().createImage((ImageProducer)content);
            } else {
                return null;
            }
            if (component != null) {
                component.prepareImage(image, component);
            } else {
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, component);
            }
            urlImageCache.put(url.toString(), image, component);
            return image;
        }
        catch (IOException e2) {
            System.err.println("loadFromResource IOException name=" + name + " component=" + component + " cl=" + cl);
        }
        catch (Exception e3) {
            System.err.println("loadFromResource Exception" + e3 + " name=" + name + " component=" + component + " cl=" + cl);
        }
        return null;
    }

    public static Image loadFromBlob(Object object, Component component) throws IOException {
        Image image;
        if (object == null) {
            return null;
        }
        if (object instanceof Variant) {
            Variant value = (Variant)object;
            if (value.isNull()) {
                return null;
            }
            object = value.getInputStream();
        }
        if ((image = blobImageCache.get(object)) != null) {
            return image;
        }
        if (object instanceof Image) {
            image = (Image)object;
        } else if (object instanceof InputStream) {
            InputStream stream = (InputStream)object;
            stream.reset();
            byte[] buffer = ImageLoader.byteArrayFromStream(stream);
            Toolkit tk = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
            image = tk.createImage(buffer);
        }
        if (image != null) {
            blobImageCache.put(object, image, component);
        }
        return image;
    }

    public static Image loadFromBlob(Object object, Component component, boolean wait) throws IOException {
        Image image = ImageLoader.loadFromBlob(object, component);
        if (image != null && wait) {
            ImageLoader.waitForImage(component, image);
        }
        return image;
    }

    private static byte[] byteArrayFromStream(InputStream s) throws IOException {
        int n;
        int len = s.available();
        byte[] buf = new byte[len];
        for (int count = 0; count < len; count += n) {
            n = s.read(buf, count, len - count);
            if (n >= 0) continue;
            return null;
        }
        return buf;
    }

    public static boolean waitForImage(Component component, Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker m = new MediaTracker(component);
        m.addImage(image, 1);
        try {
            m.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !m.isErrorID(1);
    }

    public static Image getDisabledImage(Component component, Image image) {
        Image disabledImage = disabledImageCache.get(image);
        if (disabledImage != null) {
            return disabledImage;
        }
        disabledImage = GrayFilter.createDisabledImage(image);
        disabledImageCache.put(image, disabledImage, component);
        return disabledImage;
    }
}

