/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TextFieldView
extends TextField
implements SingletonModelView,
SingletonModelListener,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient SingletonModel model;
    protected transient WritableSingletonModel writeModel;
    protected transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected boolean readOnly;
    protected boolean postOnFocusLost = true;
    protected boolean locateOnly = false;

    public TextFieldView() {
        this.enableEvents(12L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel sm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = sm;
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)sm : null;
        this.setEditable(!this.isReadOnly());
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener l) {
        this.modelMulticaster.add(l);
    }

    public void removeModelListener(SingletonModelListener l) {
        this.modelMulticaster.remove(l);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
        this.setEditable(!this.isReadOnly());
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setPostOnFocusLost(boolean post) {
        this.postOnFocusLost = post;
    }

    protected void updateText() {
        if (this.model != null) {
            Object o = this.model.get();
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            super.setText(o != null ? o.toString() : "");
            this.setSelectionStart(selectionStart);
            this.setSelectionEnd(selectionEnd);
        }
    }

    protected void setSuperText(String text) {
        super.setText(text);
    }

    public void setText(String text) {
        if (this.canSet(true) && !this.locateOnly) {
            String oldText = this.getText();
            if (oldText == null && text == null) {
                return;
            }
            if (oldText != null && text != null && oldText.equals(text)) {
                return;
            }
            this.writeModel.set(text);
        }
    }

    protected void postText() {
        if (this.canSet(true) && !this.locateOnly) {
            String text = super.getText();
            this.writeModel.set(text);
        }
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        this.updateText();
    }

    protected void processKeyEvent(KeyEvent e2) {
        super.processKeyEvent(e2);
        this.canSet(true);
        if (e2.getID() == 401) {
            switch (e2.getKeyCode()) {
                case 10: {
                    this.postText();
                    break;
                }
                case 27: {
                    this.updateText();
                }
            }
        }
    }

    public boolean canSet(boolean startingEdit) {
        return this.locateOnly ? true : (this.isReadOnly() ? false : this.writeModel.canSet(startingEdit));
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        if (e2.getID() == 1005) {
            String text = super.getText();
            Object data = this.model.get();
            if (this.postOnFocusLost && !text.equals(data)) {
                this.postText();
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }
}

