/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer = new byte[3];
    private int bufsize;
    private int index;
    private byte[] input_buffer = new byte[8190];
    private int input_pos;
    private int input_len;
    private boolean ignoreErrors = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];

    public BASE64DecoderStream(InputStream inputStream) {
        super(inputStream);
        try {
            String string = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = string != null && !string.equalsIgnoreCase("false");
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    public BASE64DecoderStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.ignoreErrors = bl;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.bufsize = this.decode(this.buffer, 0, this.buffer.length);
            if (this.bufsize <= 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = var2_2;
        while (this.index < this.bufsize && var3_3 > 0) {
            var1_1[var2_2++] = this.buffer[this.index++];
            --var3_3;
        }
        this.index = 0;
        this.bufsize = 0;
        var5_5 = var3_3 / 3 * 3;
        if (var5_5 <= 0) ** GOTO lbl20
        var6_6 = this.decode(var1_1, var2_2, var5_5);
        var2_2 += var6_6;
        var3_3 -= var6_6;
        if (var6_6 == var5_5) ** GOTO lbl20
        if (var2_2 == var4_4) {
            return -1;
        }
        return var2_2 - var4_4;
        while ((var6_6 = this.read()) != -1) {
            var1_1[var2_2++] = (byte)var6_6;
            --var3_3;
lbl20:
            // 3 sources

            if (var3_3 > 0) continue;
        }
        if (var2_2 == var4_4) {
            return -1;
        }
        return var2_2 - var4_4;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private int decode(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n2 >= 3) {
            int n4 = 0;
            int n5 = 0;
            while (n4 < 4) {
                int n6 = this.getByte();
                if (n6 == -1 || n6 == -2) {
                    boolean bl;
                    if (n6 == -1) {
                        if (n4 == 0) {
                            return n - n3;
                        }
                        if (!this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed 4 valid base64 characters but only got " + n4 + " before EOF" + this.recentChars());
                        }
                        bl = true;
                    } else {
                        if (n4 < 2 && !this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed at least 2 valid base64 characters, but only got " + n4 + " before padding character (=)" + this.recentChars());
                        }
                        if (n4 == 0) {
                            return n - n3;
                        }
                        bl = false;
                    }
                    int n7 = n4 - 1;
                    if (n7 == 0) {
                        n7 = 1;
                    }
                    ++n4;
                    n5 <<= 6;
                    while (n4 < 4) {
                        if (!bl) {
                            n6 = this.getByte();
                            if (n6 == -1) {
                                if (!this.ignoreErrors) {
                                    throw new IOException("Error in encoded stream: hit EOF while looking for padding characters (=)" + this.recentChars());
                                }
                            } else if (n6 != -2 && !this.ignoreErrors) {
                                throw new IOException("Error in encoded stream: found valid base64 character after a padding character (=)" + this.recentChars());
                            }
                        }
                        n5 <<= 6;
                        ++n4;
                    }
                    n5 >>= 8;
                    if (n7 == 2) {
                        byArray[n + 1] = (byte)(n5 & 0xFF);
                    }
                    byArray[n] = (byte)((n5 >>= 8) & 0xFF);
                    n2 -= n7;
                    return (n += n7) - n3;
                }
                n5 <<= 6;
                ++n4;
                n5 |= n6;
            }
            byArray[n + 2] = (byte)(n5 & 0xFF);
            byArray[n + 1] = (byte)((n5 >>= 8) & 0xFF);
            byArray[n] = (byte)((n5 >>= 8) & 0xFF);
            n2 -= 3;
            n += 3;
        }
        return n - n3;
    }

    private int getByte() throws IOException {
        int n;
        do {
            if (this.input_pos >= this.input_len) {
                try {
                    this.input_len = this.in.read(this.input_buffer);
                }
                catch (EOFException eOFException) {
                    return -1;
                }
                if (this.input_len <= 0) {
                    return -1;
                }
                this.input_pos = 0;
            }
            if ((n = this.input_buffer[this.input_pos++] & 0xFF) != 61) continue;
            return -2;
        } while ((n = pem_convert_array[n]) == -1);
        return n;
    }

    private String recentChars() {
        int n;
        String string = "";
        int n2 = n = this.input_pos > 10 ? 10 : this.input_pos;
        if (n > 0) {
            string = String.valueOf(string) + ", the " + n + " most recent characters were: \"";
            int n3 = this.input_pos - n;
            while (n3 < this.input_pos) {
                char c2 = (char)(this.input_buffer[n3] & 0xFF);
                switch (c2) {
                    case '\r': {
                        string = String.valueOf(string) + "\\r";
                        break;
                    }
                    case '\n': {
                        string = String.valueOf(string) + "\\n";
                        break;
                    }
                    case '\t': {
                        string = String.valueOf(string) + "\\t";
                        break;
                    }
                    default: {
                        string = c2 >= ' ' && c2 < '\u007f' ? String.valueOf(string) + c2 : String.valueOf(string) + "\\" + c2;
                    }
                }
                ++n3;
            }
            string = String.valueOf(string) + "\"";
        }
        return string;
    }

    public static byte[] decode(byte[] byArray) {
        int n = byArray.length / 4 * 3;
        if (n == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 61) {
            --n;
            if (byArray[byArray.length - 2] == 61) {
                --n;
            }
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        n = byArray.length;
        while (n > 0) {
            int n4 = 3;
            int n5 = pem_convert_array[byArray[n2++] & 0xFF];
            n5 <<= 6;
            n5 |= pem_convert_array[byArray[n2++] & 0xFF];
            n5 <<= 6;
            if (byArray[n2] != 61) {
                n5 |= pem_convert_array[byArray[n2++] & 0xFF];
            } else {
                --n4;
            }
            n5 <<= 6;
            if (byArray[n2] != 61) {
                n5 |= pem_convert_array[byArray[n2++] & 0xFF];
            } else {
                --n4;
            }
            if (n4 > 2) {
                byArray2[n3 + 2] = (byte)(n5 & 0xFF);
            }
            n5 >>= 8;
            if (n4 > 1) {
                byArray2[n3 + 1] = (byte)(n5 & 0xFF);
            }
            byArray2[n3] = (byte)((n5 >>= 8) & 0xFF);
            n3 += n4;
            n -= 4;
        }
        return byArray2;
    }

    static {
        int n = 0;
        while (n < 255) {
            BASE64DecoderStream.pem_convert_array[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < pem_array.length) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[n2]] = (byte)n2;
            ++n2;
        }
    }
}

