/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ATENFlash
implements IPMIDCMOEMCommand.Progress {
    MOut mout = MOut.G();
    int preserveConfigFlag = 1;
    public static final String FLASH_VERSION = "V2.0";
    IPMIDCMOEMCommand.Progress progress;
    int valueBak = -1;

    public int getPreserveConfigFlag() {
        return this.preserveConfigFlag;
    }

    public void setPreserveConfigFlag(int preserveConfigFlag) {
        this.preserveConfigFlag = preserveConfigFlag;
    }

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    private void API____________() {
    }

    public static void setEnableDebugMessage(boolean flag) {
        if (flag) {
            Logger.getLogger("org.apache.http.wire").setLevel(Level.FINEST);
            Logger.getLogger("org.apache.http.headers").setLevel(Level.FINEST);
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "debug");
        } else {
            Logger.getLogger("org.apache.http.wire").setLevel(Level.OFF);
            Logger.getLogger("org.apache.http.headers").setLevel(Level.OFF);
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "false");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "ERROR");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "ERROR");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.headers", "ERROR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashWorker(String ip, String username, String password, String filename, boolean ssl) throws Exception {
        boolean isIpv6 = false;
        if (StunnelUtility.isIPv6(ip)) {
            isIpv6 = true;
        }
        ATENFlash.setEnableDebugMessage(false);
        String protocol = "http";
        if (ssl) {
            protocol = "https";
        }
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLParameters params = builder.build().getSupportedSSLParameters();
        String[] suites = params.getCipherSuites();
        SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1", "TLSv1.2"}, suites, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.cookie-store", cookieStore);
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(globalConfig).setDefaultCookieStore(cookieStore).setSSLSocketFactory(sslSF).build();
        if (isIpv6 && !ip.contains("[")) {
            ip = "[" + ip + "]";
        }
        this.progress.setValue(0);
        try {
            boolean result;
            String httpUploadResponseString;
            CloseableHttpResponse response4;
            String httpCSRFTokenResponseString;
            boolean result2;
            int retry;
            InetAddress address = InetAddress.getByName(ip);
            for (retry = 10; retry > 0 && !(result2 = address.isReachable(30000)); --retry) {
            }
            if (retry == 0) {
                this.progress.message("Connect Failed");
                return;
            }
            HttpGet httpGet = new HttpGet(protocol + "://" + ip + "/");
            try (CloseableHttpResponse response1 = httpClient.execute(httpGet);){
                HttpEntity httpEntity = response1.getEntity();
            }
            HttpPost httpPost = new HttpPost(protocol + "://" + ip + "/cgi/login.cgi");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("name", username));
            nvps.add(new BasicNameValuePair("pwd", password));
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nvps));
            httpPost.addHeader("Referer", protocol + "://" + ip);
            try (CloseableHttpResponse response2 = httpClient.execute(httpPost);){
                HttpEntity entity2 = response2.getEntity();
                String response2String = EntityUtils.toString(entity2);
                if (response2.getStatusLine().getStatusCode() == 301) {
                    protocol = "https";
                    httpPost = new HttpPost(protocol + "://" + ip + "/cgi/login.cgi");
                    httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nvps));
                    httpPost.addHeader("Referer", protocol + "://" + ip);
                    response2 = httpClient.execute(httpPost);
                    entity2 = response2.getEntity();
                    response2String = EntityUtils.toString(entity2);
                }
                if (response2String.indexOf("url_name=mainmenu") == -1) {
                    throw new Exception("Authentication failed");
                }
            }
            HttpGet httpGetCSRFToken = new HttpGet(protocol + "://" + ip + "/cgi/url_redirect.cgi?url_name=sys_info");
            try (CloseableHttpResponse response2_1 = httpClient.execute(httpGetCSRFToken);){
                HttpEntity entity2_1 = response2_1.getEntity();
                httpCSRFTokenResponseString = EntityUtils.toString(entity2_1);
            }
            String token = "";
            if (httpCSRFTokenResponseString.indexOf("CSRF_TOKEN") != -1) {
                token = httpCSRFTokenResponseString.substring(httpCSRFTokenResponseString.indexOf("CSRF_TOKEN") + 12);
                int startIndex = token.indexOf("\"") + 1;
                int endIndex = token.indexOf("\"", token.indexOf("\"") + 1);
                token = token.substring(startIndex, endIndex);
            }
            this.progress.message("Entering update mode... ");
            HttpGet httpEnterUpdateMode = new HttpGet(protocol + "://" + ip + "/cgi/url_redirect.cgi?url_name=main_fw_upload");
            if (isIpv6) {
                for (Cookie cookie : context.getCookieStore().getCookies()) {
                    if (!cookie.getName().contains("SID")) continue;
                    httpEnterUpdateMode.addHeader("Cookie", cookie.getName() + "=" + cookie.getValue());
                }
            }
            try (CloseableHttpResponse response3 = httpClient.execute(httpEnterUpdateMode);){
                HttpEntity httpEntity = response3.getEntity();
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.progress.setValue(9999);
            this.progress.message("Uploading" + (protocol.equals("https") ? "[SSL|TLS]" : "") + "... ");
            HttpPost httpPost2 = new HttpPost(protocol + "://" + ip + "/cgi/firmware_upload.cgi");
            FileBody fileBody = new FileBody(new File(filename));
            StringBody stringBody1 = new StringBody("3", ContentType.MULTIPART_FORM_DATA);
            StringBody stringBody2 = new StringBody("" + this.preserveConfigFlag, ContentType.MULTIPART_FORM_DATA);
            MultipartEntityBuilder mpBuilder = MultipartEntityBuilder.create();
            mpBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            mpBuilder.addPart("FileType", stringBody1);
            mpBuilder.addPart("preserve_config", stringBody2);
            mpBuilder.addPart("FS_Whatever", fileBody);
            HttpEntity entity = mpBuilder.build();
            httpPost2.setEntity(entity);
            if (isIpv6) {
                for (Cookie c3 : context.getCookieStore().getCookies()) {
                    if (!c3.getName().contains("SID")) continue;
                    httpPost2.addHeader("Cookie", c3.getName() + "=" + c3.getValue());
                }
            }
            httpPost2.addHeader("Referer", protocol + "://" + ip);
            if (token.length() != 0) {
                httpPost2.addHeader("CSRF_TOKEN", token);
            }
            if ((response4 = httpClient.execute(httpPost2)).getStatusLine().getStatusCode() == 403) {
                response4.close();
                throw new Exception("CSRF authentification failed");
            }
            if (response4.getStatusLine().getStatusCode() == 500) {
                response4.close();
                throw new Exception("BMC internal server error");
            }
            try {
                HttpEntity entity4 = response4.getEntity();
                httpUploadResponseString = EntityUtils.toString(entity4);
            }
            finally {
                response4.close();
            }
            if (httpUploadResponseString.indexOf("Update package type mismatch!") != -1) {
                throw new Exception("Update package type mismatch! Please select the correct type and try again!");
            }
            if (httpUploadResponseString.indexOf("Another user is updating!") != -1) {
                throw new Exception("Another user is updating! Please wait for the BMC to restart!");
            }
            if (httpUploadResponseString.indexOf("This update package is not compatible") != -1) {
                throw new Exception("This update package is not compatible with your system configuration.");
            }
            if (httpUploadResponseString.indexOf("Update package verification failed!") != -1) {
                throw new Exception("Update package verification failed!");
            }
            if (httpUploadResponseString.indexOf("downgrade to this update package version!") != -1) {
                throw new Exception("Can't downgrade to this update package version!");
            }
            this.progress.setValue(9999);
            this.progress.message("Updating ");
            int i2 = 0;
            int missPercentCount = 0;
            int progressRetry = 0;
            while (i2 != 100) {
                try {
                    CloseableHttpResponse response5;
                    HttpEntity entity5;
                    String response5String;
                    HttpGet httpGetUpgradeProgress = new HttpGet(protocol + "://" + ip + "/cgi/upgrade_process.cgi");
                    if (isIpv6) {
                        for (Cookie c4 : context.getCookieStore().getCookies()) {
                            if (!c4.getName().contains("SID")) continue;
                            httpGetUpgradeProgress.addHeader("Cookie", c4.getName() + "=" + c4.getValue());
                        }
                    }
                    if ((response5String = EntityUtils.toString(entity5 = (response5 = httpClient.execute(httpGetUpgradeProgress)).getEntity())).indexOf("<percent") <= 0 || response5String.indexOf("</percent>") <= 0) {
                        if (missPercentCount++ > 5) {
                            throw new Exception("Cannot get update progress. Please retry after 1 minute");
                        }
                        Thread.sleep(1000L);
                        continue;
                    }
                    String percentString = response5String.substring(response5String.indexOf("<percent"));
                    int frontLength = percentString.indexOf(62) + 1;
                    i2 = Integer.valueOf(percentString.substring(frontLength, percentString.indexOf("</percent>")).trim());
                    this.progress.setValue(i2);
                    Thread.sleep(1000L);
                    progressRetry = 0;
                }
                catch (Exception e2) {
                    if (i2 != 0) {
                        if (progressRetry == 2) {
                            this.progress.setValue(100);
                            break;
                        }
                        ++progressRetry;
                        continue;
                    }
                    throw e2;
                }
            }
            retry = 20;
            if (i2 == 100) {
                this.progress.message("Resetting BMC");
            } else {
                this.progress.message("Wait for BMC reset[" + i2 + "] ...");
                try {
                    Thread.sleep((100 - i2) * 3 * 1000);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            while (retry > 0 && !(result = address.isReachable(3000))) {
                --retry;
            }
            if (retry == 0) {
                this.progress.message("BMC IP is unavailable currently. Please check after 2 minutes later");
                this.progress.message("RoT devices will perform system backup, may need up to 8 minutes to recover.");
            } else {
                this.progress.message("Done");
            }
        }
        catch (Exception e3) {
            throw e3;
        }
        finally {
            httpClient.close();
        }
    }

    public String checkFirmwareVersion(String filename) throws Exception {
        return this.checkFirmwareVersion(filename, null);
    }

    public String checkFirmwareVersion(String filename, byte[] guid) throws Exception {
        File firmware = new File(filename);
        if (firmware.length() == 0x1000000L) {
            return this.checkFirmwareVersionX9(filename);
        }
        if (firmware.length() > 0x1000000L) {
            String firmwareVersion;
            if (IPMIMessagingCommand.isATENGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX9(filename);
            } else if (IPMIMessagingCommand.isATENAspeedGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX10(filename);
            } else if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionMicroCMM(filename);
            } else if (IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionMicroBladeNode(filename);
            } else if (IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionMicroBladeNode(filename);
            } else if (IPMIMessagingCommand.isSAS3_946E90GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionSAS_946E90(filename);
            } else if (IPMIMessagingCommand.isAST2400GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionAST2400(filename);
            } else if (IPMIMessagingCommand.isCB3GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX10(filename);
            } else if (IPMIMessagingCommand.isAST2500GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionAST2500(filename);
            } else if (IPMIMessagingCommand.isP8DTUGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionP8(filename);
            } else if (IPMIMessagingCommand.is8USuperBladeGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersion8USuperBlade(filename);
            } else if (IPMIMessagingCommand.isAST2500HW1GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionAST2500HW1(filename);
            } else if (IPMIMessagingCommand.isH11GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionH11(filename);
            } else if (IPMIMessagingCommand.isPOWER9GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionP9(filename);
            } else if (IPMIMessagingCommand.isH12GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionH12(filename);
            } else if (IPMIMessagingCommand.isH12RoTGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionH12RoT(filename);
            } else if (IPMIMessagingCommand.isNuvotonGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionNuvoton(filename);
            } else if (IPMIMessagingCommand.isX11RotGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX11Rot(filename);
            } else if (IPMIMessagingCommand.isX12GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX12(filename);
            } else if (IPMIMessagingCommand.isX12RoTGUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX12RoT(filename);
            } else if (IPMIMessagingCommand.isX12RoTHW1GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionX12RoTHW1(filename);
            } else if (IPMIMessagingCommand.isJBOF2500GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionJBOF2500(filename);
            } else if (IPMIMessagingCommand.isJBOD2500GUID(guid)) {
                firmwareVersion = this.checkFirmwareVersionJBOD2500(filename);
            } else {
                throw new Exception("Target BMC type error");
            }
            return firmwareVersion;
        }
        throw new Exception("Invalid firmware");
    }

    public String checkFirmwareVersionX9(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte16 = new byte[16];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int i2 = 0;
        while ((long)i2 < firmware.length() / 65536L) {
            raf.seek((i2 + 1) * 65536 - 80);
            int count = raf.read(byte16);
            if (count != byte16.length) {
                raf.close();
                throw new Exception("File error");
            }
            if (byte16[3] == 65 && byte16[4] == 84 && byte16[5] == 69 && byte16[6] == 78) {
                version = byte16[11] + "." + ByteUtility.byteToHex(byte16[12]);
            }
            ++i2;
        }
        raf.close();
        if (version == null) {
            throw new Exception("invalid file (X8,X9 BMC *.bin required)");
        }
        if (version.equals("30.30")) {
            version = "00.00";
        }
        return version;
    }

    public String checkFirmwareVersionX10(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte16 = new byte[16];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte16);
                if (count != byte16.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte16[0] == 65 && byte16[1] == 84 && byte16[2] == 69 && byte16[3] == 78) {
                    version = byte16[8] + "." + ByteUtility.byteToHex(byte16[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X10 ASPEED BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionP8(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[18] == 113 && byte32[27] == 24) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (P8 ASPEED BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionMicroCMM(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[8] == 95 && byte32[9] == 77 && byte32[10] == 105 && byte32[11] == 99 && byte32[12] == 114 && byte32[13] == 111 && byte32[14] == 67 && byte32[15] == 77 && byte32[16] == 77) {
                    version = byte32[17] + "." + ByteUtility.byteToHex(byte32[18]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (MicroCMM *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionMicroBladeNode(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[8] == 95 && byte32[9] == 77 && byte32[10] == 105 && byte32[11] == 99 && byte32[12] == 114 && byte32[13] == 111 && byte32[14] == 66 && byte32[15] == 108 && byte32[16] == 97 && byte32[17] == 100 && byte32[18] == 101) {
                    version = byte32[19] + "." + ByteUtility.byteToHex(byte32[20]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (MicroBlade *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionSAS_946E90(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[8] == 95 && byte32[9] == 57 && byte32[10] == 52 && byte32[11] == 54 && byte32[12] == 69 && byte32[13] == 57 && byte32[14] == 48) {
                    version = byte32[15] + "." + ByteUtility.byteToHex(byte32[16]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (SAS BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2400(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 49 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X11 AST2400 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2500(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 65 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X11 AST2500 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH11(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 97 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H11 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionP9(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 65 && byte32[1] == 84 && byte32[2] == 69 && byte32[3] == 78 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[18] == 113 && byte32[27] == 25) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (P9 ASPEED BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersion8USuperBlade(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte48 = new byte[48];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte48);
                if (count != byte48.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte48[0] == 65 && byte48[1] == 84 && byte48[2] == 69 && byte48[3] == 78 && byte48[4] == 115 && byte48[5] == 95 && byte48[6] == 70 && byte48[7] == 87 && byte48[8] == 95 && byte48[9] == 83 && byte48[10] == 117 && byte48[11] == 112 && byte48[12] == 101 && byte48[13] == 114 && byte48[14] == 66 && byte48[15] == 108 && byte48[16] == 97 && byte48[17] == 100 && byte48[18] == 101) {
                    version = byte48[21] + "." + ByteUtility.byteToHex(byte48[22]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte48[42] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte48[42]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B11IPMI *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 177 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 34 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2500HW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -111 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X11 AST2500 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionNuvoton(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        block0: do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -31 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    continue block0;
                }
                ++i2;
            }
        } while (version == null && (block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X11 Nuvoton BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX11Rot(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -47 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X11 Rot BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -15 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 2 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT HW1 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 50 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionJBOF2500(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -126 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (JBOF AST2500 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionJBOD2500(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i2 = (int)(firmware.length() / (long)block / 2L);
            while ((long)i2 < firmware.length() / (long)block - 1L) {
                raf.seek((i2 + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -94 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i2;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (JBOD AST2500 BMC *.bin required)");
        }
        return version;
    }

    @Override
    public void setValue(int value) {
        if (value == 9999) {
            this.mout.print("Done");
            return;
        }
        if (value == 0) {
            return;
        }
        if (value > this.valueBak) {
            for (int i2 = 0; i2 < value - this.valueBak; ++i2) {
                if ((i2 + value) % 2 != 0) continue;
                this.mout.print(">");
            }
            if (value == 100) {
                this.mout.print("100%");
            }
            this.valueBak = value;
        }
    }

    @Override
    public void message(String message) {
        this.mout.print("\n" + message);
    }

    @Override
    public void left(long value) {
    }

    public String getCurrentFWVersion(String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiGlobalCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        sessionController.closeSession();
        if (deviceInfo.usingAuxiliaryFWVesion) {
            return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]);
        }
        return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public boolean flash(String ip, String id, String pw, String filename) {
        return this.flash(ip, id, pw, filename, 1, false, 0, false);
    }

    public boolean flash(String ip, String id, String pw, String filename, int preserve_config, boolean checkEqualVersion, int delayAfterUpdate, boolean ssl) {
        String firmwareVersion;
        byte[] guid;
        ATENFlash atenFlash;
        long start;
        block35: {
            start = System.currentTimeMillis();
            atenFlash = new ATENFlash();
            atenFlash.progress = atenFlash;
            atenFlash.setMOut(this.mout);
            atenFlash.setPreserveConfigFlag(preserve_config);
            guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
            this.mout.print("Check firmware file...");
            firmwareVersion = null;
            try {
                if (IPMIMessagingCommand.isATENGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX9(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isATENAspeedGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX10(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionMicroCMM(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionMicroBladeNode(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isATENSuperBladeGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionMicroBladeNode(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isSAS3_946E90GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionSAS_946E90(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isAST2400GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionAST2400(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isCB3GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX10(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isAST2500GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionAST2500(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isP8DTUGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionP8(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.is8USuperBladeGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersion8USuperBlade(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isAST2500HW1GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionAST2500HW1(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isH11GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionH11(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isPOWER9GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionP9(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isH12GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionH12(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isH12RoTGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionH12RoT(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isNuvotonGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionNuvoton(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isX11RotGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX11Rot(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isX12GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX12(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isX12RoTGUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX12RoT(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isX12RoTHW1GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionX12RoTHW1(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isJBOF2500GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionJBOF2500(filename);
                    break block35;
                }
                if (IPMIMessagingCommand.isJBOD2500GUID(guid)) {
                    firmwareVersion = atenFlash.checkFirmwareVersionJBOD2500(filename);
                    break block35;
                }
                throw new Exception("Target BMC type error");
            }
            catch (Exception ex) {
                this.mout.println(ex.getMessage());
                return false;
            }
        }
        this.mout.println(" Done (ver:" + firmwareVersion + ")");
        this.mout.print("Check BMC status...");
        String bmcVersion = null;
        try {
            bmcVersion = atenFlash.getCurrentFWVersion(ip, id, pw);
        }
        catch (Exception ex) {
            this.mout.println(ex.getMessage());
            return false;
        }
        this.mout.print(" Done (ver:" + bmcVersion + ")");
        if (checkEqualVersion && firmwareVersion.equals(bmcVersion)) {
            this.mout.println("\nThe BMC version is equal to BMC firmware file. Ignore update");
            return true;
        }
        try {
            atenFlash.flashWorker(ip, id, pw, filename, ssl);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            if (ex1.getMessage().contains("Update package verification failed") && IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
                IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                config.setIp(ip);
                config.setUserName(id);
                config.setPassword(pw);
                config.setPrivilege((byte)4);
                IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
                ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiGlobalCommand);
                if (sessionController == null) {
                    return false;
                }
                this.mout.println("\nPerform BMC reset..");
                ipmiGlobalCommand.coldReset();
                sessionController.closeSession();
            }
            return false;
        }
        this.printTimeString("\nTotal Elapsed Time", System.currentTimeMillis() - start);
        if (delayAfterUpdate != 0) {
            this.mout.println("Wait " + delayAfterUpdate + " sec(s)");
            try {
                Thread.sleep(delayAfterUpdate * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        MessageCenter.getInstance().deleteObservers();
        ATENFlash atenFlash = new ATENFlash();
        atenFlash.progress = atenFlash;
        atenFlash.flash("2.2.2.2", StunnelUtility.testADMIN(), StunnelUtility.testADMIN(), "c:\\REDFISH_X10_311.bin", 1, false, 0, false);
    }

    public IPMIDCMOEMCommand.Progress getProgress() {
        return this.progress;
    }

    public void setProgress(IPMIDCMOEMCommand.Progress progress) {
        this.progress = progress;
    }
}

