/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteUtility {
    public static final char[] hex = "0123456789ABCDEF".toCharArray();
    static SecureRandom random = new SecureRandom();

    public static byte[] hexToBytes(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (byte)Integer.parseInt(s.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        return ret;
    }

    public static byte[] hexToBytesWithSpace(String s) {
        String orgByteStr = "";
        Scanner scan = new Scanner(s);
        scan.useDelimiter(" ");
        while (scan.hasNext()) {
            orgByteStr = orgByteStr + scan.next();
        }
        if (null != scan) {
            scan.close();
        }
        byte[] bytes = ByteUtility.toBinArray(orgByteStr);
        return bytes;
    }

    public static String bytesToHex(byte[] b2) {
        if (b2 == null) {
            return "";
        }
        char[] ret = new char[b2.length * 3];
        int j2 = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
            ret[j2++] = 32;
        }
        return new String(ret);
    }

    public static String bytesToHex(byte[] b2, int length) {
        if (b2 == null) {
            return "";
        }
        char[] ret = new char[length * 3];
        int j2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
            ret[j2++] = 32;
        }
        return new String(ret);
    }

    public static String byteToHex(byte b2) {
        int i2 = b2 & 0xFF;
        String strByte = Integer.toHexString(i2);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public static String bytesToBin(byte[] b2) {
        if (b2 == null) {
            return "";
        }
        String ret = "";
        for (int i2 = 0; i2 < b2.length; ++i2) {
            for (int ii = 0; ii < 8; ++ii) {
                ret = ret + ((b2[i2] & 128 >> ii) > 0 ? "1" : "0");
            }
            ret = ret + "(" + ByteUtility.byteToHex(b2[i2]) + "h) ";
        }
        return ret;
    }

    public static void intTo4Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void longTo4Bytes(byte[] bytedest, int offset, long longsrc) {
        bytedest[offset + 0] = (byte)longsrc;
        bytedest[offset + 1] = (byte)(longsrc >> 8);
        bytedest[offset + 2] = (byte)(longsrc >> 16);
        bytedest[offset + 3] = (byte)(longsrc >> 24);
    }

    public static byte[] longToBytes(long input) {
        String hex = Long.toHexString(input);
        byte[] result = new byte[8];
        if (hex.length() < 16) {
            int length = hex.length();
            for (int loop = 0; loop < 16 - length; ++loop) {
                hex = "0" + hex;
            }
        }
        for (int loop = 0; loop < 16; loop += 2) {
            String temp = hex.substring(loop, loop + 2);
            result[loop / 2] = new Integer(Integer.parseInt(temp, 16)).byteValue();
        }
        return result;
    }

    public static void intTo2Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
    }

    public static byte[] getBytes(byte[] raw, int start, int length) {
        byte[] bytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bytes[i2] = raw[i2 + start];
        }
        return bytes;
    }

    public static int twoBytesToInt(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntLSB(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntLSB(byte[] b2, int startIndex) {
        int b1 = b2[startIndex + 1] & 0xFF;
        int b0 = b2[startIndex] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntLSBSigned(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        if ((byte)(b1 & 0x80) == -128) {
            return 0xFFFF0000 | (b1 << 8) + b0;
        }
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntMSB(byte[] b2) {
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b0 << 8) + b1;
    }

    public static long fourBytesToLong(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b22 << 8) + b3;
    }

    public static long eightBytesToLong(byte[] b2) {
        long b7 = b2[7] & 0xFF;
        long b6 = b2[6] & 0xFF;
        long b5 = b2[5] & 0xFF;
        long b4 = b2[4] & 0xFF;
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b0 << 56) + (b1 << 48) + (b22 << 40) + (b3 << 32) + (b4 << 24) + (b5 << 16) + (b6 << 8) + b7;
    }

    public static long eightBytesToLongByLSBFirst(byte[] b2) {
        long b7 = b2[7] & 0xFF;
        long b6 = b2[6] & 0xFF;
        long b5 = b2[5] & 0xFF;
        long b4 = b2[4] & 0xFF;
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b7 << 56) + (b6 << 48) + (b5 << 40) + (b4 << 32) + (b3 << 24) + (b22 << 16) + (b1 << 8) + b0;
    }

    public static int fourBytesToInt(byte[] b2) {
        int b3 = b2[3] & 0xFF;
        int b22 = b2[2] & 0xFF;
        int b1 = b2[1] & 0xFF;
        int b0 = b2[0] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b22 << 8) + b3;
    }

    public static long fourBytesToLongByLSBFirst(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b3 << 24) + (b22 << 16) + (b1 << 8) + b0;
    }

    public static int fourBytesToIntByLSBFirst(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (int)((b3 << 24) + (b22 << 16) + (b1 << 8) + b0);
    }

    public static long fourBytesToUnsignedLongByLSBFirst(byte[] b2) {
        long b3 = b2[3] & 0xFF;
        long b22 = b2[2] & 0xFF;
        long b1 = b2[1] & 0xFF;
        long b0 = b2[0] & 0xFF;
        return (b3 << 24) + (b22 << 16) + (b1 << 8) + b0;
    }

    public static byte[] random16Bytes() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String fourByteToDate(byte[] date) {
        if (!ByteUtility.isLostDateFormat(date)) {
            long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(date);
            String dateString = null;
            SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            f2.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            long k = timeStamp * 1000L;
            Date d2 = new Date(k);
            dateString = f2.format(d2);
            return dateString;
        }
        return "";
    }

    public static boolean isLostDateFormat(byte[] date) {
        byte[] emptyArray = new byte[]{-1, -1, -1, -1};
        return Arrays.equals(date, emptyArray);
    }

    public static String fourByteToDateFormat2(byte[] date) {
        if (!ByteUtility.isLostDateFormat(date)) {
            return ByteUtility.fourByteToDateFormatSpecific(date, "yyyy/MM/dd HH:mm:ss");
        }
        return "";
    }

    public static String fourByteToDateFormatSpecific(byte[] date, String pattern) {
        long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(date);
        String dateString = null;
        SimpleDateFormat f2 = new SimpleDateFormat(pattern);
        f2.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        long k = timeStamp * 1000L;
        Date d2 = new Date(k);
        dateString = f2.format(d2);
        return dateString;
    }

    private static long addTimeZoneOffset(long time) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c2 = new GregorianCalendar(tz);
        c2.setTimeInMillis(time);
        long zoneOffset = 0L;
        zoneOffset = c2.get(15) + c2.get(16);
        return time - zoneOffset;
    }

    public static byte[] toBinArray(String hexStr) {
        char[] hexChars = hexStr.toCharArray();
        int startIndex = 0;
        int length = hexChars.length;
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Length must be even");
        }
        byte[] result = new byte[length / 2];
        for (int j2 = 0; j2 < result.length; ++j2) {
            result[j2] = (byte)(ByteUtility.hexCharToNibble(hexChars[startIndex++]) * 16 + ByteUtility.hexCharToNibble(hexChars[startIndex++]));
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        char[] chars = str.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] >= '0' && chars[i2] <= '9') continue;
            return false;
        }
        return true;
    }

    private static int hexCharToNibble(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex char - '" + ch + "'");
    }

    public static int bcdToInt(byte b2) {
        int d0 = b2 & 0xF;
        int d1 = b2 & 0xF0;
        return 10 * (d1 >>= 4) + d0;
    }

    public static byte intToBCD(int i2) {
        int b1 = i2 / 10;
        int b0 = i2 % 10;
        return (byte)((b1 <<= 4) + b0);
    }

    public static int ipToInt(String ip) {
        int intValue = 0;
        StringTokenizer st = new StringTokenizer(ip, ".");
        intValue = (Integer.parseInt(st.nextToken()) << 24) + (Integer.parseInt(st.nextToken()) << 16) + (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        return intValue;
    }

    public static byte[] ipToBytes(String ip) throws NumberFormatException {
        byte[] bytes = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        bytes[0] = (byte)Integer.parseInt(st.nextToken());
        bytes[1] = (byte)Integer.parseInt(st.nextToken());
        bytes[2] = (byte)Integer.parseInt(st.nextToken());
        bytes[3] = (byte)Integer.parseInt(st.nextToken());
        return bytes;
    }

    public static String bytesToHexNoSpace(byte[] b2) {
        if (b2 == null || b2.length == 0) {
            return "";
        }
        char[] ret = new char[b2.length * 2];
        int j2 = 0;
        for (int i2 = 0; i2 < b2.length; ++i2) {
            ret[j2++] = hex[(b2[i2] & 0xF0) >> 4];
            ret[j2++] = hex[b2[i2] & 0xF];
        }
        return new String(ret);
    }

    public static boolean validateKeyFormat(String value) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}");
        Matcher m = macPattern.matcher(value);
        return m.matches();
    }

    public static boolean validateHSMKeyFormat(String value) {
        if ((!value.contains("ProductKey") || !value.contains("Node") || !value.contains("Signature") || !value.contains("LicenseID") || !value.contains("LicenseName") || !value.contains("CreateDate")) && value.contains("ProductKey") && value.contains("Node") && value.contains("DateTime") && value.contains("SwName") && value.contains("MAC") && value.contains("SwType")) {
            return false;
        }
        return !value.contains("\"{") && !value.contains("}\"") && !value.contains("\\\"");
    }

    public static byte[] fromFormatKey(String data) throws Exception {
        if (!ByteUtility.validateKeyFormat(data)) {
            throw new Exception("Node product Key format error");
        }
        String orgByteStr = "";
        Scanner scan = new Scanner(data);
        scan.useDelimiter("-");
        while (scan.hasNext()) {
            orgByteStr = orgByteStr + scan.next();
        }
        if (null != scan) {
            scan.close();
        }
        byte[] keyBytes = ByteUtility.toBinArray(orgByteStr);
        return keyBytes;
    }

    public static byte[] getSubBytes(byte[] raw, int from, int to) {
        return Arrays.copyOfRange(raw, from, to);
    }

    public static void main(String[] args) {
        byte[] c2 = new byte[]{-102, 0};
        System.out.println(ByteUtility.twoBytesToInt(c2));
        byte[] a2 = new byte[20];
        System.out.println(ByteUtility.bytesToHex(a2));
        System.out.println(ByteUtility.byteToHex(ByteUtility.intToBCD(33)));
        System.out.println(Calendar.getInstance().get(1));
        int ip = ByteUtility.ipToInt("2.168.1.1");
        int gw = ByteUtility.ipToInt("2.168.127.254");
        int nm = ByteUtility.ipToInt("255.255.128.0");
        System.out.println("ip =" + ip);
        System.out.println("gw =" + gw);
        System.out.println("nm =" + nm);
        if ((ip & nm) == (gw & nm)) {
            System.out.println("yes");
        } else {
            System.out.println("no");
        }
        System.out.println(ByteUtility.bytesToHex(ByteUtility.random16Bytes()));
        byte tester = -55;
        System.out.println(ByteUtility.checkBit(tester, 0));
        System.out.println(ByteUtility.checkBit(tester, 1));
        System.out.println(ByteUtility.checkBit(tester, 2));
        System.out.println(ByteUtility.checkBit(tester, 3));
        System.out.println(ByteUtility.checkBit(tester, 4));
        System.out.println(ByteUtility.checkBit(tester, 5));
        System.out.println(ByteUtility.checkBit(tester, 6));
        System.out.println(ByteUtility.checkBit(tester, 7));
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String getDateTimeShortString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return f2.format(date);
    }

    public static String getDateShortString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("yyyyMMdd");
        return f2.format(date);
    }

    public static String getTimeShortString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("HHmmss");
        return f2.format(date);
    }

    public static String getDateTimeString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        return f2.format(date);
    }

    public static String transferDateFormat(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        String result = "";
        try {
            date = df.parse(s);
        }
        catch (ParseException e2) {
            return null;
        }
        result = sdf.format(date);
        return result;
    }

    public static String transferDateFormatFromBiosFormat(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        Date date = null;
        String result = "";
        try {
            date = df.parse(s);
        }
        catch (ParseException e2) {
            return null;
        }
        result = sdf.format(date);
        return result;
    }

    public static String getTimeString() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f2 = new SimpleDateFormat("HH:mm:ss");
        return f2.format(date);
    }

    public static int checkBit(byte value, int pos) {
        if ((value & 1 << pos) > 0) {
            return 1;
        }
        return 0;
    }

    public static byte[] arrayTrimZero(byte[] data) {
        byte[] dataArr = new byte[data.length];
        int count = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2] == 0) continue;
            dataArr[count] = data[i2];
            ++count;
        }
        byte[] result = new byte[count];
        for (int j2 = 0; j2 < dataArr.length; ++j2) {
            if (data[j2] == 0) continue;
            result[j2] = dataArr[j2];
        }
        return result;
    }

    public static byte binToByte(String s) {
        String hexStr = new BigInteger(s, 2).toString(16);
        byte[] data = ByteUtility.hexToBytes(String.format("%2s", hexStr).replace(' ', '0'));
        if (data.length != 1) {
            throw new IllegalArgumentException("Transform format incorrect");
        }
        return data[0];
    }
}

