/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class CRC8 {
    static final byte[] crcTbl = new byte[256];
    private static char[] hexDigits;

    public static byte crc8(byte[] data) {
        byte crcReg = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            crcReg = crcTbl[(crcReg ^ data[i2]) & 0xFF];
        }
        return crcReg;
    }

    private static String hexString(byte b2) {
        return hexDigits[0xF & b2 >> 4] + "" + hexDigits[b2 & 0xF];
    }

    private static void test(byte[] vec) {
        System.out.println(CRC8.hexString(CRC8.crc8(vec)));
    }

    public static void main(String[] args) {
        CRC8.test(new byte[]{84});
        CRC8.test(new byte[]{3, 115});
        CRC8.test(new byte[]{1, 63});
    }

    static {
        int polynomial = 7;
        for (int i2 = 0; i2 < 256; ++i2) {
            byte j2 = (byte)i2;
            for (int k = 0; k < 8; ++k) {
                j2 = (byte)(j2 < 0 ? j2 << 1 ^ polynomial : j2 << 1);
            }
            CRC8.crcTbl[i2] = j2;
        }
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

