/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class DiagnosticCommand
extends IPMICommand {
    public DiagnosticCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getDiagnosticStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{50, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDiagnosticStatusCommand(byte[] pdata) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + pdata.length];
        data[0] = 50;
        data[1] = 1;
        System.arraycopy(pdata, 0, data, 2, pdata.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean isDiagnosticSupported() {
        IPMIMessage resMessage = this.getDiagnosticStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                try {
                    this.fromRaw(resMessage.data);
                }
                catch (Exception e2) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean beginDiagnostic() {
        byte[] data = new byte[]{0};
        IPMIMessage resMessage = this.setDiagnosticStatusCommand(data);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public byte[] getDiagnosticRaw() throws IPMIException {
        IPMIMessage resMessage = this.getDiagnosticStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getDiagnosticStatusCommand failed");
    }

    public Diagnostic fromRaw(byte[] raw) {
        Diagnostic diag = new Diagnostic();
        diag.revision = raw[0];
        diag.totalCase = raw[1];
        diag.currentCase = raw[2];
        diag.action = raw[3];
        diag.item = raw[4];
        diag.name1 = new byte[7];
        diag.name2 = new byte[7];
        diag.time = new byte[7];
        System.arraycopy(raw, 5, diag.name1, 0, 7);
        System.arraycopy(raw, 13, diag.name2, 0, 7);
        diag.progress = raw[21];
        System.arraycopy(raw, 22, diag.time, 0, 7);
        return diag;
    }

    public class Diagnostic {
        public byte revision;
        public byte totalCase;
        public byte currentCase;
        public byte action;
        public byte item;
        public byte[] name1;
        public byte[] name2;
        public byte progress;
        public byte[] time;

        public byte getRevision() {
            return this.revision;
        }

        public byte getTotalCase() {
            return this.totalCase;
        }

        public byte getCurrentCase() {
            return this.currentCase;
        }

        public String getAction() {
            String actionString = "";
            switch (this.action) {
                case 1: {
                    actionString = "Collecting";
                    break;
                }
                case 2: {
                    actionString = "Detecting";
                    break;
                }
                case 3: {
                    actionString = "Diagnosting";
                }
            }
            return actionString;
        }

        public String getItem() {
            String itemString = "";
            switch (this.item) {
                case 1: {
                    itemString = "BackPlane";
                    break;
                }
                case 2: {
                    itemString = "Bios";
                    break;
                }
                case 3: {
                    itemString = "CPU";
                    break;
                }
                case 4: {
                    itemString = "Display";
                    break;
                }
                case 5: {
                    itemString = "Fan";
                    break;
                }
                case 6: {
                    itemString = "HDD";
                    break;
                }
                case 7: {
                    itemString = "IPMI";
                    break;
                }
                case 8: {
                    itemString = "Memory";
                    break;
                }
                case 9: {
                    itemString = "Network";
                    break;
                }
                case 10: {
                    itemString = "PCIe";
                    break;
                }
                case 11: {
                    itemString = "PSU";
                    break;
                }
                case 12: {
                    itemString = "RAID";
                    break;
                }
                case 13: {
                    itemString = "Sensor";
                    break;
                }
                case 14: {
                    itemString = "Serial IO";
                }
            }
            return itemString;
        }

        public byte getProgress() {
            return this.progress;
        }

        public String getTime() {
            String timeString = "";
            for (int i2 = 0; i2 < 7; ++i2) {
                timeString = timeString + Byte.toString(this.time[i2]);
            }
            return timeString;
        }
    }
}

