/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRU;
import com.supermicro.ipmi.FRU_Internal;
import com.supermicro.ipmi.FRU_MultiRecordData;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;

public class FRUInfo {
    public FRU fru = new FRU();

    public static FRUInfo fromRaw(byte[] raw) {
        FRUInfo fruInfo = new FRUInfo();
        byte commonHeaderVersion = raw[0];
        byte internalUseAreaOffset = raw[1];
        byte chassisInfoAreaOffset = raw[2];
        byte boardInfoAreaOffset = raw[3];
        byte productInfoAreaOffset = raw[4];
        byte multiRecordAreaOffset = raw[5];
        fruInfo.fru.common.formatVersion = raw[0];
        fruInfo.fru.common.internalUseArea = raw[1];
        fruInfo.fru.common.chassisInfoArea = raw[2];
        fruInfo.fru.common.boardInfoArea = raw[3];
        fruInfo.fru.common.productInfoArea = raw[4];
        fruInfo.fru.common.multiRecordArea = raw[5];
        if (commonHeaderVersion != 1) {
            return null;
        }
        if (internalUseAreaOffset != 0) {
            fruInfo.fru.isInternalExist = true;
            FRUInfo.parseFRUInternalUse(fruInfo, internalUseAreaOffset, raw);
        }
        if (chassisInfoAreaOffset != 0) {
            fruInfo.fru.isChassisExist = true;
            FRUInfo.parseFRUChassisInfo(fruInfo, chassisInfoAreaOffset, raw);
        }
        if (boardInfoAreaOffset != 0) {
            fruInfo.fru.isBoardExist = true;
            FRUInfo.parseFRUBoardInfo(fruInfo, boardInfoAreaOffset, raw);
        }
        if (productInfoAreaOffset != 0) {
            fruInfo.fru.isProductExist = true;
            FRUInfo.parseFRUProductInfo(fruInfo, productInfoAreaOffset, raw);
        }
        if (multiRecordAreaOffset != 0) {
            fruInfo.fru.isMultiRecordExist = true;
            FRUInfo.parseMultiRecordInfo(fruInfo, multiRecordAreaOffset, raw);
        }
        return fruInfo;
    }

    public static FRUInfo fromFRU1Raw(byte[] raw) {
        FRUInfo fruInfo = new FRUInfo();
        byte commonHeaderVersion = raw[0];
        byte internalUseAreaOffset = raw[1];
        byte chassisInfoAreaOffset = raw[2];
        byte boardInfoAreaOffset = raw[3];
        byte productInfoAreaOffset = raw[4];
        byte multiRecordAreaOffset = raw[5];
        fruInfo.fru.common.formatVersion = raw[0];
        fruInfo.fru.common.internalUseArea = raw[1];
        fruInfo.fru.common.chassisInfoArea = raw[2];
        fruInfo.fru.common.boardInfoArea = raw[3];
        fruInfo.fru.common.productInfoArea = raw[4];
        fruInfo.fru.common.multiRecordArea = raw[5];
        if (commonHeaderVersion != 1) {
            return null;
        }
        if (internalUseAreaOffset != 0) {
            fruInfo.fru.isInternalExist = true;
            FRUInfo.parseFRUInternalUse(fruInfo, internalUseAreaOffset, raw);
        }
        if (chassisInfoAreaOffset != 0) {
            fruInfo.fru.isChassisExist = true;
            FRUInfo.parseFRUChassisInfo(fruInfo, chassisInfoAreaOffset, raw);
        }
        if (boardInfoAreaOffset != 0) {
            fruInfo.fru.isBoardExist = true;
            FRUInfo.parseFRU1BoardInfo(fruInfo, boardInfoAreaOffset, raw);
        }
        if (productInfoAreaOffset != 0) {
            fruInfo.fru.isProductExist = true;
            FRUInfo.parseFRUProductInfo(fruInfo, productInfoAreaOffset, raw);
        }
        if (multiRecordAreaOffset != 0) {
            fruInfo.fru.isMultiRecordExist = true;
            FRUInfo.parseMultiRecordInfo(fruInfo, multiRecordAreaOffset, raw);
        }
        return fruInfo;
    }

    private static void parseFRUInternalUse(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        FRU_Internal cfr_ignored_0 = fruInfo.fru.internal;
        int internalUseAreaSize = FRU_Internal.fixedInternalAreaSize;
        fruInfo.fru.internal.formatVersion = data[index];
        byte[] tempBytes = new byte[internalUseAreaSize - 1];
        System.arraycopy(data, ++index, tempBytes, 0, tempBytes.length);
        fruInfo.fru.internal.useData = tempBytes;
    }

    private static void parseFRUChassisInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index;
        int accIndex = index = offset * 8;
        fruInfo.fru.chassis.formatVersion = data[accIndex];
        fruInfo.fru.chassis.length = data[++accIndex];
        fruInfo.fru.chassis.chassisType = data[++accIndex];
        fruInfo.fru.chassis.partNumberLength = data[++accIndex];
        byte[] tempBytes = new byte[fruInfo.fru.chassis.partNumberLength & 0x3F];
        System.arraycopy(data, ++accIndex, tempBytes, 0, tempBytes.length);
        String partNumber = new String(tempBytes);
        fruInfo.fru.chassis.partNumber = tempBytes;
        fruInfo.fru.chassis.serialNumberLength = data[accIndex += tempBytes.length];
        tempBytes = new byte[fruInfo.fru.chassis.serialNumberLength & 0x3F];
        System.arraycopy(data, ++accIndex, tempBytes, 0, tempBytes.length);
        String serialNumber = new String(tempBytes);
        fruInfo.fru.chassis.serialNumber = tempBytes;
        int customInfoSize = 0;
        int tempIndex = accIndex += tempBytes.length;
        while (data[tempIndex] != -63) {
            ++customInfoSize;
            if (data.length != ++tempIndex + 1) continue;
            System.out.println("equal data size; break");
            break;
        }
        if (customInfoSize > 0) {
            tempBytes = new byte[customInfoSize];
            System.arraycopy(data, accIndex, tempBytes, 0, tempBytes.length);
            fruInfo.fru.chassis.customChassisInfo = tempBytes;
            accIndex += tempBytes.length;
        }
    }

    private static void parseFRUBoardInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        String mfgDataTime = "" + data[index + 3] + "" + data[index + 4] + "" + data[index + 5];
        fruInfo.fru.board.formatVersion = data[index];
        fruInfo.fru.board.length = data[index + 1];
        fruInfo.fru.board.languageCode = data[index + 2];
        fruInfo.fru.board.mfgDateTime[0] = data[index + 3];
        fruInfo.fru.board.mfgDateTime[1] = data[index + 4];
        fruInfo.fru.board.mfgDateTime[2] = data[index + 5];
        byte[] tempBytes = new byte[data[index + 6] & 0x3F];
        System.arraycopy(data, index + 7, tempBytes, 0, tempBytes.length);
        String manufacturerName = new String(tempBytes);
        fruInfo.fru.board.boardManufacturer = tempBytes;
        int accIndex = index + 6 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        fruInfo.fru.board.boardProductName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardSerialNumber = new String(tempBytes);
        fruInfo.fru.board.boardSerialNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardPartNumber = new String(tempBytes);
        fruInfo.fru.board.boardPartNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardFruFileID = new String(tempBytes);
        fruInfo.fru.board.boardFruFileID = tempBytes;
        int customInfoSize = 0;
        int tempIndex = accIndex += tempBytes.length + 1;
        while (data[tempIndex] != -63) {
            if (customInfoSize == 0) {
                fruInfo.fru.board.customBoardInfoLength = data[tempIndex];
            }
            ++customInfoSize;
            if (data.length != ++tempIndex + 1) continue;
        }
        if (customInfoSize > 0) {
            tempBytes = new byte[data[accIndex] & 0x3F];
            System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
            fruInfo.fru.board.customBoardInfo = tempBytes;
            accIndex += tempBytes.length;
        }
    }

    private static void parseFRU1BoardInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        String mfgDataTime = "" + data[index + 3] + "" + data[index + 4] + "" + data[index + 5];
        fruInfo.fru.board.formatVersion = data[index];
        fruInfo.fru.board.length = data[index + 1];
        fruInfo.fru.board.languageCode = data[index + 2];
        fruInfo.fru.board.mfgDateTime[0] = data[index + 3];
        fruInfo.fru.board.mfgDateTime[1] = data[index + 4];
        fruInfo.fru.board.mfgDateTime[2] = data[index + 5];
        byte[] tempBytes = new byte[data[index + 6] & 0x3F];
        System.arraycopy(data, index + 7, tempBytes, 0, tempBytes.length);
        String manufacturerName = new String(tempBytes);
        fruInfo.fru.board.boardManufacturer = tempBytes;
        int accIndex = index + 6 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        fruInfo.fru.board.boardProductName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardSerialNumber = new String(tempBytes);
        fruInfo.fru.board.boardSerialNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardPartNumber = new String(tempBytes);
        fruInfo.fru.board.boardPartNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String boardFruFileID = new String(tempBytes);
        fruInfo.fru.board.boardFruFileID = tempBytes;
        int customInfoSize = 0;
        int tempIndex = accIndex += tempBytes.length + 1;
        while (data[tempIndex] != -63) {
            if (customInfoSize == 0) {
                fruInfo.fru.board.customBoardInfoLength = data[tempIndex];
            }
            ++customInfoSize;
            if (data.length != ++tempIndex + 1) continue;
        }
        if (customInfoSize > 0) {
            tempBytes = new byte[data[accIndex] & 0x3F];
            System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
            fruInfo.fru.board.customBoardInfo = tempBytes;
            accIndex += tempBytes.length;
        }
    }

    private static void parseFRUProductInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        byte languageCode = data[index + 2];
        fruInfo.fru.product.formatVersion = data[index];
        fruInfo.fru.product.length = data[index + 1];
        fruInfo.fru.product.languageCode = data[index + 2];
        byte[] tempBytes = new byte[data[index + 3] & 0x3F];
        System.arraycopy(data, index + 4, tempBytes, 0, tempBytes.length);
        String productManufacturerName = new String(tempBytes);
        fruInfo.fru.product.productManufacturerName = tempBytes;
        int accIndex = index + 3 + tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productName = new String(tempBytes);
        fruInfo.fru.product.productName = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productPartModelNumber = new String(tempBytes);
        fruInfo.fru.product.productPartModelNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productVersion = new String(tempBytes);
        fruInfo.fru.product.productVersion = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String productSerialNumber = new String(tempBytes);
        fruInfo.fru.product.productSerialNumber = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String assetTag = new String(tempBytes);
        fruInfo.fru.product.assetTag = tempBytes;
        accIndex += tempBytes.length + 1;
        tempBytes = new byte[data[accIndex] & 0x3F];
        System.arraycopy(data, accIndex + 1, tempBytes, 0, tempBytes.length);
        String prodcutfruFileID = new String(tempBytes);
        fruInfo.fru.product.fruFileID = tempBytes;
        int customInfoSize = 0;
        int tempIndex = accIndex += tempBytes.length + 1;
        while (data[tempIndex] != -63) {
            ++customInfoSize;
            if (data.length != ++tempIndex + 1) continue;
        }
        if (customInfoSize > 0) {
            tempBytes = new byte[customInfoSize];
            System.arraycopy(data, accIndex, tempBytes, 0, tempBytes.length);
            fruInfo.fru.product.customProductInfo = tempBytes;
            accIndex += tempBytes.length;
        }
    }

    private static void parseMultiRecordInfo(FRUInfo fruInfo, int offset, byte[] data) {
        int index = offset * 8;
        boolean hasNextRecord = true;
        int accIndex = index;
        do {
            FRU_MultiRecordData multiRecordData = new FRU_MultiRecordData();
            multiRecordData.recordTypeID = data[accIndex];
            multiRecordData.flag = data[++accIndex];
            multiRecordData.recordLength = data[++accIndex];
            multiRecordData.recordChecksum = data[++accIndex];
            multiRecordData.headerChecksum = data[++accIndex];
            ++accIndex;
            if (multiRecordData.recordLength == -1 || multiRecordData.recordLength < 0) break;
            multiRecordData.data = new byte[multiRecordData.recordLength];
            System.arraycopy(data, accIndex, multiRecordData.data, 0, multiRecordData.recordLength);
            accIndex += multiRecordData.recordLength;
            if ((byte)(multiRecordData.flag & 0x80) == -128) {
                hasNextRecord = false;
            }
            fruInfo.fru.multiRecord.multiRecordData.add(multiRecordData);
        } while (hasNextRecord);
    }

    public String toString() {
        return this.toReadableString();
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        if (this.fru.isInternalExist) {
            sb.append("Internal Use Area         = " + ByteUtility.bytesToHex(this.fru.internal.useData) + "\n");
        }
        if (this.fru.isChassisExist) {
            sb.append("Chassis Type (CT)              = " + this.fru.chassis.getChassisTypeDesc() + " (" + ByteUtility.byteToHex(this.fru.chassis.chassisType) + "h)\n");
            sb.append("Chassis Part Number (CP)       = " + new String(this.fru.chassis.partNumber) + "\n");
            sb.append("Chassis Serial Number (CS)     = " + new String(this.fru.chassis.serialNumber) + "\n");
            if (this.fru.chassis.customChassisInfo != null && this.fru.chassis.customChassisInfo.length != 0) {
                sb.append("Chassis custom Info            = " + ByteUtility.bytesToHex(this.fru.chassis.customChassisInfo) + "\n");
            }
        }
        if (this.fru.isBoardExist) {
            sb.append("Board mfg. Date/Time (BDT)     = " + new String(FRUInfo.getMfgDateTime(this.fru.board.mfgDateTime)) + "\n");
            sb.append("Board Manufacturer Name (BM)   = " + new String(this.fru.board.boardManufacturer) + "\n");
            sb.append("Board Product Name (BPN)       = " + new String(this.fru.board.boardProductName) + "\n");
            sb.append("Board Serial Number (BS)       = " + new String(this.fru.board.boardSerialNumber) + "\n");
            sb.append("Board Part Number (BP)         = " + new String(this.fru.board.boardPartNumber) + "\n");
            sb.append("Board FRU File ID              = " + new String(this.fru.board.boardFruFileID) + "\n");
            if (this.fru.board.customBoardInfo != null && this.fru.board.customBoardInfo.length != 0) {
                sb.append("Board custom Info              = " + ByteUtility.bytesToHex(this.fru.board.customBoardInfo) + "\n");
            }
        }
        if (this.fru.isProductExist) {
            sb.append("Product Manufacturer Name (PM) = " + new String(this.fru.product.productManufacturerName) + "\n");
            sb.append("Product Name (PN)              = " + new String(this.fru.product.productName) + "\n");
            sb.append("Product PartModel Number (PPM) = " + new String(this.fru.product.productPartModelNumber) + "\n");
            sb.append("Product Version (PV)           = " + new String(this.fru.product.productVersion) + "\n");
            sb.append("Product Serial Number (PS)     = " + new String(this.fru.product.productSerialNumber) + "\n");
            sb.append("Product Asset Tag (PAT)        = " + new String(this.fru.product.assetTag) + "\n");
            sb.append("Product FRU File ID            = " + new String(this.fru.product.fruFileID) + "\n");
            if (this.fru.product.customProductInfo != null && this.fru.product.customProductInfo.length != 0) {
                sb.append("Product custom Info            = " + ByteUtility.bytesToHex(this.fru.product.customProductInfo) + "\n");
            }
        }
        if (this.fru.isMultiRecordExist) {
            sb.append(this.fru.multiRecord.toString());
        }
        return sb.toString();
    }

    public String toReadableStringForFRU1() {
        StringBuffer sb = new StringBuffer();
        if (this.fru.isInternalExist) {
            sb.append("Internal Use Area         = " + ByteUtility.bytesToHex(this.fru.internal.useData) + "\n");
        }
        if (this.fru.isChassisExist) {
            sb.append("Chassis Type (CT)              = " + this.fru.chassis.getChassisTypeDesc() + " (" + ByteUtility.byteToHex(this.fru.chassis.chassisType) + "h)\n");
            sb.append("Chassis Part Number (CP)       = " + new String(this.fru.chassis.partNumber) + "\n");
            sb.append("Chassis Serial Number (CS)     = " + new String(this.fru.chassis.serialNumber) + "\n");
            if (this.fru.chassis.customChassisInfo != null && this.fru.chassis.customChassisInfo.length != 0) {
                sb.append("Chassis custom Info            = " + ByteUtility.bytesToHex(this.fru.chassis.customChassisInfo) + "\n");
            }
        }
        sb.append("Board mfg. Date/Time (BDT)     = " + new String(FRUInfo.getMfgDateTime(this.fru.board.mfgDateTime)) + "\n");
        sb.append("Board Manufacturer Name (BM)   = " + new String(this.fru.board.boardManufacturer) + "\n");
        sb.append("Board Product Name (BPN)       = " + new String(this.fru.board.boardProductName) + "\n");
        sb.append("Board Serial Number (BS)       = " + new String(this.fru.board.boardSerialNumber) + "\n");
        sb.append("Board Part Number (BP)         = " + new String(this.fru.board.boardPartNumber) + "\n");
        sb.append("Board FRU File ID              = " + new String(this.fru.board.boardFruFileID) + "\n");
        sb.append("Board Version (BV)             = " + new String(this.fru.board.customBoardInfo) + "\n");
        sb.append("Product Manufacturer Name (PM) = " + new String(this.fru.product.productManufacturerName) + "\n");
        sb.append("Product Name (PN)              = " + new String(this.fru.product.productName) + "\n");
        sb.append("Product PartModel Number (PPM) = " + new String(this.fru.product.productPartModelNumber) + "\n");
        sb.append("Product Version (PV)           = " + new String(this.fru.product.productVersion) + "\n");
        sb.append("Product Serial Number (PS)     = " + new String(this.fru.product.productSerialNumber) + "\n");
        sb.append("Product Asset Tag (PAT)        = " + new String(this.fru.product.assetTag) + "\n");
        sb.append("Product FRU File ID            = " + new String(this.fru.product.fruFileID) + "\n");
        if (this.fru.product.customProductInfo != null && this.fru.product.customProductInfo.length != 0) {
            sb.append("Product custom Info            = " + ByteUtility.bytesToHex(Arrays.copyOfRange(this.fru.product.customProductInfo, 1, this.fru.product.customProductInfo.length)) + "\n");
        }
        if (this.fru.isMultiRecordExist) {
            sb.append(this.fru.multiRecord.toString());
        }
        return sb.toString();
    }

    public String toReadableStringForMidPlane() {
        StringBuffer sb = new StringBuffer();
        String language = "English";
        if (this.fru.board.languageCode == 0) {
            language = "English";
        }
        sb.append("Board Info: \n");
        sb.append("---------------------------\n");
        sb.append("Language                  = " + language + "\n");
        sb.append("Board mfg. Date/Time      = " + new String(FRUInfo.getMfgDateTime(this.fru.board.mfgDateTime)) + "\n");
        sb.append("Board Manufacturer Name   = " + new String(this.fru.board.boardManufacturer) + "\n");
        sb.append("Board Product Name        = " + new String(this.fru.board.boardProductName) + "\n");
        sb.append("Board Serial Number       = " + new String(this.fru.board.boardSerialNumber) + "\n");
        sb.append("Board Part Number         = " + new String(this.fru.board.boardPartNumber) + "\n");
        sb.append("\nProduct Info: \n");
        sb.append("---------------------------\n");
        sb.append("Product Manufacturer Name = " + new String(this.fru.product.productManufacturerName) + "\n");
        sb.append("Product Name              = " + new String(this.fru.product.productName) + "\n");
        sb.append("Product PartModel Number  = " + new String(this.fru.product.productPartModelNumber) + "\n");
        sb.append("Product Version           = " + new String(this.fru.product.productVersion) + "\n");
        sb.append("Product Serial Number     = " + new String(this.fru.product.productSerialNumber) + "\n");
        sb.append("Product Asset Tag         = " + new String(this.fru.product.assetTag) + "\n");
        return sb.toString();
    }

    private static String getMfgDateTime(byte[] mfgDateTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.set(1996, 0, 1, 0, 0, 0);
        long timeValue = ((long)(mfgDateTime[2] & 0xFF) << 16) + ((long)(mfgDateTime[1] & 0xFF) << 8) + (long)(mfgDateTime[0] & 0xFF);
        cal.setTimeInMillis(cal.getTimeInMillis() + (timeValue *= 60000L));
        return sdf.format(cal.getTime()) + " (" + ByteUtility.byteToHex(mfgDateTime[0]) + " " + ByteUtility.byteToHex(mfgDateTime[1]) + " " + ByteUtility.byteToHex(mfgDateTime[2]) + ")";
    }

    public static void main(String[] args) {
        byte[] b2 = new byte[]{-1, -1, -1};
        String s = FRUInfo.getMfgDateTime(b2);
        System.out.println("s =" + s);
    }
}

