/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class FRU_Chassis {
    public byte formatVersion = 1;
    public byte length;
    public byte chassisType;
    public byte partNumberLength;
    public byte[] partNumber = new byte[0];
    public byte serialNumberLength;
    public byte[] serialNumber = new byte[0];
    public byte[] customChassisInfo = new byte[0];
    public byte endOfInfoField = (byte)-63;
    public byte checkSum;
    public String[] chassisTypeDesc = new String[]{"Unspecified", "Other", "Unknown", "Desktop", "Low Profile Desktop", "Pizza Box", "Mini Tower", "Tower", "Portable", "LapTop", "Notebook", "Hand Held", "Docking Station", "All in One", "Sub Notebook", "Space-saving", "Lunch Box", "Main Server Chassis", "Expansion Chassis", "SubChassis", "Bus Expansion Chassis", "Peripheral Chassis", "RAID Chassis", "Rack Mount Chassis", "Sealed-case PC", "Multi-system Chassis", "CompactPCI", "AdvancedTCA", "Blade", "Blade Enclosure", "Tablet", "Convertible", "Detachable", "IoT Gateway", "Embedded PC", "Mini PC", "Stick PC"};

    public String getChassisTypeDesc() {
        if (this.chassisType < 1 || this.chassisType > 36) {
            return "undefined";
        }
        return this.chassisTypeDesc[this.chassisType];
    }

    public byte[] toRaw() {
        int i2;
        this.checkSum = 0;
        int size = 7 + this.partNumber.length + this.serialNumber.length + this.customChassisInfo.length;
        int padSize = 8 - size % 8;
        if (padSize == 8) {
            padSize = 0;
        }
        byte[] raw = new byte[size + padSize];
        int index = 0;
        raw[index] = this.formatVersion;
        raw[++index] = (byte)(raw.length / 8);
        raw[++index] = this.chassisType;
        raw[++index] = this.partNumberLength = (byte)(192 + this.partNumber.length);
        System.arraycopy(this.partNumber, 0, raw, ++index, this.partNumber.length);
        raw[index += this.partNumber.length] = this.serialNumberLength = (byte)(192 + this.serialNumber.length);
        System.arraycopy(this.serialNumber, 0, raw, ++index, this.serialNumber.length);
        System.arraycopy(this.customChassisInfo, 0, raw, index += this.serialNumber.length, this.customChassisInfo.length);
        raw[index += this.customChassisInfo.length] = this.endOfInfoField;
        ++index;
        for (i2 = 0; i2 < padSize; ++i2) {
            raw[index] = 0;
            ++index;
        }
        for (i2 = 0; i2 < raw.length - 1; ++i2) {
            this.checkSum = (byte)(this.checkSum + raw[i2]);
        }
        raw[index] = this.checkSum = (byte)(-this.checkSum);
        return raw;
    }

    public void testData() {
        this.customChassisInfo = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
    }
}

