/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.microblade.cmmdiag.CMMDiagCpuTemp;
import com.supermicro.ipmi.microblade.cmmdiag.NodeStatus;
import java.util.Arrays;
import nn.pp.drvredir.ByteUtility;

public class IPMICMMDiagCommand
extends IPMICommand {
    public IPMICMMDiagCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getBBPFWCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{34};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBBPThrottleCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-17, 13, -120, 2, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkCMMRemainPowerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage compareCPUTemperatureWithTJMaxCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-10, 3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage powerCappingDiagnosingCommand(byte bladeLocation, byte nodeLocatoin) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{33, bladeLocation, nodeLocatoin};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMicroBladeCommand(byte type, byte bladeLocation, byte nodeLocatoin) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-15, type, bladeLocation, 0, nodeLocatoin, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage powerReadingCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage generateTroubleShootingCommand(byte option) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{62, 0, option};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGeneratingStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{62, 2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerCappingValueCommand(byte bladeLocation, byte nodeLocatoin) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-9, bladeLocation, nodeLocatoin, 48, 113, 12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBMCRegIDCommand(byte bladeLocation, byte nodeLocatoin) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-9, bladeLocation, nodeLocatoin, 6, 82, 3, 112, 1, 4};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGPIOStateCommand(byte bladeLocation, byte nodeLocatoin, byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-9, bladeLocation, nodeLocatoin, 48, 112, -61, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGPLDGPOCommand(byte bladeLocation, byte nodeLocatoin, byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-9, bladeLocation, nodeLocatoin, 6, 82, 3, 112, 1, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPSUStatusCommand(byte psuLocation, byte psuSubLocation) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-17, psuLocation, psuSubLocation, 1, 12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getBBPFW() throws IPMIException {
        IPMIMessage resMessage = this.getBBPFWCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException("Can't execute get bbp firmware command");
        }
        throw new IPMIException("Can't execute get bbp firmware command");
    }

    public boolean isBBPThrottle() throws IPMIException {
        IPMIMessage resMessage = this.getBBPThrottleCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[0] == 85 || resMessage.data[0] == -86) && resMessage.data[1] == 85;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute get bbp throttle command");
    }

    public boolean isCMMRemainPower() throws IPMIException {
        IPMIMessage resMessage = this.checkCMMRemainPowerCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] != 0 || resMessage.data[1] != 0;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute is CMM remain power command");
    }

    public byte getPowerCapping(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.powerCappingDiagnosingCommand(bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute get power capping command");
    }

    public NodeStatus checkBladeInitial(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)41, bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                NodeStatus node = new NodeStatus();
                node.fromRaw(resMessage.data);
                return node;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute check blade initial command");
    }

    public byte[] checkNodesPresent(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)38, bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute nodes present command");
    }

    public byte[] getSpecialCaseOfNodeIP(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)39, bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute check blade initial command");
    }

    public byte getBladeThrottle(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)42, bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get Blade Throttle");
    }

    public byte[] getBladeCPLDVersion(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getMicroBladeCommand((byte)45, bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get Blade Throttle");
    }

    public byte[] getPowerCappingValue(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getPowerCappingValueCommand(bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get Blade Throttle");
    }

    public byte getBMCRegID(byte bladeLocation, byte nodeLocatoin) throws IPMIException {
        IPMIMessage resMessage = this.getBMCRegIDCommand(bladeLocation, nodeLocatoin);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get Blade Throttle");
    }

    public byte getGPIOState(byte bladeLocation, byte nodeLocatoin, byte index) throws IPMIException {
        IPMIMessage resMessage = this.getGPIOStateCommand(bladeLocation, nodeLocatoin, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get GPIOA3 State");
    }

    public byte getCPLDGPO(byte bladeLocation, byte nodeLocatoin, byte index) throws IPMIException {
        IPMIMessage resMessage = this.getGPLDGPOCommand(bladeLocation, nodeLocatoin, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get CPLD GPO");
    }

    public byte getPSUStatus(byte psuLocation, byte psuSubLocation) throws IPMIException {
        IPMIMessage resMessage = this.getPSUStatusCommand(psuLocation, psuSubLocation);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get PSU status");
    }

    public byte getPowerReading() throws IPMIException {
        IPMIMessage resMessage = this.powerReadingCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't get power reading command");
    }

    public CMMDiagCpuTemp[] isCPUsHighCT() throws IPMIException {
        IPMIMessage resMessage = this.compareCPUTemperatureWithTJMaxCommand();
        CMMDiagCpuTemp[] array = new CMMDiagCpuTemp[4];
        boolean isHighCT = false;
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (resMessage.data[i2] != -1) {
                        int tempeurate = Integer.parseInt(ByteUtility.byteToHex(resMessage.data[i2]), 16);
                        int lastCollection = resMessage.data.length % 16;
                        lastCollection = lastCollection == 0 ? 16 : lastCollection;
                        byte[] tjmaxTemp = Arrays.copyOfRange(resMessage.data, 0, resMessage.data.length - (16 + lastCollection));
                        tjmaxTemp = Arrays.copyOfRange(tjmaxTemp, tjmaxTemp.length - 16, tjmaxTemp.length);
                        int tjmax = Integer.parseInt(ByteUtility.byteToHex(tjmaxTemp[i2 + 9]), 16);
                        isHighCT = tempeurate >= tjmax + 2;
                        array[i2] = new CMMDiagCpuTemp(isHighCT, tempeurate);
                        continue;
                    }
                    array[i2] = new CMMDiagCpuTemp(false, -1);
                }
                return array;
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Can't execute is CPUs High CT command");
    }

    public byte generateTroubleShooting(byte option) throws IPMIException {
        IPMIMessage resMessage = this.generateTroubleShootingCommand(option);
        if (resMessage != null) {
            return resMessage.completionCode;
        }
        throw new IPMIException("Cannot Generate trouble shooting");
    }

    public byte getDownloadStatus() throws IPMIException {
        IPMIMessage resMessage = this.getGeneratingStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(resMessage, GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Cannot Get Generating Status");
    }
}

