/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPMILanCommand
extends IPMICommand {
    public static final byte DHCP = 2;
    public static final byte STATIC_IP = 1;
    public static final byte IPV4 = 0;
    public static final byte IPV6 = 1;
    public static final byte DUAL = 2;

    public IPMILanCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage setLanConfigurationParameterCommand(byte channelNumber, byte selector, byte[] pData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + pData.length];
        data[0] = channelNumber;
        data[1] = selector;
        System.arraycopy(pData, 0, data, 2, pData.length);
        ipmiMessage.setCommandAndData((byte)48, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLanConfigurationParameterCommand(byte channelNumber, byte selector, byte setSelector, byte blockSelector) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channelNumber, selector, setSelector, blockSelector};
        ipmiMessage.setCommandAndData((byte)48, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIP_UDP_RMCP_StatisticsCommand(boolean clear) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, clear ? (byte)1 : 0};
        ipmiMessage.setCommandAndData((byte)48, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public String getIP() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)3, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getIPEx() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)3, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return ip;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public boolean setIP(String ip) {
        byte[] data = new byte[4];
        if (ip == null) {
            MessageCenter.getInstance().put(this, (Object)"IP is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)3, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setIPEx(String ip) throws IPMIException {
        byte[] data = new byte[4];
        if (ip == null) {
            MessageCenter.getInstance().put(this, (Object)"IP is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(ip)) {
            throw new IPMIException("IP format error!");
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("IP format error!");
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)3, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public String getMAC() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)5, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mac = "";
                mac = ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ":" + ByteUtility.byteToHex(resMessage.data[6]);
                return mac;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getMACEx() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)5, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mac = "";
                mac = ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ":" + ByteUtility.byteToHex(resMessage.data[6]);
                return mac;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public String getMAC2Ex() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)5, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mac = "";
                mac = ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[2]) + ByteUtility.byteToHex(resMessage.data[3]) + ByteUtility.byteToHex(resMessage.data[4]) + ByteUtility.byteToHex(resMessage.data[5]) + ByteUtility.byteToHex(resMessage.data[6]);
                return mac;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public boolean setMAC(String mac) {
        byte[] data = new byte[6];
        if (mac == null) {
            MessageCenter.getInstance().put(this, (Object)"MAC is null!");
            return false;
        }
        if (!IPMILanCommand.isMacAddress(mac)) {
            MessageCenter.getInstance().put(this, (Object)"MAC format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mac, ":");
        for (int i2 = 0; i2 < 6; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MAC format error!");
                return false;
            }
            data[i2] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)5, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setMACEx(String mac) throws IPMIException {
        byte[] data = new byte[6];
        if (mac == null) {
            MessageCenter.getInstance().put(this, (Object)"MAC is null!");
            return false;
        }
        if (!IPMILanCommand.isMacAddress(mac)) {
            throw new IPMIException("MAC format error!");
        }
        StringTokenizer st = new StringTokenizer(mac, ":");
        for (int i2 = 0; i2 < 6; ++i2) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("MAC format error!");
            }
            data[i2] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)5, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public String getSubnetMask() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)6, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mask = "";
                mask = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return mask;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getSubnetMaskEx() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)6, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String mask = "";
                mask = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return mask;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public boolean setSubnetMask(String mask) {
        byte[] data = new byte[4];
        if (mask == null) {
            MessageCenter.getInstance().put(this, (Object)"Subnet Mask is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(mask)) {
            MessageCenter.getInstance().put(this, (Object)"Subnet Mask format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(mask, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MASK format error!");
                return false;
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)6, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setSubnetMaskEx(String mask) throws IPMIException {
        byte[] data = new byte[4];
        if (mask == null) {
            MessageCenter.getInstance().put(this, (Object)"Subnet Mask is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(mask)) {
            throw new IPMIException("Subnet Mask format error!");
        }
        StringTokenizer st = new StringTokenizer(mask, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("Subnet Mask format error!");
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)6, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public String getGatewayIP() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)12, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayIP = "";
                gatewayIP = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return gatewayIP;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getGatewayIPEx() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)12, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayIP = "";
                gatewayIP = (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF) + "." + (resMessage.data[4] & 0xFF);
                return gatewayIP;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getLanConfigurationParameterCommand failed");
    }

    public boolean setGatewayIP(String gatewayIP) {
        byte[] data = new byte[4];
        if (gatewayIP == null) {
            MessageCenter.getInstance().put(this, (Object)"Gateway IP is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(gatewayIP)) {
            MessageCenter.getInstance().put(this, (Object)"Gateway IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(gatewayIP, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"gatewayIP format error!");
                return false;
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)12, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setGatewayIPEx(String gatewayIP) throws IPMIException {
        byte[] data = new byte[4];
        if (gatewayIP == null) {
            MessageCenter.getInstance().put(this, (Object)"Gateway IP is null!");
            return false;
        }
        if (!IPMILanCommand.isIPAddress(gatewayIP)) {
            throw new IPMIException("Gateway IP format error!");
        }
        StringTokenizer st = new StringTokenizer(gatewayIP, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("Gateway IP format error!");
            }
            data[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)12, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public String getGatewayMAC() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)13, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayMAC = "";
                gatewayMAC = ByteUtility.byteToHex(resMessage.data[1]) + ":" + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ":" + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ":" + ByteUtility.byteToHex(resMessage.data[6]);
                return gatewayMAC;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setGatewayMAC(String gatewayMAC) {
        byte[] data = new byte[6];
        if (gatewayMAC == null) {
            MessageCenter.getInstance().put(this, (Object)"setGateway MAC is null!");
            return false;
        }
        if (!IPMILanCommand.isMacAddress(gatewayMAC)) {
            MessageCenter.getInstance().put(this, (Object)"setGateway MAC format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(gatewayMAC, ":");
        for (int i2 = 0; i2 < 6; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"gateway MAC format error!");
                return false;
            }
            data[i2] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)13, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public String getCommunityString() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)16, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] data = new byte[18];
                System.arraycopy(resMessage.data, 1, data, 0, data.length);
                return new String(data).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setCommunityString(String communityString) {
        if (communityString == null) {
            MessageCenter.getInstance().put(this, (Object)"Can't set null Community");
            return false;
        }
        byte[] data = new byte[18];
        System.arraycopy(communityString.getBytes(), 0, data, 0, communityString.getBytes().length);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)16, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public int getNumberOfDestination() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)17, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return 0;
    }

    public byte[] getDestinationType(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)18, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] result = new byte[4];
                System.arraycopy(resMessage.data, 1, result, 0, 4);
                return result;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getDestinationIP(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)19, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = (resMessage.data[4] & 0xFF) + "." + (resMessage.data[5] & 0xFF) + "." + (resMessage.data[6] & 0xFF) + "." + (resMessage.data[7] & 0xFF);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getDestinationMAC(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)19, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String gatewayMAC = "";
                gatewayMAC = ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ":" + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ":" + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]);
                return gatewayMAC;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public static boolean isMacAddress(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    public static boolean isMacAddressNoColon(String macAddressCandidate) {
        Pattern macPattern = Pattern.compile("[0-9a-fA-F]{2}[0-9a-fA-F]{2}[0-9a-fA-F]{2}[0-9a-fA-F]{2}[0-9a-fA-F]{2}[0-9a-fA-F]{2}");
        Matcher m = macPattern.matcher(macAddressCandidate);
        return m.matches();
    }

    public static boolean isIPAddress(String ipAddressCandidate) {
        boolean isPass = true;
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ipAddressCandidate);
        if (m.matches()) {
            StringTokenizer st = new StringTokenizer(ipAddressCandidate, ".");
            while (st.hasMoreTokens()) {
                int value = Integer.parseInt(st.nextToken());
                if (value >= 0 && value <= 255) continue;
                isPass = false;
            }
        } else {
            isPass = false;
        }
        return isPass;
    }

    public static boolean isValidateDomain(String isDomain) {
        String pattern = "^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,24}$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(isDomain);
        return m.find();
    }

    public static boolean isStandardIPv6Address(String ipAddressCandidate) {
        Pattern v6Pattern = Pattern.compile("^([0-9a-fA-F]{4}:){7}[0-9a-fA-F]{4}$");
        Matcher m = v6Pattern.matcher(ipAddressCandidate);
        return m.matches();
    }

    public boolean setDesitnationIPandMAC(byte index, String ip, String mac) {
        if (ip == null || mac == null) {
            MessageCenter.getInstance().put(this, (Object)"Can't set LAN configuration with null ip or mac");
            return false;
        }
        byte[] data = new byte[13];
        byte[] ipBytes = new byte[4];
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            ipBytes[i2] = (byte)Integer.parseInt(st.nextToken());
        }
        byte[] macBytes = new byte[6];
        st = new StringTokenizer(mac, ":");
        for (int i3 = 0; i3 < 6; ++i3) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"MAC format error!");
                return false;
            }
            macBytes[i3] = (byte)(Integer.parseInt(st.nextToken(), 16) & 0xFF);
        }
        data[0] = index;
        data[1] = 0;
        data[2] = 0;
        System.arraycopy(ipBytes, 0, data, 3, 4);
        System.arraycopy(macBytes, 0, data, 7, 6);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)19, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setDefaultPEFDestinationType(byte destinationSelector) {
        byte[] data = new byte[]{destinationSelector, 0, 0, 0};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)18, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean setPEFSendingAlertTrap(byte destinationSelector, boolean flag) {
        byte[] data = new byte[4];
        data[0] = destinationSelector;
        if (flag) {
            data[1] = -128;
            data[2] = 3;
            data[3] = 3;
        } else {
            data[1] = 0;
            data[2] = 0;
            data[3] = 0;
        }
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)18, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public byte getLanSettingType() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)4, (byte)0, (byte)0);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        return 0;
    }

    public boolean setLanSettingType(byte type) {
        byte[] data = new byte[]{type};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)4, data);
        return resMessage != null && resMessage.completionCode == 0;
    }

    public byte getBMCGeneratedARP() {
        byte[] data = new byte[]{};
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)11, (byte)0, (byte)0);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        return 0;
    }

    public boolean setBMCGeneratedARP(boolean isEnable) {
        byte[] data = new byte[]{this.getBMCGeneratedARP()};
        data[0] = isEnable ? (byte)(data[0] | 1) : (byte)(data[0] & 0xFFFFFFFE);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)11, data);
        return resMessage != null && resMessage.completionCode == 0;
    }

    public boolean isVLANEnabled() throws IPMIException {
        boolean result = false;
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)20, (byte)0, (byte)0);
        if (resMessage == null) {
            throw new IPMIException("call getLanConfigurationParameterCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte data1 = resMessage.data[1];
            byte data2 = resMessage.data[2];
            if ((byte)(data2 & 0x80) == -128) {
                result = true;
            }
        } else {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        return result;
    }

    public int getVLANTag() throws IPMIException {
        int tag = 0;
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)20, (byte)0, (byte)0);
        if (resMessage == null) {
            throw new IPMIException("call getLanConfigurationParameterCommand failed");
        }
        if (resMessage.completionCode != 0) {
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        byte data1 = resMessage.data[1];
        byte data2 = resMessage.data[2];
        tag = ((data2 & 0xF) << 8) + (data1 & 0xFF);
        return tag;
    }

    public boolean setVLANEnabled(boolean isEnable, int vlanTag) throws IPMIException {
        IPMIMessage resMessage;
        if (vlanTag > 4095 || vlanTag < 0) {
            throw new IPMIException("VLAN Tag invalid");
        }
        byte[] data = new byte[]{(byte)vlanTag, (byte)(vlanTag >> 8)};
        if (isEnable) {
            data[1] = (byte)(data[1] | 0x80);
        }
        if ((resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)20, data)) == null) {
            throw new IPMIException("call setLanConfigurationParameterCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte IPv6SupportedStatus() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)50, (byte)0, (byte)0);
        if (resMessage == null) {
            throw new IPMIException("call getLanConfigurationParameterCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[1];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean setIPv4IPv6Support(byte option) throws IPMIException {
        byte[] data = new byte[]{option};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)51, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public int getMaxStaticIPv6Number() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)55, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public int getMaxDynamicIPv6Number() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)55, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[2];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public boolean addIPv6Address(byte index, String ip, byte prefix) {
        String s = ip.replaceAll(":", "");
        byte[] IP = ByteUtility.hexToBytes(s);
        byte[] data = new byte[19];
        data[0] = index;
        data[1] = -128;
        System.arraycopy(IP, 0, data, 2, IP.length);
        data[18] = prefix;
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)56, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean removeIPv6Address(byte index) {
        byte[] data = new byte[19];
        data[0] = index;
        data[1] = 0;
        byte[] oldData = this.getStaticIPv6Array(index);
        System.arraycopy(oldData, 3, data, 2, 17);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)56, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public byte[] getStaticIPv6Array(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)56, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public byte[] getDynamicIPv6Array(byte index) {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)59, index, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public boolean setStaticIPv6IP(String ip, byte prefixLength) {
        byte[] data = new byte[19];
        byte[] ipArray = new byte[16];
        byte[] subData = new byte[2];
        if (!IPMILanCommand.isStandardIPv6Address(ip)) {
            MessageCenter.getInstance().put(this, (Object)"IP format error!");
            return false;
        }
        StringTokenizer st = new StringTokenizer(ip, ":");
        for (int i2 = 0; i2 < 15; i2 += 2) {
            if (!st.hasMoreTokens()) {
                MessageCenter.getInstance().put(this, (Object)"IP format error!");
                return false;
            }
            subData = ByteUtility.hexToBytes(st.nextToken());
            System.arraycopy(subData, 0, ipArray, i2, 2);
        }
        data[0] = 0;
        data[1] = -128;
        System.arraycopy(ipArray, 0, data, 2, 16);
        data[18] = prefixLength;
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)56, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set LAN configuration");
        return false;
    }

    public boolean isRouteStaticEnabled() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)64, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[1] & 1) == 1;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public String getStaticRouterIP1() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)65, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ByteUtility.byteToHex(resMessage.data[6]) + ":" + ByteUtility.byteToHex(resMessage.data[7]) + ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]) + ByteUtility.byteToHex(resMessage.data[14]) + ":" + ByteUtility.byteToHex(resMessage.data[15]) + ByteUtility.byteToHex(resMessage.data[16]);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getStaticRouterIP2() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)69, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String ip = "";
                ip = ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ByteUtility.byteToHex(resMessage.data[6]) + ":" + ByteUtility.byteToHex(resMessage.data[7]) + ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]) + ByteUtility.byteToHex(resMessage.data[14]) + ":" + ByteUtility.byteToHex(resMessage.data[15]) + ByteUtility.byteToHex(resMessage.data[16]);
                return ip;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public int getStaticRouterPrefixLength1() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)67, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1] & 0xFF;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public int getStaticRouterPrefixLength2() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)71, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1] & 0xFF;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public String getStaticRouterPrefixValue1() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)68, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String prefix = "";
                prefix = ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ByteUtility.byteToHex(resMessage.data[6]) + ":" + ByteUtility.byteToHex(resMessage.data[7]) + ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]) + ByteUtility.byteToHex(resMessage.data[14]) + ":" + ByteUtility.byteToHex(resMessage.data[15]) + ByteUtility.byteToHex(resMessage.data[16]);
                return prefix;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public String getStaticRouterPrefixValue2() {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)72, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                String prefix = "";
                prefix = ByteUtility.byteToHex(resMessage.data[1]) + ByteUtility.byteToHex(resMessage.data[2]) + ":" + ByteUtility.byteToHex(resMessage.data[3]) + ByteUtility.byteToHex(resMessage.data[4]) + ":" + ByteUtility.byteToHex(resMessage.data[5]) + ByteUtility.byteToHex(resMessage.data[6]) + ":" + ByteUtility.byteToHex(resMessage.data[7]) + ByteUtility.byteToHex(resMessage.data[8]) + ":" + ByteUtility.byteToHex(resMessage.data[9]) + ByteUtility.byteToHex(resMessage.data[10]) + ":" + ByteUtility.byteToHex(resMessage.data[11]) + ByteUtility.byteToHex(resMessage.data[12]) + ":" + ByteUtility.byteToHex(resMessage.data[13]) + ByteUtility.byteToHex(resMessage.data[14]) + ":" + ByteUtility.byteToHex(resMessage.data[15]) + ByteUtility.byteToHex(resMessage.data[16]);
                return prefix;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get LAN configuration");
        return null;
    }

    public void setRouteStatus(boolean enable) throws IPMIException {
        this.setRouteStatus(enable ? (byte)3 : 2);
    }

    public void setRouteStatus(byte status) throws IPMIException {
        byte[] data = new byte[]{status};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, (byte)64, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public void setStaticRouterPrefixLength(int ID2, int length) throws IPMIException {
        byte parameterSelector = 67;
        byte[] data = new byte[1];
        if (ID2 == 2) {
            parameterSelector = 71;
        }
        data[0] = (byte)(length & 0xFF);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, parameterSelector, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public void setStaticRouterPrefixValue(int ID2, String prefix) throws IPMIException {
        byte parameterSelector = 68;
        if (ID2 == 2) {
            parameterSelector = 72;
        }
        if (prefix == null) {
            throw new IPMIException("prefix cannot be null");
        }
        String s = prefix.replaceAll(":", "");
        byte[] data = ByteUtility.hexToBytes(s);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, parameterSelector, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public void setStaticRouterAddress(int ID2, String address) throws IPMIException {
        byte parameterSelector = 65;
        if (ID2 == 2) {
            parameterSelector = 69;
        }
        if (address == null) {
            throw new IPMIException("address cannot be null");
        }
        String s = address.replaceAll(":", "");
        byte[] data = ByteUtility.hexToBytes(s);
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, parameterSelector, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public void setIPProtocol(byte protocol) throws IPMIException {
        byte parameterSelector = 51;
        byte[] data = new byte[]{protocol};
        IPMIMessage resMessage = this.setLanConfigurationParameterCommand((byte)1, parameterSelector, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public byte getIPProtocol() throws IPMIException {
        IPMIMessage resMessage = this.getLanConfigurationParameterCommand((byte)1, (byte)51, (byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[1];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setLanConfigurationParameterCommand failed");
    }

    public static String StandardIPv6Converter(String address) {
        int i2;
        int j2;
        if (address == null) {
            return "";
        }
        int tempCompressLocation = address.indexOf("::");
        int componentNumberPrePart = 0;
        if (tempCompressLocation != -1) {
            String prePart = address.substring(0, tempCompressLocation);
            componentNumberPrePart = prePart.split(":").length;
            address = address.replace("::", ":");
        }
        String[] addressComponents = address.toString().split(":");
        for (int i3 = 0; i3 < addressComponents.length; ++i3) {
            StringBuilder uncompressedComponent = new StringBuilder("");
            for (j2 = 0; j2 < 4 - addressComponents[i3].length(); ++j2) {
                uncompressedComponent.append("0");
            }
            uncompressedComponent.append(addressComponents[i3]);
            addressComponents[i3] = uncompressedComponent.toString();
        }
        LinkedList<String> uncompressedAddressComponents = new LinkedList<String>();
        for (i2 = 0; i2 < addressComponents.length; ++i2) {
            if (i2 == componentNumberPrePart) {
                for (j2 = 0; j2 < 8 - addressComponents.length; ++j2) {
                    uncompressedAddressComponents.add("0000");
                }
            }
            uncompressedAddressComponents.add(addressComponents[i2]);
        }
        if (uncompressedAddressComponents.size() < 8) {
            for (i2 = uncompressedAddressComponents.size(); i2 < 8; ++i2) {
                uncompressedAddressComponents.add("0000");
            }
        }
        StringBuilder uncompressedAddress = new StringBuilder("");
        for (int i4 = 0; i4 < uncompressedAddressComponents.size(); ++i4) {
            uncompressedAddress.append((String)uncompressedAddressComponents.get(i4));
            uncompressedAddress.append(":");
        }
        uncompressedAddress.replace(uncompressedAddress.length() - 1, uncompressedAddress.length(), "");
        return uncompressedAddress.toString();
    }

    public static void main_old(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.10.155");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        int count = 0;
        while (true) {
            IPMINetworkInterface rmcp;
            if ((rmcp = sessionController.startup(config)) != null) {
                LogUtil.printLog("(" + count++ + ") Login:OK");
                ipmiLanCommand.setIPMIInterface(rmcp);
                System.out.println(ipmiLanCommand.getCommunityString());
                boolean result = sessionController.closeSession();
                if (result) {
                    LogUtil.printLog("Logout:OK");
                } else {
                    LogUtil.printLog("Logout:Fail");
                }
            } else {
                LogUtil.printLog("Login:Fail");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void main___(String[] args) {
        String communityString;
        String getwayMAC;
        String getwayIP;
        String subnetMask;
        String mac;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.10.158");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiLanCommand.setIPMIInterface(rmcp);
        String ip = ipmiLanCommand.getIP();
        if (ip != null) {
            MessageCenter.getInstance().put("IP = " + ip);
        }
        if ((mac = ipmiLanCommand.getMAC()) != null) {
            MessageCenter.getInstance().put("MAC = " + mac);
        }
        if ((subnetMask = ipmiLanCommand.getSubnetMask()) != null) {
            MessageCenter.getInstance().put("Subnet Mask = " + subnetMask);
        }
        if ((getwayIP = ipmiLanCommand.getGatewayIP()) != null) {
            MessageCenter.getInstance().put("Getway IP = " + getwayIP);
        }
        if ((getwayMAC = ipmiLanCommand.getGatewayMAC()) != null) {
            MessageCenter.getInstance().put("Getway MAC = " + getwayMAC);
        }
        if ((communityString = ipmiLanCommand.getCommunityString()) != null) {
            MessageCenter.getInstance().put("Community String = " + communityString);
        }
        int numberOfDestination = ipmiLanCommand.getNumberOfDestination();
        MessageCenter.getInstance().put("Number of Destination = " + numberOfDestination);
        for (int j2 = 0; j2 < numberOfDestination + 5; ++j2) {
            String dIP = ipmiLanCommand.getDestinationIP((byte)j2);
            String dMAC = ipmiLanCommand.getDestinationMAC((byte)j2);
            if (ip == null) continue;
            System.out.println(j2 + ": Destination IP address : " + dIP + ", MAC : " + dMAC);
        }
        System.out.println(ipmiLanCommand.getLanSettingType());
        try {
            System.out.println(ipmiLanCommand.isVLANEnabled());
            System.out.println(ipmiLanCommand.getVLANTag());
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        String ip = "2.168.1.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.-1.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.256.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1aa.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "444.168.1.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.112.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1.-23";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1.600";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1555.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.1685.1.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "255.168.1.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.112.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1221.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.121.1";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        ip = "2.168.1.12222";
        System.out.println(ip + ":" + IPMILanCommand.isIPAddress(ip));
        System.out.println("\nName of the OS: " + System.getProperty("os.name"));
        System.out.println("Version of the OS: " + System.getProperty("os.version"));
        System.out.println("Architecture of the OS: " + System.getProperty("os.arch"));
    }

    public static void main_(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.12.16");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiLanCommand.setIPMIInterface(rmcp);
        for (int i2 = 0; i2 < 10000; ++i2) {
            String communityString;
            String getwayMAC;
            String getwayIP;
            String subnetMask;
            String mac;
            System.out.println("i =" + i2);
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                MessageCenter.getInstance().put("IP = " + ip);
            }
            if ((mac = ipmiLanCommand.getMAC()) != null) {
                MessageCenter.getInstance().put("MAC = " + mac);
            }
            if ((subnetMask = ipmiLanCommand.getSubnetMask()) != null) {
                MessageCenter.getInstance().put("Subnet Mask = " + subnetMask);
            }
            if ((getwayIP = ipmiLanCommand.getGatewayIP()) != null) {
                MessageCenter.getInstance().put("Getway IP = " + getwayIP);
            }
            if ((getwayMAC = ipmiLanCommand.getGatewayMAC()) != null) {
                MessageCenter.getInstance().put("Getway MAC = " + getwayMAC);
            }
            if ((communityString = ipmiLanCommand.getCommunityString()) != null) {
                MessageCenter.getInstance().put("Community String = " + communityString);
            }
            int numberOfDestination = ipmiLanCommand.getNumberOfDestination();
            MessageCenter.getInstance().put("Number of Destination = " + numberOfDestination);
        }
        sessionController.closeSession();
    }
}

