/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.lang.L;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPMIMELCommand
extends IPMICommand {
    public static final byte MEL_DOWNLOAD_OPCODE = 22;
    public static final int MEL_FORMAT_HW1_NORMAL = 0;
    public static final int MEL_FORMAT_HW2_NORMAL = 1;
    public static final int MEL_FORMAT_HW2_EXTEND = 2;
    public static final int MEL_FORMAT_UNKNOWN = 3;
    private ArrayList<Object[]> melEntryArrayList = null;
    private final Pattern checkPattern = Pattern.compile("(\\ +\\d+\\ +\\d+)");
    private final Pattern hw1Pattern = Pattern.compile(".*\\ (\\d{4}\\/\\d{2}\\/\\d{2},\\d{2}\\:\\d{2}\\:\\d{2}) (\\S+) (\\S+) (\\S+) (.*)");
    private final Pattern hw2Pattern = Pattern.compile("(\\d{1,4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}\\:\\d{1,2}\\:\\d{1,2}) (\\S{4,15}\\(?\\w?\\)?):(.*):(.*):(.*) ([a-zA-Z0-9:.]+):(\\w+)");
    private final Pattern hw2ExPattern = Pattern.compile("(\\d{1,4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}\\:\\d{1,2}\\:\\d{1,2}) (\\S{4,15}\\(?\\w?\\)?):(.*):(.*):(.*) ([a-zA-Z0-9:.]+):(\\w+):(\\w+)");

    public IPMIMELCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.melEntryArrayList = new ArrayList();
    }

    public boolean update() throws Exception {
        return this.update(null);
    }

    public boolean update(String datetimeFormat) throws Exception {
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiInterface);
        MessageCenter.getInstance().put(this, (Object)L.t("mel.Getting_MEL_entry"));
        byte[] melByteArray = ipmiBMCFileCommand.generalFileDownloadbyArray((byte)22, false, false);
        return this.melParser(melByteArray, datetimeFormat);
    }

    public boolean clear() {
        IPMIOEMCommand ipmioemCommand = new IPMIOEMCommand(this.ipmiInterface);
        return ipmioemCommand.clearSyslog();
    }

    public ArrayList<Object[]> getEntryArrayList() {
        return this.melEntryArrayList;
    }

    public ArrayList<Object[]> getEntryArrayList(int lastEvent) {
        return this.getEntryArrayList(lastEvent > this.melEntryArrayList.size() ? 1 : this.melEntryArrayList.size() - lastEvent + 1, this.melEntryArrayList.size());
    }

    public ArrayList<Object[]> getEntryArrayList(int beginIndex, int endIndex) {
        if (beginIndex > this.melEntryArrayList.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.addAll(this.melEntryArrayList.subList(beginIndex - 1, endIndex > this.melEntryArrayList.size() ? this.melEntryArrayList.size() : endIndex));
        return arrayList;
    }

    public int getEntrySize() {
        return this.melEntryArrayList.size();
    }

    private int checkFormatPattern(String melString, Scanner scanner) {
        String firstLine = melString.substring(0, melString.indexOf(10));
        if (this.checkPattern.matcher(firstLine).find()) {
            scanner.nextLine();
            return 0;
        }
        if (this.hw2ExPattern.matcher(firstLine).find()) {
            return 2;
        }
        if (this.hw2Pattern.matcher(firstLine).find()) {
            return 1;
        }
        return 3;
    }

    private Pattern selectFormatPattern(int type) {
        if (type == 0) {
            return this.hw1Pattern;
        }
        if (type == 1) {
            return this.hw2Pattern;
        }
        if (type == 2) {
            return this.hw2ExPattern;
        }
        return null;
    }

    private boolean melParser(byte[] byteArray, String format) {
        if (byteArray == null || byteArray.length == 0) {
            return true;
        }
        int index = 1;
        String melString = new String(byteArray);
        Scanner scanner = new Scanner(melString);
        int formatPattern = this.checkFormatPattern(melString, scanner);
        Pattern pattern = this.selectFormatPattern(formatPattern);
        Vector<String> singleRowEntry = new Vector<String>();
        this.melEntryArrayList.clear();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Matcher macher = pattern.matcher(line);
            if (!macher.find()) continue;
            singleRowEntry.clear();
            singleRowEntry.add(String.valueOf(index++));
            if (formatPattern == 0) {
                singleRowEntry.add(this.getDateTime(macher.group(1), format));
                singleRowEntry.add(macher.group(2));
                singleRowEntry.add(macher.group(3));
                singleRowEntry.add(macher.group(4));
                singleRowEntry.add(macher.group(5));
            } else if (formatPattern == 1 || formatPattern == 2) {
                singleRowEntry.add(this.getDateTime(macher.group(1), format));
                singleRowEntry.add(macher.group(7));
                singleRowEntry.add(macher.group(2));
                singleRowEntry.add(macher.group(6));
                singleRowEntry.add(macher.group(3));
            }
            this.melEntryArrayList.add(singleRowEntry.toArray());
        }
        scanner.close();
        return true;
    }

    private String getDateTime(String datetime, String pattern) {
        if (pattern != null) {
            SimpleDateFormat inFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            SimpleDateFormat outFormat = new SimpleDateFormat(pattern);
            String outputDatetime = null;
            try {
                Date inputDatetime = inFormat.parse(datetime);
                outputDatetime = outFormat.format(inputDatetime).toString();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return outputDatetime != null ? outputDatetime : datetime;
        }
        return datetime;
    }
}

