/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class IPMIOEMIpv6Command
extends IPMICommand {
    public IPMIOEMIpv6Command(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getIPv6NetworkCommand(byte parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, 0, parameter};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPv6NetworkCommand(byte state, byte autoconfig, byte action, byte[] address) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5 + address.length];
        data[0] = 9;
        data[1] = 1;
        data[2] = state;
        data[3] = autoconfig;
        data[4] = action;
        System.arraycopy(address, 0, data, 5, address.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSServerCommand(boolean isIPv6) {
        return this.getDNSServerCommand(isIPv6, 1);
    }

    public IPMIMessage getDNSServerCommand(boolean isIPv6, int index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, index == 1 ? (byte)0 : 2, isIPv6 ? (byte)1 : 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSServerCommand(byte[] address, boolean isIPv6) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[20];
        data[0] = 10;
        data[1] = 1;
        data[2] = isIPv6 ? (byte)1 : 0;
        data[3] = 0;
        System.arraycopy(address, 0, data, 4, isIPv6 ? 16 : 8);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearDNSServerCommand(boolean isIPv6) {
        return this.clearDNSServerCommand(isIPv6, 1);
    }

    public IPMIMessage clearDNSServerCommand(boolean isIPv6, int index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, index == 1 ? (byte)1 : 3, isIPv6 ? (byte)1 : 0, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public boolean isIPV6ModeStateful() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] != 0;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public boolean isAutoConfig() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] != 0;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public boolean setAutoConfigMode(boolean enable) throws IPMIException {
        byte[] address;
        byte autoConfig;
        byte dhcpMode = (byte)this.getIPV6DHCPMode();
        IPMIMessage resMessage = this.setIPv6NetworkCommand(dhcpMode, autoConfig = enable ? (byte)1 : 0, (byte)0, address = new byte[17]);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public boolean setIPV6Network(int dhcpMode, boolean autoconfig) {
        byte[] address;
        byte autoconfigByte = autoconfig ? (byte)1 : 0;
        IPMIMessage resMessage = this.setIPv6NetworkCommand((byte)dhcpMode, autoconfigByte, (byte)0, address = new byte[17]);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public int getIPV6DHCPMode() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public boolean setIPV6DHCPMode(int mode) throws IPMIException {
        byte[] address;
        byte autoConfigByte = this.isAutoConfig() ? (byte)1 : 0;
        IPMIMessage resMessage = this.setIPv6NetworkCommand((byte)mode, autoConfigByte, (byte)0, address = new byte[17]);
        return resMessage != null && resMessage.completionCode == 0;
    }

    public boolean setIPV6Address(byte[] address, boolean addAction) throws IPMIException {
        byte action;
        byte isAutoConfig = this.isAutoConfig() ? (byte)1 : 0;
        byte dhcpMode = (byte)this.getIPV6DHCPMode();
        IPMIMessage resMessage = this.setIPv6NetworkCommand(dhcpMode, isAutoConfig, action = addAction ? (byte)0 : 1, address);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public byte[] getIPV6AddressList() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)2);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }

    public byte[] getIPV4DNS() throws IPMIException {
        IPMIMessage resMessage = this.getDNSServerCommand(false);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data.length == 0) {
                    return null;
                }
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getDNSServerCommand failed");
    }

    public boolean setIPV4DNS(byte[] address) throws IPMIException {
        IPMIMessage resMessage = this.setDNSServerCommand(address, false);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setDNSServerCommand failed");
    }

    public boolean clearIPV4DNS() throws IPMIException {
        IPMIMessage resMessage = this.clearDNSServerCommand(false);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call clearDNSServerCommand failed");
    }

    public byte[] getIPV6DNS() throws IPMIException {
        return this.getIPV6DNS(1);
    }

    public byte[] getIPV6DNS(int index) throws IPMIException {
        IPMIMessage resMessage = this.getDNSServerCommand(true, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data.length == 0) {
                    return null;
                }
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6DNSCommand failed");
    }

    public boolean setIPV6DNS(String address) throws IPMIException {
        String s = address.replaceAll(":", "");
        byte[] IP = ByteUtility.hexToBytes(s);
        IPMIMessage resMessage = this.setDNSServerCommand(IP, true);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setIPv6DNSCommand failed");
    }

    public boolean clearIPV6DNS() throws IPMIException {
        return this.clearIPV6DNS(1);
    }

    public boolean clearIPV6DNS(int index) throws IPMIException {
        IPMIMessage resMessage = this.clearDNSServerCommand(true, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call setIPv6DNSCommand failed");
    }

    public byte[] getDuid() throws IPMIException {
        IPMIMessage resMessage = this.getIPv6NetworkCommand((byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("call getIPv6NetworkCommand failed");
    }
}

