/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class IPMIOEMPortServiceCommand
extends IPMICommand {
    public IPMIOEMPortServiceCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void OEM_PORT_SERVICE_CMD_________() {
    }

    public IPMIMessage getPortServiceCommand(byte service) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{103, 0, service};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPortServiceCommand(byte service, int port) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[5];
        data[0] = 103;
        data[1] = 1;
        data[2] = service;
        ByteUtility.intTo2Bytes(data, 3, port);
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void OEM_PORT_SERVICE_API_________() {
    }

    public int getPort(byte service) throws Exception {
        IPMIMessage resMessage = this.getPortServiceCommand(service);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return ByteUtility.twoBytesToIntLSB(resMessage.data);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getPortService failed");
    }

    public boolean setPort(byte service, int port) throws IPMIException {
        IPMIMessage resMessage = this.setPortServiceCommand(service, port);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call setPortService failed");
    }

    public boolean checkStunnelSupport() throws IPMIException {
        IPMIMessage resMessage = this.getPortServiceCommand((byte)15);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return !"0".equals(ByteUtility.bytesToHex(resMessage.data).trim().substring(1, 2));
            }
            return false;
        }
        throw new IPMIException(resMessage, "Call getPortService to check stunnel failed");
    }

    public boolean isDynamicStunnelPort() throws IPMIException {
        IPMIMessage resMessage = this.getPortServiceCommand((byte)15);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return "03 00".equals(ByteUtility.bytesToHex(resMessage.data).trim());
            }
            return false;
        }
        throw new IPMIException(resMessage, "Call getPortService to check stunnel failed");
    }

    public int checkStunenelVer() throws IPMIException {
        IPMIMessage resMessage = this.getPortServiceCommand((byte)15);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte type = resMessage.data[0];
                return type;
            }
            return 0;
        }
        throw new IPMIException(resMessage, "Call getPortService to check stunnel ver failed");
    }
}

