/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class IPMIOEMWebSettingCommand
extends IPMICommand {
    public static byte VM_PARAM_HOST = 0;
    public static byte VM_PARAM_PATH = 1;
    public static byte VM_PARAM_USERNAME = (byte)2;
    public static byte VM_PARAM_PASSWORD = (byte)3;
    public static final int LENGTH_RESPONSE_NTP_NEW = 4;
    public static final int LENGTH_RESPONSE_NTP_LEGACY = 7;
    public static final byte TIME_UPDATE_MODE_LOCAL = 0;
    public static final byte TIME_UPDATE_MODE_NTP = 1;
    public static final byte TIME_UPDATE_MODE_BLADE = 3;
    public static final int DNS_IPV4 = 0;
    public static final int DNS_IPV6 = 1;
    public static final int DNS_AUTO_MODE = 0;
    public static final int DNS_MANUAL_MODE = 1;

    public IPMIOEMWebSettingCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    public IPMIMessage getNTPDateTimeCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNTPDateTimeCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 1;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getActiveDirectoryCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getActiveDirectoryRoleGroupCommand(byte param, byte index) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, 0, param, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setActiveDirectoryCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 2;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDDNSCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDDNSCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 4;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getRADIUSCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setRADIUSCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 5;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSMTPCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSMTPCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 6;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLDAPCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{8, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setLDAPCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 8;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPV6Command(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPV6Command(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 9;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSServerCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSServerCommand(byte target, byte protocol) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, target, protocol};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSServerCommand(byte param, byte[] value, byte operation) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + value.length];
        data[0] = 10;
        data[1] = 1;
        data[2] = param;
        data[3] = operation;
        System.arraycopy(value, 0, data, 4, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSServerCommand(byte[] addr, byte target, byte protocol) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + addr.length];
        data[0] = 10;
        data[1] = target;
        data[2] = protocol;
        data[3] = 0;
        System.arraycopy(addr, 0, data, 4, addr.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearDNSServerCommand(byte target, byte protocol) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, target, protocol, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSModeCommand(byte protocol) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, protocol};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSModeCommand(byte protocol, byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, protocol, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAlertCommand(byte number, byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, 0, number, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAlertCommand(byte number, byte type, byte[] param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + param.length];
        data[0] = 11;
        data[1] = 1;
        data[2] = number;
        data[3] = type;
        System.arraycopy(param, 0, data, 4, param.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getVMDeviceStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setVMParameterCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + value.length];
        data[0] = 13;
        data[1] = param;
        System.arraycopy(value, 0, data, 2, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPCtrlCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPCtrlRuleCommand(byte param, byte index) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, param, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPCtrlCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + value.length];
        data[0] = 1;
        data[1] = param;
        System.arraycopy(value, 0, data, 2, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage mountISOCommand(byte type) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, type};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage umountISOCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{15};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage umountFloppyCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSMBStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{23};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKCSStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{33, 1, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setKCSStatusCommand(byte isEnable) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{33, 1, 1, isEnable};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public byte[] getVMDeviceStatus() throws IPMIException {
        IPMIMessage resMessage = this.getVMDeviceStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getVMDeviceStatusCommand failed");
    }

    public void setVMParameter(byte param, String value) throws IPMIException {
        IPMIMessage resMessage = this.setVMParameterCommand(param, value.getBytes());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setVMParameterCommand failed");
    }

    public void checkVMParameter09(byte param, String value) throws IPMIException {
        IPMIMessage resMessage = this.setVMParameterCommand(param, value.getBytes());
        if (resMessage != null) {
            if (resMessage.completionCode == 0 && resMessage.data.length == 2) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setVMParameterCommand failed");
    }

    public void setVMParameter(byte param, byte value, byte value2) throws IPMIException {
        byte[] data = new byte[]{value, value2};
        IPMIMessage resMessage = this.setVMParameterCommand(param, data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setVMParameterCommand failed");
    }

    public boolean mountISOImageForTextMode(byte deviceID, String host, String path, String username, String password) throws IPMIException {
        try {
            this.setVMParameter((byte)0, host);
        }
        catch (IPMIException e2) {
            throw new IPMIException("Set host IP failed");
        }
        try {
            this.setVMParameter((byte)1, path);
        }
        catch (IPMIException e3) {
            throw new IPMIException("Set path failed");
        }
        if (username != null && username.length() > 0) {
            try {
                this.setVMParameter((byte)2, username);
            }
            catch (IPMIException e4) {
                throw new IPMIException("Set username failed");
            }
        }
        if (password != null && password.length() > 0) {
            try {
                this.setVMParameter((byte)3, password);
            }
            catch (IPMIException e5) {
                throw new IPMIException("Set password failed");
            }
        }
        try {
            this.mountISO(deviceID);
        }
        catch (IPMIException e6) {
            throw new IPMIException("mount ISO failed");
        }
        return true;
    }

    public void mountISO(byte param) throws IPMIException {
        IPMIMessage resMessage = this.mountISOCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call mountISOCommand failed");
    }

    public void umountISO() throws IPMIException {
        IPMIMessage resMessage = this.umountISOCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call umountISOCommand failed");
    }

    public void umountFloppy() throws IPMIException {
        IPMIMessage resMessage = this.umountFloppyCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call umountFloppyCommand failed");
    }

    public byte[] getADServer(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getActiveDirectoryCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getADServer failed");
    }

    public byte[] getADRoleGroup(byte param, byte index) throws IPMIException {
        IPMIMessage resMessage = this.getActiveDirectoryRoleGroupCommand(param, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getADServerRoleGroup failed");
    }

    public boolean setActiveDirectory(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setActiveDirectoryCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set Active Directory");
        return false;
    }

    public byte[] getLdap(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getLDAPCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getLdap failed");
    }

    public boolean setLdap(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setLDAPCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set LDAP");
        return false;
    }

    public byte[] getRadius(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getRADIUSCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getRadius failed");
    }

    public boolean setRadius(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setRADIUSCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set Radius");
        return false;
    }

    public byte[] getIpCtrl() throws IPMIException {
        IPMIMessage resMessage = this.getIPCtrlCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getIpCtrl failed");
    }

    public byte[] getIpCtrlRule(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getIPCtrlRuleCommand((byte)1, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getIpCtrlRule failed");
    }

    public boolean setIpCtrl(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setIPCtrlCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set IP control rule");
        return false;
    }

    public byte[] getNTPDateTime(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getNTPDateTimeCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNTPDateTimeCommand failed");
    }

    public void setNTPDateTime(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setNTPDateTimeCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNTPDateTimeCommand failed");
    }

    public byte[] getDDNS(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getDDNSCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDDNSCommand failed");
    }

    public void setDDNS(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setDDNSCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setDDNSCommand failed");
    }

    public byte[] getAlert(byte number, byte param) throws IPMIException {
        IPMIMessage resMessage = this.getAlertCommand(number, param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getAlertCommand failed");
    }

    public byte[] setAlert(byte number, byte type, byte[] param) throws IPMIException {
        IPMIMessage resMessage = this.setAlertCommand(number, type, param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getAlertCommand failed");
    }

    public byte[] getSMTP(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getSMTPCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSMTPCommand failed");
    }

    public void setSMTP(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setSMTPCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSMTPCommand failed");
    }

    public byte getSMBStatus() throws IPMIException {
        IPMIMessage resMessage = this.getSMBStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSMBStatusCommand failed");
    }

    public String getDNS(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getDNSServerCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDNSCommand failed");
    }

    public String getDNS(byte protocol, byte targetIndex) throws IPMIException {
        block1: {
            byte targetOpCode = (byte)(targetIndex == 1 ? 0 : 2);
            IPMIMessage resMessage = this.getDNSServerCommand(targetOpCode, protocol);
            if (resMessage == null) break block1;
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)this.ccode2Exception(resMessage).getMessage());
        }
        return null;
    }

    public boolean setDNS(byte param, String ip, byte operation) throws IPMIException {
        IPMIMessage resMessage;
        int ipLength = 4;
        byte[] data = null;
        if (param == 1) {
            ipLength = ip.length();
            data = new byte[ipLength];
            for (int i2 = 0; i2 < ipLength; ++i2) {
                data[i2] = (byte)(ip.charAt(i2) & 0xFF);
            }
        } else {
            data = new byte[ipLength];
            StringTokenizer st = new StringTokenizer(ip, ".");
            for (int i3 = 0; i3 < ipLength; ++i3) {
                if (!st.hasMoreTokens()) {
                    MessageCenter.getInstance().put(this, (Object)"IP format error!");
                    return false;
                }
                data[i3] = (byte)Integer.parseInt(st.nextToken());
            }
        }
        if ((resMessage = this.setDNSServerCommand(param, data, operation)) != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setDNSCommand failed");
    }

    public boolean setDNS(String ip, byte protocol, byte targetIndex) throws IPMIException {
        boolean result;
        block3: {
            byte[] data;
            byte targetOpCode;
            block2: {
                result = false;
                targetOpCode = (byte)(targetIndex == 1 ? 1 : 3);
                data = this.getIPAddressBytes(ip, protocol);
                if (data != null) break block2;
                MessageCenter.getInstance().put(this, (Object)"Invalid IP address");
                break block3;
            }
            IPMIMessage resMessage = this.setDNSServerCommand(data, targetOpCode, protocol);
            if (resMessage == null) break block3;
            if (resMessage.completionCode == 0) {
                result = true;
            } else {
                MessageCenter.getInstance().put(this, (Object)this.ccode2Exception(resMessage).getMessage());
            }
        }
        return result;
    }

    public boolean deleteDNS(byte protocol, byte targetIndex) throws IPMIException {
        boolean result;
        block2: {
            result = false;
            byte targetOpCode = (byte)(targetIndex == 1 ? 1 : 3);
            IPMIMessage resMessage = this.clearDNSServerCommand(targetOpCode, protocol);
            if (resMessage == null) break block2;
            if (resMessage.completionCode == 0) {
                result = true;
            } else {
                MessageCenter.getInstance().put(this, (Object)this.ccode2Exception(resMessage).getMessage());
            }
        }
        return result;
    }

    public int getDNSMode(int protocolEnum) throws IPMIException {
        byte protocol = protocolEnum == 0 ? (byte)32 : 16;
        IPMIMessage resMessage = this.getDNSModeCommand(protocol);
        if (resMessage != null) {
            if (resMessage.completionCode == 0 && resMessage.data != null) {
                return resMessage.data[0];
            }
            if (resMessage.completionCode == -52) {
                return -1;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDNSMode failed");
    }

    public int setDNSMode(int protocolEnum, int modeEnum) throws IPMIException {
        byte mode;
        byte protocol = protocolEnum == 0 ? (byte)33 : 17;
        IPMIMessage resMessage = this.setDNSModeCommand(protocol, mode = modeEnum == 0 ? (byte)0 : 1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0;
            }
            if (resMessage.completionCode == -52) {
                return -1;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setDNSMode failed");
    }

    public void setKCSControl(boolean isEnable) throws IPMIException {
        byte enable = isEnable ? (byte)1 : 0;
        IPMIMessage resMessage = this.setKCSStatusCommand(enable);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setKCSCommand failed");
    }

    public byte getKCSControl() throws IPMIException {
        IPMIMessage resMessage = this.getKCSStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getKCSCommand failed");
    }

    public static boolean isNTPLegacyResponse(byte[] resp) throws IPMIException {
        if (resp != null) {
            if (resp.length == 4) {
                return false;
            }
            if (resp.length == 7) {
                return true;
            }
        }
        throw new IPMIException(resp == null ? "NTP response is null" : "NTP response has invalid length: " + resp.length);
    }

    @Deprecated
    public boolean isNewNTPDSTEnable(byte[] resp) throws IPMIException {
        if (resp == null) {
            throw new IPMIException("NTP response is null");
        }
        if (resp.length < 4) {
            throw new IPMIException("NTP response has invalid length: " + resp.length);
        }
        byte DSTState = resp[2];
        return DSTState == 1;
    }

    @Deprecated
    public boolean isNewNTPAutoDSTEnable(byte[] resp) throws IPMIException {
        if (resp == null) {
            throw new IPMIException("NTP response is null");
        }
        if (resp.length < 4) {
            throw new IPMIException("NTP response has invalid length: " + resp.length);
        }
        byte autoDSTState = resp[3];
        return autoDSTState == 1;
    }

    @Deprecated
    public boolean isNewNTPTimeUpdateWithNTP(byte[] resp) throws IPMIException {
        return this.getNewNTPTimeUpdateMode(resp) == 1;
    }

    @Deprecated
    public int getNewNTPTimeUpdateMode(byte[] resp) throws IPMIException {
        if (resp == null) {
            throw new IPMIException("NTP response is null");
        }
        if (resp.length < 4) {
            throw new IPMIException("NTP response has invalid length: " + resp.length);
        }
        return resp[0];
    }

    @Deprecated
    public String getNewNTPTimeZone(byte[] resp) throws IPMIException {
        if (resp == null) {
            throw new IPMIException("NTP response is null");
        }
        if (resp.length < 4) {
            throw new IPMIException("NTP response has invalid length: " + resp.length);
        }
        byte timeZontIndex = resp[1];
        return this.getNewNTPTimeZone(Byte.toUnsignedInt(timeZontIndex));
    }

    @Deprecated
    public String getNewNTPTimeZone(int index) {
        List<String> item = IPMIOEMWebSettingCommand.getNTPTimeZoneNameMap().get(index);
        if (item != null) {
            return item.get(0) + " " + (item.size() > 1 ? item.get(1) : "");
        }
        return "Undefined index: " + index;
    }

    public static String getNTPTimeZoneNameList(String formatTemplate) {
        StringBuilder builder = new StringBuilder();
        TreeMap<Integer, List<String>> sortedHashMap = new TreeMap<Integer, List<String>>();
        sortedHashMap.putAll(IPMIOEMWebSettingCommand.getNTPTimeZoneNameMap());
        int index = 1;
        for (Map.Entry entry : sortedHashMap.entrySet()) {
            String country;
            String offset = (String)((List)entry.getValue()).get(0);
            String string = country = ((List)entry.getValue()).size() > 1 ? (String)((List)entry.getValue()).get(1) : null;
            if (formatTemplate != null) {
                builder.append(String.format(formatTemplate, index, offset, country));
            } else {
                builder.append(index + " " + offset + " " + country + System.lineSeparator());
            }
            ++index;
        }
        return builder.toString();
    }

    public static ArrayList<String> getNTPTimeZoneNameArrayList() {
        ArrayList<String> list = new ArrayList<String>();
        Map<Integer, List<String>> map = IPMIOEMWebSettingCommand.getNTPTimeZoneNameMap();
        for (int idx = 1; idx <= map.size(); ++idx) {
            String offset = map.get(idx).get(0);
            String value = map.get(idx).get(1);
            list.add(offset + " " + value);
        }
        return list;
    }

    public static ArrayList<Boolean> getNTPTimeZoneSupportAutoList() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        Map<Integer, List<String>> map = IPMIOEMWebSettingCommand.getNTPTimeZoneNameMap();
        for (int idx = 1; idx <= map.size(); ++idx) {
            String isSupported = map.get(idx).get(2);
            list.add(Boolean.valueOf(isSupported));
        }
        return list;
    }

    public static Map<Integer, List<String>> getNTPTimeZoneNameMap() {
        HashMap<Integer, List<String>> table = new HashMap<Integer, List<String>>();
        table.put(1, new ArrayList<String>(Arrays.asList("(UTC-12:00)", "International Date Line West", "false")));
        table.put(2, new ArrayList<String>(Arrays.asList("(UTC-11:00)", "Coordinated Universal Time-11", "false")));
        table.put(3, new ArrayList<String>(Arrays.asList("(UTC-10:00)", "Aleutian Islands", "true")));
        table.put(4, new ArrayList<String>(Arrays.asList("(UTC-10:00)", "Hawaii", "false")));
        table.put(5, new ArrayList<String>(Arrays.asList("(UTC-09:30)", "Marquesas Islands", "false")));
        table.put(6, new ArrayList<String>(Arrays.asList("(UTC-09:00)", "Alaska", "true")));
        table.put(7, new ArrayList<String>(Arrays.asList("(UTC-09:00)", "Coordinated Universal Time-09", "false")));
        table.put(8, new ArrayList<String>(Arrays.asList("(UTC-08:00)", "Baja California", "true")));
        table.put(9, new ArrayList<String>(Arrays.asList("(UTC-08:00)", "Coordinated Universal Time-08", "false")));
        table.put(10, new ArrayList<String>(Arrays.asList("(UTC-08:00)", "Pacific Time (US & Canada)", "true")));
        table.put(11, new ArrayList<String>(Arrays.asList("(UTC-07:00)", "Arizona", "false")));
        table.put(12, new ArrayList<String>(Arrays.asList("(UTC-07:00)", "Chihuahua, La Paz, Mazatlan", "false")));
        table.put(13, new ArrayList<String>(Arrays.asList("(UTC-07:00)", "Mountain Time (US & Canada)", "true")));
        table.put(14, new ArrayList<String>(Arrays.asList("(UTC-07:00)", "Yukon", "false")));
        table.put(15, new ArrayList<String>(Arrays.asList("(UTC-06:00)", "Central America", "false")));
        table.put(16, new ArrayList<String>(Arrays.asList("(UTC-06:00)", "Central Time (US & Canada)", "true")));
        table.put(17, new ArrayList<String>(Arrays.asList("(UTC-06:00)", "Easter Island", "true")));
        table.put(18, new ArrayList<String>(Arrays.asList("(UTC-06:00)", "Guadalajara, Mexico City, Monterrey", "false")));
        table.put(19, new ArrayList<String>(Arrays.asList("(UTC-06:00)", "Saskatchewan", "false")));
        table.put(20, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Bogota, Lima, Quito, Rio Branco", "false")));
        table.put(21, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Chetumal", "false")));
        table.put(22, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Eastern Time (US & Canada)", "true")));
        table.put(23, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Haiti", "true")));
        table.put(24, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Havana", "true")));
        table.put(25, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Indiana (East)", "true")));
        table.put(26, new ArrayList<String>(Arrays.asList("(UTC-05:00)", "Turks and Caicos", "true")));
        table.put(27, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Asuncion", "true")));
        table.put(28, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Atlantic Time (Canada)", "true")));
        table.put(29, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Caracas", "false")));
        table.put(30, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Cuiaba", "false")));
        table.put(31, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Georgetown, La Paz, Manaus, San Juan", "false")));
        table.put(32, new ArrayList<String>(Arrays.asList("(UTC-04:00)", "Santiago", "true")));
        table.put(33, new ArrayList<String>(Arrays.asList("(UTC-03:30)", "Newfoundland", "true")));
        table.put(34, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Araguaina", "false")));
        table.put(35, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Brasilia", "false")));
        table.put(36, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Cayenne, Fortaleza", "false")));
        table.put(37, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "City of Buenos Aires", "false")));
        table.put(38, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Greenland", "false")));
        table.put(39, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Montevideo", "false")));
        table.put(40, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Punta Arenas", "false")));
        table.put(41, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Saint Pierre and Miquelon", "true")));
        table.put(42, new ArrayList<String>(Arrays.asList("(UTC-03:00)", "Salvador", "false")));
        table.put(43, new ArrayList<String>(Arrays.asList("(UTC-02:00)", "Coordinated Universal Time-02", "false")));
        table.put(44, new ArrayList<String>(Arrays.asList("(UTC-01:00)", "Azores", "true")));
        table.put(45, new ArrayList<String>(Arrays.asList("(UTC-01:00)", "Cabo Verde Is.", "false")));
        table.put(46, new ArrayList<String>(Arrays.asList("(UTC+00:00)", "Coordinated Universal Time", "false")));
        table.put(47, new ArrayList<String>(Arrays.asList("(UTC+00:00)", "Dublin, Edinburgh, Lisbon, London", "true")));
        table.put(48, new ArrayList<String>(Arrays.asList("(UTC+00:00)", "Monrovia, Reykjavik", "false")));
        table.put(49, new ArrayList<String>(Arrays.asList("(UTC+00:00)", "Sao Tome", "false")));
        table.put(50, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "Casablanca", "true")));
        table.put(51, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", "true")));
        table.put(52, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "Belgrade, Bratislava, Budapest, Ljubljana, Prague", "true")));
        table.put(53, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "Brussels, Copenhagen, Madrid, Paris", "true")));
        table.put(54, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "Sarajevo, Skopje, Warsaw, Zagreb", "true")));
        table.put(55, new ArrayList<String>(Arrays.asList("(UTC+01:00)", "West Central Africa", "false")));
        table.put(56, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Amman", "false")));
        table.put(57, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Athens, Bucharest", "true")));
        table.put(58, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Beirut", "true")));
        table.put(59, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Cairo", "false")));
        table.put(60, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Chisinau", "true")));
        table.put(61, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Damascus", "false")));
        table.put(62, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Gaza, Hebron", "true")));
        table.put(63, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Harare, Pretoria", "false")));
        table.put(64, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius", "true")));
        table.put(65, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Jerusalem", "true")));
        table.put(66, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Juba", "false")));
        table.put(67, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Kaliningrad", "false")));
        table.put(68, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Khartoum", "false")));
        table.put(69, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Tripoli", "false")));
        table.put(70, new ArrayList<String>(Arrays.asList("(UTC+02:00)", "Windhoek", "false")));
        table.put(71, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Baghdad", "false")));
        table.put(72, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Istanbul", "false")));
        table.put(73, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Kuwait, Riyadh", "false")));
        table.put(74, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Minsk", "false")));
        table.put(75, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Moscow, St. Petersburg", "false")));
        table.put(76, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Nairobi", "false")));
        table.put(77, new ArrayList<String>(Arrays.asList("(UTC+03:00)", "Volgograd", "false")));
        table.put(78, new ArrayList<String>(Arrays.asList("(UTC+03:30)", "Tehran", "false")));
        table.put(79, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Abu Dhabi, Muscat", "false")));
        table.put(80, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Astrakhan, Ulyanovsk", "false")));
        table.put(81, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Baku", "false")));
        table.put(82, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Izhevsk, Samara", "false")));
        table.put(83, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Port Louis", "false")));
        table.put(84, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Saratov", "false")));
        table.put(85, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Tbilisi", "false")));
        table.put(86, new ArrayList<String>(Arrays.asList("(UTC+04:00)", "Yerevan", "false")));
        table.put(87, new ArrayList<String>(Arrays.asList("(UTC+04:30)", "Kabul", "false")));
        table.put(88, new ArrayList<String>(Arrays.asList("(UTC+05:00)", "Ashgabat, Tashkent", "false")));
        table.put(89, new ArrayList<String>(Arrays.asList("(UTC+05:00)", "Ekaterinburg", "false")));
        table.put(90, new ArrayList<String>(Arrays.asList("(UTC+05:00)", "Islamabad, Karachi", "false")));
        table.put(91, new ArrayList<String>(Arrays.asList("(UTC+05:00)", "Qyzylorda", "false")));
        table.put(92, new ArrayList<String>(Arrays.asList("(UTC+05:30)", "Chennai, Kolkata, Mumbai, New Delhi", "false")));
        table.put(93, new ArrayList<String>(Arrays.asList("(UTC+05:30)", "Sri Jayawardenepura", "false")));
        table.put(94, new ArrayList<String>(Arrays.asList("(UTC+05:45)", "Kathmandu", "false")));
        table.put(95, new ArrayList<String>(Arrays.asList("(UTC+06:00)", "Astana", "false")));
        table.put(96, new ArrayList<String>(Arrays.asList("(UTC+06:00)", "Dhaka", "false")));
        table.put(97, new ArrayList<String>(Arrays.asList("(UTC+06:00)", "Omsk", "false")));
        table.put(98, new ArrayList<String>(Arrays.asList("(UTC+06:30)", "Yangon (Rangoon)", "false")));
        table.put(99, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Bangkok, Hanoi, Jakarta", "false")));
        table.put(100, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Barnaul, Gorno-Altaysk", "false")));
        table.put(101, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Hovd", "false")));
        table.put(102, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Krasnoyarsk", "false")));
        table.put(103, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Novosibirsk", "false")));
        table.put(104, new ArrayList<String>(Arrays.asList("(UTC+07:00)", "Tomsk", "false")));
        table.put(105, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Beijing, Chongqing, Hong Kong, Urumqi", "false")));
        table.put(106, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Irkutsk", "false")));
        table.put(107, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Kuala Lumpur, Singapore", "false")));
        table.put(108, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Perth", "false")));
        table.put(109, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Taipei", "false")));
        table.put(110, new ArrayList<String>(Arrays.asList("(UTC+08:00)", "Ulaanbaatar", "false")));
        table.put(111, new ArrayList<String>(Arrays.asList("(UTC+08:45)", "Eucla", "false")));
        table.put(112, new ArrayList<String>(Arrays.asList("(UTC+09:00)", "Chita", "false")));
        table.put(113, new ArrayList<String>(Arrays.asList("(UTC+09:00)", "Osaka, Sapporo, Tokyo", "false")));
        table.put(114, new ArrayList<String>(Arrays.asList("(UTC+09:00)", "Pyongyang", "false")));
        table.put(115, new ArrayList<String>(Arrays.asList("(UTC+09:00)", "Seoul", "false")));
        table.put(116, new ArrayList<String>(Arrays.asList("(UTC+09:00)", "Yakutsk", "false")));
        table.put(117, new ArrayList<String>(Arrays.asList("(UTC+09:30)", "Adelaide", "true")));
        table.put(118, new ArrayList<String>(Arrays.asList("(UTC+09:30)", "Darwin", "false")));
        table.put(119, new ArrayList<String>(Arrays.asList("(UTC+10:00)", "Brisbane", "false")));
        table.put(120, new ArrayList<String>(Arrays.asList("(UTC+10:00)", "Canberra, Melbourne, Sydney", "true")));
        table.put(121, new ArrayList<String>(Arrays.asList("(UTC+10:00)", "Guam, Port Moresby", "false")));
        table.put(122, new ArrayList<String>(Arrays.asList("(UTC+10:00)", "Hobart", "true")));
        table.put(123, new ArrayList<String>(Arrays.asList("(UTC+10:00)", "Vladivostok", "false")));
        table.put(124, new ArrayList<String>(Arrays.asList("(UTC+10:30)", "Lord Howe Island", "true")));
        table.put(125, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Bougainville Island", "false")));
        table.put(126, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Chokurdakh", "false")));
        table.put(127, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Magadan", "false")));
        table.put(128, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Norfolk Island", "true")));
        table.put(129, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Sakhalin", "false")));
        table.put(130, new ArrayList<String>(Arrays.asList("(UTC+11:00)", "Solomon Is., New Caledonia", "false")));
        table.put(131, new ArrayList<String>(Arrays.asList("(UTC+12:00)", "Anadyr, Petropavlovsk-Kamchatsky", "false")));
        table.put(132, new ArrayList<String>(Arrays.asList("(UTC+12:00)", "Auckland, Wellington", "true")));
        table.put(133, new ArrayList<String>(Arrays.asList("(UTC+12:00)", "Coordinated Universal Time+12", "false")));
        table.put(134, new ArrayList<String>(Arrays.asList("(UTC+12:00)", "Fiji", "false")));
        table.put(135, new ArrayList<String>(Arrays.asList("(UTC+12:45)", "Chatham Islands", "true")));
        table.put(136, new ArrayList<String>(Arrays.asList("(UTC+13:00)", "Coordinated Universal Time+13", "false")));
        table.put(137, new ArrayList<String>(Arrays.asList("(UTC+13:00)", "Nuku'alofa", "false")));
        table.put(138, new ArrayList<String>(Arrays.asList("(UTC+13:00)", "Samoa", "false")));
        table.put(139, new ArrayList<String>(Arrays.asList("(UTC+14:00)", "Kiritimati Island", "false")));
        return table;
    }

    public static ArrayList<String> getNTPTimeZoneList() {
        ArrayList<String> timezoneItems = new ArrayList<String>();
        timezoneItems.add("-1200");
        timezoneItems.add("-1100");
        timezoneItems.add("-1000");
        timezoneItems.add("-0930");
        timezoneItems.add("-0900");
        timezoneItems.add("-0800");
        timezoneItems.add("-0700");
        timezoneItems.add("-0600");
        timezoneItems.add("-0500");
        timezoneItems.add("-0430");
        timezoneItems.add("-0400");
        timezoneItems.add("-0330");
        timezoneItems.add("-0300");
        timezoneItems.add("-0230");
        timezoneItems.add("-0200");
        timezoneItems.add("-0100");
        timezoneItems.add("+0000");
        timezoneItems.add("+0100");
        timezoneItems.add("+0200");
        timezoneItems.add("+0300");
        timezoneItems.add("+0330");
        timezoneItems.add("+0400");
        timezoneItems.add("+0430");
        timezoneItems.add("+0500");
        timezoneItems.add("+0530");
        timezoneItems.add("+0545");
        timezoneItems.add("+0600");
        timezoneItems.add("+0630");
        timezoneItems.add("+0700");
        timezoneItems.add("+0800");
        timezoneItems.add("+0900");
        timezoneItems.add("+0930");
        timezoneItems.add("+1000");
        timezoneItems.add("+1030");
        timezoneItems.add("+1100");
        timezoneItems.add("+1130");
        timezoneItems.add("+1200");
        timezoneItems.add("+1300");
        timezoneItems.add("+1400");
        return timezoneItems;
    }

    public void setNewNTPSettings(byte[] config) throws IPMIException {
        this.setNewNTPSettings(config, false);
    }

    public void setNewNTPSettings(byte[] config, boolean isForceDisableAutoDST) throws IPMIException {
        if (config == null || config.length < 4) {
            throw new IPMIException("Unable to set NTP time update mode.");
        }
        byte[] req = new byte[]{config[0], config[1], isForceDisableAutoDST ? (byte)0 : config[3]};
        this.setNTPDateTime((byte)0, req);
    }

    private byte[] getIPAddressBytes(String ip, byte protocol) {
        byte[] data;
        block4: {
            block5: {
                int ipv4TokenCount = 4;
                int ipv6TokenCount = 8;
                data = null;
                if (ip == null) break block4;
                if (protocol != 0) break block5;
                data = new byte[4];
                String[] token = ip.split("\\.");
                if (token.length != 4) break block4;
                for (int idx = 0; idx < 4; ++idx) {
                    Integer val = Integer.valueOf(token[idx]);
                    data[idx] = val.byteValue();
                }
                break block4;
            }
            if (protocol == 1) {
                data = new byte[16];
                String standardIPAddr = IPMILanCommand.StandardIPv6Converter(ip);
                if (standardIPAddr != null) {
                    standardIPAddr = standardIPAddr.replace(":", "");
                    for (int idx = 0; idx < data.length; ++idx) {
                        int offset = idx * 2;
                        int value = Integer.parseInt(standardIPAddr.substring(offset, offset + 2), 16);
                        data[idx] = (byte)value;
                    }
                }
            }
        }
        return data;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiOEMWebSettingCommand);
        if (sessionController == null) {
            return;
        }
        try {
            GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = 1;
            ipmiOEMWebSettingCommand.setVMParameter(VM_PARAM_HOST, "2.133.176.217");
            ipmiOEMWebSettingCommand.setVMParameter(VM_PARAM_PATH, "\\test_vm\\a.iso");
            ipmiOEMWebSettingCommand.mountISO((byte)0);
            byte[] vmStatus = ipmiOEMWebSettingCommand.getVMDeviceStatus();
            System.out.println(ByteUtility.bytesToHex(vmStatus));
            System.out.println("Sleep");
            try {
                Thread.sleep(100000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }
}

